/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms;

import Jama.Matrix;
import java.util.List;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.Pair;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.matrix.MatrixUtils;
import org.openimaj.util.pair.IndependentPair;

public enum FundamentalRefinement {
    NONE{

        @Override
        public Matrix refine(Matrix initial, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            return initial;
        }

        @Override
        protected MultivariateJacobianFunction getFunctions(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data, Parameterisation p) {
            return null;
        }
    }
    ,
    EPIPOLAR{

        @Override
        protected MultivariateJacobianFunction getFunctions(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data, Parameterisation p) {
            switch (p) {
                case F12: {
                    return new F12Epipolar(data);
                }
                case F13: {
                    return new F13Epipolar(data);
                }
                case F23: {
                    return new F23Epipolar(data);
                }
            }
            return null;
        }
    }
    ,
    SAMPSON{

        @Override
        protected MultivariateJacobianFunction getFunctions(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data, Parameterisation p) {
            switch (p) {
                case F12: {
                    return new F12Sampson(data);
                }
                case F13: {
                    return new F13Sampson(data);
                }
                case F23: {
                    return new F23Sampson(data);
                }
            }
            return null;
        }
    };


    protected abstract MultivariateJacobianFunction getFunctions(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> var1, Parameterisation var2);

    public Matrix refine(Matrix initial, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
        double[] params = new double[8];
        Parameterisation p = Parameterisation.chooseOptimalParameterisation(initial, params);
        LevenbergMarquardtOptimizer lm = new LevenbergMarquardtOptimizer();
        ArrayRealVector start = new ArrayRealVector(params, false);
        ArrayRealVector observed = new ArrayRealVector(data.size());
        int maxEvaluations = 1000;
        int maxIterations = 1000;
        MultivariateJacobianFunction model = this.getFunctions(data, p);
        LeastSquaresOptimizer.Optimum result = lm.optimize(LeastSquaresFactory.create((MultivariateJacobianFunction)model, (RealVector)observed, (RealVector)start, null, (int)1000, (int)1000));
        Matrix improved = p.paramsToMatrix(result.getPoint().toArray());
        MatrixUtils.times(improved, 1.0 / improved.normInf());
        return improved;
    }

    protected static class F23Sampson
    extends Base {
        public F23Sampson(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            super(data);
        }

        @Override
        double computeValue(double x, double y, double X, double Y, double f4, double f5, double f6, double f7, double f8, double f9, double r, double s) {
            double t4 = f4 * r;
            double t5 = f7 * s;
            double t6 = t4 + t5;
            double t8 = f5 * r;
            double t9 = f8 * s;
            double t10 = t8 + t9;
            double t16 = f6 * r;
            double t17 = f9 * s;
            double t2 = t16 + t17 + t6 * x + t10 * y;
            double t3 = f6 + f4 * x + f5 * y;
            double t12 = Y * f4;
            double t13 = X * t6;
            double t7 = f7 + t12 + t13;
            double t14 = Y * f5;
            double t15 = X * t10;
            double t11 = f8 + t14 + t15;
            double t18 = f9 + Y * f6 + t7 * x + t11 * y + X * (t16 + t17);
            double t0 = t18 * t18 / (t2 * t2 + t3 * t3 + t7 * t7 + t11 * t11);
            return t0;
        }

        @Override
        double[] computeJacobian(double x, double y, double X, double Y, double f4, double f5, double f6, double f7, double f8, double f9, double r, double s) {
            double[] A0 = new double[8];
            double t2 = f4 * r;
            double t3 = f7 * s;
            double t4 = t2 + t3;
            double t5 = f6 * r;
            double t6 = f9 * s;
            double t7 = t4 * x;
            double t8 = f5 * r;
            double t9 = f8 * s;
            double t10 = t8 + t9;
            double t11 = t10 * y;
            double t12 = t5 + t6 + t7 + t11;
            double t13 = f4 * x;
            double t14 = f5 * y;
            double t15 = f6 + t13 + t14;
            double t16 = Y * f4;
            double t17 = X * t4;
            double t18 = f7 + t16 + t17;
            double t20 = Y * f5;
            double t21 = X * t10;
            double t19 = f8 + t20 + t21;
            double t30 = Y * f6;
            double t31 = t18 * x;
            double t32 = t19 * y;
            double t33 = t5 + t6;
            double t34 = X * t33;
            double t22 = f9 + t30 + t31 + t32 + t34;
            double t23 = X * r;
            double t24 = Y + t23;
            double t25 = t12 * t12;
            double t26 = t15 * t15;
            double t27 = t18 * t18;
            double t28 = t19 * t19;
            double t29 = t25 + t26 + t27 + t28;
            double t35 = 1.0 / (t29 * t29);
            double t36 = t22 * t22;
            double t37 = 1.0 / t29;
            double t38 = X * s;
            double t39 = t38 + 1.0;
            A0[0] = -t35 * t36 * (t18 * t24 * 2.0 + t15 * x * 2.0 + r * t12 * x * 2.0) + t22 * t24 * t37 * x * 2.0;
            A0[1] = -t35 * t36 * (t19 * t24 * 2.0 + t15 * y * 2.0 + r * t12 * y * 2.0) + t22 * t24 * t37 * y * 2.0;
            A0[2] = -t35 * t36 * (f6 * 2.0 + f4 * x * 2.0 + f5 * y * 2.0 + r * t12 * 2.0) + t22 * t24 * t37 * 2.0;
            A0[3] = -t35 * t36 * (t18 * t39 * 2.0 + s * t12 * x * 2.0) + t22 * t37 * t39 * x * 2.0;
            A0[4] = -t35 * t36 * (t19 * t39 * 2.0 + s * t12 * y * 2.0) + t22 * t37 * t39 * y * 2.0;
            A0[5] = t22 * t37 * t39 * 2.0 - s * t12 * t35 * t36 * 2.0;
            A0[6] = -t35 * t36 * (t12 * t15 * 2.0 + X * f4 * t18 * 2.0 + X * f5 * t19 * 2.0) + t22 * t37 * (X * f6 + X * f4 * x + X * f5 * y) * 2.0;
            A0[7] = -t35 * t36 * (t12 * (f9 + f7 * x + f8 * y) * 2.0 + X * f7 * t18 * 2.0 + X * f8 * t19 * 2.0) + t22 * t37 * (X * f9 + X * f7 * x + X * f8 * y) * 2.0;
            return A0;
        }
    }

    protected static class F13Sampson
    extends Base {
        public F13Sampson(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            super(data);
        }

        @Override
        double computeValue(double x, double y, double X, double Y, double f1, double f2, double f3, double f7, double f8, double f9, double r, double s) {
            double t4 = f1 * r;
            double t5 = f7 * s;
            double t6 = t4 + t5;
            double t8 = f2 * r;
            double t9 = f8 * s;
            double t10 = t8 + t9;
            double t16 = f3 * r;
            double t17 = f9 * s;
            double t2 = t16 + t17 + t6 * x + t10 * y;
            double t3 = f3 + f1 * x + f2 * y;
            double t12 = X * f1;
            double t13 = Y * t6;
            double t7 = f7 + t12 + t13;
            double t14 = X * f2;
            double t15 = Y * t10;
            double t11 = f8 + t14 + t15;
            double t18 = f9 + X * f3 + t7 * x + t11 * y + Y * (t16 + t17);
            double t0 = t18 * t18 / (t2 * t2 + t3 * t3 + t7 * t7 + t11 * t11);
            return t0;
        }

        @Override
        double[] computeJacobian(double x, double y, double X, double Y, double f1, double f2, double f3, double f7, double f8, double f9, double r, double s) {
            double[] A0 = new double[8];
            double t2 = f1 * r;
            double t3 = f7 * s;
            double t4 = t2 + t3;
            double t5 = f3 * r;
            double t6 = f9 * s;
            double t7 = t4 * x;
            double t8 = f2 * r;
            double t9 = f8 * s;
            double t10 = t8 + t9;
            double t11 = t10 * y;
            double t12 = t5 + t6 + t7 + t11;
            double t13 = f1 * x;
            double t14 = f2 * y;
            double t15 = f3 + t13 + t14;
            double t16 = X * f1;
            double t17 = Y * t4;
            double t18 = f7 + t16 + t17;
            double t20 = X * f2;
            double t21 = Y * t10;
            double t19 = f8 + t20 + t21;
            double t30 = X * f3;
            double t31 = t18 * x;
            double t32 = t19 * y;
            double t33 = t5 + t6;
            double t34 = Y * t33;
            double t22 = f9 + t30 + t31 + t32 + t34;
            double t23 = Y * r;
            double t24 = X + t23;
            double t25 = t12 * t12;
            double t26 = t15 * t15;
            double t27 = t18 * t18;
            double t28 = t19 * t19;
            double t29 = t25 + t26 + t27 + t28;
            double t35 = 1.0 / (t29 * t29);
            double t36 = t22 * t22;
            double t37 = 1.0 / t29;
            double t38 = Y * s;
            double t39 = t38 + 1.0;
            A0[0] = -t35 * t36 * (t18 * t24 * 2.0 + t15 * x * 2.0 + r * t12 * x * 2.0) + t22 * t24 * t37 * x * 2.0;
            A0[1] = -t35 * t36 * (t19 * t24 * 2.0 + t15 * y * 2.0 + r * t12 * y * 2.0) + t22 * t24 * t37 * y * 2.0;
            A0[2] = -t35 * t36 * (f3 * 2.0 + f1 * x * 2.0 + f2 * y * 2.0 + r * t12 * 2.0) + t22 * t24 * t37 * 2.0;
            A0[3] = -t35 * t36 * (t18 * t39 * 2.0 + s * t12 * x * 2.0) + t22 * t37 * t39 * x * 2.0;
            A0[4] = -t35 * t36 * (t19 * t39 * 2.0 + s * t12 * y * 2.0) + t22 * t37 * t39 * y * 2.0;
            A0[5] = t22 * t37 * t39 * 2.0 - s * t12 * t35 * t36 * 2.0;
            A0[6] = -t35 * t36 * (t12 * t15 * 2.0 + Y * f1 * t18 * 2.0 + Y * f2 * t19 * 2.0) + t22 * t37 * (Y * f3 + Y * f1 * x + Y * f2 * y) * 2.0;
            A0[7] = -t35 * t36 * (t12 * (f9 + f7 * x + f8 * y) * 2.0 + Y * f7 * t18 * 2.0 + Y * f8 * t19 * 2.0) + t22 * t37 * (Y * f9 + Y * f7 * x + Y * f8 * y) * 2.0;
            return A0;
        }
    }

    protected static class F12Sampson
    extends Base {
        public F12Sampson(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            super(data);
        }

        @Override
        double computeValue(double x, double y, double X, double Y, double f1, double f2, double f3, double f4, double f5, double f6, double r, double s) {
            double t6 = X * f1;
            double t7 = Y * f4;
            double t8 = f1 * r;
            double t9 = f4 * s;
            double t2 = t6 + t7 + t8 + t9;
            double t10 = X * f2;
            double t11 = Y * f5;
            double t12 = f2 * r;
            double t13 = f5 * s;
            double t3 = t10 + t11 + t12 + t13;
            double t4 = f3 + f1 * x + f2 * y;
            double t5 = f6 + f4 * x + f5 * y;
            double t14 = X * f3 + Y * f6 + f3 * r + f6 * s + t2 * x + t3 * y;
            double t0 = t14 * t14 / (t2 * t2 + t3 * t3 + t4 * t4 + t5 * t5);
            return t0;
        }

        @Override
        double[] computeJacobian(double x, double y, double X, double Y, double f1, double f2, double f3, double f4, double f5, double f6, double r, double s) {
            double[] A0 = new double[8];
            double t2 = X * f1;
            double t3 = Y * f4;
            double t4 = f1 * r;
            double t5 = f4 * s;
            double t6 = t2 + t3 + t4 + t5;
            double t12 = X * f2;
            double t13 = Y * f5;
            double t14 = f2 * r;
            double t15 = f5 * s;
            double t7 = t12 + t13 + t14 + t15;
            double t8 = f1 * x;
            double t9 = f2 * y;
            double t10 = f3 + t8 + t9;
            double t21 = f4 * x;
            double t22 = f5 * y;
            double t11 = f6 + t21 + t22;
            double t25 = X * f3;
            double t26 = Y * f6;
            double t27 = f3 * r;
            double t28 = f6 * s;
            double t29 = t6 * x;
            double t30 = t7 * y;
            double t16 = t25 + t26 + t27 + t28 + t29 + t30;
            double t17 = X + r;
            double t18 = t6 * t6;
            double t19 = t7 * t7;
            double t20 = t10 * t10;
            double t23 = t11 * t11;
            double t24 = t18 + t19 + t20 + t23;
            double t31 = 1.0 / (t24 * t24);
            double t32 = t16 * t16;
            double t33 = 1.0 / t24;
            double t34 = Y + s;
            A0[0] = -t31 * t32 * (t6 * t17 * 2.0 + t10 * x * 2.0) + t16 * t17 * t33 * x * 2.0;
            A0[1] = -t31 * t32 * (t7 * t17 * 2.0 + t10 * y * 2.0) + t16 * t17 * t33 * y * 2.0;
            A0[2] = t16 * t17 * t33 * 2.0 - t31 * t32 * (f3 * 2.0 + f1 * x * 2.0 + f2 * y * 2.0);
            A0[3] = -t31 * t32 * (t6 * t34 * 2.0 + t11 * x * 2.0) + t16 * t33 * t34 * x * 2.0;
            A0[4] = -t31 * t32 * (t7 * t34 * 2.0 + t11 * y * 2.0) + t16 * t33 * t34 * y * 2.0;
            A0[5] = t16 * t33 * t34 * 2.0 - t31 * t32 * (f6 * 2.0 + f4 * x * 2.0 + f5 * y * 2.0);
            A0[6] = -t31 * t32 * (f1 * t6 * 2.0 + f2 * t7 * 2.0) + t10 * t16 * t33 * 2.0;
            A0[7] = -t31 * t32 * (f4 * t6 * 2.0 + f5 * t7 * 2.0) + t11 * t16 * t33 * 2.0;
            return A0;
        }
    }

    protected static class F23Epipolar
    extends Base {
        public F23Epipolar(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            super(data);
        }

        @Override
        double computeValue(double x, double y, double X, double Y, double f4, double f5, double f6, double f7, double f8, double f9, double r, double s) {
            double t4 = f4 * r;
            double t5 = f7 * s;
            double t6 = t4 + t5;
            double t12 = Y * f4;
            double t13 = X * t6;
            double t2 = f7 + t12 + t13;
            double t7 = f5 * r;
            double t8 = f8 * s;
            double t9 = t7 + t8;
            double t14 = Y * f5;
            double t15 = X * t9;
            double t3 = f8 + t14 + t15;
            double t16 = f6 * r;
            double t17 = f9 * s;
            double t10 = t16 + t17 + t6 * x + t9 * y;
            double t11 = f6 + f4 * x + f5 * y;
            double t18 = f9 + Y * f6 + t2 * x + t3 * y + X * (t16 + t17);
            double t0 = t18 * t18 * (1.0 / (t2 * t2 + t3 * t3) + 1.0 / (t10 * t10 + t11 * t11));
            return t0;
        }

        @Override
        double[] computeJacobian(double x, double y, double X, double Y, double f4, double f5, double f6, double f7, double f8, double f9, double r, double s) {
            double[] A0 = new double[8];
            double t6 = f6 * r;
            double t7 = f9 * s;
            double t8 = f4 * r;
            double t9 = f7 * s;
            double t10 = t8 + t9;
            double t11 = t10 * x;
            double t12 = f5 * r;
            double t13 = f8 * s;
            double t14 = t12 + t13;
            double t15 = t14 * y;
            double t2 = t6 + t7 + t11 + t15;
            double t4 = f4 * x;
            double t5 = f5 * y;
            double t3 = f6 + t4 + t5;
            double t18 = Y * f4;
            double t19 = X * t10;
            double t16 = f7 + t18 + t19;
            double t20 = Y * f5;
            double t21 = X * t14;
            double t17 = f8 + t20 + t21;
            double t31 = Y * f6;
            double t32 = t16 * x;
            double t33 = t17 * y;
            double t34 = t6 + t7;
            double t35 = X * t34;
            double t22 = f9 + t31 + t32 + t33 + t35;
            double t23 = t16 * t16;
            double t24 = t17 * t17;
            double t25 = t23 + t24;
            double t26 = t2 * t2;
            double t27 = t3 * t3;
            double t28 = t26 + t27;
            double t29 = X * r;
            double t30 = Y + t29;
            double t36 = 1.0 / (t28 * t28);
            double t37 = 1.0 / (t25 * t25);
            double t38 = t22 * t22;
            double t39 = 1.0 / t25;
            double t40 = 1.0 / t28;
            double t41 = t39 + t40;
            double t42 = X * s;
            double t43 = t42 + 1.0;
            A0[0] = -t38 * (t36 * (t3 * x * 2.0 + r * t2 * x * 2.0) + t16 * t30 * t37 * 2.0) + t22 * t30 * t41 * x * 2.0;
            A0[1] = -t38 * (t36 * (t3 * y * 2.0 + r * t2 * y * 2.0) + t17 * t30 * t37 * 2.0) + t22 * t30 * t41 * y * 2.0;
            A0[2] = -t36 * t38 * (f6 * 2.0 + f4 * x * 2.0 + f5 * y * 2.0 + r * t2 * 2.0) + t22 * t30 * t41 * 2.0;
            A0[3] = -t38 * (t16 * t37 * t43 * 2.0 + s * t2 * t36 * x * 2.0) + t22 * t41 * t43 * x * 2.0;
            A0[4] = -t38 * (t17 * t37 * t43 * 2.0 + s * t2 * t36 * y * 2.0) + t22 * t41 * t43 * y * 2.0;
            A0[5] = t22 * t41 * t43 * 2.0 - s * t2 * t36 * t38 * 2.0;
            A0[6] = -t38 * (t37 * (X * f4 * t16 * 2.0 + X * f5 * t17 * 2.0) + t2 * t3 * t36 * 2.0) + t22 * t41 * (X * f6 + X * f4 * x + X * f5 * y) * 2.0;
            A0[7] = -t38 * (t37 * (X * f7 * t16 * 2.0 + X * f8 * t17 * 2.0) + t2 * t36 * (f9 + f7 * x + f8 * y) * 2.0) + t22 * t41 * (X * f9 + X * f7 * x + X * f8 * y) * 2.0;
            return A0;
        }
    }

    protected static class F13Epipolar
    extends Base {
        public F13Epipolar(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            super(data);
        }

        @Override
        double computeValue(double x, double y, double X, double Y, double f1, double f2, double f3, double f7, double f8, double f9, double r, double s) {
            double t4 = f1 * r;
            double t5 = f7 * s;
            double t6 = t4 + t5;
            double t12 = X * f1;
            double t13 = Y * t6;
            double t2 = f7 + t12 + t13;
            double t7 = f2 * r;
            double t8 = f8 * s;
            double t9 = t7 + t8;
            double t14 = X * f2;
            double t15 = Y * t9;
            double t3 = f8 + t14 + t15;
            double t16 = f3 * r;
            double t17 = f9 * s;
            double t10 = t16 + t17 + t6 * x + t9 * y;
            double t11 = f3 + f1 * x + f2 * y;
            double t18 = f9 + X * f3 + t2 * x + t3 * y + Y * (t16 + t17);
            double t0 = t18 * t18 * (1.0 / (t2 * t2 + t3 * t3) + 1.0 / (t10 * t10 + t11 * t11));
            return t0;
        }

        @Override
        double[] computeJacobian(double x, double y, double X, double Y, double f1, double f2, double f3, double f7, double f8, double f9, double r, double s) {
            double[] A0 = new double[8];
            double t6 = f3 * r;
            double t7 = f9 * s;
            double t8 = f1 * r;
            double t9 = f7 * s;
            double t10 = t8 + t9;
            double t11 = t10 * x;
            double t12 = f2 * r;
            double t13 = f8 * s;
            double t14 = t12 + t13;
            double t15 = t14 * y;
            double t2 = t6 + t7 + t11 + t15;
            double t4 = f1 * x;
            double t5 = f2 * y;
            double t3 = f3 + t4 + t5;
            double t18 = X * f1;
            double t19 = Y * t10;
            double t16 = f7 + t18 + t19;
            double t20 = X * f2;
            double t21 = Y * t14;
            double t17 = f8 + t20 + t21;
            double t31 = X * f3;
            double t32 = t16 * x;
            double t33 = t17 * y;
            double t34 = t6 + t7;
            double t35 = Y * t34;
            double t22 = f9 + t31 + t32 + t33 + t35;
            double t23 = t16 * t16;
            double t24 = t17 * t17;
            double t25 = t23 + t24;
            double t26 = t2 * t2;
            double t27 = t3 * t3;
            double t28 = t26 + t27;
            double t29 = Y * r;
            double t30 = X + t29;
            double t36 = 1.0 / (t28 * t28);
            double t37 = 1.0 / (t25 * t25);
            double t38 = t22 * t22;
            double t39 = 1.0 / t25;
            double t40 = 1.0 / t28;
            double t41 = t39 + t40;
            double t42 = Y * s;
            double t43 = t42 + 1.0;
            A0[0] = -t38 * (t36 * (t3 * x * 2.0 + r * t2 * x * 2.0) + t16 * t30 * t37 * 2.0) + t22 * t30 * t41 * x * 2.0;
            A0[1] = -t38 * (t36 * (t3 * y * 2.0 + r * t2 * y * 2.0) + t17 * t30 * t37 * 2.0) + t22 * t30 * t41 * y * 2.0;
            A0[2] = -t36 * t38 * (f3 * 2.0 + f1 * x * 2.0 + f2 * y * 2.0 + r * t2 * 2.0) + t22 * t30 * t41 * 2.0;
            A0[3] = -t38 * (t16 * t37 * t43 * 2.0 + s * t2 * t36 * x * 2.0) + t22 * t41 * t43 * x * 2.0;
            A0[4] = -t38 * (t17 * t37 * t43 * 2.0 + s * t2 * t36 * y * 2.0) + t22 * t41 * t43 * y * 2.0;
            A0[5] = t22 * t41 * t43 * 2.0 - s * t2 * t36 * t38 * 2.0;
            A0[6] = -t38 * (t37 * (Y * f1 * t16 * 2.0 + Y * f2 * t17 * 2.0) + t2 * t3 * t36 * 2.0) + t22 * t41 * (Y * f3 + Y * f1 * x + Y * f2 * y) * 2.0;
            A0[7] = -t38 * (t37 * (Y * f7 * t16 * 2.0 + Y * f8 * t17 * 2.0) + t2 * t36 * (f9 + f7 * x + f8 * y) * 2.0) + t22 * t41 * (Y * f9 + Y * f7 * x + Y * f8 * y) * 2.0;
            return A0;
        }
    }

    protected static class F12Epipolar
    extends Base {
        public F12Epipolar(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            super(data);
        }

        @Override
        double computeValue(double x, double y, double X, double Y, double f1, double f2, double f3, double f4, double f5, double f6, double r, double s) {
            double t2 = f3 + f1 * x + f2 * y;
            double t3 = f6 + f4 * x + f5 * y;
            double t6 = X * f1;
            double t7 = Y * f4;
            double t8 = f1 * r;
            double t9 = f4 * s;
            double t4 = t6 + t7 + t8 + t9;
            double t10 = X * f2;
            double t11 = Y * f5;
            double t12 = f2 * r;
            double t13 = f5 * s;
            double t5 = t10 + t11 + t12 + t13;
            double t14 = X * f3 + Y * f6 + f3 * r + f6 * s + t4 * x + t5 * y;
            double t0 = t14 * t14 * (1.0 / (t2 * t2 + t3 * t3) + 1.0 / (t4 * t4 + t5 * t5));
            return t0;
        }

        @Override
        double[] computeJacobian(double x, double y, double X, double Y, double f1, double f2, double f3, double f4, double f5, double f6, double r, double s) {
            double[] A0 = new double[8];
            double t4 = f1 * x;
            double t5 = f2 * y;
            double t2 = f3 + t4 + t5;
            double t19 = f4 * x;
            double t20 = f5 * y;
            double t3 = f6 + t19 + t20;
            double t8 = X * f1;
            double t9 = Y * f4;
            double t10 = f1 * r;
            double t11 = f4 * s;
            double t6 = t8 + t9 + t10 + t11;
            double t12 = X * f2;
            double t13 = Y * f5;
            double t14 = f2 * r;
            double t15 = f5 * s;
            double t7 = t12 + t13 + t14 + t15;
            double t26 = X * f3;
            double t27 = Y * f6;
            double t28 = f3 * r;
            double t29 = f6 * s;
            double t30 = t6 * x;
            double t31 = t7 * y;
            double t16 = t26 + t27 + t28 + t29 + t30 + t31;
            double t17 = X + r;
            double t18 = t2 * t2;
            double t21 = t3 * t3;
            double t22 = t18 + t21;
            double t23 = t6 * t6;
            double t24 = t7 * t7;
            double t25 = t23 + t24;
            double t32 = 1.0 / (t22 * t22);
            double t33 = 1.0 / (t25 * t25);
            double t34 = t16 * t16;
            double t35 = 1.0 / t22;
            double t36 = 1.0 / t25;
            double t37 = t35 + t36;
            double t38 = Y + s;
            A0[0] = -t34 * (t6 * t17 * t33 * 2.0 + t2 * t32 * x * 2.0) + t16 * t17 * t37 * x * 2.0;
            A0[1] = -t34 * (t7 * t17 * t33 * 2.0 + t2 * t32 * y * 2.0) + t16 * t17 * t37 * y * 2.0;
            A0[2] = t16 * t17 * t37 * 2.0 - t32 * t34 * (f3 * 2.0 + f1 * x * 2.0 + f2 * y * 2.0);
            A0[3] = -t34 * (t6 * t33 * t38 * 2.0 + t3 * t32 * x * 2.0) + t16 * t37 * t38 * x * 2.0;
            A0[4] = -t34 * (t7 * t33 * t38 * 2.0 + t3 * t32 * y * 2.0) + t16 * t37 * t38 * y * 2.0;
            A0[5] = t16 * t37 * t38 * 2.0 - t32 * t34 * (f6 * 2.0 + f4 * x * 2.0 + f5 * y * 2.0);
            A0[6] = -t33 * t34 * (f1 * t6 * 2.0 + f2 * t7 * 2.0) + t2 * t16 * t37 * 2.0;
            A0[7] = -t33 * t34 * (f4 * t6 * 2.0 + f5 * t7 * 2.0) + t3 * t16 * t37 * 2.0;
            return A0;
        }
    }

    protected static abstract class Base
    implements MultivariateJacobianFunction {
        List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data;

        public Base(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            this.data = data;
        }

        public Pair<RealVector, RealMatrix> value(RealVector point) {
            double[] params = point.toArray();
            return new Pair((Object)this.value(params), (Object)this.jacobian(params));
        }

        RealVector value(double[] params) {
            double[] result = new double[this.data.size()];
            for (int i = 0; i < this.data.size(); ++i) {
                IndependentPair<? extends Point2d, ? extends Point2d> pair = this.data.get(i);
                Point2d p1 = (Point2d)pair.firstObject();
                Point2d p2 = (Point2d)pair.secondObject();
                double x = p1.getX();
                double y = p1.getY();
                double X = p2.getX();
                double Y = p2.getY();
                result[i] = this.computeValue(x, y, X, Y, params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]);
            }
            return new ArrayRealVector(result, false);
        }

        abstract double computeValue(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23);

        RealMatrix jacobian(double[] params) {
            double[][] result = new double[this.data.size()][];
            for (int i = 0; i < this.data.size(); ++i) {
                IndependentPair<? extends Point2d, ? extends Point2d> pair = this.data.get(i);
                Point2d p1 = (Point2d)pair.firstObject();
                Point2d p2 = (Point2d)pair.secondObject();
                double x = p1.getX();
                double y = p1.getY();
                double X = p2.getX();
                double Y = p2.getY();
                result[i] = this.computeJacobian(x, y, X, Y, params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]);
            }
            return new Array2DRowRealMatrix((double[][])result, false);
        }

        abstract double[] computeJacobian(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23);
    }

    protected static class FastSolveNormal3x2 {
        double r;
        double s;
        double absDet;

        protected FastSolveNormal3x2() {
        }

        protected static FastSolveNormal3x2 solve(double[] r1, double[] r2, double[] r3) {
            FastSolveNormal3x2 s = new FastSolveNormal3x2();
            double a = r1[0] * r1[0] + r1[1] * r1[1] + r1[2] * r1[2];
            double b = r1[0] * r2[0] + r1[1] * r2[1] + r1[2] * r2[2];
            double c = r2[0] * r2[0] + r2[1] * r2[1] + r2[2] * r2[2];
            double d = r1[0] * r3[0] + r1[1] * r3[1] + r1[2] * r3[2];
            double e = r2[0] * r3[0] + r2[1] * r3[1] + r2[2] * r3[2];
            double det = a * c - b * b;
            s.absDet = Math.abs(det);
            s.r = (c * d - b * e) / det;
            s.s = (-b * d + a * e) / det;
            return s;
        }
    }

    protected static enum Parameterisation {
        F12{

            @Override
            void matrixToParams(double[][] Fv, double r, double s, double[] params) {
                this.matrixToParams(Fv[0], Fv[1], r, s, params);
            }

            @Override
            Matrix paramsToMatrix(double[] params) {
                return new Matrix((double[][])new double[][]{{params[0], params[1], params[2]}, {params[3], params[4], params[5]}, {params[0] * params[6] + params[3] * params[7], params[1] * params[6] + params[4] * params[7], params[2] * params[6] + params[5] * params[7]}});
            }
        }
        ,
        F13{

            @Override
            void matrixToParams(double[][] Fv, double r, double s, double[] params) {
                this.matrixToParams(Fv[0], Fv[2], r, s, params);
            }

            @Override
            Matrix paramsToMatrix(double[] params) {
                return new Matrix((double[][])new double[][]{{params[0], params[1], params[2]}, {params[0] * params[6] + params[3] * params[7], params[1] * params[6] + params[4] * params[7], params[2] * params[6] + params[5] * params[7]}, {params[3], params[4], params[5]}});
            }
        }
        ,
        F23{

            @Override
            void matrixToParams(double[][] Fv, double r, double s, double[] params) {
                this.matrixToParams(Fv[1], Fv[2], r, s, params);
            }

            @Override
            Matrix paramsToMatrix(double[] params) {
                return new Matrix((double[][])new double[][]{{params[0] * params[6] + params[3] * params[7], params[1] * params[6] + params[4] * params[7], params[2] * params[6] + params[5] * params[7]}, {params[0], params[1], params[2]}, {params[3], params[4], params[5]}});
            }
        };


        abstract Matrix paramsToMatrix(double[] var1);

        abstract void matrixToParams(double[][] var1, double var2, double var4, double[] var6);

        void matrixToParams(double[] Fv1, double[] Fv2, double r, double s, double[] params) {
            params[0] = Fv1[0];
            params[1] = Fv1[1];
            params[2] = Fv1[2];
            params[3] = Fv2[0];
            params[4] = Fv2[1];
            params[5] = Fv2[2];
            params[6] = r;
            params[7] = s;
        }

        public static Parameterisation chooseOptimalParameterisation(Matrix F, double[] params) {
            double[][] Fv = F.getArray();
            FastSolveNormal3x2 f12 = FastSolveNormal3x2.solve(Fv[0], Fv[1], Fv[2]);
            FastSolveNormal3x2 f13 = FastSolveNormal3x2.solve(Fv[0], Fv[2], Fv[1]);
            FastSolveNormal3x2 f23 = FastSolveNormal3x2.solve(Fv[1], Fv[2], Fv[0]);
            if (f12.absDet + f13.absDet + f23.absDet == 0.0) {
                throw new IllegalArgumentException("F matrix is probably zero");
            }
            if (f12.absDet > f13.absDet) {
                if (f12.absDet > f23.absDet) {
                    F12.matrixToParams(Fv, f12.r, f12.s, params);
                    return F12;
                }
                F23.matrixToParams(Fv, f23.r, f23.s, params);
                return F23;
            }
            if (f13.absDet > f23.absDet) {
                return F13;
            }
            F23.matrixToParams(Fv, f23.r, f23.s, params);
            return F23;
        }
    }
}

