/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms.estimation.sampling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.util.CollectionSampler;
import org.openimaj.util.pair.IndependentPair;

@Reference(type=ReferenceType.Article, author={"Zhengyou Zhang", "Rachid Deriche", "Olivier Faugeras", "Quang-Tuan Luong"}, title="A robust technique for matching two uncalibrated images through the recovery of the unknown epipolar geometry ", year="1995", journal="Artificial Intelligence ", pages={"87 ", " 119"}, url="http://www.sciencedirect.com/science/article/pii/0004370295000224", note="Special Volume on Computer Vision ", number="1--2", volume="78", customData={"issn", "0004-3702", "doi", "http://dx.doi.org/10.1016/0004-3702(95)00022-4", "keywords", "Correlation "})
public class BucketingSampler2d
implements CollectionSampler<IndependentPair<Point2d, Point2d>> {
    public static final int DEFAULT_N_BUCKETS_PER_DIM = 8;
    public static int NUM_TRIALS = 100;
    private Random rng;
    private Bucket[] bucketList;
    private int nBucketsX;
    private int nBucketsY;

    public BucketingSampler2d() {
        this(8, 8);
    }

    public BucketingSampler2d(int nBucketsX, int nBucketsY) {
        this.nBucketsX = nBucketsX;
        this.nBucketsY = nBucketsY;
        this.rng = new Random();
    }

    public void setCollection(Collection<? extends IndependentPair<Point2d, Point2d>> collection) {
        float minx = Float.MAX_VALUE;
        float maxx = -3.4028235E38f;
        float miny = Float.MAX_VALUE;
        float maxy = -3.4028235E38f;
        for (IndependentPair<Point2d, Point2d> independentPair : collection) {
            Point2d first = (Point2d)independentPair.firstObject();
            float x = first.getX();
            float y = first.getY();
            if (x < minx) {
                minx = x;
            }
            if (x > maxx) {
                maxx = x;
            }
            if (y < miny) {
                miny = y;
            }
            if (!(y > maxy)) continue;
            maxy = y;
        }
        minx = (float)((double)minx - 0.001);
        maxx = (float)((double)maxx + 0.001);
        miny = (float)((double)miny - 0.001);
        maxy = (float)((double)maxy + 0.001);
        Bucket[][] buckets = new Bucket[this.nBucketsY][this.nBucketsX];
        double d = (double)(maxx - minx) / (double)buckets[0].length;
        double bucketHeight = (double)(maxy - miny) / (double)buckets.length;
        int numNonEmptyBuckets = 0;
        for (IndependentPair<Point2d, Point2d> independentPair : collection) {
            int bx;
            Point2d first = (Point2d)independentPair.firstObject();
            float x = first.getX();
            float y = first.getY();
            int by = (int)((double)(y - miny) / bucketHeight);
            if (buckets[by][bx = (int)((double)(x - minx) / d)] == null) {
                buckets[by][bx] = new Bucket();
                ++numNonEmptyBuckets;
            }
            buckets[by][bx].buckets.add(independentPair);
        }
        this.bucketList = new Bucket[numNonEmptyBuckets];
        boolean bl = false;
        for (int y = 0; y < buckets.length; ++y) {
            for (int x = 0; x < buckets.length; ++x) {
                if (buckets[y][x] == null) continue;
                buckets[y][x].interval = (double)buckets[y][x].buckets.size() / (double)collection.size();
                this.bucketList[++var13_18] = buckets[y][x];
            }
        }
    }

    public List<IndependentPair<Point2d, Point2d>> sample(int nItems) {
        ArrayList<IndependentPair<Point2d, Point2d>> sample = new ArrayList<IndependentPair<Point2d, Point2d>>(nItems);
        boolean[] selected = new boolean[this.bucketList.length];
        int nSelectedBuckets = 0;
        for (int i = 0; i < nItems; ++i) {
            int selectedBucketIdx = 0;
            for (int j = 0; j < NUM_TRIALS; ++j) {
                double r = this.rng.nextDouble();
                double sum = 0.0;
                selectedBucketIdx = -1;
                while ((sum += this.bucketList[++selectedBucketIdx].interval) < r) {
                }
                if (selected[j] && nSelectedBuckets < selected.length) continue;
                ++nSelectedBuckets;
                break;
            }
            selected[selectedBucketIdx] = true;
            int selectedPairIdx = this.rng.nextInt(this.bucketList[selectedBucketIdx].buckets.size());
            sample.add((IndependentPair<Point2d, Point2d>)this.bucketList[selectedBucketIdx].buckets.get(selectedPairIdx));
        }
        return sample;
    }

    private class Bucket {
        private List<IndependentPair<Point2d, Point2d>> buckets = new ArrayList<IndependentPair<Point2d, Point2d>>();
        private double interval;

        private Bucket() {
        }
    }
}

