/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264;

import java.nio.ByteBuffer;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.decode.SliceHeaderReader;
import org.jcodec.codecs.h264.io.model.NALUnit;
import org.jcodec.codecs.h264.io.model.NALUnitType;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.RefPicMarking;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.common.DemuxerTrack;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.IntObjectMap;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.model.Packet;

public class MappedH264ES
implements DemuxerTrack {
    private ByteBuffer bb;
    private SliceHeaderReader shr;
    private IntObjectMap<PictureParameterSet> pps = new IntObjectMap();
    private IntObjectMap<SeqParameterSet> sps = new IntObjectMap();
    private int prevFrameNumOffset;
    private int prevFrameNum;
    private int prevPicOrderCntMsb;
    private int prevPicOrderCntLsb;
    private int frameNo;

    public MappedH264ES(ByteBuffer bb) {
        this.bb = bb;
        this.shr = new SliceHeaderReader();
        this.frameNo = 0;
    }

    @Override
    public Packet nextFrame() {
        ByteBuffer result = this.bb.duplicate();
        NALUnit prevNu = null;
        SliceHeader prevSh = null;
        while (true) {
            Object read;
            this.bb.mark();
            ByteBuffer buf = H264Utils.nextNALUnit(this.bb);
            if (buf == null) break;
            NALUnit nu = NALUnit.read(buf);
            if (nu.type == NALUnitType.IDR_SLICE || nu.type == NALUnitType.NON_IDR_SLICE) {
                SliceHeader sh = this.readSliceHeader(buf, nu);
                if (prevNu != null && prevSh != null && !this.sameFrame(prevNu, nu, prevSh, sh)) {
                    this.bb.reset();
                    break;
                }
                prevSh = sh;
                prevNu = nu;
                continue;
            }
            if (nu.type == NALUnitType.PPS) {
                read = PictureParameterSet.read(buf);
                this.pps.put(((PictureParameterSet)read).pic_parameter_set_id, (PictureParameterSet)read);
                continue;
            }
            if (nu.type != NALUnitType.SPS) continue;
            read = SeqParameterSet.read(buf);
            this.sps.put(((SeqParameterSet)read).seq_parameter_set_id, (SeqParameterSet)read);
        }
        result.limit(this.bb.position());
        return prevSh == null ? null : this.detectPoc(result, prevNu, prevSh);
    }

    private SliceHeader readSliceHeader(ByteBuffer buf, NALUnit nu) {
        BitReader br = new BitReader(buf);
        SliceHeader sh = this.shr.readPart1(br);
        PictureParameterSet pp = this.pps.get(sh.pic_parameter_set_id);
        this.shr.readPart2(sh, nu, this.sps.get(pp.seq_parameter_set_id), pp, br);
        return sh;
    }

    private boolean sameFrame(NALUnit nu1, NALUnit nu2, SliceHeader sh1, SliceHeader sh2) {
        if (sh1.pic_parameter_set_id != sh2.pic_parameter_set_id) {
            return false;
        }
        if (sh1.frame_num != sh2.frame_num) {
            return false;
        }
        SeqParameterSet sps = sh1.sps;
        if (sps.pic_order_cnt_type == 0 && sh1.pic_order_cnt_lsb != sh2.pic_order_cnt_lsb) {
            return false;
        }
        if (sps.pic_order_cnt_type == 1 && (sh1.delta_pic_order_cnt[0] != sh2.delta_pic_order_cnt[0] || sh1.delta_pic_order_cnt[1] != sh2.delta_pic_order_cnt[1])) {
            return false;
        }
        if ((nu1.nal_ref_idc == 0 || nu2.nal_ref_idc == 0) && nu1.nal_ref_idc != nu2.nal_ref_idc) {
            return false;
        }
        if (nu1.type == NALUnitType.IDR_SLICE != (nu2.type == NALUnitType.IDR_SLICE)) {
            return false;
        }
        return sh1.idr_pic_id == sh2.idr_pic_id;
    }

    private Packet detectPoc(ByteBuffer result, NALUnit nu, SliceHeader sh) {
        int maxFrameNum = 1 << sh.sps.log2_max_frame_num_minus4 + 4;
        if (this.detectGap(sh, maxFrameNum)) {
            this.issueNonExistingPic(sh, maxFrameNum);
        }
        int absFrameNum = this.updateFrameNumber(sh.frame_num, maxFrameNum, this.detectMMCO5(sh.refPicMarkingNonIDR));
        int poc = 0;
        if (nu.type == NALUnitType.NON_IDR_SLICE) {
            poc = this.calcPoc(absFrameNum, nu, sh);
        }
        return new Packet(result, absFrameNum, 1L, 1L, this.frameNo++, nu.type == NALUnitType.IDR_SLICE, null, poc);
    }

    private int updateFrameNumber(int frameNo, int maxFrameNum, boolean mmco5) {
        int frameNumOffset = this.prevFrameNum > frameNo ? this.prevFrameNumOffset + maxFrameNum : this.prevFrameNumOffset;
        int absFrameNum = frameNumOffset + frameNo;
        this.prevFrameNum = mmco5 ? 0 : frameNo;
        this.prevFrameNumOffset = frameNumOffset;
        return absFrameNum;
    }

    private void issueNonExistingPic(SliceHeader sh, int maxFrameNum) {
        int nextFrameNum;
        this.prevFrameNum = nextFrameNum = (this.prevFrameNum + 1) % maxFrameNum;
    }

    private boolean detectGap(SliceHeader sh, int maxFrameNum) {
        return sh.frame_num != this.prevFrameNum && sh.frame_num != (this.prevFrameNum + 1) % maxFrameNum;
    }

    private int calcPoc(int absFrameNum, NALUnit nu, SliceHeader sh) {
        if (sh.sps.pic_order_cnt_type == 0) {
            return this.calcPOC0(nu, sh);
        }
        if (sh.sps.pic_order_cnt_type == 1) {
            return this.calcPOC1(absFrameNum, nu, sh);
        }
        return this.calcPOC2(absFrameNum, nu, sh);
    }

    private int calcPOC2(int absFrameNum, NALUnit nu, SliceHeader sh) {
        if (nu.nal_ref_idc == 0) {
            return 2 * absFrameNum - 1;
        }
        return 2 * absFrameNum;
    }

    private int calcPOC1(int absFrameNum, NALUnit nu, SliceHeader sh) {
        int expectedPicOrderCnt;
        if (sh.sps.num_ref_frames_in_pic_order_cnt_cycle == 0) {
            absFrameNum = 0;
        }
        if (nu.nal_ref_idc == 0 && absFrameNum > 0) {
            --absFrameNum;
        }
        int expectedDeltaPerPicOrderCntCycle = 0;
        for (int i = 0; i < sh.sps.num_ref_frames_in_pic_order_cnt_cycle; ++i) {
            expectedDeltaPerPicOrderCntCycle += sh.sps.offsetForRefFrame[i];
        }
        if (absFrameNum > 0) {
            int picOrderCntCycleCnt = (absFrameNum - 1) / sh.sps.num_ref_frames_in_pic_order_cnt_cycle;
            int frameNumInPicOrderCntCycle = (absFrameNum - 1) % sh.sps.num_ref_frames_in_pic_order_cnt_cycle;
            expectedPicOrderCnt = picOrderCntCycleCnt * expectedDeltaPerPicOrderCntCycle;
            for (int i = 0; i <= frameNumInPicOrderCntCycle; ++i) {
                expectedPicOrderCnt += sh.sps.offsetForRefFrame[i];
            }
        } else {
            expectedPicOrderCnt = 0;
        }
        if (nu.nal_ref_idc == 0) {
            expectedPicOrderCnt += sh.sps.offset_for_non_ref_pic;
        }
        return expectedPicOrderCnt + sh.delta_pic_order_cnt[0];
    }

    private int calcPOC0(NALUnit nu, SliceHeader sh) {
        int pocCntLsb = sh.pic_order_cnt_lsb;
        int maxPicOrderCntLsb = 1 << sh.sps.log2_max_pic_order_cnt_lsb_minus4 + 4;
        int picOrderCntMsb = pocCntLsb < this.prevPicOrderCntLsb && this.prevPicOrderCntLsb - pocCntLsb >= maxPicOrderCntLsb / 2 ? this.prevPicOrderCntMsb + maxPicOrderCntLsb : (pocCntLsb > this.prevPicOrderCntLsb && pocCntLsb - this.prevPicOrderCntLsb > maxPicOrderCntLsb / 2 ? this.prevPicOrderCntMsb - maxPicOrderCntLsb : this.prevPicOrderCntMsb);
        if (nu.nal_ref_idc != 0) {
            this.prevPicOrderCntMsb = picOrderCntMsb;
            this.prevPicOrderCntLsb = pocCntLsb;
        }
        return picOrderCntMsb + pocCntLsb;
    }

    private boolean detectMMCO5(RefPicMarking refPicMarkingNonIDR) {
        if (refPicMarkingNonIDR == null) {
            return false;
        }
        for (RefPicMarking.Instruction instr : refPicMarkingNonIDR.getInstructions()) {
            if (instr.getType() != RefPicMarking.InstrType.CLEAR) continue;
            return true;
        }
        return false;
    }

    public SeqParameterSet[] getSps() {
        return this.sps.values((SeqParameterSet[])new SeqParameterSet[0]);
    }

    public PictureParameterSet[] getPps() {
        return this.pps.values((PictureParameterSet[])new PictureParameterSet[0]);
    }

    @Override
    public DemuxerTrackMeta getMeta() {
        throw new UnsupportedOperationException();
    }
}

