/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg4.es;

import java.nio.ByteBuffer;
import org.jcodec.codecs.mpeg4.es.Descriptor;
import org.jcodec.codecs.mpeg4.es.NodeDescriptor;

public class DecoderConfig
extends NodeDescriptor {
    private int objectType;
    private int bufSize;
    private int maxBitrate;
    private int avgBitrate;

    public DecoderConfig(int tag, int size) {
        super(tag, size);
    }

    public DecoderConfig(int objectType, int bufSize, int maxBitrate, int avgBitrate, Descriptor ... children) {
        super(DecoderConfig.tag(), children);
        this.objectType = objectType;
        this.bufSize = bufSize;
        this.maxBitrate = maxBitrate;
        this.avgBitrate = avgBitrate;
    }

    @Override
    protected void parse(ByteBuffer input) {
        this.objectType = input.get() & 0xFF;
        input.get();
        this.bufSize = (input.get() & 0xFF) << 16 | input.getShort() & 0xFFFF;
        this.maxBitrate = input.getInt();
        this.avgBitrate = input.getInt();
        super.parse(input);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.put((byte)this.objectType);
        out.put((byte)21);
        out.put((byte)(this.bufSize >> 16));
        out.putShort((short)this.bufSize);
        out.putInt(this.maxBitrate);
        out.putInt(this.avgBitrate);
        super.doWrite(out);
    }

    public static int tag() {
        return 4;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public int getBufSize() {
        return this.bufSize;
    }

    public int getMaxBitrate() {
        return this.maxBitrate;
    }

    public int getAvgBitrate() {
        return this.avgBitrate;
    }
}

