/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.photos;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.people.User;
import com.flickr4java.flickr.photos.Editability;
import com.flickr4java.flickr.photos.GeoData;
import com.flickr4java.flickr.photos.Note;
import com.flickr4java.flickr.photos.Permissions;
import com.flickr4java.flickr.photos.PhotoUrl;
import com.flickr4java.flickr.photos.Size;
import com.flickr4java.flickr.photos.Usage;
import com.flickr4java.flickr.places.Place;
import com.flickr4java.flickr.stats.Stats;
import com.flickr4java.flickr.tags.Tag;
import com.flickr4java.flickr.util.IOUtilities;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.imageio.ImageIO;

public class Photo {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATS = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static final String DEFAULT_ORIGINAL_IMAGE_SUFFIX = "_o.jpg";
    private static final String SMALL_SQUARE_IMAGE_SUFFIX = "_s.jpg";
    private static final String SMALL_IMAGE_SUFFIX = "_m.jpg";
    private static final String THUMBNAIL_IMAGE_SUFFIX = "_t.jpg";
    private static final String MEDIUM_IMAGE_SUFFIX = ".jpg";
    private static final String LARGE_IMAGE_SUFFIX = "_b.jpg";
    private static final String LARGE_1600_IMAGE_SUFFIX = "_h.jpg";
    private static final String LARGE_2048_IMAGE_SUFFIX = "_k.jpg";
    private static final String SQUARE_LARGE_IMAGE_SUFFIX = "_q.jpg";
    private static final String SQUARE_320_IMAGE_SUFFIX = "_n.jpg";
    private static final String MEDIUM_640_IMAGE_SUFFIX = "_z.jpg";
    private static final String MEDIUM_800_IMAGE_SUFFIX = "_c.jpg";
    private Size squareSize;
    private Size smallSize;
    private Size thumbnailSize;
    private Size mediumSize;
    private Size largeSize;
    private Size large1600Size;
    private Size large2048Size;
    private Size originalSize;
    private Size squareLargeSize;
    private Size small320Size;
    private Size medium640Size;
    private Size medium800Size;
    private Size videoPlayer;
    private Size siteMP4;
    private Size videoOriginal;
    private Size mobileMP4;
    private Size hdMP4;
    private String id;
    private User owner;
    private String secret;
    private String farm;
    private String server;
    private boolean favorite;
    private String license;
    private boolean primary;
    private String title;
    private String description;
    private boolean publicFlag;
    private boolean friendFlag;
    private boolean familyFlag;
    private Date dateAdded;
    private Date datePosted;
    private Date dateTaken;
    private Date lastUpdate;
    private String takenGranularity;
    private Permissions permissions;
    private Editability editability;
    private Editability publicEditability;
    private int comments;
    private int views = -1;
    private int rotation;
    private Collection<Note> notes;
    private Collection<Tag> tags;
    private Collection<String> urls;
    private String iconServer;
    private String iconFarm;
    private String url;
    private GeoData geoData;
    private String originalFormat;
    private String originalSecret;
    private String placeId;
    private String media;
    private String mediaStatus;
    private String pathAlias;
    private int originalWidth;
    private int originalHeight;
    private PhotoUrl photoUrl;
    private Usage usage;
    private boolean hasPeople;
    private Place locality;
    private Place county;
    private Place region;
    private Place country;
    private Stats stats;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getFarm() {
        return this.farm;
    }

    public void setFarm(String farm) {
        this.farm = farm;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void setPrimary(String primary) {
        this.setPrimary("1".equals(primary));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPublicFlag() {
        return this.publicFlag;
    }

    public void setPublicFlag(boolean publicFlag) {
        this.publicFlag = publicFlag;
    }

    public boolean isFriendFlag() {
        return this.friendFlag;
    }

    public void setFriendFlag(boolean friendFlag) {
        this.friendFlag = friendFlag;
    }

    public boolean isFamilyFlag() {
        return this.familyFlag;
    }

    public void setFamilyFlag(boolean familyFlag) {
        this.familyFlag = familyFlag;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }

    public void setDateAdded(long dateAdded) {
        this.setDateAdded(new Date(dateAdded));
    }

    public void setDateAdded(String dateAdded) {
        if (dateAdded == null || "".equals(dateAdded)) {
            return;
        }
        this.setDateAdded(Long.parseLong(dateAdded) * 1000L);
    }

    public Date getDatePosted() {
        return this.datePosted;
    }

    public void setDatePosted(Date datePosted) {
        this.datePosted = datePosted;
    }

    public void setDatePosted(long datePosted) {
        this.setDatePosted(new Date(datePosted));
    }

    public void setDatePosted(String datePosted) {
        if (datePosted == null || "".equals(datePosted)) {
            return;
        }
        this.setDatePosted(Long.parseLong(datePosted) * 1000L);
    }

    public Date getDateTaken() {
        return this.dateTaken;
    }

    public void setDateTaken(Date dateTaken) {
        this.dateTaken = dateTaken;
    }

    public void setDateTaken(String dateTaken) {
        if (dateTaken == null || "".equals(dateTaken)) {
            return;
        }
        try {
            this.setDateTaken(((DateFormat)DATE_FORMATS.get()).parse(dateTaken));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setLastUpdate(String lastUpdateStr) {
        if (lastUpdateStr == null || "".equals(lastUpdateStr)) {
            return;
        }
        long unixTime = Long.parseLong(lastUpdateStr);
        this.setLastUpdate(new Date(unixTime * 1000L));
    }

    public String getTakenGranularity() {
        return this.takenGranularity;
    }

    public void setTakenGranularity(String takenGranularity) {
        this.takenGranularity = takenGranularity;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public Editability getEditability() {
        return this.editability;
    }

    public void setEditability(Editability editability) {
        this.editability = editability;
    }

    public int getComments() {
        return this.comments;
    }

    public void setComments(int comments) {
        this.comments = comments;
    }

    public void setComments(String comments) {
        if (comments != null) {
            this.setComments(Integer.parseInt(comments));
        }
    }

    public Collection<Note> getNotes() {
        return this.notes;
    }

    public void setNotes(Collection<Note> notes) {
        this.notes = notes;
    }

    public Collection<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        this.tags = tags;
    }

    public Collection<String> getUrls() {
        return this.urls;
    }

    public void setUrls(Collection<String> urls) {
        this.urls = urls;
    }

    @Deprecated
    public void setViews(String views) {
        if (views != null) {
            try {
                this.setViews(Integer.parseInt(views));
            }
            catch (NumberFormatException e) {
                this.setViews(-1);
            }
        }
    }

    @Deprecated
    public void setViews(int views) {
        this.views = views;
    }

    @Deprecated
    public int getViews() {
        return this.views;
    }

    public void setRotation(String rotation) {
        if (rotation != null) {
            try {
                this.setRotation(Integer.parseInt(rotation));
            }
            catch (NumberFormatException e) {
                this.setRotation(-1);
            }
        }
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public String getIconServer() {
        return this.iconServer;
    }

    public void setIconServer(String iconServer) {
        this.iconServer = iconServer;
    }

    public String getIconFarm() {
        return this.iconFarm;
    }

    public void setIconFarm(String iconFarm) {
        this.iconFarm = iconFarm;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public GeoData getGeoData() {
        return this.geoData;
    }

    public void setGeoData(GeoData geoData) {
        this.geoData = geoData;
    }

    public boolean hasGeoData() {
        return this.geoData != null;
    }

    public String getOriginalFormat() {
        return this.originalFormat;
    }

    public void setOriginalFormat(String originalFormat) {
        this.originalFormat = originalFormat;
    }

    public String getOriginalSecret() {
        return this.originalSecret;
    }

    public void setOriginalSecret(String originalSecret) {
        this.originalSecret = originalSecret;
    }

    @Deprecated
    public BufferedImage getOriginalImage() throws IOException, FlickrException {
        if (this.originalFormat != null) {
            return this.getOriginalImage("_o." + this.originalFormat);
        }
        return this.getOriginalImage(DEFAULT_ORIGINAL_IMAGE_SUFFIX);
    }

    @Deprecated
    public InputStream getOriginalAsStream() throws IOException, FlickrException {
        if (this.originalFormat != null) {
            return this.getOriginalImageAsStream("_o." + this.originalFormat);
        }
        return this.getOriginalImageAsStream(DEFAULT_ORIGINAL_IMAGE_SUFFIX);
    }

    public String getOriginalUrl() throws FlickrException {
        if (this.originalSize == null) {
            if (this.originalFormat != null) {
                return this.getOriginalBaseImageUrl() + "_o." + this.originalFormat;
            }
            return this.getOriginalBaseImageUrl() + DEFAULT_ORIGINAL_IMAGE_SUFFIX;
        }
        return this.originalSize.getSource();
    }

    @Deprecated
    public BufferedImage getSmallSquareImage() throws IOException {
        return this.getImage(SMALL_SQUARE_IMAGE_SUFFIX);
    }

    @Deprecated
    public InputStream getSmallSquareAsInputStream() throws IOException {
        return this.getImageAsStream(SMALL_SQUARE_IMAGE_SUFFIX);
    }

    public String getSmallSquareUrl() {
        if (this.squareSize == null) {
            return this.getBaseImageUrl() + SMALL_SQUARE_IMAGE_SUFFIX;
        }
        return this.squareSize.getSource();
    }

    @Deprecated
    public BufferedImage getThumbnailImage() throws IOException {
        return this.getImage(THUMBNAIL_IMAGE_SUFFIX);
    }

    @Deprecated
    public InputStream getThumbnailAsInputStream() throws IOException {
        return this.getImageAsStream(THUMBNAIL_IMAGE_SUFFIX);
    }

    public String getThumbnailUrl() {
        if (this.thumbnailSize == null) {
            return this.getBaseImageUrl() + THUMBNAIL_IMAGE_SUFFIX;
        }
        return this.thumbnailSize.getSource();
    }

    @Deprecated
    public BufferedImage getSmallImage() throws IOException {
        return this.getImage(SMALL_IMAGE_SUFFIX);
    }

    @Deprecated
    public InputStream getSmallAsInputStream() throws IOException {
        return this.getImageAsStream(SMALL_IMAGE_SUFFIX);
    }

    public String getSmallUrl() {
        if (this.smallSize == null) {
            return this.getBaseImageUrl() + SMALL_IMAGE_SUFFIX;
        }
        return this.smallSize.getSource();
    }

    @Deprecated
    public BufferedImage getMediumImage() throws IOException {
        return this.getImage(MEDIUM_IMAGE_SUFFIX);
    }

    @Deprecated
    public InputStream getMediumAsStream() throws IOException {
        return this.getImageAsStream(MEDIUM_IMAGE_SUFFIX);
    }

    public String getMediumUrl() {
        if (this.mediumSize == null) {
            return this.getBaseImageUrl() + MEDIUM_IMAGE_SUFFIX;
        }
        return this.mediumSize.getSource();
    }

    @Deprecated
    public BufferedImage getLargeImage() throws IOException {
        return this.getImage(LARGE_IMAGE_SUFFIX);
    }

    @Deprecated
    public InputStream getLargeAsStream() throws IOException {
        return this.getImageAsStream(LARGE_IMAGE_SUFFIX);
    }

    public String getLargeUrl() {
        if (this.largeSize == null) {
            return this.getBaseImageUrl() + LARGE_IMAGE_SUFFIX;
        }
        return this.largeSize.getSource();
    }

    public String getLarge1600Url() {
        if (this.large1600Size == null) {
            return this.getBaseImageUrl() + LARGE_1600_IMAGE_SUFFIX;
        }
        return this.large1600Size.getSource();
    }

    public String getLarge2048Url() {
        if (this.large2048Size == null) {
            return this.getBaseImageUrl() + LARGE_2048_IMAGE_SUFFIX;
        }
        return this.large2048Size.getSource();
    }

    public String getSquareLargeUrl() {
        if (this.squareLargeSize == null) {
            return this.getBaseImageUrl() + SQUARE_LARGE_IMAGE_SUFFIX;
        }
        return this.squareLargeSize.getSource();
    }

    public String getSmall320Url() {
        if (this.small320Size == null) {
            return this.getBaseImageUrl() + SQUARE_320_IMAGE_SUFFIX;
        }
        return this.small320Size.getSource();
    }

    public String getMedium640Url() {
        if (this.medium640Size == null) {
            return this.getBaseImageUrl() + MEDIUM_640_IMAGE_SUFFIX;
        }
        return this.medium640Size.getSource();
    }

    public String getMedium800Url() {
        if (this.medium800Size == null) {
            return this.getBaseImageUrl() + MEDIUM_800_IMAGE_SUFFIX;
        }
        return this.medium800Size.getSource();
    }

    public String getVideoPlayerUrl() {
        if (this.videoPlayer == null) {
            return "";
        }
        return this.videoPlayer.getSource();
    }

    public String getSiteMP4Url() {
        if (this.siteMP4 == null) {
            return "";
        }
        return this.siteMP4.getSource();
    }

    public String getVideoOriginalUrl() {
        if (this.videoOriginal == null) {
            return "";
        }
        return this.videoOriginal.getSource();
    }

    public String getMobileMp4Url() {
        if (this.mobileMP4 == null) {
            return "";
        }
        return this.mobileMP4.getSource();
    }

    public String getHdMp4Url() {
        if (this.hdMP4 == null) {
            return "";
        }
        return this.hdMP4.getSource();
    }

    @Deprecated
    private BufferedImage getImage(String suffix) throws IOException {
        StringBuffer buffer = this.getBaseImageUrl();
        buffer.append(suffix);
        return this._getImage(buffer.toString());
    }

    @Deprecated
    private BufferedImage getOriginalImage(String suffix) throws IOException, FlickrException {
        StringBuffer buffer = this.getOriginalBaseImageUrl();
        buffer.append(suffix);
        return this._getImage(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private BufferedImage _getImage(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        InputStream in = null;
        try {
            in = conn.getInputStream();
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        finally {
            IOUtilities.close(in);
        }
    }

    @Deprecated
    private InputStream getImageAsStream(String suffix) throws IOException {
        StringBuffer buffer = this.getBaseImageUrl();
        buffer.append(suffix);
        return this._getImageAsStream(buffer.toString());
    }

    @Deprecated
    private InputStream getOriginalImageAsStream(String suffix) throws IOException, FlickrException {
        StringBuffer buffer = this.getOriginalBaseImageUrl();
        buffer.append(suffix);
        return this._getImageAsStream(buffer.toString());
    }

    private InputStream _getImageAsStream(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        return conn.getInputStream();
    }

    private StringBuffer getBaseImageUrl() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this._getBaseImageUrl());
        buffer.append(this.getSecret());
        return buffer;
    }

    private StringBuffer getOriginalBaseImageUrl() throws FlickrException, NullPointerException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this._getBaseImageUrl());
        if (this.getOriginalSecret().length() <= 8) {
            throw new FlickrException("0", "OriginalUrl not available because of missing originalsecret.");
        }
        buffer.append(this.getOriginalSecret());
        return buffer;
    }

    private StringBuffer _getBaseImageUrl() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("https://farm");
        buffer.append(this.getFarm());
        buffer.append(".static.flickr.com/");
        buffer.append(this.getServer());
        buffer.append("/");
        buffer.append(this.getId());
        buffer.append("_");
        return buffer;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public String getMediaStatus() {
        return this.mediaStatus;
    }

    public void setMediaStatus(String mediaStatus) {
        this.mediaStatus = mediaStatus;
    }

    public int getOriginalWidth() {
        return this.originalWidth;
    }

    public void setOriginalWidth(String originalWidth) {
        try {
            this.setOriginalWidth(Integer.parseInt(originalWidth));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setOriginalWidth(int originalWidth) {
        this.originalWidth = originalWidth;
    }

    public int getOriginalHeight() {
        return this.originalHeight;
    }

    public void setOriginalHeight(String originalHeight) {
        try {
            this.setOriginalHeight(Integer.parseInt(originalHeight));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setOriginalHeight(int originalHeight) {
        this.originalHeight = originalHeight;
    }

    public void setSizes(Collection<Size> sizes) {
        for (Size size : sizes) {
            if (size.getLabel() == 2) {
                this.smallSize = size;
                continue;
            }
            if (size.getLabel() == 1) {
                this.squareSize = size;
                continue;
            }
            if (size.getLabel() == 0) {
                this.thumbnailSize = size;
                continue;
            }
            if (size.getLabel() == 3) {
                this.mediumSize = size;
                continue;
            }
            if (size.getLabel() == 4) {
                this.largeSize = size;
                continue;
            }
            if (size.getLabel() == 10) {
                this.large1600Size = size;
                continue;
            }
            if (size.getLabel() == 11) {
                this.large2048Size = size;
                continue;
            }
            if (size.getLabel() == 5) {
                this.originalSize = size;
                continue;
            }
            if (size.getLabel() == 6) {
                this.squareLargeSize = size;
                continue;
            }
            if (size.getLabel() == 7) {
                this.small320Size = size;
                continue;
            }
            if (size.getLabel() == 8) {
                this.medium640Size = size;
                continue;
            }
            if (size.getLabel() == 9) {
                this.medium800Size = size;
                continue;
            }
            if (size.getLabel() == 13) {
                this.videoPlayer = size;
                continue;
            }
            if (size.getLabel() == 12) {
                this.siteMP4 = size;
                continue;
            }
            if (size.getLabel() == 14) {
                this.videoOriginal = size;
                continue;
            }
            if (size.getLabel() == 15) {
                this.mobileMP4 = size;
                continue;
            }
            if (size.getLabel() != 16) continue;
            this.hdMP4 = size;
        }
    }

    public Size getSquareSize() {
        return this.squareSize;
    }

    public Size getSmallSize() {
        return this.smallSize;
    }

    public Size getThumbnailSize() {
        return this.thumbnailSize;
    }

    public Size getMediumSize() {
        return this.mediumSize;
    }

    public Size getLargeSize() {
        return this.largeSize;
    }

    public Size getLarge1600Size() {
        return this.large1600Size;
    }

    public Size getLarge2048Size() {
        return this.large2048Size;
    }

    public Size getOriginalSize() {
        return this.originalSize;
    }

    public Size getSquareLargeSize() {
        return this.squareLargeSize;
    }

    public Size getSmall320Size() {
        return this.small320Size;
    }

    public Size getMedium640Size() {
        return this.medium640Size;
    }

    public Size getMedium800Size() {
        return this.medium800Size;
    }

    public Size getVideoPlayerSize() {
        return this.videoPlayer;
    }

    public Size getSiteMP4Size() {
        return this.siteMP4;
    }

    public Size getVideoOriginalSize() {
        return this.videoOriginal;
    }

    public Size getMobileMp4() {
        return this.mobileMP4;
    }

    public void setMobileMp4(Size mobileMP4) {
        this.mobileMP4 = mobileMP4;
    }

    public Size getHdMp4() {
        return this.hdMP4;
    }

    public void setHdMp4(Size hdMP4) {
        this.hdMP4 = hdMP4;
    }

    public String getPathAlias() {
        return this.pathAlias;
    }

    public void setPathAlias(String pathAlias) {
        this.pathAlias = pathAlias;
    }

    public Stats getStats() {
        return this.stats;
    }

    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Photo test = (Photo)obj;
        return this.areEqual(this.id, test.id) && this.areEqual(this.secret, test.secret);
    }

    public int hashCode() {
        int hash = 83;
        if (this.id != null) {
            hash ^= this.id.hashCode();
        }
        if (this.secret != null) {
            hash ^= this.secret.hashCode();
        }
        return hash;
    }

    private boolean areEqual(Object x, Object y) {
        return x == null ? y == null : x.equals(y);
    }

    public PhotoUrl getPhotoUrl() {
        return this.photoUrl;
    }

    public void setPhotoUrl(PhotoUrl photoUrl) {
        this.photoUrl = photoUrl;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public void setUsage(Usage usage) {
        this.usage = usage;
    }

    public Editability getPublicEditability() {
        return this.publicEditability;
    }

    public void setPublicEditability(Editability publicEditability) {
        this.publicEditability = publicEditability;
    }

    public boolean isHasPeople() {
        return this.hasPeople;
    }

    public void setIsHasPeople(boolean hasPeople) {
        this.hasPeople = hasPeople;
    }

    public Place getLocality() {
        return this.locality;
    }

    public void setLocality(Place locality) {
        this.locality = locality;
    }

    public Place getCounty() {
        return this.county;
    }

    public void setCounty(Place county) {
        this.county = county;
    }

    public Place getRegion() {
        return this.region;
    }

    public void setRegion(Place region) {
        this.region = region;
    }

    public Place getCountry() {
        return this.country;
    }

    public void setCountry(Place country) {
        this.country = country;
    }
}

