/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.bridj.AbstractBridJRuntime;
import org.bridj.BridJ;
import org.bridj.BridJRuntime;
import org.bridj.Callback;
import org.bridj.CallbackInterface;
import org.bridj.CallbackNativeImplementer;
import org.bridj.DynamicFunction;
import org.bridj.DynamicFunctionFactory;
import org.bridj.IntValuedEnum;
import org.bridj.JNI;
import org.bridj.MethodCallInfo;
import org.bridj.NativeEntities;
import org.bridj.NativeLibrary;
import org.bridj.NativeObject;
import org.bridj.NativeObjectInterface;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.ann.Convention;
import org.bridj.ann.JNIBound;
import org.bridj.ann.Optional;
import org.bridj.demangling.Demangler;
import org.bridj.util.AnnotationUtils;
import org.bridj.util.ConcurrentCache;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRuntime
extends AbstractBridJRuntime {
    static final Set<Type> registeredTypes = new HashSet<Type>();
    final AtomicReference<CallbackNativeImplementer> _callbackNativeImplementer = new AtomicReference();
    static final int defaultObjectSize = Platform.is64Bits() ? 8 : 4;
    public static final String PROPERTY_bridj_c_defaultObjectSize = "bridj.c.defaultObjectSize";
    protected Set<Class> rootCallbackClasses = new HashSet<Class>(Arrays.asList(Callback.class, DynamicFunction.class));

    @Deprecated
    public CRuntime() {
    }

    public CallbackNativeImplementer getCallbackNativeImplementer() {
        CallbackNativeImplementer impl = this._callbackNativeImplementer.get();
        if (impl == null) {
            CallbackNativeImplementer newImpl = new CallbackNativeImplementer(BridJ.getOrphanEntities(), this);
            impl = this._callbackNativeImplementer.compareAndSet(null, newImpl) ? newImpl : this._callbackNativeImplementer.get();
        }
        return impl;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public static CRuntime getInstance() {
        return BridJ.getRuntimeByRuntimeClass(CRuntime.class);
    }

    @Override
    public <T extends NativeObject> Class<? extends T> getActualInstanceClass(Pointer<T> pInstance, Type officialType) {
        return Utils.getClass(officialType);
    }

    protected boolean shouldWarnIfNoFieldsInStruct() {
        return true;
    }

    @Override
    public <T extends NativeObject> BridJRuntime.TypeInfo<T> getTypeInfo(Type type) {
        return new CTypeInfo(type);
    }

    @Override
    public Type getType(Class<?> cls, Object[] targs, int[] typeParamCount) {
        return cls;
    }

    @Override
    public void register(Type type) {
        this.register(type, null, null);
    }

    @Override
    public void unregister(Type type) {
        Class typeClass = Utils.getClass(type);
        registeredTypes.remove(typeClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void register(Type type, NativeLibrary forcedLibrary, MethodCallInfoBuilder methodCallInfoBuilder) {
        block23: {
            Class typeClass = Utils.getClass(type);
            if (!BridJ.getRuntimeClass(typeClass).isInstance(this)) {
                BridJ.register(typeClass);
                return;
            }
            Set<Type> set = registeredTypes;
            synchronized (set) {
                if (!registeredTypes.add(typeClass)) {
                    return;
                }
            }
            if (methodCallInfoBuilder == null) {
                methodCallInfoBuilder = new MethodCallInfoBuilder();
            }
            if (BridJ.verbose) {
                BridJ.info("Registering type " + Utils.toString(type));
            }
            int typeModifiers = typeClass.getModifiers();
            NativeLibrary typeLibrary = null;
            try {
                typeLibrary = forcedLibrary == null ? this.getNativeLibrary(typeClass) : forcedLibrary;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ConcurrentCache<NativeEntities, NativeEntities.Builder> builders = new ConcurrentCache<NativeEntities, NativeEntities.Builder>(NativeEntities.Builder.class);
            try {
                HashSet<Method> handledMethods = new HashSet<Method>();
                if (CallbackInterface.class.isAssignableFrom(typeClass)) {
                    if (this.rootCallbackClasses.contains(type)) {
                        return;
                    }
                    if (Modifier.isAbstract(typeModifiers)) {
                        this.getCallbackNativeImplementer().getCallbackImplType((Class)type, forcedLibrary);
                    }
                }
                ArrayList<Method> nativeMethods = new ArrayList<Method>();
                for (Method method : typeClass.getDeclaredMethods()) {
                    int modifiers = method.getModifiers();
                    if (!Modifier.isNative(modifiers) || AnnotationUtils.isAnnotationPresent(JNIBound.class, method, new Annotation[0])) continue;
                    nativeMethods.add(method);
                }
                if (nativeMethods.isEmpty()) break block23;
                try {
                    for (Method method : nativeMethods) {
                        if (!handledMethods.add(method)) continue;
                        try {
                            NativeLibrary methodLibrary = forcedLibrary == null ? BridJ.getNativeLibrary(method) : forcedLibrary;
                            NativeEntities nativeEntities = methodLibrary == null ? BridJ.getOrphanEntities() : methodLibrary.getNativeEntities();
                            NativeEntities.Builder builder = builders.get(nativeEntities);
                            this.registerNativeMethod(typeClass, typeLibrary, method, methodLibrary, builder, methodCallInfoBuilder);
                        }
                        catch (Exception ex) {
                            if (!BridJ.verbose) continue;
                            BridJ.error("Method " + method.toGenericString() + " cannot be mapped : " + ex, ex);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to register class " + Utils.toString(type), ex);
                }
            }
            finally {
                for (Map.Entry e : builders.entrySet()) {
                    ((NativeEntities)e.getKey()).addDefinitions(typeClass, e.getValue());
                }
                this.registerFamily(type, forcedLibrary, methodCallInfoBuilder);
            }
        }
    }

    protected void registerFamily(Type type, NativeLibrary forcedLibrary, MethodCallInfoBuilder methodCallInfoBuilder) {
        Class typeClass = Utils.getClass(type);
        for (Class<?> child : typeClass.getClasses()) {
            this.register(child, forcedLibrary, methodCallInfoBuilder);
        }
        if ((typeClass = typeClass.getSuperclass()) != null && typeClass != Object.class) {
            this.register(typeClass, forcedLibrary, methodCallInfoBuilder);
        }
    }

    protected NativeLibrary getNativeLibrary(Class<?> type) throws IOException {
        return BridJ.getNativeLibrary(type);
    }

    protected boolean isSymbolOptional(Method method) {
        return AnnotationUtils.getInheritableAnnotation(Optional.class, method, new Annotation[0]) != null;
    }

    protected void registerNativeMethod(Class<?> type, NativeLibrary typeLibrary, Method method, NativeLibrary methodLibrary, NativeEntities.Builder builder, MethodCallInfoBuilder methodCallInfoBuilder) throws FileNotFoundException {
        MethodCallInfo mci;
        try {
            mci = methodCallInfoBuilder.apply(method);
            if (mci == null) {
                return;
            }
        }
        catch (Throwable th) {
            BridJ.error("Unable to register " + method + " : " + th);
            th.printStackTrace();
            return;
        }
        if (CallbackInterface.class.isAssignableFrom(type)) {
            if (BridJ.debug) {
                BridJ.info("Registering java -> native callback : " + method);
            }
            builder.addJavaToNativeCallback(mci);
        } else {
            Convention.Style cc;
            Demangler.Symbol symbol;
            Demangler.Symbol symbol2 = symbol = methodLibrary == null ? null : methodLibrary.getSymbol(method);
            if (symbol == null) {
                if (!this.isSymbolOptional(method)) {
                    BridJ.error("Failed to get address of method " + method);
                }
                return;
            }
            mci.setForwardedPointer(symbol.getAddress());
            if (!mci.hasCallingConvention() && (cc = symbol.getInferredCallingConvention()) != null) {
                mci.setCallingConvention(cc);
            }
            builder.addFunction(mci);
            if (BridJ.debug) {
                BridJ.info("Registering " + method + " as C function " + symbol.getName() + " (address = 0x" + Long.toHexString(symbol.getAddress()) + ")");
            }
        }
    }

    public <T extends NativeObject> Pointer<T> allocate(Class<T> type, int constructorId, Object ... args) {
        if (CallbackInterface.class.isAssignableFrom(type)) {
            if (constructorId != -1 || args.length != 0) {
                throw new RuntimeException("Callback should have a constructorId == -1 and no constructor args !");
            }
            return null;
        }
        throw new RuntimeException("Cannot allocate instance of type " + type.getName() + " (unhandled NativeObject subclass)");
    }

    public int getDefaultStructSize() {
        String s = System.getProperty(PROPERTY_bridj_c_defaultObjectSize);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (Throwable th) {
                BridJ.error("Invalid value for property bridj.c.defaultObjectSize : '" + s + "'");
            }
        }
        return defaultObjectSize;
    }

    public long sizeOf(Type structType, StructIO io) {
        long size;
        if (io == null) {
            io = StructIO.getInstance(Utils.getClass(structType), structType);
        }
        if (io == null || (size = io.desc.getStructSize()) <= 0L) {
            return this.getDefaultStructSize();
        }
        return size;
    }

    public Method getUniqueCallbackMethod(Class type) {
        return this.getCallbackMethod(type, true);
    }

    public Method getFastestCallbackMethod(Class type) {
        return this.getCallbackMethod(type, false);
    }

    private Method getSingleAbstractMethodMethod(Class type) {
        Method[] declaredMethods;
        assert (Modifier.isAbstract(type.getModifiers()));
        Method method = null;
        for (Method dm : declaredMethods = type.getDeclaredMethods()) {
            int modifiers = dm.getModifiers();
            if (!Modifier.isAbstract(modifiers)) continue;
            if (method == null) {
                method = dm;
                continue;
            }
            throw new RuntimeException("Callback " + type.getName() + " has more than one abstract method (" + dm + " and " + method + ")");
        }
        return method;
    }

    private boolean sameBindings(Method m1, Method m2) {
        Class<?> r2;
        Class<?>[] params1 = m1.getParameterTypes();
        Class<?>[] params2 = m2.getParameterTypes();
        Class<?> r1 = m1.getReturnType();
        if (!CRuntime.sameBindings(r1, r2 = m2.getReturnType()) || params1.length != params2.length) {
            return false;
        }
        for (int i = 0; i < params1.length; ++i) {
            Class<?> p1 = params1[i];
            Class<?> p2 = params2[i];
            if (CRuntime.sameBindings(p1, p2)) continue;
            return false;
        }
        return true;
    }

    private static int getSignatureObjectCount(Class t) {
        return t.isPrimitive() ? 0 : 1;
    }

    private int getSignatureObjectCount(Method m) {
        int count = CRuntime.getSignatureObjectCount(m.getReturnType());
        for (Class<?> param : m.getParameterTypes()) {
            count += CRuntime.getSignatureObjectCount(param);
        }
        return count;
    }

    public List<Method> getApplyMethods(Class type) {
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method method : type.getDeclaredMethods()) {
            if (!method.getName().equals("apply")) continue;
            ret.add(method);
        }
        return ret;
    }

    public Class<?> getAbstractCallback(Class type) {
        Class parent = null;
        while ((parent = type.getSuperclass()) != null && !this.rootCallbackClasses.contains(parent)) {
            type = parent;
        }
        if (!Modifier.isAbstract(type.getModifiers())) {
            throw new RuntimeException("Callback definition " + type.getName() + " must be abstract.");
        }
        return type;
    }

    public Method getCallbackMethod(Class<?> type, boolean expectUniqueMethod) {
        boolean overridesOnlyOneMethod;
        Class<?> abstractCallback = this.getAbstractCallback(type);
        Method singleAbstractMethod = this.getSingleAbstractMethodMethod(abstractCallback);
        if (singleAbstractMethod != null) {
            return singleAbstractMethod;
        }
        List<Method> applyList = this.getApplyMethods(type);
        if (applyList.isEmpty()) {
            throw new RuntimeException("Type doesn't have any abstract method nor any 'apply' method: " + abstractCallback.getName());
        }
        Method m0 = applyList.get(0);
        int n = applyList.size();
        for (int i = 1; i < n; ++i) {
            Method mi = applyList.get(i);
            if (this.sameBindings(m0, mi)) continue;
            throw new RuntimeException("Callback apply methods don't match: " + m0 + " vs. " + mi);
        }
        boolean bl = overridesOnlyOneMethod = applyList.size() == 1;
        if (expectUniqueMethod && !overridesOnlyOneMethod) {
            throw new RuntimeException("Expected only one overridden apply method in " + type.getName() + ", but got " + applyList);
        }
        if (overridesOnlyOneMethod) {
            return applyList.get(0);
        }
        int bestCount = Integer.MAX_VALUE;
        Method best = null;
        for (Method m : applyList) {
            int count = this.getSignatureObjectCount(m);
            if (count >= bestCount) continue;
            bestCount = count;
            best = m;
        }
        return best;
    }

    private static boolean sameBindings(Class t1, Class t2) {
        return t1.equals(t2) || t1 == Long.TYPE && Pointer.class.isAssignableFrom(t2) || t2 == Long.TYPE && Pointer.class.isAssignableFrom(t1) || t1 == Integer.TYPE && IntValuedEnum.class.isAssignableFrom(t2) || t2 == Integer.TYPE && IntValuedEnum.class.isAssignableFrom(t1);
    }

    public <T extends NativeObject> Class<? extends T> getTypeForCast(Type type) {
        Class typeClass = Utils.getClass(type);
        if (CallbackInterface.class.isAssignableFrom(typeClass)) {
            return this.getCallbackNativeImplementer().getCallbackImplType(typeClass, null);
        }
        return typeClass;
    }

    public DynamicFunctionFactory getDynamicFunctionFactory(NativeLibrary library, Convention.Style callingConvention, Type returnType, Type ... parameterTypes) {
        return this.getCallbackNativeImplementer().getDynamicCallback(library, callingConvention, returnType, parameterTypes);
    }

    public static <T> Pointer<T> createCToJavaCallback(MethodCallInfo mci, Type t) {
        mci.prependCallbackCC();
        final long handle = JNI.createCToJavaCallback(mci);
        long peer = JNI.getActualCToJavaCallback(handle);
        Throwable stackTrace = BridJ.debugPointers ? new RuntimeException().fillInStackTrace() : null;
        return Pointer.pointerToAddress(peer, t, new Pointer.Releaser(){

            @Override
            public void release(Pointer<?> p) {
                if (BridJ.debugPointers) {
                    BridJ.info("Freeing callback pointer " + p + "\n(Creation trace = \n\t" + Utils.toString(p.creationTrace).replaceAll("\n", "\n\t") + "\n)", new RuntimeException().fillInStackTrace());
                }
                if (BridJ.debugNeverFree) {
                    return;
                }
                JNI.freeCToJavaCallback(handle);
            }
        });
    }

    protected <T extends CallbackInterface> Pointer<T> registerCallbackInstance(T instance) {
        try {
            Class<?> c = instance.getClass();
            MethodCallInfo mci = new MethodCallInfo(this.getFastestCallbackMethod(c));
            mci.setDeclaringClass(c);
            mci.setJavaCallback(instance);
            return CRuntime.createCToJavaCallback(mci, c);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register callback instance of type " + instance.getClass().getName(), e);
        }
    }

    protected void setNativeObjectPeer(NativeObjectInterface instance, Pointer<? extends NativeObjectInterface> peer) {
        ((NativeObject)instance).peer = peer;
    }

    public static class MethodCallInfoBuilder {
        public MethodCallInfo apply(Method method) throws FileNotFoundException {
            return new MethodCallInfo(method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CTypeInfo<T extends NativeObject>
    implements BridJRuntime.TypeInfo<T> {
        protected final Type type;
        protected final Class<T> typeClass;
        protected final StructIO structIO;
        protected final PointerIO<T> pointerIO;
        protected volatile Class<T> castClass;

        public CTypeInfo(Type type) {
            this.type = type;
            this.typeClass = Utils.getClass(type);
            this.structIO = StructIO.getInstance(this.typeClass, type);
            if (this.structIO != null) {
                this.structIO.desc.build();
                if (BridJ.verbose && this.structIO.desc.getAggregatedFields().isEmpty() && CRuntime.this.shouldWarnIfNoFieldsInStruct()) {
                    BridJ.info("No fields found in " + Utils.toString(type) + " (maybe they weren't declared as public ?)");
                }
            }
            this.pointerIO = PointerIO.getInstance(this.structIO);
            CRuntime.this.register(this.typeClass);
        }

        @Override
        public long sizeOf() {
            return this.structIO.desc.getStructSize();
        }

        @Override
        public boolean equal(T instance, T other) {
            if (this.structIO != null) {
                if (((StructObject)instance).io != this.structIO) {
                    throw new IllegalArgumentException("This is not this instance's StructIO");
                }
                if (((StructObject)other).io != this.structIO) {
                    return false;
                }
                return this.structIO.equal((StructObject)instance, (StructObject)other);
            }
            return ((NativeObject)instance).peer.equals(((NativeObject)other).peer);
        }

        @Override
        public int compare(T instance, T other) {
            if (this.structIO != null) {
                if (((StructObject)instance).io != this.structIO) {
                    throw new IllegalArgumentException("This is not this instance's StructIO");
                }
                if (((StructObject)other).io != this.structIO) {
                    return 1;
                }
                return this.structIO.compare((StructObject)instance, (StructObject)other);
            }
            return ((NativeObject)instance).peer.compareTo(((NativeObject)other).peer);
        }

        @Override
        public BridJRuntime getRuntime() {
            return CRuntime.this;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        protected Class<T> getCastClass() {
            if (this.castClass == null) {
                this.castClass = CRuntime.this.getTypeForCast(this.typeClass);
            }
            return this.castClass;
        }

        protected T newCastInstance() throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Class<T> cc = this.getCastClass();
            try {
                return (T)((NativeObject)cc.newInstance());
            }
            catch (IllegalAccessException ex) {
                Constructor<T> constructor = cc.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (T)((NativeObject)constructor.newInstance(new Object[0]));
            }
        }

        @Override
        public T cast(Pointer peer) {
            try {
                T instance = this.newCastInstance();
                this.initialize(instance, peer);
                return instance;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to cast pointer " + peer + " to instance of type " + Utils.toString(this.type), ex);
            }
        }

        @Override
        public T createReturnInstance() {
            try {
                T instance = this.newCastInstance();
                this.initialize(instance);
                return instance;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create return instance for type " + Utils.toString(this.type), ex);
            }
        }

        @Override
        public void writeToNative(T instance) {
            if (instance instanceof StructObject) {
                this.structIO.writeFieldsToNative((StructObject)instance);
            }
        }

        @Override
        public void readFromNative(T instance) {
            if (instance instanceof StructObject) {
                this.structIO.readFieldsFromNative((StructObject)instance);
            }
        }

        @Override
        public void copyNativeObjectToAddress(T instance, Pointer<T> ptr) {
            if (instance instanceof StructObject) {
                ((StructObject)instance).peer.copyBytesTo(ptr, this.structIO.desc.getStructSize());
            }
        }

        @Override
        public String describe(T instance) {
            if (instance instanceof StructObject) {
                return this.structIO.describe((StructObject)instance);
            }
            return instance.toString();
        }

        @Override
        public String describe() {
            if (this.structIO != null) {
                return this.structIO.desc.describe();
            }
            return Utils.toString(this.typeClass);
        }

        @Override
        public void initialize(T instance) {
            if (!BridJ.isCastingNativeObjectInCurrentThread()) {
                if (instance instanceof CallbackInterface) {
                    if (!(instance instanceof DynamicFunction)) {
                        CRuntime.this.setNativeObjectPeer((NativeObjectInterface)instance, (Pointer<? extends NativeObjectInterface>)CRuntime.this.registerCallbackInstance((CallbackInterface)instance));
                    }
                } else {
                    this.initialize(instance, -1, new Object[0]);
                }
                if (instance instanceof StructObject) {
                    this.structIO.readFieldsFromNative((StructObject)instance);
                }
            } else if (instance instanceof StructObject) {
                ((StructObject)instance).io = this.structIO;
            }
        }

        @Override
        public void initialize(T instance, Pointer peer) {
            ((NativeObject)instance).peer = peer;
            if (instance instanceof StructObject) {
                ((StructObject)instance).io = this.structIO;
                this.structIO.readFieldsFromNative((StructObject)instance);
            }
        }

        protected <V> Pointer<V> allocateStructMemory(PointerIO<V> pointerIO) {
            return Pointer.allocate(pointerIO);
        }

        @Override
        public void initialize(T instance, int constructorId, Object ... args) {
            StructObject s = (StructObject)instance;
            if (constructorId < 0) {
                s.io = this.structIO;
                if (((NativeObject)instance).peer == null) {
                    ((NativeObject)instance).peer = this.allocateStructMemory(this.pointerIO);
                }
            } else {
                throw new UnsupportedOperationException("TODO implement structs constructors !");
            }
        }

        @Override
        public T clone(T instance) throws CloneNotSupportedException {
            if (instance == null) {
                return null;
            }
            try {
                NativeObject clone = (NativeObject)this.typeClass.newInstance();
                Pointer<T> p = this.allocateStructMemory(this.pointerIO);
                Pointer.getPointer(instance).copyTo(p);
                this.initialize(clone, p);
                return (T)clone;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to clone instance of type " + this.getType());
            }
        }

        @Override
        public void destroy(T instance) {
            if (instance instanceof CallbackInterface) {
                return;
            }
        }
    }
}

