/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nlogo.mc.Model;
import org.nlogo.mc.PostRequest;

public strictfp abstract class SearchForModelsRequest
extends PostRequest {
    public SearchForModelsRequest(HttpClient http, String queryString, int count, boolean changeability) {
        super(http, "http://modelingcommons.org/account/models");
        this.addStringParam("query", queryString);
        this.addStringParam("count", "" + count);
        if (changeability) {
            this.addStringParam("changeability", "changeability");
        }
    }

    @Override
    protected void onReturn(String response) {
        if (response == null) {
            this.onSearchResults("ABORTED_OR_CONNECTION_ERROR", null);
        } else {
            JSONParser json = new JSONParser();
            try {
                ArrayList<Model> out = new ArrayList<Model>();
                JSONObject obj = (JSONObject)json.parse(response);
                JSONArray models = (JSONArray)obj.get((Object)"models");
                for (Object modelObj : models) {
                    JSONObject model = (JSONObject)modelObj;
                    String modelName = (String)model.get((Object)"name");
                    int modelId = ((Number)model.get((Object)"id")).intValue();
                    out.add(new Model(modelId, modelName));
                }
                this.onSearchResults("SUCCESS", out);
            }
            catch (ParseException e) {
                this.onSearchResults("INVALID_RESPONSE_FROM_SERVER", null);
            }
        }
    }

    protected abstract void onSearchResults(String var1, List<Model> var2);
}

