/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.concurrent;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.openimaj.util.concurrent.BlockingDroppingQueue;

public class ArrayBlockingDroppingQueue<E>
extends AbstractQueue<E>
implements BlockingDroppingQueue<E>,
Serializable {
    private static final long serialVersionUID = -2040484277582233451L;
    private long insertCount;
    private long dropCount;
    private final E[] items;
    private int takeIndex;
    private int putIndex;
    private int count;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        E[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E ret = null;
            if (this.count == items.length) {
                ret = this.extract();
                ++this.dropCount;
            }
            this.insert(e);
            E e2 = ret;
            return e2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertCount() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            long l = this.insertCount;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long dropCount() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            long l = this.dropCount;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    private void insert(E x) {
        this.items[this.putIndex] = x;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        ++this.insertCount;
        this.notEmpty.signal();
    }

    final int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }

    private E extract() {
        E[] items = this.items;
        E x = items[this.takeIndex];
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return x;
    }

    void removeAt(int i) {
        E[] items = this.items;
        if (i == this.takeIndex) {
            items[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int nexti;
            while ((nexti = this.inc(i)) != this.putIndex) {
                items[i] = items[nexti];
                i = nexti;
            }
            items[i] = null;
            this.putIndex = i;
        }
        --this.count;
        this.notFull.signal();
    }

    public ArrayBlockingDroppingQueue(int capacity) {
        this(capacity, false);
    }

    public ArrayBlockingDroppingQueue(int capacity, boolean fair) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[capacity];
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public ArrayBlockingDroppingQueue(int capacity, boolean fair, Collection<? extends E> c) {
        this(capacity, fair);
        if (capacity < c.size()) {
            throw new IllegalArgumentException();
        }
        Iterator<E> it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    @Override
    public boolean add(E e) {
        return super.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count == this.items.length) {
                boolean bl = false;
                return bl;
            }
            this.insert(e);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E x;
            if (this.count == 0) {
                E e = null;
                return e;
            }
            E e = x = this.extract();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            E x;
            try {
                while (this.count == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            E e = x = this.extract();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.count == 0 ? null : (E)this.items[this.takeIndex];
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.items.length - this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        E[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = 0;
            while (true) {
                if (k++ >= this.count) {
                    boolean bl = false;
                    return bl;
                }
                if (o.equals(items[i])) {
                    this.removeAt(i);
                    boolean bl = true;
                    return bl;
                }
                i = this.inc(i);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        E[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = 0;
            while (k++ < this.count) {
                if (o.equals(items[i])) {
                    boolean bl = true;
                    return bl;
                }
                i = this.inc(i);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        E[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] a = new Object[this.count];
            int k = 0;
            int i = this.takeIndex;
            while (k < this.count) {
                a[k++] = items[i];
                i = this.inc(i);
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        E[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (a.length < this.count) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.count);
            }
            int k = 0;
            int i = this.takeIndex;
            while (k < this.count) {
                a[k++] = items[i];
                i = this.inc(i);
            }
            if (a.length > this.count) {
                a[this.count] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        E[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = this.count;
            while (k-- > 0) {
                items[i] = null;
                i = this.inc(i);
            }
            this.count = 0;
            this.putIndex = 0;
            this.takeIndex = 0;
            this.notFull.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        E[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int i = this.takeIndex;
            int max = this.count;
            for (n = 0; n < max; ++n) {
                c.add(items[i]);
                items[i] = null;
                i = this.inc(i);
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        E[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int max;
            int i = this.takeIndex;
            int n2 = max = maxElements < this.count ? maxElements : this.count;
            for (n = 0; n < max; ++n) {
                c.add(items[i]);
                items[i] = null;
                i = this.inc(i);
            }
            if (n > 0) {
                this.count -= n;
                this.takeIndex = i;
                this.notFull.signalAll();
            }
            int n3 = n;
            return n3;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Itr itr = new Itr();
            return itr;
        }
        finally {
            lock.unlock();
        }
    }

    private class Itr
    implements Iterator<E> {
        private int nextIndex;
        private E nextItem;
        private int lastRet = -1;

        Itr() {
            if (ArrayBlockingDroppingQueue.this.count == 0) {
                this.nextIndex = -1;
            } else {
                this.nextIndex = ArrayBlockingDroppingQueue.this.takeIndex;
                this.nextItem = ArrayBlockingDroppingQueue.this.items[ArrayBlockingDroppingQueue.this.takeIndex];
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        private void checkNext() {
            if (this.nextIndex == ArrayBlockingDroppingQueue.this.putIndex) {
                this.nextIndex = -1;
                this.nextItem = null;
            } else {
                this.nextItem = ArrayBlockingDroppingQueue.this.items[this.nextIndex];
                if (this.nextItem == null) {
                    this.nextIndex = -1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            ReentrantLock lock = ArrayBlockingDroppingQueue.this.lock;
            lock.lock();
            try {
                if (this.nextIndex < 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                Object x = this.nextItem;
                this.nextIndex = ArrayBlockingDroppingQueue.this.inc(this.nextIndex);
                this.checkNext();
                Object e = x;
                return e;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock lock = ArrayBlockingDroppingQueue.this.lock;
            lock.lock();
            try {
                int i = this.lastRet;
                if (i == -1) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                int ti = ArrayBlockingDroppingQueue.this.takeIndex;
                ArrayBlockingDroppingQueue.this.removeAt(i);
                this.nextIndex = i == ti ? ArrayBlockingDroppingQueue.this.takeIndex : i;
                this.checkNext();
            }
            finally {
                lock.unlock();
            }
        }
    }
}

