/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util;

import com.github.sarxos.webcam.WebcamException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static final String FORMAT_GIF = "GIF";
    public static final String FORMAT_PNG = "PNG";
    public static final String FORMAT_JPG = "JPG";
    public static final String FORMAT_BMP = "BMP";
    public static final String FORMAT_WBMP = "WBMP";

    public static byte[] toByteArray(BufferedImage image, String format) {
        byte[] bytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, format, baos);
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new WebcamException(e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new WebcamException(e);
            }
        }
        return bytes;
    }

    public static BufferedImage readFromResource(String resource) {
        InputStream is = null;
        try {
            is = ImageUtils.class.getClassLoader().getResourceAsStream(resource);
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    public static BufferedImage createEmptyImage(BufferedImage source) {
        return new BufferedImage(source.getWidth(), source.getHeight(), 1);
    }

    public static int clamp(int c) {
        if (c < 0) {
            return 0;
        }
        if (c > 255) {
            return 255;
        }
        return c;
    }

    public static byte[] imageToBytes(BufferedImage bi) {
        return ((DataBufferByte)bi.getData().getDataBuffer()).getData();
    }
}

