/*
 * Decompiled with CFR 0.152.
 */
package bsearch.algorithms;

import bsearch.algorithms.SearchMethod;
import bsearch.app.BehaviorSearchException;
import bsearch.util.GeneralUtils;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

public class SearchMethodLoader {
    public static SearchMethod createFromName(String searchMethodName) throws BehaviorSearchException {
        SearchMethod searcher;
        String searchMethodClassName = searchMethodName;
        if (!searchMethodClassName.contains(".")) {
            searchMethodClassName = "bsearch.algorithms." + searchMethodClassName;
        }
        try {
            searcher = (SearchMethod)Class.forName(searchMethodClassName).newInstance();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            throw new BehaviorSearchException("Failed to find/load SearchMethod from Java class: " + searchMethodClassName);
        }
        return searcher;
    }

    public static List<String> getAllSearchMethodNames() throws BehaviorSearchException {
        Scanner scanner;
        try {
            scanner = new Scanner(GeneralUtils.getResource("SearchMethodList.txt"));
        }
        catch (FileNotFoundException e) {
            throw new BehaviorSearchException("Error loading list of SearchMethod names: File 'SearchMethodList.txt' couldn't be found.");
        }
        LinkedList<String> list = new LinkedList<String>();
        while (scanner.hasNextLine()) {
            String s = scanner.nextLine();
            if (s.trim().length() <= 0) continue;
            list.add(s);
        }
        return list;
    }
}

