/*
 * Decompiled with CFR 0.152.
 */
package bsearch.app;

import bsearch.util.GeneralUtils;
import bsearch.util.Stats;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public strictfp class SearchProtocol {
    public final double bsearchVersionNumber;
    public final String modelFile;
    public final String modelStepCommands;
    public final String modelSetupCommands;
    public final String modelStopCondition;
    public final int modelStepLimit;
    public final String modelMetricReporter;
    public final String modelMeasureIf;
    public final List<String> paramSpecStrings;
    public final boolean fitnessMinimized;
    public final int fitnessSamplingReplications;
    public final FITNESS_COLLECTING fitnessCollecting;
    public final FITNESS_COMBINE_REPLICATIONS fitnessCombineReplications;
    public final String fitnessDerivativeParameter;
    public final double fitnessDerivativeDelta;
    public final boolean fitnessDerivativeUseAbs;
    public String searchMethodType;
    public final HashMap<String, String> searchMethodParams;
    public final String chromosomeType;
    public final boolean caching;
    public final int evaluationLimit;
    public final int bestCheckingNumReplications;

    public SearchProtocol(String modelFile, List<String> paramSpecStrings, String modelStepCommands, String modelSetupCommands, String modelStopCondition, int modelStepLimit, String modelMetricReporter, String modelMeasureIf, boolean fitnessMinimized, int fitnessSamplingRepetitions, FITNESS_COLLECTING fitnessCollecting, FITNESS_COMBINE_REPLICATIONS fitnessCombineReplications, String fitnessDerivativeParameter, double fitnessDerivativeDelta, boolean fitnessDerivativeUseAbs, String searchMethodType, HashMap<String, String> searchMethodParams, String chromosomeType, boolean caching, int evaluationLimit, int bestCheckingNumReplications) {
        this.bsearchVersionNumber = GeneralUtils.getVersionNumber();
        this.modelFile = modelFile;
        this.paramSpecStrings = paramSpecStrings;
        this.modelStepCommands = modelStepCommands;
        this.modelSetupCommands = modelSetupCommands;
        this.modelStopCondition = modelStopCondition;
        this.modelStepLimit = modelStepLimit;
        this.modelMetricReporter = modelMetricReporter;
        this.modelMeasureIf = modelMeasureIf;
        this.fitnessMinimized = fitnessMinimized;
        this.fitnessSamplingReplications = fitnessSamplingRepetitions;
        this.fitnessCollecting = fitnessCollecting;
        this.fitnessCombineReplications = fitnessCombineReplications;
        this.fitnessDerivativeParameter = fitnessDerivativeParameter;
        this.fitnessDerivativeDelta = fitnessDerivativeDelta;
        this.fitnessDerivativeUseAbs = fitnessDerivativeUseAbs;
        this.searchMethodType = searchMethodType;
        this.searchMethodParams = searchMethodParams;
        this.chromosomeType = chromosomeType;
        this.caching = caching;
        this.evaluationLimit = evaluationLimit;
        this.bestCheckingNumReplications = bestCheckingNumReplications;
    }

    private static String loadOrGetDefault(XPath xpath, Document xmlDoc, String path, String defaultVal) {
        try {
            String s = (String)xpath.evaluate(path, xmlDoc, XPathConstants.STRING);
            if (s.equals("")) {
                return defaultVal;
            }
            return s;
        }
        catch (XPathExpressionException e) {
            return defaultVal;
        }
    }

    private static int loadOrGetDefaultInt(XPath xpath, Document xmlDoc, String path, int defaultVal) {
        try {
            String s = (String)xpath.evaluate(path, xmlDoc, XPathConstants.STRING);
            if (s.equals("")) {
                return defaultVal;
            }
            return Integer.valueOf(s.trim());
        }
        catch (XPathExpressionException e) {
            return defaultVal;
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }

    private static double loadOrGetDefaultDouble(XPath xpath, Document xmlDoc, String path, double defaultVal) {
        try {
            String s = (String)xpath.evaluate(path, xmlDoc, XPathConstants.STRING);
            if (s.equals("")) {
                return defaultVal;
            }
            return Double.valueOf(s.trim());
        }
        catch (XPathExpressionException e) {
            return defaultVal;
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }

    private SearchProtocol(Document xmlDoc) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        this.bsearchVersionNumber = SearchProtocol.loadOrGetDefaultDouble(xpath, xmlDoc, "/search/bsearchVersionNumber/text()", 0.71);
        this.modelFile = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/modelInfo/modelFile/text()", "");
        this.modelSetupCommands = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/modelInfo/modelSetupCommands/text()", "");
        this.modelStepCommands = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/modelInfo/modelStepCommands/text()", "");
        this.modelStopCondition = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/modelInfo/modelStopCondition/text()", "");
        this.modelStepLimit = SearchProtocol.loadOrGetDefaultInt(xpath, xmlDoc, "/search/modelInfo/modelStepLimit/text()", 100);
        this.modelMetricReporter = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/modelInfo/modelMetricReporter/text()", "");
        this.modelMeasureIf = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/modelInfo/modelMeasureIf/text()", "true");
        this.fitnessMinimized = Boolean.valueOf(SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/fitnessInfo/fitnessMinimized/text()", "false").trim());
        String fcollect = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/fitnessInfo/fitnessCollecting/text()", FITNESS_COLLECTING.AT_FINAL_STEP.toString());
        this.fitnessCollecting = FITNESS_COLLECTING.valueOf(fcollect.trim());
        this.fitnessSamplingReplications = SearchProtocol.loadOrGetDefaultInt(xpath, xmlDoc, "/search/fitnessInfo/fitnessSamplingReplications/text()", 10);
        String fcombine = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/fitnessInfo/fitnessCombineReplications/text()", FITNESS_COMBINE_REPLICATIONS.MEAN.toString());
        this.fitnessCombineReplications = FITNESS_COMBINE_REPLICATIONS.valueOf(fcombine.trim());
        this.fitnessDerivativeParameter = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/fitnessInfo/fitnessDerivative/@parameter", "");
        this.fitnessDerivativeDelta = SearchProtocol.loadOrGetDefaultDouble(xpath, xmlDoc, "/search/fitnessInfo/fitnessDerivative/@delta", 0.0);
        this.fitnessDerivativeUseAbs = Boolean.valueOf(SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/fitnessInfo/fitnessDerivative/@useabs", "false").trim());
        NodeList paramSpecNodes = (NodeList)xpath.evaluate("/search/searchSpace/paramSpec/text()", xmlDoc, XPathConstants.NODESET);
        this.paramSpecStrings = new LinkedList<String>();
        for (int i = 0; i < paramSpecNodes.getLength(); ++i) {
            Node n = paramSpecNodes.item(i);
            this.paramSpecStrings.add(n.getNodeValue().trim());
        }
        this.searchMethodType = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/searchMethod/@type", "RandomSearch");
        NodeList methodParamNodes = (NodeList)xpath.evaluate("/search/searchMethod/searchMethodParameter", xmlDoc, XPathConstants.NODESET);
        this.searchMethodParams = new LinkedHashMap<String, String>();
        for (int i = 0; i < methodParamNodes.getLength(); ++i) {
            Element n = (Element)methodParamNodes.item(i);
            this.searchMethodParams.put(n.getAttribute("name"), n.getAttribute("value"));
        }
        this.chromosomeType = SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/chromosomeRepresentation/@type", "MixedTypeChromosome");
        this.caching = Boolean.valueOf(SearchProtocol.loadOrGetDefault(xpath, xmlDoc, "/search/caching/text()", "true"));
        this.evaluationLimit = SearchProtocol.loadOrGetDefaultInt(xpath, xmlDoc, "/search/evaluationLimit/text()", 300);
        this.bestCheckingNumReplications = SearchProtocol.loadOrGetDefaultInt(xpath, xmlDoc, "/search/bestCheckingNumReplications/text()", 0);
        this.updateForVersionChanges();
    }

    private void updateForVersionChanges() {
        if (this.bsearchVersionNumber < 0.72 && this.searchMethodType.equals("GenerationalGA")) {
            this.searchMethodType = "StandardGA";
        }
    }

    private static void xmlElementNoAtts(TransformerHandler hd, String elementName, String cData) throws SAXException {
        SearchProtocol.xmlElementWithAtts(hd, elementName, new AttributesImpl(), cData);
    }

    private static void xmlElementWithAtts(TransformerHandler hd, String elementName, AttributesImpl atts) throws SAXException {
        SearchProtocol.xmlElementWithAtts(hd, elementName, atts, "");
    }

    private static void xmlElementWithAtts(TransformerHandler hd, String elementName, AttributesImpl atts, String cData) throws SAXException {
        hd.startElement("", "", elementName, atts);
        if (cData.length() > 0) {
            hd.characters(cData.toCharArray(), 0, cData.length());
        }
        hd.endElement("", "", elementName);
    }

    public void save(Writer out) {
        try {
            StreamResult streamResult = new StreamResult(out);
            SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler hd = tf.newTransformerHandler();
            Transformer serializer = hd.getTransformer();
            serializer.setOutputProperty("encoding", "us-ascii");
            serializer.setOutputProperty("doctype-system", "behaviorsearch.dtd");
            serializer.setOutputProperty("indent", "yes");
            hd.setResult(streamResult);
            hd.startDocument();
            AttributesImpl noAtts = new AttributesImpl();
            AttributesImpl atts = new AttributesImpl();
            hd.startElement("", "", "search", noAtts);
            SearchProtocol.xmlElementNoAtts(hd, "bsearchVersionNumber", String.format("%.2f", GeneralUtils.getVersionNumber()));
            hd.startElement("", "", "modelInfo", noAtts);
            SearchProtocol.xmlElementNoAtts(hd, "modelFile", this.modelFile);
            SearchProtocol.xmlElementNoAtts(hd, "modelSetupCommands", this.modelSetupCommands);
            SearchProtocol.xmlElementNoAtts(hd, "modelStepCommands", this.modelStepCommands);
            SearchProtocol.xmlElementNoAtts(hd, "modelStopCondition", this.modelStopCondition);
            SearchProtocol.xmlElementNoAtts(hd, "modelStepLimit", Integer.toString(this.modelStepLimit));
            SearchProtocol.xmlElementNoAtts(hd, "modelMetricReporter", this.modelMetricReporter);
            SearchProtocol.xmlElementNoAtts(hd, "modelMeasureIf", this.modelMeasureIf);
            hd.endElement("", "", "modelInfo");
            hd.startElement("", "", "fitnessInfo", noAtts);
            SearchProtocol.xmlElementNoAtts(hd, "fitnessMinimized", Boolean.toString(this.fitnessMinimized));
            SearchProtocol.xmlElementNoAtts(hd, "fitnessCollecting", this.fitnessCollecting.toString());
            SearchProtocol.xmlElementNoAtts(hd, "fitnessSamplingReplications", Integer.toString(this.fitnessSamplingReplications));
            SearchProtocol.xmlElementNoAtts(hd, "fitnessCombineReplications", this.fitnessCombineReplications.toString());
            if (this.fitnessDerivativeParameter.length() > 0) {
                atts.clear();
                atts.addAttribute("", "", "parameter", "CDATA", this.fitnessDerivativeParameter);
                atts.addAttribute("", "", "delta", "CDATA", Double.toString(this.fitnessDerivativeDelta));
                atts.addAttribute("", "", "useabs", "CDATA", Boolean.toString(this.fitnessDerivativeUseAbs));
                SearchProtocol.xmlElementWithAtts(hd, "fitnessDerivative", atts);
            }
            hd.endElement("", "", "fitnessInfo");
            hd.startElement("", "", "searchSpace", noAtts);
            for (String ps : this.paramSpecStrings) {
                SearchProtocol.xmlElementNoAtts(hd, "paramSpec", ps);
            }
            hd.endElement("", "", "searchSpace");
            atts.clear();
            atts.addAttribute("", "", "type", "CDATA", this.searchMethodType);
            hd.startElement("", "", "searchMethod", atts);
            for (String pName : this.searchMethodParams.keySet()) {
                atts.clear();
                atts.addAttribute("", "", "name", "CDATA", pName);
                atts.addAttribute("", "", "value", "CDATA", this.searchMethodParams.get(pName));
                hd.startElement("", "", "searchMethodParameter", atts);
                hd.endElement("", "", "searchMethodParameter");
            }
            hd.endElement("", "", "searchMethod");
            atts.clear();
            atts.addAttribute("", "", "type", "CDATA", this.chromosomeType);
            SearchProtocol.xmlElementWithAtts(hd, "chromosomeRepresentation", atts);
            SearchProtocol.xmlElementNoAtts(hd, "caching", Boolean.toString(this.caching));
            SearchProtocol.xmlElementNoAtts(hd, "evaluationLimit", Integer.toString(this.evaluationLimit));
            SearchProtocol.xmlElementNoAtts(hd, "bestCheckingNumReplications", Integer.toString(this.bestCheckingNumReplications));
            hd.endElement("", "", "search");
            hd.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
    }

    public String toXMLString() {
        StringWriter sw = new StringWriter();
        this.save(sw);
        sw.flush();
        return sw.toString();
    }

    public static SearchProtocol load(String xmlStr) throws IOException, SAXException {
        InputSource inputSource = new InputSource(new StringReader(xmlStr));
        return SearchProtocol.load(inputSource);
    }

    public static SearchProtocol load(InputSource inputSource) throws IOException, SAXException {
        File resourcesDir = new File(GeneralUtils.attemptResolvePathFromBSearchRoot("resources/"));
        inputSource.setSystemId(resourcesDir.toURI().toString());
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fac.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException ex) throws SAXException {
                    throw ex;
                }

                @Override
                public void fatalError(SAXParseException ex) throws SAXException {
                    throw ex;
                }

                @Override
                public void warning(SAXParseException ex) throws SAXException {
                    throw ex;
                }
            });
            doc = builder.parse(inputSource);
            return new SearchProtocol(doc);
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            System.exit(1);
        }
        throw new IllegalStateException("Unreachable code.");
    }

    public static SearchProtocol loadFile(String fullPathFilename) throws IOException, SAXException {
        return SearchProtocol.loadFile(new File(fullPathFilename));
    }

    public static SearchProtocol loadFile(File file) throws IOException, SAXException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            SearchProtocol searchProtocol = SearchProtocol.load(new InputSource(reader));
            return searchProtocol;
        }
    }

    public boolean useBestChecking() {
        return this.bestCheckingNumReplications > 0;
    }

    public strictfp static enum FITNESS_COMBINE_REPLICATIONS {
        MEAN{

            @Override
            public double combine(List<Double> results) {
                return Stats.mean(results);
            }
        }
        ,
        MEDIAN{

            @Override
            public double combine(List<Double> results) {
                return Stats.median(results);
            }
        }
        ,
        MIN{

            @Override
            public double combine(List<Double> results) {
                return Collections.min(results);
            }
        }
        ,
        MAX{

            @Override
            public double combine(List<Double> results) {
                return Collections.max(results);
            }
        }
        ,
        VARIANCE{

            @Override
            public double combine(List<Double> results) {
                return Stats.variance(results);
            }
        }
        ,
        STDEV{

            @Override
            public double combine(List<Double> results) {
                return Stats.stdev(results);
            }
        };


        public abstract double combine(List<Double> var1);
    }

    public strictfp static enum FITNESS_COLLECTING {
        AT_FINAL_STEP{

            @Override
            public double collectFrom(List<Double> results) {
                return results.get(results.size() - 1);
            }

            @Override
            public boolean requiresAllSteps() {
                return false;
            }
        }
        ,
        MEAN_ACROSS_STEPS{

            @Override
            public double collectFrom(List<Double> results) {
                return Stats.mean(results);
            }
        }
        ,
        MEDIAN_ACROSS_STEPS{

            @Override
            public double collectFrom(List<Double> results) {
                return Stats.median(results);
            }
        }
        ,
        MIN_ACROSS_STEPS{

            @Override
            public double collectFrom(List<Double> results) {
                return Collections.min(results);
            }
        }
        ,
        MAX_ACROSS_STEPS{

            @Override
            public double collectFrom(List<Double> results) {
                return Collections.max(results);
            }
        }
        ,
        VARIANCE_ACROSS_STEPS{

            @Override
            public double collectFrom(List<Double> results) {
                return Stats.variance(results);
            }
        }
        ,
        SUM_ACROSS_STEPS{

            @Override
            public double collectFrom(List<Double> results) {
                return Stats.sum(results);
            }
        };


        public abstract double collectFrom(List<Double> var1);

        public boolean requiresAllSteps() {
            return true;
        }
    }
}

