/*
 * Decompiled with CFR 0.152.
 */
package bsearch.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Stats {
    public static double sum(List<Double> dlist) {
        double sum = 0.0;
        for (double d : dlist) {
            sum += d;
        }
        return sum;
    }

    public static double mean(List<Double> dlist) {
        double sum = 0.0;
        for (double d : dlist) {
            sum += d;
        }
        return sum / (double)dlist.size();
    }

    public static double median(List<Double> dlist) {
        ArrayList<Double> sortedlist = new ArrayList<Double>(dlist);
        Collections.sort(sortedlist);
        int len = sortedlist.size();
        if (len % 2 == 0) {
            return ((Double)sortedlist.get(len / 2 - 1) + (Double)sortedlist.get(len / 2)) / 2.0;
        }
        return (Double)sortedlist.get(len / 2);
    }

    public static double variance(List<Double> dlist) {
        double n = dlist.size();
        if (n <= 1.0) {
            return 0.0;
        }
        double mean = Stats.mean(dlist);
        double sum = 0.0;
        double sumsq = 0.0;
        for (double d : dlist) {
            sum += d - mean;
            sumsq += (d - mean) * (d - mean);
        }
        return (sumsq - sum * sum / n) / (n - 1.0);
    }

    public static double stdev(List<Double> dlist) {
        return StrictMath.sqrt(Stats.variance(dlist));
    }
}

