/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.AbstractValueAnimator;
import org.openimaj.content.animation.animator.ReversableValueAnimator;

public class LinearDoubleValueAnimator
extends AbstractValueAnimator<Double>
implements ReversableValueAnimator<Double> {
    double start;
    double finish;
    double incr;
    double current;

    public LinearDoubleValueAnimator(double start, double finish, int duration) {
        super(start, 0, 0);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (finish - start) / (double)duration;
    }

    public LinearDoubleValueAnimator(int startWait, int stopWait, double start, double finish, int duration) {
        super(start, startWait, stopWait);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (finish - start) / (double)duration;
    }

    @Override
    public Double makeNextValue() {
        this.current += this.incr;
        if (this.start < this.finish && this.current > this.finish) {
            this.current = this.finish;
        } else if (this.start > this.finish && this.current < this.finish) {
            this.current = this.finish;
        }
        return this.current;
    }

    @Override
    protected boolean complete() {
        if (this.incr == 0.0) {
            return true;
        }
        double next = this.current + this.incr;
        if (this.start < this.finish && next - 1.0E-7 > this.finish) {
            return true;
        }
        return this.start > this.finish && next + 1.0E-7 < this.finish;
    }

    @Override
    protected void resetToInitial() {
        this.current = this.start;
    }

    @Override
    public ReversableValueAnimator<Double> reverseAnimator() {
        double curr = this.current;
        double sta = this.start;
        this.reset();
        this.current = curr;
        this.incr *= -1.0;
        this.start = this.finish;
        this.finish = sta;
        return this;
    }
}

