/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.inversion;

import org.la4j.factory.Factory;
import org.la4j.inversion.MatrixInvertor;
import org.la4j.linear.LinearSystem;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;

public class GaussianInvertor
implements MatrixInvertor {
    @Override
    public Matrix inverse(Matrix matrix, Factory factory) {
        if (matrix.rows() != matrix.columns()) {
            throw new IllegalArgumentException("Wrong matrix size: rows != columns");
        }
        Matrix result = factory.createMatrix(matrix.rows(), matrix.columns());
        for (int i = 0; i < matrix.rows(); ++i) {
            Vector b = factory.createVector(matrix.rows());
            b.set(i, 1.0);
            LinearSystem system = factory.createLinearSystem(matrix, b);
            Vector x = system.solve(Matrices.GAUSSIAN_SOLVER);
            result.setColumn(i, x);
        }
        return result;
    }
}

