/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extension.r;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.nlogo.api.FileIO$;
import org.nlogo.extension.r.Entry;

public class Configuration {
    private final Properties properties;
    private Path rHomePath;
    private Optional<Path> selectedJRIPath = Optional.empty();

    static String userExtensionDir() {
        return FileIO$.MODULE$.perUserDir("r", true);
    }

    static List<Path> pathsFromString(String pathString) {
        if (pathString == null || pathString.isEmpty()) {
            return new ArrayList<Path>();
        }
        String[] pathComponents = pathString.split(File.pathSeparator);
        ArrayList<Path> paths = new ArrayList<Path>(pathComponents.length);
        String home = System.getProperty("user.home");
        for (String path : pathComponents) {
            try {
                paths.add(Paths.get(path.replace("~", home), new String[0]));
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        return paths;
    }

    static Properties getRExtensionProperties() {
        Properties extensionProperties = new Properties();
        String osName = System.getProperty("os.name").toLowerCase();
        String propertiesFileName = null;
        if (osName.startsWith("mac", 0)) {
            propertiesFileName = "mac.properties";
        } else if (osName.startsWith("windows", 0)) {
            propertiesFileName = "windows.properties";
        } else if (osName.startsWith("linux", 0)) {
            propertiesFileName = "linux.properties";
        }
        if (propertiesFileName != null) {
            InputStream propertiesStream = Entry.class.getClassLoader().getResourceAsStream(propertiesFileName);
            try {
                extensionProperties.load(propertiesStream);
            }
            catch (IOException e) {
                System.err.println("Error reading default properties from file");
            }
            catch (IllegalArgumentException e) {
                System.err.println("Illegal character in default properties file");
            }
            Path userPropertiesPath = Paths.get(Configuration.userExtensionDir(), "user.properties");
            if (Files.exists(userPropertiesPath, new LinkOption[0])) {
                try {
                    BufferedReader userPropertiesReader = Files.newBufferedReader(userPropertiesPath);
                    Properties userProperties = new Properties(extensionProperties);
                    userProperties.load(userPropertiesReader);
                    extensionProperties = userProperties;
                }
                catch (IOException e) {
                    System.err.println("Error reading user properties file");
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Illegal character in user properties file");
                }
                catch (SecurityException e) {
                    System.err.println("Security exception while reading user properties file");
                }
            }
        }
        return extensionProperties;
    }

    public static Configuration fromRExtensionProperties() {
        return new Configuration(Configuration.getRExtensionProperties());
    }

    public Configuration(Properties properties) {
        this.properties = properties;
        this.rHomePath = Paths.get(properties.getProperty("r.home", ""), new String[0]);
    }

    public List<Path> jriHomePaths() {
        return Configuration.pathsFromString(this.properties.getProperty("jri.home.paths", ""));
    }

    public List<Path> rLibPaths() {
        return Configuration.pathsFromString(this.properties.getProperty("r.lib.paths", ""));
    }

    public Path rHomePath() {
        return this.rHomePath;
    }

    public void setRHomePath(Path newRHomePath) {
        this.rHomePath = newRHomePath;
    }

    public String extensionMode() {
        return this.properties.getProperty("extension.mode", "");
    }

    public Optional<Path> selectedJRIPath() {
        return this.selectedJRIPath;
    }

    public void selectJRIPath(Path p) {
        this.selectedJRIPath = Optional.of(p);
    }
}

