/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extension.r;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;

public class JavaLibraryPath {
    private static final Class<?>[] parameters = new Class[]{URL.class};

    public static void addLibraryPath(File path) throws Exception {
        String newLibraryPath = System.getProperty("java.library.path");
        newLibraryPath = newLibraryPath == null || newLibraryPath.length() < 1 ? path.getCanonicalPath() : newLibraryPath + File.pathSeparator + path.getCanonicalPath();
        Field f = System.class.getDeclaredField("props");
        f.setAccessible(true);
        Properties props = (Properties)f.get(null);
        props.put("java.library.path", newLibraryPath);
        Field usr_pathsField = ClassLoader.class.getDeclaredField("usr_paths");
        usr_pathsField.setAccessible(true);
        String[] usr_paths = (String[])usr_pathsField.get(null);
        String[] newUsr_paths = new String[usr_paths == null ? 1 : usr_paths.length + 1];
        if (usr_paths != null) {
            System.arraycopy(usr_paths, 0, newUsr_paths, 0, usr_paths.length);
        }
        newUsr_paths[newUsr_paths.length - 1] = path.getAbsolutePath();
        usr_pathsField.set(null, newUsr_paths);
    }

    public static void addFile(String s) throws IOException {
        File f = new File(s);
        JavaLibraryPath.addFile(f);
    }

    public static void addFile(File f) throws IOException {
        JavaLibraryPath.addURL(f.toURI().toURL());
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

