/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.prism.Graphics;
import com.sun.prism.shape.ShapeRep;

public class NGEllipse
extends NGShape {
    private Ellipse2D ellipse = new Ellipse2D();
    private float cx;
    private float cy;

    public void updateEllipse(float cx, float cy, float rx, float ry) {
        this.ellipse.x = cx - rx;
        this.ellipse.width = rx * 2.0f;
        this.ellipse.y = cy - ry;
        this.ellipse.height = ry * 2.0f;
        this.cx = cx;
        this.cy = cy;
        this.geometryChanged();
    }

    @Override
    public final Shape getShape() {
        return this.ellipse;
    }

    @Override
    protected ShapeRep createShapeRep(Graphics g) {
        return g.getResourceFactory().createEllipseRep();
    }

    @Override
    protected boolean supportsOpaqueRegions() {
        return true;
    }

    @Override
    protected boolean hasOpaqueRegion() {
        return super.hasOpaqueRegion() && this.ellipse.width > 0.0f && this.ellipse.height > 0.0f;
    }

    @Override
    protected RectBounds computeOpaqueRegion(RectBounds opaqueRegion) {
        float halfWidth = this.ellipse.width * 0.353f;
        float halfHeight = this.ellipse.height * 0.353f;
        return (RectBounds)opaqueRegion.deriveWithNewBounds(this.cx - halfWidth, this.cy - halfHeight, 0.0f, this.cx + halfWidth, this.cy + halfHeight, 0.0f);
    }
}

