/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.plan.logical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.function.Functions;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Project
extends UnaryPlan {
    private final List<? extends NamedExpression> projections;

    public Project(Source source, LogicalPlan child, List<? extends NamedExpression> projections) {
        super(source, child);
        this.projections = projections;
    }

    @Override
    protected NodeInfo<Project> info() {
        return NodeInfo.create(this, Project::new, this.child(), this.projections);
    }

    @Override
    public Project replaceChild(LogicalPlan newChild) {
        return new Project(this.source(), newChild, this.projections);
    }

    public List<? extends NamedExpression> projections() {
        return this.projections;
    }

    @Override
    public boolean resolved() {
        return super.resolved() && !Expressions.anyMatch(this.projections, Functions::isAggregate);
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.projections);
    }

    @Override
    public List<Attribute> output() {
        return Expressions.asAttributes(this.projections);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.projections, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return Objects.equals(this.projections, other.projections) && Objects.equals(this.child(), other.child());
    }
}

