/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.process.normalizer.AbstractLeafNormalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.Level;

class RecordNormalizable
extends AbstractLeafNormalizable {
    private final AnomalyRecord record;

    RecordNormalizable(AnomalyRecord record, String indexName) {
        super(indexName);
        this.record = Objects.requireNonNull(record);
    }

    @Override
    public String getId() {
        return this.record.getId();
    }

    @Override
    public Level getLevel() {
        return Level.LEAF;
    }

    @Override
    public String getPartitionFieldName() {
        return this.record.getPartitionFieldName();
    }

    @Override
    public String getPartitionFieldValue() {
        return this.record.getPartitionFieldValue();
    }

    @Override
    public String getPersonFieldName() {
        String over = this.record.getOverFieldName();
        return over != null ? over : this.record.getByFieldName();
    }

    @Override
    public String getPersonFieldValue() {
        String over = this.record.getOverFieldValue();
        return over != null ? over : this.record.getByFieldValue();
    }

    @Override
    public String getFunctionName() {
        return this.record.getFunction();
    }

    @Override
    public String getValueFieldName() {
        return this.record.getFieldName();
    }

    @Override
    public double getProbability() {
        return this.record.getProbability();
    }

    @Override
    public double getNormalizedScore() {
        return this.record.getRecordScore();
    }

    @Override
    public void setNormalizedScore(double normalizedScore) {
        this.record.setRecordScore(normalizedScore);
    }

    @Override
    public void setParentScore(double parentScore) {
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.record.toXContent(builder, params);
    }

    public AnomalyRecord getRecord() {
        return this.record;
    }
}

