/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;

abstract class OrdinalGroup<E>
implements Iterable<Ordinal>,
Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(OrdinalGroup.class);
    private final Function<E, Ordinal> extractor;
    private final LinkedList<E> elements = new LinkedList();
    private Ordinal start;
    private Ordinal stop;

    protected OrdinalGroup(Function<E, Ordinal> extractor) {
        this.extractor = extractor;
    }

    void add(E element) {
        Ordinal ordinal = this.extractor.apply(element);
        if (this.start == null || this.start.compareTo(ordinal) > 0) {
            this.start = ordinal;
        }
        if (this.stop == null || this.stop.compareTo(ordinal) < 0) {
            this.stop = ordinal;
        }
        this.elements.add(element);
    }

    E trimBefore(Ordinal ordinal) {
        return this.trimBefore(ordinal, true);
    }

    E trimBeforeLast(Ordinal ordinal) {
        return this.trimBefore(ordinal, false);
    }

    private E trimBefore(Ordinal ordinal, boolean removeMatch) {
        Tuple<E, Integer> match = this.findBefore(ordinal);
        if (match != null) {
            int pos = (Integer)match.v2();
            if (removeMatch) {
                ++pos;
            }
            this.elements.subList(0, pos).clear();
            if (!this.elements.isEmpty()) {
                this.start = this.extractor.apply(this.elements.peekFirst());
                this.stop = this.extractor.apply(this.elements.peekLast());
            } else {
                this.start = null;
                this.stop = null;
            }
        }
        return (E)(match != null ? match.v1() : null);
    }

    E before(Ordinal ordinal) {
        Tuple<E, Integer> match = this.findBefore(ordinal);
        return (E)(match != null ? match.v1() : null);
    }

    private Tuple<E, Integer> findBefore(Ordinal ordinal) {
        Object match = null;
        int matchPos = -1;
        int position = -1;
        for (Object element : this.elements) {
            ++position;
            Ordinal o = this.extractor.apply(element);
            if (o.compareTo(ordinal) >= 0) break;
            match = element;
            matchPos = position;
        }
        return match != null ? new Tuple(match, (Object)matchPos) : null;
    }

    boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<Ordinal> iterator() {
        return new Iterator<Ordinal>(){
            final Iterator<E> iter;
            {
                this.iter = OrdinalGroup.this.elements.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Ordinal next() {
                return (Ordinal)OrdinalGroup.this.extractor.apply(this.iter.next());
            }
        };
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOfCollection(this.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OrdinalGroup other = (OrdinalGroup)obj;
        return Objects.equals(this.elements, other.elements);
    }

    public String toString() {
        return LoggerMessageFormat.format(null, (String)"[{}-{}]({} seqs)", (Object[])new Object[]{this.start, this.stop, this.elements.size()});
    }
}

