/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.core.enrich.action.DeleteEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.AbstractEnrichProcessor;
import org.elasticsearch.xpack.enrich.EnrichPolicyLocks;
import org.elasticsearch.xpack.enrich.EnrichStore;

public class TransportDeleteEnrichPolicyAction
extends AcknowledgedTransportMasterNodeAction<DeleteEnrichPolicyAction.Request> {
    private final EnrichPolicyLocks enrichPolicyLocks;
    private final IngestService ingestService;
    private final Client client;
    private static final IndicesOptions LENIENT_OPTIONS = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)true, (boolean)true);

    @Inject
    public TransportDeleteEnrichPolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, EnrichPolicyLocks enrichPolicyLocks, IngestService ingestService) {
        super("cluster:admin/xpack/enrich/delete", transportService, clusterService, threadPool, actionFilters, DeleteEnrichPolicyAction.Request::new, indexNameExpressionResolver, "same");
        this.client = client;
        this.enrichPolicyLocks = enrichPolicyLocks;
        this.ingestService = ingestService;
    }

    protected void masterOperation(DeleteEnrichPolicyAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        String policyName = request.getName();
        EnrichPolicy policy = EnrichStore.getPolicy(policyName, state);
        if (policy == null) {
            throw new ResourceNotFoundException("policy [{}] not found", new Object[]{policyName});
        }
        EnrichPolicyLocks.EnrichPolicyLock policyLock = this.enrichPolicyLocks.lockPolicy(policyName);
        try {
            List pipelines = IngestService.getPipelines((ClusterState)state, (String[])new String[0]);
            ArrayList<String> pipelinesWithProcessors = new ArrayList<String>();
            for (PipelineConfiguration pipelineConfiguration : pipelines) {
                List enrichProcessors = this.ingestService.getProcessorsInPipeline(pipelineConfiguration.getId(), AbstractEnrichProcessor.class);
                for (AbstractEnrichProcessor processor : enrichProcessors) {
                    if (!processor.getPolicyName().equals(policyName)) continue;
                    pipelinesWithProcessors.add(pipelineConfiguration.getId());
                }
            }
            if (!pipelinesWithProcessors.isEmpty()) {
                throw new ElasticsearchStatusException("Could not delete policy [{}] because a pipeline is referencing it {}", RestStatus.CONFLICT, new Object[]{policyName, pipelinesWithProcessors});
            }
        }
        catch (Exception e) {
            policyLock.close();
            listener.onFailure(e);
            return;
        }
        try {
            GetIndexRequest indices = (GetIndexRequest)((GetIndexRequest)new GetIndexRequest().indices(new String[]{EnrichPolicy.getBaseName((String)policyName) + "-*"})).indicesOptions(IndicesOptions.lenientExpand());
            String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state, (IndicesRequest)indices);
            concreteIndices = (String[])Stream.of(concreteIndices).filter(i -> EnrichPolicy.isPolicyForIndex((String)policyName, (String)i)).toArray(String[]::new);
            this.deleteIndicesAndPolicy(concreteIndices, policyName, (ActionListener<AcknowledgedResponse>)ActionListener.runBefore(listener, policyLock::close));
        }
        catch (Exception e) {
            policyLock.close();
            listener.onFailure(e);
        }
    }

    private void deleteIndicesAndPolicy(String[] indices, String name, ActionListener<AcknowledgedResponse> listener) {
        if (indices.length == 0) {
            this.deletePolicy(name, listener);
            return;
        }
        DeleteIndexRequest deleteRequest = new DeleteIndexRequest().indices(indices).indicesOptions(LENIENT_OPTIONS);
        new OriginSettingClient(this.client, "enrich").admin().indices().delete(deleteRequest, ActionListener.wrap(response -> {
            if (!response.isAcknowledged()) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Could not fetch indices to delete during policy delete of [{}]", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{name}));
            } else {
                this.deletePolicy(name, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void deletePolicy(String name, ActionListener<AcknowledgedResponse> listener) {
        EnrichStore.deletePolicy(name, this.clusterService, e -> {
            if (e == null) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                listener.onFailure(e);
            }
        });
    }

    protected ClusterBlockException checkBlock(DeleteEnrichPolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

