/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.PromptTrustManagerProcessor;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.X509Certificate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PromptTrustManager
implements X509TrustManager {
    private static final java.security.cert.X509Certificate[] NO_CERTIFICATES = new java.security.cert.X509Certificate[0];
    private final boolean examineValidityDates;
    private final ConcurrentHashMap<String, Boolean> acceptedCerts;
    private final InputStream in;
    private final List<String> expectedAddresses;
    private final PrintStream out;
    private final String acceptedCertsFile;

    public PromptTrustManager() {
        this(null, true, null, null);
    }

    public PromptTrustManager(String acceptedCertsFile) {
        this(acceptedCertsFile, true, null, null);
    }

    public PromptTrustManager(String acceptedCertsFile, boolean examineValidityDates, InputStream in, PrintStream out) {
        this(acceptedCertsFile, examineValidityDates, Collections.emptyList(), in, out);
    }

    public PromptTrustManager(String acceptedCertsFile, boolean examineValidityDates, String expectedAddress, InputStream in, PrintStream out) {
        this(acceptedCertsFile, examineValidityDates, expectedAddress == null ? Collections.emptyList() : Collections.singletonList(expectedAddress), in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PromptTrustManager(String acceptedCertsFile, boolean examineValidityDates, Collection<String> expectedAddresses, InputStream in, PrintStream out) {
        block15: {
            this.acceptedCertsFile = acceptedCertsFile;
            this.examineValidityDates = examineValidityDates;
            this.expectedAddresses = expectedAddresses == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(expectedAddresses));
            this.in = in == null ? System.in : in;
            this.out = out == null ? System.out : out;
            this.acceptedCerts = new ConcurrentHashMap(20);
            if (acceptedCertsFile != null) {
                BufferedReader r = null;
                try {
                    String line;
                    File f = new File(acceptedCertsFile);
                    if (!f.exists()) break block15;
                    r = new BufferedReader(new FileReader(f));
                    while ((line = r.readLine()) != null) {
                        this.acceptedCerts.put(line, false);
                    }
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCacheFile() throws IOException {
        File tempFile = new File(this.acceptedCertsFile + ".new");
        try (BufferedWriter w = null;){
            w = new BufferedWriter(new FileWriter(tempFile));
            for (String certBytes : this.acceptedCerts.keySet()) {
                w.write(certBytes);
                w.newLine();
            }
        }
        File cacheFile = new File(this.acceptedCertsFile);
        if (cacheFile.exists()) {
            File oldFile = new File(this.acceptedCertsFile + ".previous");
            if (oldFile.exists()) {
                Files.delete(oldFile.toPath());
            }
            Files.move(cacheFile.toPath(), oldFile.toPath(), new CopyOption[0]);
        }
        Files.move(tempFile.toPath(), cacheFile.toPath(), new CopyOption[0]);
    }

    public synchronized boolean wouldPrompt(java.security.cert.X509Certificate[] chain) {
        try {
            String cacheKey = PromptTrustManager.getCacheKey(chain[0]);
            return PromptTrustManagerProcessor.shouldPrompt(cacheKey, PromptTrustManager.convertChain(chain), false, this.examineValidityDates, this.acceptedCerts, null).getFirst();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void checkCertificateChain(java.security.cert.X509Certificate[] chain, boolean serverCert) throws CertificateException {
        StringBuilder buffer;
        X509Certificate[] convertedChain = PromptTrustManager.convertChain(chain);
        String cacheKey = PromptTrustManager.getCacheKey(chain[0]);
        ObjectPair<Boolean, List<String>> shouldPromptResult = PromptTrustManagerProcessor.shouldPrompt(cacheKey, convertedChain, serverCert, this.examineValidityDates, this.acceptedCerts, this.expectedAddresses);
        if (!shouldPromptResult.getFirst().booleanValue()) {
            return;
        }
        if (serverCert) {
            this.out.println(SSLMessages.INFO_PROMPT_SERVER_HEADING.get());
        } else {
            this.out.println(SSLMessages.INFO_PROMPT_CLIENT_HEADING.get());
        }
        this.out.println();
        this.out.println("     " + SSLMessages.INFO_PROMPT_SUBJECT.get(convertedChain[0].getSubjectDN()));
        this.out.println("     " + SSLMessages.INFO_PROMPT_VALID_FROM.get(PromptTrustManagerProcessor.formatDate(convertedChain[0].getNotBeforeDate())));
        this.out.println("     " + SSLMessages.INFO_PROMPT_VALID_TO.get(PromptTrustManagerProcessor.formatDate(convertedChain[0].getNotAfterDate())));
        try {
            byte[] sha1Fingerprint = convertedChain[0].getSHA1Fingerprint();
            buffer = new StringBuilder();
            StaticUtils.toHex(sha1Fingerprint, ":", buffer);
            this.out.println("     " + SSLMessages.INFO_PROMPT_SHA1_FINGERPRINT.get(buffer));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            byte[] sha256Fingerprint = convertedChain[0].getSHA256Fingerprint();
            buffer = new StringBuilder();
            StaticUtils.toHex(sha256Fingerprint, ":", buffer);
            this.out.println("     " + SSLMessages.INFO_PROMPT_SHA256_FINGERPRINT.get(buffer));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        for (int i = 1; i < chain.length; ++i) {
            StringBuilder buffer2;
            this.out.println("     -");
            this.out.println("     " + SSLMessages.INFO_PROMPT_ISSUER_SUBJECT.get(i, convertedChain[i].getSubjectDN()));
            this.out.println("     " + SSLMessages.INFO_PROMPT_VALID_FROM.get(PromptTrustManagerProcessor.formatDate(convertedChain[i].getNotBeforeDate())));
            this.out.println("     " + SSLMessages.INFO_PROMPT_VALID_TO.get(PromptTrustManagerProcessor.formatDate(convertedChain[i].getNotAfterDate())));
            try {
                byte[] sha1Fingerprint = convertedChain[i].getSHA1Fingerprint();
                buffer2 = new StringBuilder();
                StaticUtils.toHex(sha1Fingerprint, ":", buffer2);
                this.out.println("     " + SSLMessages.INFO_PROMPT_SHA1_FINGERPRINT.get(buffer2));
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                byte[] sha256Fingerprint = convertedChain[i].getSHA256Fingerprint();
                buffer2 = new StringBuilder();
                StaticUtils.toHex(sha256Fingerprint, ":", buffer2);
                this.out.println("     " + SSLMessages.INFO_PROMPT_SHA256_FINGERPRINT.get(buffer2));
                continue;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        for (String warningMessage : shouldPromptResult.getSecond()) {
            this.out.println();
            for (String line : StaticUtils.wrapLine(warningMessage, StaticUtils.TERMINAL_WIDTH_COLUMNS - 1)) {
                this.out.println(line);
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
        block16: while (true) {
            try {
                String line;
                do {
                    this.out.println();
                    this.out.print(SSLMessages.INFO_PROMPT_MESSAGE.get() + ' ');
                    this.out.flush();
                    line = reader.readLine();
                    if (line == null) {
                        throw new CertificateException(SSLMessages.ERR_CERTIFICATE_REJECTED_BY_END_OF_STREAM.get(SSLUtil.certificateToString(chain[0])));
                    }
                    if (line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes")) break block16;
                } while (!line.equalsIgnoreCase("n") && !line.equalsIgnoreCase("no"));
                throw new CertificateException(SSLMessages.ERR_CERTIFICATE_REJECTED_BY_USER.get(SSLUtil.certificateToString(chain[0])));
            }
            catch (CertificateException ce) {
                throw ce;
            }
            catch (Exception e) {
                Debug.debugException(e);
                continue;
            }
            break;
        }
        boolean isOutsideValidityWindow = false;
        for (X509Certificate c : convertedChain) {
            if (c.isWithinValidityWindow()) continue;
            isOutsideValidityWindow = true;
            break;
        }
        this.acceptedCerts.put(cacheKey, isOutsideValidityWindow);
        if (this.acceptedCertsFile == null) return;
        try {
            this.writeCacheFile();
            return;
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    public boolean examineValidityDates() {
        return this.examineValidityDates;
    }

    public List<String> getExpectedAddresses() {
        return this.expectedAddresses;
    }

    @Override
    public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificateChain(chain, false);
    }

    @Override
    public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificateChain(chain, true);
    }

    @Override
    public java.security.cert.X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }

    static String getCacheKey(Certificate certificate) {
        java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)certificate;
        return StaticUtils.toLowerCase(StaticUtils.toHex(x509Certificate.getSignature()));
    }

    static X509Certificate[] convertChain(Certificate[] chain) throws CertificateException {
        X509Certificate[] convertedChain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            try {
                convertedChain[i] = new X509Certificate(chain[i].getEncoded());
                continue;
            }
            catch (CertException ce) {
                Debug.debugException(ce);
                throw new CertificateException(ce.getMessage(), ce);
            }
        }
        return convertedChain;
    }
}

