/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.ingest.geoip.GeoIpDownloader;
import org.elasticsearch.ingest.geoip.GeoIpTaskParams;
import org.elasticsearch.ingest.geoip.GeoIpTaskState;
import org.elasticsearch.ingest.geoip.HttpClient;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteTransportException;

public final class GeoIpDownloaderTaskExecutor
extends PersistentTasksExecutor<GeoIpTaskParams>
implements ClusterStateListener {
    private static final boolean ENABLED_DEFAULT = !"false".equals(System.getProperty("ingest.geoip.downloader.enabled.default", "true"));
    public static final Setting<Boolean> ENABLED_SETTING = Setting.boolSetting((String)"ingest.geoip.downloader.enabled", (boolean)ENABLED_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(GeoIpDownloader.class);
    private final Client client;
    private final HttpClient httpClient;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final PersistentTasksService persistentTasksService;
    private final AtomicReference<GeoIpDownloader> currentTask = new AtomicReference();

    GeoIpDownloaderTaskExecutor(Client client, HttpClient httpClient, ClusterService clusterService, ThreadPool threadPool) {
        super("geoip-downloader", "generic");
        this.client = new OriginSettingClient(client, "ingest");
        this.httpClient = httpClient;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.settings = clusterService.getSettings();
        this.persistentTasksService = new PersistentTasksService(clusterService, threadPool, client);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ENABLED_SETTING, this::setEnabled);
    }

    private void setEnabled(boolean enabled) {
        if (!this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            return;
        }
        if (enabled) {
            this.startTask(() -> {});
        } else {
            this.stopTask(() -> {});
        }
    }

    protected void nodeOperation(AllocatedPersistentTask task, GeoIpTaskParams params, PersistentTaskState state) {
        GeoIpDownloader downloader = (GeoIpDownloader)task;
        this.currentTask.set(downloader);
        GeoIpTaskState geoIpTaskState = state == null ? GeoIpTaskState.EMPTY : (GeoIpTaskState)state;
        downloader.setState(geoIpTaskState);
        if (((Boolean)ENABLED_SETTING.get(this.clusterService.state().metadata().settings(), this.settings)).booleanValue()) {
            downloader.runDownloader();
        }
    }

    protected GeoIpDownloader createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<GeoIpTaskParams> taskInProgress, Map<String, String> headers) {
        return new GeoIpDownloader(this.client, this.httpClient, this.clusterService, this.threadPool, this.settings, id, type, action, this.getDescription(taskInProgress), parentTaskId, headers);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNode masterNode = event.state().nodes().getMasterNode();
        if (masterNode == null || masterNode.getVersion().before(Version.V_7_14_0)) {
            return;
        }
        this.clusterService.removeListener((ClusterStateListener)this);
        if (((Boolean)ENABLED_SETTING.get(event.state().getMetadata().settings(), this.settings)).booleanValue()) {
            this.startTask(() -> this.clusterService.addListener((ClusterStateListener)this));
        } else {
            this.stopTask(() -> this.clusterService.addListener((ClusterStateListener)this));
        }
    }

    private void startTask(Runnable onFailure) {
        this.persistentTasksService.sendStartRequest("geoip-downloader", "geoip-downloader", (PersistentTaskParams)new GeoIpTaskParams(), ActionListener.wrap(r -> logger.debug("Started geoip downloader task"), e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? e.getCause() : e;
            if (!(t instanceof ResourceAlreadyExistsException)) {
                logger.error("failed to create geoip downloader task", (Throwable)e);
                onFailure.run();
            }
        }));
    }

    private void stopTask(Runnable onFailure) {
        ActionListener listener = ActionListener.wrap(r -> logger.debug("Stopped geoip downloader task"), e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? e.getCause() : e;
            if (!(t instanceof ResourceNotFoundException)) {
                logger.error("failed to remove geoip downloader task", (Throwable)e);
                onFailure.run();
            }
        });
        this.persistentTasksService.sendRemoveRequest("geoip-downloader", ActionListener.runAfter((ActionListener)listener, () -> this.client.admin().indices().prepareDelete(new String[]{".geoip_databases"}).execute(ActionListener.wrap(rr -> {}, e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? e.getCause() : e;
            if (!(t instanceof ResourceNotFoundException)) {
                logger.warn("failed to remove .geoip_databases", (Throwable)e);
            }
        }))));
    }

    public GeoIpDownloader getCurrentTask() {
        return this.currentTask.get();
    }
}

