/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.boxplot;

import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.analytics.boxplot.Boxplot;

public class InternalBoxplot
extends InternalNumericMetricsAggregation.MultiValue
implements Boxplot {
    public static final double IQR_MULTIPLIER = 1.5;
    static final Set<String> METRIC_NAMES = Collections.unmodifiableSet(Stream.of(Metrics.values()).map(m -> m.name().toLowerCase(Locale.ROOT)).collect(Collectors.toSet()));
    private final TDigestState state;

    public static double[] whiskers(TDigestState state) {
        double[] results = new double[]{Double.NaN, Double.NaN};
        if (state == null) {
            return results;
        }
        double q3 = state.quantile(0.75);
        double q1 = state.quantile(0.25);
        double iqr = q3 - q1;
        double upper = q3 + 1.5 * iqr;
        double lower = q1 - 1.5 * iqr;
        Centroid prev = null;
        for (Centroid c : state.centroids()) {
            if (Double.isNaN(results[0]) && c.mean() > lower) {
                results[0] = c.mean();
            }
            if (c.mean() > upper) {
                results[1] = prev.mean();
                break;
            }
            prev = c;
        }
        if (Double.isNaN(results[1])) {
            results[1] = state.getMax();
        }
        return results;
    }

    InternalBoxplot(String name, TDigestState state, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, metadata);
        this.state = state;
        this.format = formatter;
    }

    public InternalBoxplot(StreamInput in) throws IOException {
        super(in);
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.state = TDigestState.read((StreamInput)in);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        TDigestState.write((TDigestState)this.state, (StreamOutput)out);
    }

    public String getWriteableName() {
        return "boxplot";
    }

    @Override
    public double getMin() {
        return this.state.getMin();
    }

    @Override
    public double getMax() {
        return this.state.getMax();
    }

    @Override
    public double getQ1() {
        return this.state.quantile(0.25);
    }

    @Override
    public double getQ2() {
        return this.state.quantile(0.5);
    }

    @Override
    public double getQ3() {
        return this.state.quantile(0.75);
    }

    @Override
    public String getMinAsString() {
        return this.valueAsString(Metrics.MIN.name());
    }

    @Override
    public String getMaxAsString() {
        return this.valueAsString(Metrics.MAX.name());
    }

    @Override
    public String getQ1AsString() {
        return this.valueAsString(Metrics.Q1.name());
    }

    @Override
    public String getQ2AsString() {
        return this.valueAsString(Metrics.Q2.name());
    }

    @Override
    public String getQ3AsString() {
        return this.valueAsString(Metrics.Q3.name());
    }

    public double value(String name) {
        return Metrics.resolve(name).value(this);
    }

    public Iterable<String> valueNames() {
        return METRIC_NAMES;
    }

    DocValueFormat format() {
        return this.format;
    }

    TDigestState state() {
        return this.state;
    }

    public InternalBoxplot reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        TDigestState merged = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalBoxplot percentiles = (InternalBoxplot)aggregation;
            if (merged == null) {
                merged = new TDigestState(percentiles.state.compression());
            }
            merged.add((TDigest)percentiles.state);
        }
        return new InternalBoxplot(this.name, merged, this.format, this.metadata);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        double[] whiskers = InternalBoxplot.whiskers(this.state);
        builder.field("min", this.getMin());
        builder.field("max", this.getMax());
        builder.field("q1", this.getQ1());
        builder.field("q2", this.getQ2());
        builder.field("q3", this.getQ3());
        builder.field("lower", whiskers[0]);
        builder.field("upper", whiskers[1]);
        if (this.format != DocValueFormat.RAW) {
            builder.field("min_as_string", this.format.format(this.getMin()));
            builder.field("max_as_string", this.format.format(this.getMax()));
            builder.field("q1_as_string", this.format.format(this.getQ1()));
            builder.field("q2_as_string", this.format.format(this.getQ2()));
            builder.field("q3_as_string", this.format.format(this.getQ3()));
            builder.field("lower_as_string", this.format.format(whiskers[0]));
            builder.field("upper_as_string", this.format.format(whiskers[1]));
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.state);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalBoxplot that = (InternalBoxplot)obj;
        return Objects.equals(this.state, that.state);
    }

    static enum Metrics {
        MIN{

            @Override
            double value(InternalBoxplot boxplot) {
                return boxplot.getMin();
            }

            @Override
            double value(TDigestState digestState) {
                return digestState == null ? Double.NEGATIVE_INFINITY : digestState.getMin();
            }
        }
        ,
        MAX{

            @Override
            double value(InternalBoxplot boxplot) {
                return boxplot.getMax();
            }

            @Override
            double value(TDigestState digestState) {
                return digestState == null ? Double.POSITIVE_INFINITY : digestState.getMax();
            }
        }
        ,
        Q1{

            @Override
            double value(InternalBoxplot boxplot) {
                return boxplot.getQ1();
            }

            @Override
            double value(TDigestState digestState) {
                return digestState == null ? Double.NaN : digestState.quantile(0.25);
            }
        }
        ,
        Q2{

            @Override
            double value(InternalBoxplot boxplot) {
                return boxplot.getQ2();
            }

            @Override
            double value(TDigestState digestState) {
                return digestState == null ? Double.NaN : digestState.quantile(0.5);
            }
        }
        ,
        Q3{

            @Override
            double value(InternalBoxplot boxplot) {
                return boxplot.getQ3();
            }

            @Override
            double value(TDigestState digestState) {
                return digestState == null ? Double.NaN : digestState.quantile(0.75);
            }
        }
        ,
        LOWER{

            @Override
            double value(InternalBoxplot boxplot) {
                return InternalBoxplot.whiskers(boxplot.state)[0];
            }

            @Override
            double value(TDigestState digestState) {
                return InternalBoxplot.whiskers(digestState)[0];
            }
        }
        ,
        UPPER{

            @Override
            double value(InternalBoxplot boxplot) {
                return InternalBoxplot.whiskers(boxplot.state)[1];
            }

            @Override
            double value(TDigestState digestState) {
                return InternalBoxplot.whiskers(digestState)[1];
            }
        };


        public static Metrics resolve(String name) {
            return Metrics.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        abstract double value(InternalBoxplot var1);

        abstract double value(TDigestState var1);
    }
}

