// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssmsap

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opDeleteResourcePermission = "DeleteResourcePermission"

// DeleteResourcePermissionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePermission for more information on using the DeleteResourcePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePermissionRequest method.
//	req, resp := client.DeleteResourcePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/DeleteResourcePermission
func (c *SsmSap) DeleteResourcePermissionRequest(input *DeleteResourcePermissionInput) (req *request.Request, output *DeleteResourcePermissionOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-resource-permission",
	}

	if input == nil {
		input = &DeleteResourcePermissionInput{}
	}

	output = &DeleteResourcePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourcePermission API operation for AWS Systems Manager for SAP.
//
// Removes permissions associated with the target database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation DeleteResourcePermission for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/DeleteResourcePermission
func (c *SsmSap) DeleteResourcePermission(input *DeleteResourcePermissionInput) (*DeleteResourcePermissionOutput, error) {
	req, out := c.DeleteResourcePermissionRequest(input)
	return out, req.Send()
}

// DeleteResourcePermissionWithContext is the same as DeleteResourcePermission with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) DeleteResourcePermissionWithContext(ctx aws.Context, input *DeleteResourcePermissionInput, opts ...request.Option) (*DeleteResourcePermissionOutput, error) {
	req, out := c.DeleteResourcePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterApplication = "DeregisterApplication"

// DeregisterApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterApplication for more information on using the DeregisterApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterApplicationRequest method.
//	req, resp := client.DeregisterApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/DeregisterApplication
func (c *SsmSap) DeregisterApplicationRequest(input *DeregisterApplicationInput) (req *request.Request, output *DeregisterApplicationOutput) {
	op := &request.Operation{
		Name:       opDeregisterApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/deregister-application",
	}

	if input == nil {
		input = &DeregisterApplicationInput{}
	}

	output = &DeregisterApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterApplication API operation for AWS Systems Manager for SAP.
//
// Deregister an SAP application with AWS Systems Manager for SAP. This action
// does not aﬀect the existing setup of your SAP workloads on Amazon EC2.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation DeregisterApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/DeregisterApplication
func (c *SsmSap) DeregisterApplication(input *DeregisterApplicationInput) (*DeregisterApplicationOutput, error) {
	req, out := c.DeregisterApplicationRequest(input)
	return out, req.Send()
}

// DeregisterApplicationWithContext is the same as DeregisterApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) DeregisterApplicationWithContext(ctx aws.Context, input *DeregisterApplicationInput, opts ...request.Option) (*DeregisterApplicationOutput, error) {
	req, out := c.DeregisterApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplication for more information on using the GetApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationRequest method.
//	req, resp := client.GetApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetApplication
func (c *SsmSap) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/get-application",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	output = &GetApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplication API operation for AWS Systems Manager for SAP.
//
// Gets an application registered with AWS Systems Manager for SAP. It also
// returns the components of the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation GetApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetApplication
func (c *SsmSap) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	return out, req.Send()
}

// GetApplicationWithContext is the same as GetApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) GetApplicationWithContext(ctx aws.Context, input *GetApplicationInput, opts ...request.Option) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComponent = "GetComponent"

// GetComponentRequest generates a "aws/request.Request" representing the
// client's request for the GetComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComponent for more information on using the GetComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetComponentRequest method.
//	req, resp := client.GetComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetComponent
func (c *SsmSap) GetComponentRequest(input *GetComponentInput) (req *request.Request, output *GetComponentOutput) {
	op := &request.Operation{
		Name:       opGetComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/get-component",
	}

	if input == nil {
		input = &GetComponentInput{}
	}

	output = &GetComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComponent API operation for AWS Systems Manager for SAP.
//
// Gets the component of an application registered with AWS Systems Manager
// for SAP.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation GetComponent for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetComponent
func (c *SsmSap) GetComponent(input *GetComponentInput) (*GetComponentOutput, error) {
	req, out := c.GetComponentRequest(input)
	return out, req.Send()
}

// GetComponentWithContext is the same as GetComponent with the addition of
// the ability to pass a context and additional request options.
//
// See GetComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) GetComponentWithContext(ctx aws.Context, input *GetComponentInput, opts ...request.Option) (*GetComponentOutput, error) {
	req, out := c.GetComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatabase = "GetDatabase"

// GetDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the GetDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatabase for more information on using the GetDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDatabaseRequest method.
//	req, resp := client.GetDatabaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetDatabase
func (c *SsmSap) GetDatabaseRequest(input *GetDatabaseInput) (req *request.Request, output *GetDatabaseOutput) {
	op := &request.Operation{
		Name:       opGetDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/get-database",
	}

	if input == nil {
		input = &GetDatabaseInput{}
	}

	output = &GetDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatabase API operation for AWS Systems Manager for SAP.
//
// Gets the SAP HANA database of an application registered with AWS Systems
// Manager for SAP.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation GetDatabase for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetDatabase
func (c *SsmSap) GetDatabase(input *GetDatabaseInput) (*GetDatabaseOutput, error) {
	req, out := c.GetDatabaseRequest(input)
	return out, req.Send()
}

// GetDatabaseWithContext is the same as GetDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) GetDatabaseWithContext(ctx aws.Context, input *GetDatabaseInput, opts ...request.Option) (*GetDatabaseOutput, error) {
	req, out := c.GetDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperation = "GetOperation"

// GetOperationRequest generates a "aws/request.Request" representing the
// client's request for the GetOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperation for more information on using the GetOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOperationRequest method.
//	req, resp := client.GetOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetOperation
func (c *SsmSap) GetOperationRequest(input *GetOperationInput) (req *request.Request, output *GetOperationOutput) {
	op := &request.Operation{
		Name:       opGetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/get-operation",
	}

	if input == nil {
		input = &GetOperationInput{}
	}

	output = &GetOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperation API operation for AWS Systems Manager for SAP.
//
// Gets the details of an operation by specifying the operation ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation GetOperation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetOperation
func (c *SsmSap) GetOperation(input *GetOperationInput) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	return out, req.Send()
}

// GetOperationWithContext is the same as GetOperation with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) GetOperationWithContext(ctx aws.Context, input *GetOperationInput, opts ...request.Option) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePermission = "GetResourcePermission"

// GetResourcePermissionRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePermission for more information on using the GetResourcePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePermissionRequest method.
//	req, resp := client.GetResourcePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetResourcePermission
func (c *SsmSap) GetResourcePermissionRequest(input *GetResourcePermissionInput) (req *request.Request, output *GetResourcePermissionOutput) {
	op := &request.Operation{
		Name:       opGetResourcePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/get-resource-permission",
	}

	if input == nil {
		input = &GetResourcePermissionInput{}
	}

	output = &GetResourcePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePermission API operation for AWS Systems Manager for SAP.
//
// Gets permissions associated with the target database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation GetResourcePermission for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetResourcePermission
func (c *SsmSap) GetResourcePermission(input *GetResourcePermissionInput) (*GetResourcePermissionOutput, error) {
	req, out := c.GetResourcePermissionRequest(input)
	return out, req.Send()
}

// GetResourcePermissionWithContext is the same as GetResourcePermission with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) GetResourcePermissionWithContext(ctx aws.Context, input *GetResourcePermissionInput, opts ...request.Option) (*GetResourcePermissionOutput, error) {
	req, out := c.GetResourcePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationsRequest method.
//	req, resp := client.ListApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListApplications
func (c *SsmSap) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/list-applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for AWS Systems Manager for SAP.
//
// Lists all the applications registered with AWS Systems Manager for SAP.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListApplications
func (c *SsmSap) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplications operation.
//	pageNum := 0
//	err := client.ListApplicationsPages(params,
//	    func(page *ssmsap.ListApplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SsmSap) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListComponents = "ListComponents"

// ListComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponents for more information on using the ListComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComponentsRequest method.
//	req, resp := client.ListComponentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListComponents
func (c *SsmSap) ListComponentsRequest(input *ListComponentsInput) (req *request.Request, output *ListComponentsOutput) {
	op := &request.Operation{
		Name:       opListComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/list-components",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentsInput{}
	}

	output = &ListComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponents API operation for AWS Systems Manager for SAP.
//
// Lists all the components registered with AWS Systems Manager for SAP.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation ListComponents for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListComponents
func (c *SsmSap) ListComponents(input *ListComponentsInput) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	return out, req.Send()
}

// ListComponentsWithContext is the same as ListComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) ListComponentsWithContext(ctx aws.Context, input *ListComponentsInput, opts ...request.Option) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentsPages iterates over the pages of a ListComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListComponents operation.
//	pageNum := 0
//	err := client.ListComponentsPages(params,
//	    func(page *ssmsap.ListComponentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SsmSap) ListComponentsPages(input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool) error {
	return c.ListComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentsPagesWithContext same as ListComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) ListComponentsPagesWithContext(ctx aws.Context, input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatabases = "ListDatabases"

// ListDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the ListDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatabases for more information on using the ListDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatabasesRequest method.
//	req, resp := client.ListDatabasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListDatabases
func (c *SsmSap) ListDatabasesRequest(input *ListDatabasesInput) (req *request.Request, output *ListDatabasesOutput) {
	op := &request.Operation{
		Name:       opListDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/list-databases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatabasesInput{}
	}

	output = &ListDatabasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatabases API operation for AWS Systems Manager for SAP.
//
// Lists the SAP HANA databases of an application registered with AWS Systems
// Manager for SAP.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation ListDatabases for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListDatabases
func (c *SsmSap) ListDatabases(input *ListDatabasesInput) (*ListDatabasesOutput, error) {
	req, out := c.ListDatabasesRequest(input)
	return out, req.Send()
}

// ListDatabasesWithContext is the same as ListDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) ListDatabasesWithContext(ctx aws.Context, input *ListDatabasesInput, opts ...request.Option) (*ListDatabasesOutput, error) {
	req, out := c.ListDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatabasesPages iterates over the pages of a ListDatabases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatabases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatabases operation.
//	pageNum := 0
//	err := client.ListDatabasesPages(params,
//	    func(page *ssmsap.ListDatabasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SsmSap) ListDatabasesPages(input *ListDatabasesInput, fn func(*ListDatabasesOutput, bool) bool) error {
	return c.ListDatabasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatabasesPagesWithContext same as ListDatabasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) ListDatabasesPagesWithContext(ctx aws.Context, input *ListDatabasesInput, fn func(*ListDatabasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatabasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatabasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatabasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListTagsForResource
func (c *SsmSap) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Systems Manager for SAP.
//
// Lists all tags on an SAP HANA application and/or database registered with
// AWS Systems Manager for SAP.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListTagsForResource
func (c *SsmSap) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourcePermission = "PutResourcePermission"

// PutResourcePermissionRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePermission for more information on using the PutResourcePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourcePermissionRequest method.
//	req, resp := client.PutResourcePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/PutResourcePermission
func (c *SsmSap) PutResourcePermissionRequest(input *PutResourcePermissionInput) (req *request.Request, output *PutResourcePermissionOutput) {
	op := &request.Operation{
		Name:       opPutResourcePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/put-resource-permission",
	}

	if input == nil {
		input = &PutResourcePermissionInput{}
	}

	output = &PutResourcePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourcePermission API operation for AWS Systems Manager for SAP.
//
// Adds permissions to the target database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation PutResourcePermission for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/PutResourcePermission
func (c *SsmSap) PutResourcePermission(input *PutResourcePermissionInput) (*PutResourcePermissionOutput, error) {
	req, out := c.PutResourcePermissionRequest(input)
	return out, req.Send()
}

// PutResourcePermissionWithContext is the same as PutResourcePermission with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) PutResourcePermissionWithContext(ctx aws.Context, input *PutResourcePermissionInput, opts ...request.Option) (*PutResourcePermissionOutput, error) {
	req, out := c.PutResourcePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterApplication = "RegisterApplication"

// RegisterApplicationRequest generates a "aws/request.Request" representing the
// client's request for the RegisterApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterApplication for more information on using the RegisterApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterApplicationRequest method.
//	req, resp := client.RegisterApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/RegisterApplication
func (c *SsmSap) RegisterApplicationRequest(input *RegisterApplicationInput) (req *request.Request, output *RegisterApplicationOutput) {
	op := &request.Operation{
		Name:       opRegisterApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/register-application",
	}

	if input == nil {
		input = &RegisterApplicationInput{}
	}

	output = &RegisterApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterApplication API operation for AWS Systems Manager for SAP.
//
// Register an SAP application with AWS Systems Manager for SAP. You must meet
// the following requirements before registering.
//
// The SAP application you want to register with AWS Systems Manager for SAP
// is running on Amazon EC2.
//
// AWS Systems Manager Agent must be setup on an Amazon EC2 instance along with
// the required IAM permissions.
//
// Amazon EC2 instance(s) must have access to the secrets created in AWS Secrets
// Manager to manage SAP applications and components.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation RegisterApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - ConflictException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/RegisterApplication
func (c *SsmSap) RegisterApplication(input *RegisterApplicationInput) (*RegisterApplicationOutput, error) {
	req, out := c.RegisterApplicationRequest(input)
	return out, req.Send()
}

// RegisterApplicationWithContext is the same as RegisterApplication with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) RegisterApplicationWithContext(ctx aws.Context, input *RegisterApplicationInput, opts ...request.Option) (*RegisterApplicationOutput, error) {
	req, out := c.RegisterApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/TagResource
func (c *SsmSap) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Systems Manager for SAP.
//
// Creates tag for a resource by specifying the ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/TagResource
func (c *SsmSap) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/UntagResource
func (c *SsmSap) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Systems Manager for SAP.
//
// Delete the tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/UntagResource
func (c *SsmSap) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplicationSettings = "UpdateApplicationSettings"

// UpdateApplicationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplicationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplicationSettings for more information on using the UpdateApplicationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateApplicationSettingsRequest method.
//	req, resp := client.UpdateApplicationSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/UpdateApplicationSettings
func (c *SsmSap) UpdateApplicationSettingsRequest(input *UpdateApplicationSettingsInput) (req *request.Request, output *UpdateApplicationSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateApplicationSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/update-application-settings",
	}

	if input == nil {
		input = &UpdateApplicationSettingsInput{}
	}

	output = &UpdateApplicationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplicationSettings API operation for AWS Systems Manager for SAP.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager for SAP's
// API operation UpdateApplicationSettings for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/UpdateApplicationSettings
func (c *SsmSap) UpdateApplicationSettings(input *UpdateApplicationSettingsInput) (*UpdateApplicationSettingsOutput, error) {
	req, out := c.UpdateApplicationSettingsRequest(input)
	return out, req.Send()
}

// UpdateApplicationSettingsWithContext is the same as UpdateApplicationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplicationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SsmSap) UpdateApplicationSettingsWithContext(ctx aws.Context, input *UpdateApplicationSettingsInput, opts ...request.Option) (*UpdateApplicationSettingsOutput, error) {
	req, out := c.UpdateApplicationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type Application struct {
	_ struct{} `type:"structure"`

	AppRegistryArn *string `type:"string"`

	Arn *string `type:"string"`

	Components []*string `type:"list"`

	Id *string `type:"string"`

	LastUpdated *time.Time `type:"timestamp"`

	Status *string `type:"string" enum:"ApplicationStatus"`

	StatusMessage *string `type:"string"`

	Type *string `type:"string" enum:"ApplicationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) GoString() string {
	return s.String()
}

// SetAppRegistryArn sets the AppRegistryArn field's value.
func (s *Application) SetAppRegistryArn(v string) *Application {
	s.AppRegistryArn = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Application) SetArn(v string) *Application {
	s.Arn = &v
	return s
}

// SetComponents sets the Components field's value.
func (s *Application) SetComponents(v []*string) *Application {
	s.Components = v
	return s
}

// SetId sets the Id field's value.
func (s *Application) SetId(v string) *Application {
	s.Id = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *Application) SetLastUpdated(v time.Time) *Application {
	s.LastUpdated = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Application) SetStatus(v string) *Application {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *Application) SetStatusMessage(v string) *Application {
	s.StatusMessage = &v
	return s
}

// SetType sets the Type field's value.
func (s *Application) SetType(v string) *Application {
	s.Type = &v
	return s
}

type ApplicationCredential struct {
	_ struct{} `type:"structure"`

	// CredentialType is a required field
	CredentialType *string `type:"string" required:"true" enum:"CredentialType"`

	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// SecretId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ApplicationCredential's
	// String and GoString methods.
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationCredential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationCredential) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationCredential) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationCredential"}
	if s.CredentialType == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialType"))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialType sets the CredentialType field's value.
func (s *ApplicationCredential) SetCredentialType(v string) *ApplicationCredential {
	s.CredentialType = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ApplicationCredential) SetDatabaseName(v string) *ApplicationCredential {
	s.DatabaseName = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *ApplicationCredential) SetSecretId(v string) *ApplicationCredential {
	s.SecretId = &v
	return s
}

type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	Id *string `type:"string"`

	Tags map[string]*string `type:"map"`

	Type *string `type:"string" enum:"ApplicationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ApplicationSummary) SetArn(v string) *ApplicationSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ApplicationSummary) SetId(v string) *ApplicationSummary {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ApplicationSummary) SetTags(v map[string]*string) *ApplicationSummary {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ApplicationSummary) SetType(v string) *ApplicationSummary {
	s.Type = &v
	return s
}

type Component struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `type:"string"`

	ComponentId *string `type:"string"`

	ComponentType *string `type:"string" enum:"ComponentType"`

	Databases []*string `type:"list"`

	Hosts []*Host `type:"list"`

	LastUpdated *time.Time `type:"timestamp"`

	PrimaryHost *string `type:"string"`

	Status *string `type:"string" enum:"ComponentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Component) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Component) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *Component) SetApplicationId(v string) *Component {
	s.ApplicationId = &v
	return s
}

// SetComponentId sets the ComponentId field's value.
func (s *Component) SetComponentId(v string) *Component {
	s.ComponentId = &v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *Component) SetComponentType(v string) *Component {
	s.ComponentType = &v
	return s
}

// SetDatabases sets the Databases field's value.
func (s *Component) SetDatabases(v []*string) *Component {
	s.Databases = v
	return s
}

// SetHosts sets the Hosts field's value.
func (s *Component) SetHosts(v []*Host) *Component {
	s.Hosts = v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *Component) SetLastUpdated(v time.Time) *Component {
	s.LastUpdated = &v
	return s
}

// SetPrimaryHost sets the PrimaryHost field's value.
func (s *Component) SetPrimaryHost(v string) *Component {
	s.PrimaryHost = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Component) SetStatus(v string) *Component {
	s.Status = &v
	return s
}

type ComponentSummary struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `type:"string"`

	ComponentId *string `type:"string"`

	ComponentType *string `type:"string" enum:"ComponentType"`

	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ComponentSummary) SetApplicationId(v string) *ComponentSummary {
	s.ApplicationId = &v
	return s
}

// SetComponentId sets the ComponentId field's value.
func (s *ComponentSummary) SetComponentId(v string) *ComponentSummary {
	s.ComponentId = &v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *ComponentSummary) SetComponentType(v string) *ComponentSummary {
	s.ComponentType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ComponentSummary) SetTags(v map[string]*string) *ComponentSummary {
	s.Tags = v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type Database struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `type:"string"`

	Arn *string `type:"string"`

	ComponentId *string `type:"string"`

	Credentials []*ApplicationCredential `min:"1" type:"list"`

	DatabaseId *string `type:"string"`

	DatabaseName *string `type:"string"`

	DatabaseType *string `type:"string" enum:"DatabaseType"`

	LastUpdated *time.Time `type:"timestamp"`

	PrimaryHost *string `type:"string"`

	SQLPort *int64 `type:"integer"`

	Status *string `type:"string" enum:"DatabaseStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Database) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Database) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *Database) SetApplicationId(v string) *Database {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Database) SetArn(v string) *Database {
	s.Arn = &v
	return s
}

// SetComponentId sets the ComponentId field's value.
func (s *Database) SetComponentId(v string) *Database {
	s.ComponentId = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *Database) SetCredentials(v []*ApplicationCredential) *Database {
	s.Credentials = v
	return s
}

// SetDatabaseId sets the DatabaseId field's value.
func (s *Database) SetDatabaseId(v string) *Database {
	s.DatabaseId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Database) SetDatabaseName(v string) *Database {
	s.DatabaseName = &v
	return s
}

// SetDatabaseType sets the DatabaseType field's value.
func (s *Database) SetDatabaseType(v string) *Database {
	s.DatabaseType = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *Database) SetLastUpdated(v time.Time) *Database {
	s.LastUpdated = &v
	return s
}

// SetPrimaryHost sets the PrimaryHost field's value.
func (s *Database) SetPrimaryHost(v string) *Database {
	s.PrimaryHost = &v
	return s
}

// SetSQLPort sets the SQLPort field's value.
func (s *Database) SetSQLPort(v int64) *Database {
	s.SQLPort = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Database) SetStatus(v string) *Database {
	s.Status = &v
	return s
}

type DatabaseSummary struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `type:"string"`

	Arn *string `type:"string"`

	ComponentId *string `type:"string"`

	DatabaseId *string `type:"string"`

	DatabaseType *string `type:"string" enum:"DatabaseType"`

	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DatabaseSummary) SetApplicationId(v string) *DatabaseSummary {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DatabaseSummary) SetArn(v string) *DatabaseSummary {
	s.Arn = &v
	return s
}

// SetComponentId sets the ComponentId field's value.
func (s *DatabaseSummary) SetComponentId(v string) *DatabaseSummary {
	s.ComponentId = &v
	return s
}

// SetDatabaseId sets the DatabaseId field's value.
func (s *DatabaseSummary) SetDatabaseId(v string) *DatabaseSummary {
	s.DatabaseId = &v
	return s
}

// SetDatabaseType sets the DatabaseType field's value.
func (s *DatabaseSummary) SetDatabaseType(v string) *DatabaseSummary {
	s.DatabaseType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DatabaseSummary) SetTags(v map[string]*string) *DatabaseSummary {
	s.Tags = v
	return s
}

type DeleteResourcePermissionInput struct {
	_ struct{} `type:"structure"`

	ActionType *string `type:"string" enum:"PermissionActionType"`

	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	SourceResourceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePermissionInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionType sets the ActionType field's value.
func (s *DeleteResourcePermissionInput) SetActionType(v string) *DeleteResourcePermissionInput {
	s.ActionType = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePermissionInput) SetResourceArn(v string) *DeleteResourcePermissionInput {
	s.ResourceArn = &v
	return s
}

// SetSourceResourceArn sets the SourceResourceArn field's value.
func (s *DeleteResourcePermissionInput) SetSourceResourceArn(v string) *DeleteResourcePermissionInput {
	s.SourceResourceArn = &v
	return s
}

type DeleteResourcePermissionOutput struct {
	_ struct{} `type:"structure"`

	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePermissionOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *DeleteResourcePermissionOutput) SetPolicy(v string) *DeleteResourcePermissionOutput {
	s.Policy = &v
	return s
}

type DeregisterApplicationInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeregisterApplicationInput) SetApplicationId(v string) *DeregisterApplicationInput {
	s.ApplicationId = &v
	return s
}

type DeregisterApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterApplicationOutput) GoString() string {
	return s.String()
}

type GetApplicationInput struct {
	_ struct{} `type:"structure"`

	ApplicationArn *string `type:"string"`

	ApplicationId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *GetApplicationInput) SetApplicationArn(v string) *GetApplicationInput {
	s.ApplicationArn = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationInput) SetApplicationId(v string) *GetApplicationInput {
	s.ApplicationId = &v
	return s
}

type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	Application *Application `type:"structure"`

	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// SetApplication sets the Application field's value.
func (s *GetApplicationOutput) SetApplication(v *Application) *GetApplicationOutput {
	s.Application = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetApplicationOutput) SetTags(v map[string]*string) *GetApplicationOutput {
	s.Tags = v
	return s
}

type GetComponentInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// ComponentId is a required field
	ComponentId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComponentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ComponentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetComponentInput) SetApplicationId(v string) *GetComponentInput {
	s.ApplicationId = &v
	return s
}

// SetComponentId sets the ComponentId field's value.
func (s *GetComponentInput) SetComponentId(v string) *GetComponentInput {
	s.ComponentId = &v
	return s
}

type GetComponentOutput struct {
	_ struct{} `type:"structure"`

	Component *Component `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentOutput) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *GetComponentOutput) SetComponent(v *Component) *GetComponentOutput {
	s.Component = v
	return s
}

type GetDatabaseInput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `type:"string"`

	ComponentId *string `type:"string"`

	DatabaseArn *string `type:"string"`

	DatabaseId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatabaseInput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetDatabaseInput) SetApplicationId(v string) *GetDatabaseInput {
	s.ApplicationId = &v
	return s
}

// SetComponentId sets the ComponentId field's value.
func (s *GetDatabaseInput) SetComponentId(v string) *GetDatabaseInput {
	s.ComponentId = &v
	return s
}

// SetDatabaseArn sets the DatabaseArn field's value.
func (s *GetDatabaseInput) SetDatabaseArn(v string) *GetDatabaseInput {
	s.DatabaseArn = &v
	return s
}

// SetDatabaseId sets the DatabaseId field's value.
func (s *GetDatabaseInput) SetDatabaseId(v string) *GetDatabaseInput {
	s.DatabaseId = &v
	return s
}

type GetDatabaseOutput struct {
	_ struct{} `type:"structure"`

	Database *Database `type:"structure"`

	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatabaseOutput) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *GetDatabaseOutput) SetDatabase(v *Database) *GetDatabaseOutput {
	s.Database = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDatabaseOutput) SetTags(v map[string]*string) *GetDatabaseOutput {
	s.Tags = v
	return s
}

type GetOperationInput struct {
	_ struct{} `type:"structure"`

	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOperationInput"}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperationId sets the OperationId field's value.
func (s *GetOperationInput) SetOperationId(v string) *GetOperationInput {
	s.OperationId = &v
	return s
}

type GetOperationOutput struct {
	_ struct{} `type:"structure"`

	Operation *Operation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOperationOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *GetOperationOutput) SetOperation(v *Operation) *GetOperationOutput {
	s.Operation = v
	return s
}

type GetResourcePermissionInput struct {
	_ struct{} `type:"structure"`

	ActionType *string `type:"string" enum:"PermissionActionType"`

	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePermissionInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionType sets the ActionType field's value.
func (s *GetResourcePermissionInput) SetActionType(v string) *GetResourcePermissionInput {
	s.ActionType = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetResourcePermissionInput) SetResourceArn(v string) *GetResourcePermissionInput {
	s.ResourceArn = &v
	return s
}

type GetResourcePermissionOutput struct {
	_ struct{} `type:"structure"`

	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePermissionOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetResourcePermissionOutput) SetPolicy(v string) *GetResourcePermissionOutput {
	s.Policy = &v
	return s
}

type Host struct {
	_ struct{} `type:"structure"`

	HostIp *string `type:"string"`

	HostName *string `type:"string"`

	HostRole *string `type:"string" enum:"HostRole"`

	InstanceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Host) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Host) GoString() string {
	return s.String()
}

// SetHostIp sets the HostIp field's value.
func (s *Host) SetHostIp(v string) *Host {
	s.HostIp = &v
	return s
}

// SetHostName sets the HostName field's value.
func (s *Host) SetHostName(v string) *Host {
	s.HostName = &v
	return s
}

// SetHostRole sets the HostRole field's value.
func (s *Host) SetHostRole(v string) *Host {
	s.HostRole = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Host) SetInstanceId(v string) *Host {
	s.InstanceId = &v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `min:"1" type:"integer"`

	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	Applications []*ApplicationSummary `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *ListApplicationsOutput) SetApplications(v []*ApplicationSummary) *ListApplicationsOutput {
	s.Applications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListComponentsInput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `type:"string"`

	MaxResults *int64 `min:"1" type:"integer"`

	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListComponentsInput) SetApplicationId(v string) *ListComponentsInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentsInput) SetMaxResults(v int64) *ListComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsInput) SetNextToken(v string) *ListComponentsInput {
	s.NextToken = &v
	return s
}

type ListComponentsOutput struct {
	_ struct{} `type:"structure"`

	Components []*ComponentSummary `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsOutput) GoString() string {
	return s.String()
}

// SetComponents sets the Components field's value.
func (s *ListComponentsOutput) SetComponents(v []*ComponentSummary) *ListComponentsOutput {
	s.Components = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsOutput) SetNextToken(v string) *ListComponentsOutput {
	s.NextToken = &v
	return s
}

type ListDatabasesInput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `type:"string"`

	ComponentId *string `type:"string"`

	MaxResults *int64 `min:"1" type:"integer"`

	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatabasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatabasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListDatabasesInput) SetApplicationId(v string) *ListDatabasesInput {
	s.ApplicationId = &v
	return s
}

// SetComponentId sets the ComponentId field's value.
func (s *ListDatabasesInput) SetComponentId(v string) *ListDatabasesInput {
	s.ComponentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatabasesInput) SetMaxResults(v int64) *ListDatabasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatabasesInput) SetNextToken(v string) *ListDatabasesInput {
	s.NextToken = &v
	return s
}

type ListDatabasesOutput struct {
	_ struct{} `type:"structure"`

	Databases []*DatabaseSummary `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesOutput) GoString() string {
	return s.String()
}

// SetDatabases sets the Databases field's value.
func (s *ListDatabasesOutput) SetDatabases(v []*DatabaseSummary) *ListDatabasesOutput {
	s.Databases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatabasesOutput) SetNextToken(v string) *ListDatabasesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type Operation struct {
	_ struct{} `type:"structure"`

	EndTime *time.Time `type:"timestamp"`

	Id *string `type:"string"`

	LastUpdatedTime *time.Time `type:"timestamp"`

	Properties map[string]*string `type:"map"`

	ResourceArn *string `type:"string"`

	ResourceId *string `min:"1" type:"string"`

	ResourceType *string `min:"1" type:"string"`

	StartTime *time.Time `type:"timestamp"`

	Status *string `type:"string" enum:"OperationStatus"`

	StatusMessage *string `type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Operation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Operation) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *Operation) SetEndTime(v time.Time) *Operation {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *Operation) SetId(v string) *Operation {
	s.Id = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Operation) SetLastUpdatedTime(v time.Time) *Operation {
	s.LastUpdatedTime = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *Operation) SetProperties(v map[string]*string) *Operation {
	s.Properties = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Operation) SetResourceArn(v string) *Operation {
	s.ResourceArn = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *Operation) SetResourceId(v string) *Operation {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Operation) SetResourceType(v string) *Operation {
	s.ResourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Operation) SetStartTime(v time.Time) *Operation {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Operation) SetStatus(v string) *Operation {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *Operation) SetStatusMessage(v string) *Operation {
	s.StatusMessage = &v
	return s
}

// SetType sets the Type field's value.
func (s *Operation) SetType(v string) *Operation {
	s.Type = &v
	return s
}

type PutResourcePermissionInput struct {
	_ struct{} `type:"structure"`

	// ActionType is a required field
	ActionType *string `type:"string" required:"true" enum:"PermissionActionType"`

	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// SourceResourceArn is a required field
	SourceResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePermissionInput"}
	if s.ActionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionType"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.SourceResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionType sets the ActionType field's value.
func (s *PutResourcePermissionInput) SetActionType(v string) *PutResourcePermissionInput {
	s.ActionType = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutResourcePermissionInput) SetResourceArn(v string) *PutResourcePermissionInput {
	s.ResourceArn = &v
	return s
}

// SetSourceResourceArn sets the SourceResourceArn field's value.
func (s *PutResourcePermissionInput) SetSourceResourceArn(v string) *PutResourcePermissionInput {
	s.SourceResourceArn = &v
	return s
}

type PutResourcePermissionOutput struct {
	_ struct{} `type:"structure"`

	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePermissionOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePermissionOutput) SetPolicy(v string) *PutResourcePermissionOutput {
	s.Policy = &v
	return s
}

type RegisterApplicationInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// ApplicationType is a required field
	ApplicationType *string `type:"string" required:"true" enum:"ApplicationType"`

	// Credentials is a required field
	Credentials []*ApplicationCredential `min:"1" type:"list" required:"true"`

	// Instances is a required field
	Instances []*string `min:"1" type:"list" required:"true"`

	SapInstanceNumber *string `type:"string"`

	Sid *string `type:"string"`

	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationType"))
	}
	if s.Credentials == nil {
		invalidParams.Add(request.NewErrParamRequired("Credentials"))
	}
	if s.Credentials != nil && len(s.Credentials) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Credentials", 1))
	}
	if s.Instances == nil {
		invalidParams.Add(request.NewErrParamRequired("Instances"))
	}
	if s.Instances != nil && len(s.Instances) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Instances", 1))
	}
	if s.Credentials != nil {
		for i, v := range s.Credentials {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Credentials", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *RegisterApplicationInput) SetApplicationId(v string) *RegisterApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetApplicationType sets the ApplicationType field's value.
func (s *RegisterApplicationInput) SetApplicationType(v string) *RegisterApplicationInput {
	s.ApplicationType = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *RegisterApplicationInput) SetCredentials(v []*ApplicationCredential) *RegisterApplicationInput {
	s.Credentials = v
	return s
}

// SetInstances sets the Instances field's value.
func (s *RegisterApplicationInput) SetInstances(v []*string) *RegisterApplicationInput {
	s.Instances = v
	return s
}

// SetSapInstanceNumber sets the SapInstanceNumber field's value.
func (s *RegisterApplicationInput) SetSapInstanceNumber(v string) *RegisterApplicationInput {
	s.SapInstanceNumber = &v
	return s
}

// SetSid sets the Sid field's value.
func (s *RegisterApplicationInput) SetSid(v string) *RegisterApplicationInput {
	s.Sid = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegisterApplicationInput) SetTags(v map[string]*string) *RegisterApplicationInput {
	s.Tags = v
	return s
}

type RegisterApplicationOutput struct {
	_ struct{} `type:"structure"`

	Application *Application `type:"structure"`

	OperationId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterApplicationOutput) GoString() string {
	return s.String()
}

// SetApplication sets the Application field's value.
func (s *RegisterApplicationOutput) SetApplication(v *Application) *RegisterApplicationOutput {
	s.Application = v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *RegisterApplicationOutput) SetOperationId(v string) *RegisterApplicationOutput {
	s.OperationId = &v
	return s
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Adds/updates or removes credentials for applications registered with AWS
	// Systems Manager for SAP.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationSettingsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	CredentialsToAddOrUpdate []*ApplicationCredential `min:"1" type:"list"`

	CredentialsToRemove []*ApplicationCredential `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationSettingsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CredentialsToAddOrUpdate != nil && len(s.CredentialsToAddOrUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CredentialsToAddOrUpdate", 1))
	}
	if s.CredentialsToRemove != nil && len(s.CredentialsToRemove) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CredentialsToRemove", 1))
	}
	if s.CredentialsToAddOrUpdate != nil {
		for i, v := range s.CredentialsToAddOrUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CredentialsToAddOrUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CredentialsToRemove != nil {
		for i, v := range s.CredentialsToRemove {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CredentialsToRemove", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationSettingsInput) SetApplicationId(v string) *UpdateApplicationSettingsInput {
	s.ApplicationId = &v
	return s
}

// SetCredentialsToAddOrUpdate sets the CredentialsToAddOrUpdate field's value.
func (s *UpdateApplicationSettingsInput) SetCredentialsToAddOrUpdate(v []*ApplicationCredential) *UpdateApplicationSettingsInput {
	s.CredentialsToAddOrUpdate = v
	return s
}

// SetCredentialsToRemove sets the CredentialsToRemove field's value.
func (s *UpdateApplicationSettingsInput) SetCredentialsToRemove(v []*ApplicationCredential) *UpdateApplicationSettingsInput {
	s.CredentialsToRemove = v
	return s
}

type UpdateApplicationSettingsOutput struct {
	_ struct{} `type:"structure"`

	Message *string `type:"string"`

	OperationIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationSettingsOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *UpdateApplicationSettingsOutput) SetMessage(v string) *UpdateApplicationSettingsOutput {
	s.Message = &v
	return s
}

// SetOperationIds sets the OperationIds field's value.
func (s *UpdateApplicationSettingsOutput) SetOperationIds(v []*string) *UpdateApplicationSettingsOutput {
	s.OperationIds = v
	return s
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ApplicationStatusActivated is a ApplicationStatus enum value
	ApplicationStatusActivated = "ACTIVATED"

	// ApplicationStatusStarting is a ApplicationStatus enum value
	ApplicationStatusStarting = "STARTING"

	// ApplicationStatusStopped is a ApplicationStatus enum value
	ApplicationStatusStopped = "STOPPED"

	// ApplicationStatusStopping is a ApplicationStatus enum value
	ApplicationStatusStopping = "STOPPING"

	// ApplicationStatusFailed is a ApplicationStatus enum value
	ApplicationStatusFailed = "FAILED"

	// ApplicationStatusRegistering is a ApplicationStatus enum value
	ApplicationStatusRegistering = "REGISTERING"

	// ApplicationStatusDeleting is a ApplicationStatus enum value
	ApplicationStatusDeleting = "DELETING"

	// ApplicationStatusUnknown is a ApplicationStatus enum value
	ApplicationStatusUnknown = "UNKNOWN"
)

// ApplicationStatus_Values returns all elements of the ApplicationStatus enum
func ApplicationStatus_Values() []string {
	return []string{
		ApplicationStatusActivated,
		ApplicationStatusStarting,
		ApplicationStatusStopped,
		ApplicationStatusStopping,
		ApplicationStatusFailed,
		ApplicationStatusRegistering,
		ApplicationStatusDeleting,
		ApplicationStatusUnknown,
	}
}

const (
	// ApplicationTypeHana is a ApplicationType enum value
	ApplicationTypeHana = "HANA"
)

// ApplicationType_Values returns all elements of the ApplicationType enum
func ApplicationType_Values() []string {
	return []string{
		ApplicationTypeHana,
	}
}

const (
	// ComponentStatusActivated is a ComponentStatus enum value
	ComponentStatusActivated = "ACTIVATED"
)

// ComponentStatus_Values returns all elements of the ComponentStatus enum
func ComponentStatus_Values() []string {
	return []string{
		ComponentStatusActivated,
	}
}

const (
	// ComponentTypeHana is a ComponentType enum value
	ComponentTypeHana = "HANA"
)

// ComponentType_Values returns all elements of the ComponentType enum
func ComponentType_Values() []string {
	return []string{
		ComponentTypeHana,
	}
}

const (
	// CredentialTypeAdmin is a CredentialType enum value
	CredentialTypeAdmin = "ADMIN"
)

// CredentialType_Values returns all elements of the CredentialType enum
func CredentialType_Values() []string {
	return []string{
		CredentialTypeAdmin,
	}
}

const (
	// DatabaseStatusRunning is a DatabaseStatus enum value
	DatabaseStatusRunning = "RUNNING"

	// DatabaseStatusStarting is a DatabaseStatus enum value
	DatabaseStatusStarting = "STARTING"

	// DatabaseStatusStopped is a DatabaseStatus enum value
	DatabaseStatusStopped = "STOPPED"

	// DatabaseStatusWarning is a DatabaseStatus enum value
	DatabaseStatusWarning = "WARNING"

	// DatabaseStatusUnknown is a DatabaseStatus enum value
	DatabaseStatusUnknown = "UNKNOWN"
)

// DatabaseStatus_Values returns all elements of the DatabaseStatus enum
func DatabaseStatus_Values() []string {
	return []string{
		DatabaseStatusRunning,
		DatabaseStatusStarting,
		DatabaseStatusStopped,
		DatabaseStatusWarning,
		DatabaseStatusUnknown,
	}
}

const (
	// DatabaseTypeSystem is a DatabaseType enum value
	DatabaseTypeSystem = "SYSTEM"

	// DatabaseTypeTenant is a DatabaseType enum value
	DatabaseTypeTenant = "TENANT"
)

// DatabaseType_Values returns all elements of the DatabaseType enum
func DatabaseType_Values() []string {
	return []string{
		DatabaseTypeSystem,
		DatabaseTypeTenant,
	}
}

const (
	// HostRoleLeader is a HostRole enum value
	HostRoleLeader = "LEADER"

	// HostRoleWorker is a HostRole enum value
	HostRoleWorker = "WORKER"

	// HostRoleStandby is a HostRole enum value
	HostRoleStandby = "STANDBY"

	// HostRoleUnknown is a HostRole enum value
	HostRoleUnknown = "UNKNOWN"
)

// HostRole_Values returns all elements of the HostRole enum
func HostRole_Values() []string {
	return []string{
		HostRoleLeader,
		HostRoleWorker,
		HostRoleStandby,
		HostRoleUnknown,
	}
}

const (
	// OperationStatusInprogress is a OperationStatus enum value
	OperationStatusInprogress = "INPROGRESS"

	// OperationStatusSuccess is a OperationStatus enum value
	OperationStatusSuccess = "SUCCESS"

	// OperationStatusError is a OperationStatus enum value
	OperationStatusError = "ERROR"
)

// OperationStatus_Values returns all elements of the OperationStatus enum
func OperationStatus_Values() []string {
	return []string{
		OperationStatusInprogress,
		OperationStatusSuccess,
		OperationStatusError,
	}
}

const (
	// PermissionActionTypeRestore is a PermissionActionType enum value
	PermissionActionTypeRestore = "RESTORE"
)

// PermissionActionType_Values returns all elements of the PermissionActionType enum
func PermissionActionType_Values() []string {
	return []string{
		PermissionActionTypeRestore,
	}
}
