/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class BreitWigner
extends AbstractContinousDistribution {
    protected double mean;
    protected double gamma;
    protected double cut;
    protected static BreitWigner shared = new BreitWigner(1.0, 0.2, 1.0, AbstractDistribution.makeDefaultGenerator());

    public BreitWigner(double d2, double d3, double d4, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d2, d3, d4);
    }

    public double nextDouble() {
        return this.nextDouble(this.mean, this.gamma, this.cut);
    }

    public double nextDouble(double d2, double d3, double d4) {
        if (d3 == 0.0) {
            return d2;
        }
        if (d4 == Double.NEGATIVE_INFINITY) {
            double d5 = 2.0 * this.randomGenerator.raw() - 1.0;
            double d6 = 0.5 * d3 * Math.tan(d5 * 1.5707963267948966);
            return d2 + d6;
        }
        double d7 = Math.atan(2.0 * d4 / d3);
        double d8 = 2.0 * this.randomGenerator.raw() - 1.0;
        double d9 = 0.5 * d3 * Math.tan(d8 * d7);
        return d2 + d9;
    }

    public void setState(double d2, double d3, double d4) {
        this.mean = d2;
        this.gamma = d3;
        this.cut = d4;
    }

    public static double staticNextDouble(double d2, double d3, double d4) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            double d5 = shared.nextDouble(d2, d3, d4);
            return d5;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + "," + this.gamma + "," + this.cut + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

