/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.Stack;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class EmpiricalWalker
extends AbstractDiscreteDistribution {
    protected int K;
    protected int[] A;
    protected double[] F;
    protected double[] cdf;

    public EmpiricalWalker(double[] dArray, int n, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(dArray, n);
        this.setState2(dArray);
    }

    public double cdf(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (n >= this.cdf.length - 1) {
            return 1.0;
        }
        return this.cdf[n];
    }

    public Object clone() {
        EmpiricalWalker empiricalWalker = (EmpiricalWalker)super.clone();
        if (this.cdf != null) {
            empiricalWalker.cdf = (double[])this.cdf.clone();
        }
        if (this.A != null) {
            empiricalWalker.A = (int[])this.A.clone();
        }
        if (this.F != null) {
            empiricalWalker.F = (double[])this.F.clone();
        }
        return empiricalWalker;
    }

    public int nextInt() {
        int n = 0;
        double d2 = this.randomGenerator.raw();
        n = (int)(d2 *= (double)this.K);
        d2 -= (double)n;
        double d3 = this.F[n];
        if (d3 == 1.0) {
            return n;
        }
        if (d2 < d3) {
            return n;
        }
        return this.A[n];
    }

    public double pdf(int n) {
        if (n < 0 || n >= this.cdf.length - 1) {
            return 0.0;
        }
        return this.cdf[n - 1] - this.cdf[n];
    }

    public void setState(double[] dArray, int n) {
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException("Non-existing pdf");
        }
        int n2 = dArray.length;
        this.cdf = new double[n2 + 1];
        this.cdf[0] = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            if (dArray[n3] < 0.0) {
                throw new IllegalArgumentException("Negative probability");
            }
            this.cdf[n3 + 1] = this.cdf[n3] + dArray[n3];
            ++n3;
        }
        if (this.cdf[n2] <= 0.0) {
            throw new IllegalArgumentException("At leat one probability must be > 0.0");
        }
        int n4 = 0;
        while (n4 < n2 + 1) {
            int n5 = n4++;
            this.cdf[n5] = this.cdf[n5] / this.cdf[n2];
        }
    }

    public void setState2(double[] dArray) {
        int n;
        int n2 = dArray.length;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            d2 += dArray[n3];
            ++n3;
        }
        this.K = n2;
        this.F = new double[n2];
        this.A = new int[n2];
        double[] dArray2 = new double[n2];
        n3 = 0;
        while (n3 < n2) {
            dArray2[n3] = dArray[n3] / d2;
            ++n3;
        }
        double d3 = 1.0 / (double)n2;
        int n4 = 0;
        int n5 = 0;
        n3 = 0;
        while (n3 < n2) {
            if (dArray2[n3] < d3) {
                ++n4;
            } else {
                ++n5;
            }
            ++n3;
        }
        Stack stack = new Stack(n5);
        Stack stack2 = new Stack(n4);
        n3 = 0;
        while (n3 < n2) {
            if (dArray2[n3] < d3) {
                stack2.push(n3);
            } else {
                stack.push(n3);
            }
            ++n3;
        }
        while (stack2.size() > 0) {
            int n6 = stack2.pop();
            if (stack.size() == 0) {
                this.A[n6] = n6;
                this.F[n6] = 1.0;
                break;
            }
            this.A[n6] = n = stack.pop();
            this.F[n6] = (double)n2 * dArray2[n6];
            double d4 = d3 - dArray2[n6];
            int n7 = n6;
            dArray2[n7] = dArray2[n7] + d4;
            int n8 = n;
            dArray2[n8] = dArray2[n8] - d4;
            if (dArray2[n] < d3) {
                stack2.push(n);
                continue;
            }
            if (dArray2[n] > d3) {
                stack.push(n);
                continue;
            }
            this.A[n] = n;
            this.F[n] = 1.0;
        }
        while (stack.size() > 0) {
            this.A[n] = n = stack.pop();
            this.F[n] = 1.0;
        }
    }

    public String toString() {
        Object var1_1 = null;
        return this.getClass().getName() + "(" + (this.cdf != null ? this.cdf.length : 0) + ")";
    }
}

