/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat;

import cern.jet.math.Constants;
import cern.jet.math.Polynomial;

public class Gamma
extends Constants {
    protected Gamma() {
    }

    public static double beta(double d2, double d3) throws ArithmeticException {
        double d4 = d2 + d3;
        if ((d4 = Gamma.gamma(d4)) == 0.0) {
            return 1.0;
        }
        if (d2 > d3) {
            d4 = Gamma.gamma(d2) / d4;
            d4 *= Gamma.gamma(d3);
        } else {
            d4 = Gamma.gamma(d3) / d4;
            d4 *= Gamma.gamma(d2);
        }
        return d4;
    }

    public static double gamma(double d2) throws ArithmeticException {
        double[] dArray = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] dArray2 = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double d3 = Math.abs(d2);
        if (d3 > 33.0) {
            if (d2 < 0.0) {
                double d4 = Math.floor(d3);
                if (d4 == d3) {
                    throw new ArithmeticException("gamma: overflow");
                }
                int n = (int)d4;
                double d5 = d3 - d4;
                if (d5 > 0.5) {
                    d5 = d3 - (d4 += 1.0);
                }
                if ((d5 = d3 * Math.sin(Math.PI * d5)) == 0.0) {
                    throw new ArithmeticException("gamma: overflow");
                }
                d5 = Math.abs(d5);
                d5 = Math.PI / (d5 * Gamma.stirlingFormula(d3));
                return -d5;
            }
            return Gamma.stirlingFormula(d2);
        }
        double d6 = 1.0;
        while (d2 >= 3.0) {
            d6 *= (d2 -= 1.0);
        }
        while (d2 < 0.0) {
            if (d2 == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (d2 > -1.0E-9) {
                return d6 / ((1.0 + 0.5772156649015329 * d2) * d2);
            }
            d6 /= d2;
            d2 += 1.0;
        }
        while (d2 < 2.0) {
            if (d2 == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (d2 < 1.0E-9) {
                return d6 / ((1.0 + 0.5772156649015329 * d2) * d2);
            }
            d6 /= d2;
            d2 += 1.0;
        }
        if (d2 == 2.0 || d2 == 3.0) {
            return d6;
        }
        double d7 = Polynomial.polevl(d2 -= 2.0, dArray, 6);
        d3 = Polynomial.polevl(d2, dArray2, 7);
        return d6 * d7 / d3;
    }

    public static double incompleteBeta(double d2, double d3, double d4) throws ArithmeticException {
        double d5;
        double d6;
        double d7;
        double d8;
        if (d2 <= 0.0 || d3 <= 0.0) {
            throw new ArithmeticException("ibeta: Domain error!");
        }
        if (d4 <= 0.0 || d4 >= 1.0) {
            if (d4 == 0.0) {
                return 0.0;
            }
            if (d4 == 1.0) {
                return 1.0;
            }
            throw new ArithmeticException("ibeta: Domain error!");
        }
        boolean bl = false;
        if (d3 * d4 <= 1.0 && d4 <= 0.95) {
            double d9 = Gamma.powerSeries(d2, d3, d4);
            return d9;
        }
        double d10 = 1.0 - d4;
        if (d4 > d2 / (d2 + d3)) {
            bl = true;
            d8 = d3;
            d7 = d2;
            d6 = d4;
            d5 = d10;
        } else {
            d8 = d2;
            d7 = d3;
            d6 = d10;
            d5 = d4;
        }
        if (bl && d7 * d5 <= 1.0 && d5 <= 0.95) {
            double d11 = Gamma.powerSeries(d8, d7, d5);
            d11 = d11 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d11;
            return d11;
        }
        double d12 = d5 * (d8 + d7 - 2.0) - (d8 - 1.0);
        d10 = d12 < 0.0 ? Gamma.incompleteBetaFraction1(d8, d7, d5) : Gamma.incompleteBetaFraction2(d8, d7, d5) / d6;
        d12 = d8 * Math.log(d5);
        double d13 = d7 * Math.log(d6);
        if (d8 + d7 < 171.6243769563027 && Math.abs(d12) < 709.782712893384 && Math.abs(d13) < 709.782712893384) {
            d13 = Math.pow(d6, d7);
            d13 *= Math.pow(d5, d8);
            d13 /= d8;
            d13 *= d10;
            d13 *= Gamma.gamma(d8 + d7) / (Gamma.gamma(d8) * Gamma.gamma(d7));
            if (bl) {
                d13 = d13 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d13;
            }
            return d13;
        }
        d12 += d13 + Gamma.logGamma(d8 + d7) - Gamma.logGamma(d8) - Gamma.logGamma(d7);
        d13 = (d12 += Math.log(d10 / d8)) < -745.1332191019412 ? 0.0 : Math.exp(d12);
        if (bl) {
            d13 = d13 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d13;
        }
        return d13;
    }

    static double incompleteBetaFraction1(double d2, double d3, double d4) throws ArithmeticException {
        double d5 = d2;
        double d6 = d2 + d3;
        double d7 = d2;
        double d8 = d2 + 1.0;
        double d9 = 1.0;
        double d10 = d3 - 1.0;
        double d11 = d8;
        double d12 = d2 + 2.0;
        double d13 = 0.0;
        double d14 = 1.0;
        double d15 = 1.0;
        double d16 = 1.0;
        double d17 = 1.0;
        double d18 = 1.0;
        int n = 0;
        double d19 = 3.330669E-16f;
        do {
            double d20;
            double d21 = -(d4 * d5 * d6) / (d7 * d8);
            double d22 = d15 + d13 * d21;
            double d23 = d16 + d14 * d21;
            d13 = d15;
            d15 = d22;
            d14 = d16;
            d16 = d23;
            d21 = d4 * d9 * d10 / (d11 * d12);
            d22 = d15 + d13 * d21;
            d23 = d16 + d14 * d21;
            d13 = d15;
            d15 = d22;
            d14 = d16;
            d16 = d23;
            if (d23 != 0.0) {
                d18 = d22 / d23;
            }
            if (d18 != 0.0) {
                d20 = Math.abs((d17 - d18) / d18);
                d17 = d18;
            } else {
                d20 = 1.0;
            }
            if (d20 < d19) {
                return d17;
            }
            d5 += 1.0;
            d6 += 1.0;
            d7 += 2.0;
            d8 += 2.0;
            d9 += 1.0;
            d10 -= 1.0;
            d11 += 2.0;
            d12 += 2.0;
            if (Math.abs(d23) + Math.abs(d22) > 4.503599627370496E15) {
                d13 *= 2.220446049250313E-16;
                d15 *= 2.220446049250313E-16;
                d14 *= 2.220446049250313E-16;
                d16 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(d23) < 2.220446049250313E-16) && !(Math.abs(d22) < 2.220446049250313E-16)) continue;
            d13 *= 4.503599627370496E15;
            d15 *= 4.503599627370496E15;
            d14 *= 4.503599627370496E15;
            d16 *= 4.503599627370496E15;
        } while (++n < 300);
        return d17;
    }

    static double incompleteBetaFraction2(double d2, double d3, double d4) throws ArithmeticException {
        double d5 = d2;
        double d6 = d3 - 1.0;
        double d7 = d2;
        double d8 = d2 + 1.0;
        double d9 = 1.0;
        double d10 = d2 + d3;
        double d11 = d2 + 1.0;
        double d12 = d2 + 2.0;
        double d13 = 0.0;
        double d14 = 1.0;
        double d15 = 1.0;
        double d16 = 1.0;
        double d17 = d4 / (1.0 - d4);
        double d18 = 1.0;
        double d19 = 1.0;
        int n = 0;
        double d20 = 3.330669E-16f;
        do {
            double d21;
            double d22 = -(d17 * d5 * d6) / (d7 * d8);
            double d23 = d15 + d13 * d22;
            double d24 = d16 + d14 * d22;
            d13 = d15;
            d15 = d23;
            d14 = d16;
            d16 = d24;
            d22 = d17 * d9 * d10 / (d11 * d12);
            d23 = d15 + d13 * d22;
            d24 = d16 + d14 * d22;
            d13 = d15;
            d15 = d23;
            d14 = d16;
            d16 = d24;
            if (d24 != 0.0) {
                d19 = d23 / d24;
            }
            if (d19 != 0.0) {
                d21 = Math.abs((d18 - d19) / d19);
                d18 = d19;
            } else {
                d21 = 1.0;
            }
            if (d21 < d20) {
                return d18;
            }
            d5 += 1.0;
            d6 -= 1.0;
            d7 += 2.0;
            d8 += 2.0;
            d9 += 1.0;
            d10 += 1.0;
            d11 += 2.0;
            d12 += 2.0;
            if (Math.abs(d24) + Math.abs(d23) > 4.503599627370496E15) {
                d13 *= 2.220446049250313E-16;
                d15 *= 2.220446049250313E-16;
                d14 *= 2.220446049250313E-16;
                d16 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(d24) < 2.220446049250313E-16) && !(Math.abs(d23) < 2.220446049250313E-16)) continue;
            d13 *= 4.503599627370496E15;
            d15 *= 4.503599627370496E15;
            d14 *= 4.503599627370496E15;
            d16 *= 4.503599627370496E15;
        } while (++n < 300);
        return d18;
    }

    public static double incompleteGamma(double d2, double d3) throws ArithmeticException {
        if (d3 <= 0.0 || d2 <= 0.0) {
            return 0.0;
        }
        if (d3 > 1.0 && d3 > d2) {
            return 1.0 - Gamma.incompleteGammaComplement(d2, d3);
        }
        double d4 = d2 * Math.log(d3) - d3 - Gamma.logGamma(d2);
        if (d4 < -709.782712893384) {
            return 0.0;
        }
        d4 = Math.exp(d4);
        double d5 = d2;
        double d6 = 1.0;
        double d7 = 1.0;
        while ((d6 *= d3 / (d5 += 1.0)) / (d7 += d6) > (double)1.110223E-16f) {
        }
        return d7 * d4 / d2;
    }

    public static double incompleteGammaComplement(double d2, double d3) throws ArithmeticException {
        double d4;
        if (d3 <= 0.0 || d2 <= 0.0) {
            return 1.0;
        }
        if (d3 < 1.0 || d3 < d2) {
            return 1.0 - Gamma.incompleteGamma(d2, d3);
        }
        double d5 = d2 * Math.log(d3) - d3 - Gamma.logGamma(d2);
        if (d5 < -709.782712893384) {
            return 0.0;
        }
        d5 = Math.exp(d5);
        double d6 = 1.0 - d2;
        double d7 = d3 + d6 + 1.0;
        double d8 = 0.0;
        double d9 = 1.0;
        double d10 = d3;
        double d11 = d3 + 1.0;
        double d12 = d7 * d3;
        double d13 = d11 / d12;
        do {
            double d14 = (d6 += 1.0) * (d8 += 1.0);
            double d15 = d11 * (d7 += 2.0) - d9 * d14;
            double d16 = d12 * d7 - d10 * d14;
            if (d16 != 0.0) {
                double d17 = d15 / d16;
                d4 = Math.abs((d13 - d17) / d17);
                d13 = d17;
            } else {
                d4 = 1.0;
            }
            d9 = d11;
            d11 = d15;
            d10 = d12;
            d12 = d16;
            if (!(Math.abs(d15) > 4.503599627370496E15)) continue;
            d9 *= 2.220446049250313E-16;
            d11 *= 2.220446049250313E-16;
            d10 *= 2.220446049250313E-16;
            d12 *= 2.220446049250313E-16;
        } while (d4 > (double)1.110223E-16f);
        return d13 * d5;
    }

    public static double logGamma(double d2) throws ArithmeticException {
        double[] dArray = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] dArray2 = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] dArray3 = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (d2 < -34.0) {
            double d3 = -d2;
            double d4 = Gamma.logGamma(d3);
            double d5 = Math.floor(d3);
            if (d5 == d3) {
                throw new ArithmeticException("lgam: Overflow");
            }
            double d6 = d3 - d5;
            if (d6 > 0.5) {
                d6 = (d5 += 1.0) - d3;
            }
            if ((d6 = d3 * Math.sin(Math.PI * d6)) == 0.0) {
                throw new ArithmeticException("lgamma: Overflow");
            }
            d6 = 1.1447298858494002 - Math.log(d6) - d4;
            return d6;
        }
        if (d2 < 13.0) {
            double d7 = 1.0;
            while (d2 >= 3.0) {
                d7 *= (d2 -= 1.0);
            }
            while (d2 < 2.0) {
                if (d2 == 0.0) {
                    throw new ArithmeticException("lgamma: Overflow");
                }
                d7 /= d2;
                d2 += 1.0;
            }
            if (d7 < 0.0) {
                d7 = -d7;
            }
            if (d2 == 2.0) {
                return Math.log(d7);
            }
            double d8 = (d2 -= 2.0) * Polynomial.polevl(d2, dArray2, 5) / Polynomial.p1evl(d2, dArray3, 6);
            return Math.log(d7) + d8;
        }
        if (d2 > 2.556348E305) {
            throw new ArithmeticException("lgamma: Overflow");
        }
        double d9 = (d2 - 0.5) * Math.log(d2) - d2 + 0.9189385332046728;
        if (d2 > 1.0E8) {
            return d9;
        }
        double d10 = 1.0 / (d2 * d2);
        d9 = d2 >= 1000.0 ? (d9 += ((7.936507936507937E-4 * d10 - 0.002777777777777778) * d10 + 0.08333333333333333) / d2) : (d9 += Polynomial.polevl(d10, dArray, 4) / d2);
        return d9;
    }

    static double powerSeries(double d2, double d3, double d4) throws ArithmeticException {
        double d5;
        double d6 = 1.0 / d2;
        double d7 = (1.0 - d3) * d4;
        double d8 = d5 = d7 / (d2 + 1.0);
        double d9 = d7;
        double d10 = 2.0;
        double d11 = 0.0;
        double d12 = (double)1.110223E-16f * d6;
        while (Math.abs(d5) > d12) {
            d7 = (d10 - d3) * d4 / d10;
            d5 = (d9 *= d7) / (d2 + d10);
            d11 += d5;
            d10 += 1.0;
        }
        d11 += d8;
        d11 += d6;
        d7 = d2 * Math.log(d4);
        if (d2 + d3 < 171.6243769563027 && Math.abs(d7) < 709.782712893384) {
            d9 = Gamma.gamma(d2 + d3) / (Gamma.gamma(d2) * Gamma.gamma(d3));
            d11 = d11 * d9 * Math.pow(d4, d2);
        } else {
            d9 = Gamma.logGamma(d2 + d3) - Gamma.logGamma(d2) - Gamma.logGamma(d3) + d7 + Math.log(d11);
            d11 = d9 < -745.1332191019412 ? 0.0 : Math.exp(d9);
        }
        return d11;
    }

    static double stirlingFormula(double d2) throws ArithmeticException {
        double[] dArray = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double d3 = 143.01608;
        double d4 = 1.0 / d2;
        double d5 = Math.exp(d2);
        d4 = 1.0 + d4 * Polynomial.polevl(d4, dArray, 4);
        if (d2 > d3) {
            double d6 = Math.pow(d2, 0.5 * d2 - 0.25);
            d5 = d6 * (d6 / d5);
        } else {
            d5 = Math.pow(d2, d2 - 0.5) / d5;
        }
        d5 = 2.5066282746310007 * d5 * d4;
        return d5;
    }
}

