/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TraceOutputStream
extends FilterOutputStream {
    private boolean trace = false;
    private boolean quote = false;
    private OutputStream traceOut;

    public TraceOutputStream(OutputStream out, OutputStream traceOut) {
        super(out);
        this.traceOut = traceOut;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setQuote(boolean quote) {
        this.quote = quote;
    }

    public void write(int b2) throws IOException {
        if (this.trace) {
            if (this.quote) {
                this.writeByte(b2);
            } else {
                this.traceOut.write(b2);
            }
        }
        this.out.write(b2);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.trace) {
            if (this.quote) {
                for (int i = 0; i < len; ++i) {
                    this.writeByte(b2[off + i]);
                }
            } else {
                this.traceOut.write(b2, off, len);
            }
        }
        this.out.write(b2, off, len);
    }

    private final void writeByte(int b2) throws IOException {
        if ((b2 &= 0xFF) > 127) {
            this.traceOut.write(77);
            this.traceOut.write(45);
            b2 &= 0x7F;
        }
        if (b2 == 13) {
            this.traceOut.write(92);
            this.traceOut.write(114);
        } else if (b2 == 10) {
            this.traceOut.write(92);
            this.traceOut.write(110);
            this.traceOut.write(10);
        } else if (b2 == 9) {
            this.traceOut.write(92);
            this.traceOut.write(116);
        } else if (b2 < 32) {
            this.traceOut.write(94);
            this.traceOut.write(64 + b2);
        } else {
            this.traceOut.write(b2);
        }
    }
}

