/*
 * Decompiled with CFR 0.152.
 */
package jal.Object;

import jal.Object.BinaryOperator;
import jal.Object.BinaryPredicate;
import jal.Object.Generator;
import jal.Object.Inspection;
import jal.Object.Predicate;
import jal.Object.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3) {
        if (n2 > n) {
            System.arraycopy(objectArray, n, objectArray2, n3, n2 - n);
        }
    }

    public static void swap_ranges(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3) {
        while (n < n2) {
            Object object = objectArray2[n3];
            objectArray2[n3] = objectArray[n];
            objectArray[n] = object;
            ++n;
            ++n3;
        }
    }

    public static void transform(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, UnaryOperator unaryOperator) {
        while (n < n2) {
            objectArray2[n3++] = unaryOperator.apply(objectArray[n++]);
        }
    }

    public static void transform(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, int n, int n2, int n3, int n4, BinaryOperator binaryOperator) {
        while (n < n2) {
            objectArray3[n4++] = binaryOperator.apply(objectArray[n++], objectArray2[n3++]);
        }
    }

    public static void replace(Object[] objectArray, int n, int n2, Object object, Object object2) {
        while (n < n2) {
            if (objectArray[n] == object) {
                objectArray[n] = object2;
            }
            ++n;
        }
    }

    public static void replace_if(Object[] objectArray, int n, int n2, Predicate predicate, Object object) {
        while (n < n2) {
            if (predicate.apply(objectArray[n])) {
                objectArray[n] = object;
            }
            ++n;
        }
    }

    public static void replace_copy(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, Object object, Object object2) {
        while (n < n2) {
            Object object3 = objectArray[n++];
            Object object4 = objectArray2[n3++] = object3 == object ? object2 : object3;
        }
    }

    public static void replace_copy_if(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, Predicate predicate, Object object) {
        while (n < n2) {
            Object object2 = objectArray[n++];
            Object object3 = objectArray2[n3++] = predicate.apply(object2) ? object : object2;
        }
    }

    public static void fill(Object[] objectArray, int n, int n2, Object object) {
        while (n < n2) {
            objectArray[n++] = object;
        }
    }

    public static void generate(Object[] objectArray, int n, int n2, Generator generator) {
        while (n < n2) {
            objectArray[n++] = generator.apply();
        }
    }

    public static int remove_if(Object[] objectArray, int n, int n2, Object object) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && objectArray[n] != object) {
                continue;
            }
            while (n < --n2 && objectArray[n2] == object) {
            }
            if (n >= n2) {
                return n;
            }
            objectArray[n] = objectArray[n2];
        }
    }

    public static int remove_if(Object[] objectArray, int n, int n2, Predicate predicate) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && !predicate.apply(objectArray[n])) {
                continue;
            }
            while (n < --n2 && predicate.apply(objectArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            objectArray[n] = objectArray[n2];
        }
    }

    public static int stable_remove(Object[] objectArray, int n, int n2, Object object) {
        n = Inspection.find(objectArray, n, n2, object);
        int n3 = Inspection.find_not(objectArray, n, n2, object);
        while (n3 < n2) {
            objectArray[n++] = objectArray[n3];
            ++n3;
            n3 = Inspection.find_not(objectArray, n3, n2, object);
        }
        return n;
    }

    public static int stable_remove_if(Object[] objectArray, int n, int n2, Predicate predicate) {
        n = Inspection.find_if(objectArray, n, n2, predicate);
        int n3 = Inspection.find_if_not(objectArray, n, n2, predicate);
        while (n3 < n2) {
            objectArray[n++] = objectArray[n3];
            ++n3;
            n3 = Inspection.find_if_not(objectArray, n3, n2, predicate);
        }
        return n;
    }

    public static int remove_copy(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, Object object) {
        while (n < n2) {
            Object object2;
            if ((object2 = objectArray[n++]) == object) continue;
            objectArray2[n3++] = object2;
        }
        return n3;
    }

    public static int remove_copy_if(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, Predicate predicate) {
        while (n < n2) {
            Object object;
            if (predicate.apply(object = objectArray[n++])) continue;
            objectArray2[n3++] = object;
        }
        return n3;
    }

    public static int unique(Object[] objectArray, int n, int n2) {
        n = Inspection.adjacent_find(objectArray, n, n2);
        return Modification.unique_copy(objectArray, objectArray, n, n2, n);
    }

    public static int unique(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        n = Inspection.adjacent_find(objectArray, n, n2, binaryPredicate);
        return Modification.unique_copy(objectArray, objectArray, n, n2, n, binaryPredicate);
    }

    public static int unique_copy(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3) {
        if (n >= n2) {
            return n3;
        }
        objectArray2[n3] = objectArray[n];
        while (++n < n2) {
            if (objectArray2[n3] == objectArray[n]) continue;
            objectArray2[++n3] = objectArray[n];
        }
        return n3 + 1;
    }

    public static int unique_copy(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n3;
        }
        objectArray2[n3] = objectArray[n];
        while (++n < n2) {
            if (binaryPredicate.apply(objectArray2[n3], objectArray[n])) continue;
            objectArray2[++n3] = objectArray[n];
        }
        return n3 + 1;
    }

    public static void reverse(Object[] objectArray, int n, int n2) {
        while (n < --n2) {
            Object object = objectArray[n];
            objectArray[n++] = objectArray[n2];
            objectArray[n2] = object;
        }
    }

    public static void reverse_copy(Object[] objectArray, int n, int n2, int n3) {
        while (n2 > n) {
            objectArray[n3++] = objectArray[--n2];
        }
    }

    public static void reverse_copy(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3) {
        while (n2 > n) {
            objectArray2[n3++] = objectArray[--n2];
        }
    }

    public static void rotate(Object[] objectArray, int n, int n2, int n3) {
        if (n2 != n && n2 != n3) {
            Modification.reverse(objectArray, n, n2);
            Modification.reverse(objectArray, n2, n3);
            Modification.reverse(objectArray, n, n3);
        }
    }

    public static void rotate_copy(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, int n4) {
        Modification.copy(objectArray, objectArray2, n2, n3, n4);
        Modification.copy(objectArray, objectArray2, n, n2, n4 + (n3 - n2));
    }

    public static void random_shuffle(Object[] objectArray, int n, int n2, Random random) {
        int n3 = n + 1;
        while (n3 < n2) {
            int n4 = Math.abs(random.nextInt()) % (n3 - n + 1);
            Object object = objectArray[n4];
            objectArray[n4] = objectArray[n3];
            objectArray[n3] = object;
            ++n3;
        }
    }

    public static void random_shuffle(Object[] objectArray, int n, int n2) {
        Modification.random_shuffle(objectArray, n, n2, default_RNG);
    }

    public static int partition(Object[] objectArray, int n, int n2, Predicate predicate) {
        --n;
        while (true) {
            if (++n < n2 && predicate.apply(objectArray[n])) {
                continue;
            }
            while (n < --n2 && !predicate.apply(objectArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            Object object = objectArray[n];
            objectArray[n] = objectArray[n2];
            objectArray[n2] = object;
        }
    }

    public static int stable_partition(Object[] objectArray, int n, int n2, Predicate predicate) {
        if (n + 1 < n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = Modification.stable_partition(objectArray, n, n3, predicate);
            int n5 = Modification.stable_partition(objectArray, n3, n2, predicate);
            Modification.rotate(objectArray, n4, n3, n5);
            return n4 + (n5 - n3);
        }
        if (n >= n2 || !predicate.apply(objectArray[n])) {
            return n;
        }
        return n2;
    }

    private Modification() {
    }
}

