/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eso.cpl.CPLException;
import org.eso.cpl.CommandSequence;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.MarkedFrameList;
import org.eso.cpl.NamingScheme;
import org.eso.cpl.Parameter;
import org.eso.cpl.ParameterValueException;
import org.eso.cpl.Recipe;
import org.eso.cpl.RecipeLibrary;
import org.eso.cpl.StateLoader;
import org.eso.cpl.StateSaver;
import org.eso.cpl.jni.JNIRecipe;
import org.eso.cpl.jni.LibraryLoader;

public class Request {
    public static final int UNKNOWN = -1;
    public static final int PENDING = 0;
    public static final int EXECUTING = 1;
    public static final int SUCCESS = 2;
    public static final int FAILURE = 3;
    private final Recipe recipe_;
    private final Parameter[] params_;
    private final MarkedFrameList inFrames_;
    private File productRoot_;
    private NamingScheme namer_;
    private int state = 0;
    private static boolean defaultLogMessages_ = true;
    private boolean logMessages_ = defaultLogMessages_;

    public Request(Recipe recipe, Parameter[] params, MarkedFrameList inFrames, File productRoot, NamingScheme namer) {
        this.recipe_ = recipe;
        this.productRoot_ = productRoot;
        this.namer_ = namer;
        if (recipe != null) {
            this.params_ = this.recipe_.getDefaultParameters();
            int nparam = params.length;
            for (int i = 0; i < nparam; ++i) {
                if (!this.params_[i].getName().equals(params[i].getName())) {
                    throw new IllegalArgumentException("Parameter list mismatch at " + i + ": " + params[i] + " != " + this.params_[i]);
                }
                try {
                    this.params_[i].setValue(params[i].getValue());
                    continue;
                }
                catch (ParameterValueException e2) {
                    throw (IllegalArgumentException)new IllegalArgumentException("Must be a parameter list mismatch").initCause(e2);
                }
            }
        } else {
            this.params_ = null;
        }
        if (inFrames != null) {
            this.inFrames_ = new MarkedFrameList();
            for (Frame frm : inFrames) {
                Frame newFrm = new Frame(frm);
                this.inFrames_.add(newFrm);
                this.inFrames_.setActive(newFrm, inFrames.isActive(frm));
                this.inFrames_.setRetained(newFrm, inFrames.isRetained(frm));
            }
        } else {
            this.inFrames_ = null;
        }
    }

    public Request(Recipe recipe) {
        this(recipe, recipe.getDefaultParameters(), new MarkedFrameList(), null, NamingScheme.DEFAULT);
    }

    public Request(Request req) {
        this(req.getRecipe(), req.getParameters(), req.getInputFrames(), req.getProductRoot(), req.getNamingScheme());
    }

    public Request(InputStream istrm, LibraryLoader libLoader) throws IOException, CPLException, ParameterValueException {
        StateLoader loader = new StateLoader(istrm, libLoader);
        this.recipe_ = loader.getRecipe();
        Parameter[] params = this.recipe_.getDefaultParameters();
        loader.setParameterValues(params);
        this.params_ = params;
        this.inFrames_ = new MarkedFrameList(loader.getInputFrames());
        String proot = loader.getProductRoot();
        this.productRoot_ = proot == null ? null : new File(proot);
        this.namer_ = loader.getNamingScheme();
    }

    public Recipe getRecipe() {
        return this.recipe_;
    }

    public Parameter[] getParameters() {
        return this.params_;
    }

    public MarkedFrameList getInputFrames() {
        return this.inFrames_;
    }

    public File getProductRoot() {
        return this.productRoot_;
    }

    public void setProductRoot(File dir) {
        this.productRoot_ = dir;
    }

    public NamingScheme getNamingScheme() {
        return this.namer_;
    }

    public void setNamingScheme(NamingScheme namer) {
        this.namer_ = namer;
    }

    public void write(OutputStream ostrm) throws IOException {
        new StateSaver(this.recipe_, this.params_, this.inFrames_, this.productRoot_ == null ? null : this.productRoot_.toString(), this.namer_).write(ostrm);
    }

    public void appendToScript(CommandSequence script) {
        File file;
        String loc;
        if (!(this.recipe_ instanceof JNIRecipe)) {
            throw new IllegalStateException("No JNI recipe");
        }
        script.blankLine();
        String recipeName = this.recipe_.getName();
        String libdir = null;
        RecipeLibrary lib = this.recipe_.getLibrary();
        if (lib != null && (loc = lib.getLocation()) != null && (file = new File(loc)).exists()) {
            File dir = file.isDirectory() ? file : file.getParentFile();
            libdir = dir.toString();
        }
        String proot = null;
        if (this.productRoot_ != null && this.productRoot_.toString().trim().length() > 0) {
            proot = this.productRoot_.toString();
        }
        ArrayList<String> cplParams = new ArrayList<String>();
        if (libdir != null) {
            cplParams.add("--plugin-dir=" + script.quoteWord(libdir));
        }
        if (proot != null) {
            cplParams.add("--output-dir=" + script.quoteWord(proot));
        }
        script.defineMacro("cpl_params", cplParams);
        ArrayList<String> recParams = new ArrayList<String>();
        String paramMacro = recipeName + "_params";
        for (int i = 0; i < this.params_.length; ++i) {
            Parameter param = this.params_[i];
            String pname = param.getName();
            String pval = param.getValue().toString();
            recParams.add("--" + pname + "=" + script.quoteWord(pval));
        }
        script.defineMacro(paramMacro, recParams);
        ArrayList<String> calibFrames = new ArrayList<String>();
        ArrayList<String> rawFrames = new ArrayList<String>();
        for (Frame frm : this.inFrames_.selectActive()) {
            FrameGroup grp = frm.getGroup();
            if (grp == FrameGroup.RAW) {
                rawFrames.add(script.quoteWord(frm.getFile().toString()));
                continue;
            }
            if (grp != FrameGroup.CALIB) continue;
            calibFrames.add(script.quoteWord(frm.getFile().toString()));
        }
        script.defineMacro("raw_frames", rawFrames);
        script.defineMacro("calib_frames", calibFrames);
        script.invokeCommand("cplexec " + script.useMacro("cpl_params") + " " + recipeName + " " + script.useMacro("calib_frames") + " " + script.useMacro("raw_frames") + " " + script.useMacro(paramMacro));
    }

    public String toReportString() {
        File file;
        String loc;
        StringBuffer rc = new StringBuffer();
        rc.append("Recipe: " + this.recipe_.getName() + "\n");
        String libdir = null;
        RecipeLibrary lib = this.recipe_.getLibrary();
        if (lib != null && (loc = lib.getLocation()) != null && (file = new File(loc)).exists()) {
            File dir = file.isDirectory() ? file : file.getParentFile();
            libdir = dir.toString();
        }
        String proot = null;
        if (this.productRoot_ != null && this.productRoot_.toString().trim().length() > 0) {
            proot = this.productRoot_.toString();
        }
        if (libdir != null) {
            rc.append("Recipe location: " + libdir + "\n");
        }
        if (proot != null) {
            rc.append("Output directory: " + proot + "\n");
        }
        rc.append("Parameters:\n");
        for (int i = 0; i < this.params_.length; ++i) {
            Parameter param = this.params_[i];
            String pname = param.getName();
            String pval = param.getValue().toString();
            rc.append("  " + pname + "=" + pval + "\n");
        }
        rc.append("Input Frames:\n");
        Iterator it = this.inFrames_.selectActive().iterator();
        while (it.hasNext()) {
            rc.append("  " + ((Frame)it.next()).toString() + "\n");
        }
        return rc.toString();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }
}

