/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class LogArea
extends JTextPane {
    private StyledDocument doc_ = this.getStyledDocument();
    public static final String MESSAGE_STYLE = "message";
    public static final String ERROR_STYLE = "error";
    public static final String COMMAND_STYLE = "command";
    public static final String CONTROL_STYLE = "control";

    public LogArea() {
        this.setEditable(false);
        Style defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        this.makeStyle(CONTROL_STYLE, defStyle, new Color(139, 35, 35));
        this.makeStyle(MESSAGE_STYLE, defStyle, Color.black);
        this.makeStyle(ERROR_STYLE, defStyle, Color.red);
        this.makeStyle(COMMAND_STYLE, defStyle, Color.blue);
    }

    private void makeStyle(String name, Style base, Color color) {
        Style style = this.addStyle(name, base);
        StyleConstants.setForeground(style, color);
    }

    public void clear() {
        try {
            this.doc_.remove(0, this.doc_.getLength());
        }
        catch (BadLocationException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    public void append(String string, String styleName) {
        try {
            this.doc_.insertString(this.doc_.getLength(), string, this.getStyle(styleName));
        }
        catch (BadLocationException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    public void appendMessage(String text) {
        this.append(text, MESSAGE_STYLE);
    }

    public void appendError(String text) {
        this.append(text, ERROR_STYLE);
    }

    public void appendCommand(String text) {
        this.append(text, COMMAND_STYLE);
    }

    public void appendControl(String text) {
        this.append(text, CONTROL_STYLE);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }
}

