/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.test;

import java.io.PrintStream;
import java.util.Iterator;
import org.eso.cpl.CPLException;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameList;
import org.eso.cpl.Parameter;
import org.eso.cpl.Recipe;

public class CPLDebug {
    PrintStream out_ = System.out;

    public void log(String str) {
        this.out_.println(str);
    }

    public FrameList executeWithLogging(Recipe recipe, Parameter[] params, FrameList inFrames) throws CPLException {
        this.out_.println();
        this.out_.println("RECIPE:");
        this.logRecipe(recipe);
        this.out_.println("PARAMETERS:");
        this.logParameters(params);
        this.out_.println("INPUT FRAMES:");
        this.logFrames(inFrames);
        FrameList outFrames = recipe.execute(params, inFrames, null);
        this.out_.println("OUTPUT FRAMES:");
        this.logFrames(outFrames);
        return outFrames;
    }

    public void logRecipe(Recipe recipe) {
        this.out_.println(recipe);
    }

    public void logParameter(Parameter param) {
        this.out_.println(param);
    }

    public void logFrame(Frame frame) {
        this.out_.println(frame);
    }

    public void logParameters(Parameter[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.logParameter(params[i]);
        }
    }

    public void logFrames(FrameList frames) {
        Iterator it = frames.iterator();
        while (it.hasNext()) {
            this.logFrame((Frame)it.next());
        }
    }

    public void logFrames(Frame[] frames) {
        this.logFrames(new FrameList(frames));
    }
}

