/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.eso.gasgano.gui.DBDisplayPanel;
import org.eso.gasgano.gui.DBPanel;
import org.eso.gasgano.gui.DataPanel;
import org.eso.gasgano.gui.DisplayPanel;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.gasgano.gui.PropertyEditorSubPanel;
import org.eso.gasgano.gui.RecipePropertyPanel;
import org.eso.gasgano.properties.GasProp;

public class GasPropEditor
extends JFrame
implements ActionListener {
    private static final int UserCancelled = -1;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private boolean debug = false;
    private PropertyEditorSubPanel[] panels;
    private DataPanel dataPanel;
    private ReclassificationListener reclassificationListener;
    public GasProp gpCopy;

    public GasPropEditor() {
        super("Preferences Editor");
        JPanel buttonPanel = new JPanel();
        JTabbedPane jtp = new JTabbedPane(1);
        this.gpCopy = new GasProp(GasProp.getProperties());
        this.panels = new PropertyEditorSubPanel[5];
        this.dataPanel = new DataPanel(this.gpCopy);
        this.panels[0] = this.dataPanel;
        this.panels[1] = new DisplayPanel(this.gpCopy);
        this.panels[2] = new RecipePropertyPanel(this.gpCopy);
        this.panels[3] = new DBDisplayPanel(this.gpCopy);
        this.panels[4] = new DBPanel(this.gpCopy);
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i].setDebug(this.debug);
        }
        jtp.setBorder(new EmptyBorder(3, 3, 3, 3));
        jtp.addTab("Data", null, this.panels[0], "File set, Filesystem settings, Verbose level");
        jtp.addTab("File Display & Grouping", null, this.panels[1], "Display options, Grouping, External Viewers, Fonts, Printing");
        jtp.addTab("Recipe Configuration", null, this.panels[2], "Configure the set of recipes available.");
        if (GasProp.isEnvironmentSafe()) {
            jtp.addTab("Database Display", null, this.panels[3], "Database display options, Custom pulldown menus");
            jtp.addTab("Databases", null, this.panels[4], "Database access parameters for Observations and OB Status");
        }
        jtp.setSelectedIndex(0);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jtp, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                GasPropEditor.this.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocation(100, 300);
    }

    public void loadProperties() {
        this.gpCopy = new GasProp(GasProp.getProperties());
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i].loadProperties(this.gpCopy);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.okButton) {
            int i;
            int response = 0;
            boolean shutdown = false;
            boolean reload = false;
            for (i = 0; i < this.panels.length; ++i) {
                int action = this.panels[i].restartRequired();
                if (action == 1) {
                    reload = true;
                }
                if (action == 2) {
                    shutdown = true;
                }
                if (response >= action) continue;
                response = action;
            }
            if (response == 1) {
                if (JOptionPane.showConfirmDialog(this, "These changes require reloading the data set.\nOK to continue?", "Data Reload Required", 2) != 0) {
                    response = -1;
                    shutdown = false;
                    reload = false;
                }
            } else if (response == 2 && JOptionPane.showConfirmDialog(this, "These changes will take effect after Gasgano is restarted.\nOK to continue?", "Restart Required", 2) != 0) {
                response = -1;
                shutdown = false;
                reload = false;
            }
            if (response == -1) {
                return;
            }
            for (i = 0; i < this.panels.length; ++i) {
                String error = this.panels[i].saveProperties();
                if (error == null) continue;
                GUIUtils.userError(this, error);
                this.panels[i].loadProperties(this.gpCopy);
                return;
            }
            this.gpCopy.dumpVectors();
            if (this.debug) {
                System.out.println("will reset the preferences");
            }
            this.setVisible(false);
            GasProp.setProperties(this.gpCopy, reload);
            if (this.dataPanel.isClassificationRequired()) {
                this.reclassificationListener.reclassifyNow();
            }
        } else if (e2.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public void startEditing() {
        this.setVisible(true);
    }

    public static void main(String[] args) {
        GasPropEditor.test1(args);
        GasPropEditor.test2(args);
    }

    private static void test1(String[] args) {
        GasProp gp = new GasProp();
        if (args.length == 1 && !gp.loadProperties(args[0])) {
            System.out.println("failed to load " + args[0] + " properties file");
        }
        GasProp gp2 = new GasProp(gp);
        GasPropEditor pe = new GasPropEditor();
        pe.loadProperties();
        pe.startEditing();
    }

    private static void test2(String[] args) {
        GasProp gp = new GasProp();
        if (args.length == 1 && !gp.loadProperties(args[0])) {
            System.out.println("failed to load " + args[0] + " properties file");
        }
        GasProp gp2 = new GasProp(gp);
        gp2.instruments.setElementAt("CAZZO", 0);
        System.out.println(gp2.instruments.elementAt(0));
        System.out.println(gp.instruments.elementAt(0));
        if (gp2.getProperty("INSTRUMENT_GROUPING") == gp.getProperty("INSTRUMENT_GROUPING")) {
            System.out.println("the two properties are the same object");
        }
        if (gp2.instruments.elementAt(0) == gp.instruments.elementAt(0)) {
            System.out.println("I did something very, very wrong (instruments)");
        }
        if (gp2.instrumentGrouping.elementAt(0) == gp.instrumentGrouping.elementAt(0)) {
            System.out.println("I did something very very wrong");
        }
        System.exit(0);
        System.out.println(gp.getProperty("OB_STATUS_FROM_DB_REQUIRED"));
        GasPropEditor pe = new GasPropEditor();
        while (true) {
            pe.loadProperties();
            pe.startEditing();
        }
    }

    public void setReclassificationListener(ReclassificationListener reclassificationListener) {
        this.reclassificationListener = reclassificationListener;
    }

    public static interface ReclassificationListener {
        public void reclassifyNow();
    }
}

