/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.eso.dfs.gui.SwingFileChooser;
import org.eso.gasgano.datamodel.DataModelChangeListener;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.ReductionBlockCommon;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.filesystem.DFSFile;
import org.eso.gasgano.datamodel.gui.DFSTextFileDisplay;
import org.eso.gasgano.datamodel.gui.FitsFileOBComponent;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.properties.PropertyDB;

public class VirtualReductionBlockOBComponent
extends OBComponent
implements ReductionBlockCommon,
DataModelChangeListener {
    private Vector rawFiles = null;
    private Vector masterCalibFiles = null;
    private Vector masterCalibSignatures = null;
    private Vector masterCalibNames;
    private Vector masterCalibResolvedNames = null;
    private Vector productFiles = null;
    private String productBaseName = null;
    private DFSDataModel dm = null;
    private StringBuffer vrbData = null;
    private String myInstrument;
    private String myRecipe = null;
    private VRBPanel panelGlob = null;
    private static JFileChooser fileChooser = new SwingFileChooser();
    private static JScrollPane scrollPane = new JScrollPane();

    public VirtualReductionBlockOBComponent(KeywordContainerOBComponent triggerComp) {
        Vector tmpVect = null;
        this.dm = DFSDataModel.getDataModel();
        this.rawFiles = triggerComp.getAssociatedRawFrames();
        tmpVect = triggerComp.getAssociatedMasterInfo();
        this.masterCalibNames = (Vector)tmpVect.elementAt(0);
        this.masterCalibSignatures = (Vector)tmpVect.elementAt(1);
        this.productBaseName = triggerComp.getId();
        this.myInstrument = triggerComp.getInstrument();
        this.myRecipe = triggerComp.getAssociatedRecipeName();
        triggerComp.freeHeaderMemory();
        if (PropertyDB.getInstance().isDebug(1)) {
            System.out.println("Added: new VRB from " + this.productBaseName);
        }
        this.insertInDataModel();
    }

    @Override
    public void dataModelChanged(DataModelEvent e2) {
        if (e2.getEvent() == 0 || e2.getEvent() == 1 || e2.getEvent() == 2) {
            if (PropertyDB.getInstance().isDebug(6)) {
                System.out.println(this.productBaseName + " received dataModelChangeEvent.");
            }
            this.insertInDataModel();
        }
    }

    private void insertInDataModel() {
        Enumeration e2;
        Vector dataSourceSet = null;
        OBComponent dataSource = null;
        dataSourceSet = this.dm.getObComponentByBaseName(DFSFile.extractBaseName(this.productBaseName));
        if (dataSourceSet != null && !dataSourceSet.isEmpty()) {
            e2 = dataSourceSet.elements();
            while (dataSource == null && e2.hasMoreElements()) {
                dataSource = (OBComponent)e2.nextElement();
                if (dataSource == null || dataSource instanceof FitsFileOBComponent) continue;
                dataSource = null;
            }
        } else {
            Enumeration e3;
            Vector tmpSet;
            this.dm.removeAssociatedVRB(DFSFile.extractBaseName(this.productBaseName));
            if (PropertyDB.getInstance().isDebug(1)) {
                System.out.println("Deleting: VRB from " + this.productBaseName);
            }
            if ((tmpSet = this.getInputFileNames()) != null && !tmpSet.isEmpty()) {
                e3 = tmpSet.elements();
                while (e3.hasMoreElements()) {
                    String compName = (String)e3.nextElement();
                    OBComponent obc = this.dm.getObComponentByName(compName);
                    if (obc == null) continue;
                    obc.removeAssociatedReductionBlock(this);
                }
            }
            if ((dataSourceSet = this.masterCalibSignatures) != null && !dataSourceSet.isEmpty()) {
                e3 = dataSourceSet.elements();
                while (e3.hasMoreElements()) {
                    OBComponent obc = this.dm.getObComponentBySignature((String)e3.nextElement());
                    if (obc == null) continue;
                    obc.removeAssociatedReductionBlock(this);
                }
            }
            this.dm.removeDataModelChangeListener(this);
            return;
        }
        this.productFiles = new Vector();
        if (dataSourceSet != null && !dataSourceSet.isEmpty()) {
            e2 = dataSourceSet.elements();
            while (e2.hasMoreElements()) {
                OBComponent obc = (OBComponent)e2.nextElement();
                if (obc == null || !obc.isPipeProduct()) continue;
                obc.addAssociatedReductionBlock(this);
                this.productFiles.addElement(obc.getId());
            }
        }
        if ((dataSourceSet = this.getInputFileNames()) != null && !dataSourceSet.isEmpty()) {
            e2 = dataSourceSet.elements();
            while (e2.hasMoreElements()) {
                String compName = (String)e2.nextElement();
                OBComponent obc = this.dm.getObComponentByFilesystemBaseName(compName);
                if (obc == null) continue;
                obc.addAssociatedReductionBlock(this);
                dataSourceSet.setElementAt(obc.getId(), dataSourceSet.indexOf(compName));
            }
        }
        this.masterCalibFiles = new Vector();
        this.masterCalibResolvedNames = new Vector(this.masterCalibNames.size());
        dataSourceSet = this.masterCalibSignatures;
        for (int i = 0; i < this.masterCalibNames.size(); ++i) {
            OBComponent obcn = null;
            String md5Sig = null;
            String name = (String)this.masterCalibNames.elementAt(i);
            md5Sig = (String)this.masterCalibSignatures.elementAt(i);
            OBComponent obcs = this.dm.getObComponentBySignature(md5Sig);
            if (obcs != null) {
                obcs.addAssociatedReductionBlock(this);
                this.masterCalibFiles.addElement(obcs.getId());
            }
            if ((obcn = this.dm.getObComponentByFilesystemBaseName(name)) != null && obcn == obcs) {
                this.masterCalibResolvedNames.addElement(obcn.getId());
                continue;
            }
            if (obcs != null && obcs.getSourceFile().getFileName().equals(name)) {
                this.masterCalibResolvedNames.addElement(obcs.getId());
                continue;
            }
            this.masterCalibResolvedNames.addElement(name);
        }
    }

    @Override
    public Vector getProductFileNames() {
        return this.productFiles;
    }

    @Override
    public Vector getInputFileNames() {
        return this.rawFiles;
    }

    @Override
    public Vector getMasterCalibFileNames() {
        return this.masterCalibFiles;
    }

    @Override
    public String getId() {
        return "Virtual Reduction Block: (" + DFSFile.extractBaseName(this.productBaseName) + ")";
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public DFSFile getSourceFile() {
        return null;
    }

    @Override
    public int update() {
        return 1;
    }

    @Override
    public JComponent getDisplayComponent() {
        String classification;
        String compName;
        JScrollPane rc = null;
        this.vrbData = new StringBuffer();
        Enumeration e2 = null;
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.vrbData.append("recipe: " + this.myRecipe + "\n\n");
        this.vrbData.append("instrument: " + this.myInstrument + "\n");
        this.vrbData.append("\n");
        this.vrbData.append(this.productBaseName.substring(0, this.productBaseName.lastIndexOf(File.separatorChar) + 1) + DFSFile.extractBaseName(this.productBaseName) + "\n\n");
        this.vrbData.append("{\n");
        e2 = this.getInputFileNames().elements();
        while (e2.hasMoreElements()) {
            compName = (String)e2.nextElement();
            classification = "";
            if (this.dm.getObComponentByName(compName) instanceof KeywordContainerOBComponent) {
                classification = ((KeywordContainerOBComponent)this.dm.getObComponentByName(compName)).getClassification();
            }
            this.vrbData.append(compName + " " + classification + "\n");
        }
        this.vrbData.append("}");
        this.vrbData.append("\n\n");
        this.vrbData.append("{\n");
        e2 = this.masterCalibResolvedNames.elements();
        while (e2.hasMoreElements()) {
            compName = (String)e2.nextElement();
            classification = "";
            if (this.dm.getObComponentByName(compName) instanceof KeywordContainerOBComponent) {
                classification = ((KeywordContainerOBComponent)this.dm.getObComponentByName(compName)).getClassification();
            }
            this.vrbData.append(compName + " " + classification + "\n");
        }
        this.vrbData.append("}");
        this.panelGlob = new VRBPanel(this.getId(), this.vrbData.toString());
        scrollPane.setViewportView(this.panelGlob);
        rc = scrollPane;
        return rc;
    }

    @Override
    public JComponent getTreeCellComponent() {
        return new JLabel("PIPPO");
    }

    private boolean saveFile(File checkFile) {
        FileWriter fileOutputStream = null;
        String fileName = checkFile.getName();
        if (checkFile.exists() && checkFile.canWrite() && JOptionPane.showConfirmDialog(this.panelGlob, "The target file " + fileName + " exists, overwrite ?", "write VRB to file", 2) != 0) {
            return false;
        }
        if (checkFile.exists() && !checkFile.canWrite()) {
            JOptionPane.showMessageDialog(this.panelGlob, "The target file " + fileName + " exists and is write protected\n");
            return false;
        }
        try {
            fileOutputStream = new FileWriter(checkFile.getAbsolutePath());
            fileOutputStream.write(this.vrbData.toString(), 0, this.vrbData.length());
            fileOutputStream.close();
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    private class VRBPanel
    extends JPanel
    implements ActionListener {
        JButton dumpToFile;
        JPanel tmpPanel;
        JPanel tmpPanel2;
        String saveLabel;

        public VRBPanel(String title, String data) {
            super(new BorderLayout());
            this.dumpToFile = null;
            this.tmpPanel2 = null;
            this.saveLabel = "save to file";
            this.dumpToFile = new JButton(this.saveLabel);
            this.dumpToFile.setPreferredSize(new Dimension(130, 30));
            this.dumpToFile.addActionListener(this);
            this.tmpPanel = new JPanel(new GridLayout(8, 1));
            this.tmpPanel.add(new JLabel(""));
            this.tmpPanel.add(this.dumpToFile);
            this.tmpPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.tmpPanel2 = new JPanel(new BorderLayout());
            this.add((Component)new DFSTextFileDisplay(title, data), "Center");
            this.add((Component)this.tmpPanel, "East");
        }

        @Override
        public void actionPerformed(ActionEvent a2) {
            if (a2.getActionCommand() == this.saveLabel) {
                String fileName = "VRB-" + DFSFile.extractBaseName(VirtualReductionBlockOBComponent.this.productBaseName) + ".rb";
                fileChooser.setDialogTitle("save virtual reduction block to a file");
                fileChooser.setApproveButtonText("save");
                fileChooser.setSelectedFile(new File(fileName));
                fileChooser.setMultiSelectionEnabled(false);
                if (fileChooser.showOpenDialog(this) == 0 && fileChooser.getSelectedFile() != null) {
                    VirtualReductionBlockOBComponent.this.saveFile(fileChooser.getSelectedFile());
                }
            }
        }
    }
}

