/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.datatransfer;

import java.io.IOException;
import java.util.Calendar;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eso.util.datatransfer.StreamConsumer;

public class ShellCommand {
    static Logger logger = Logger.getLogger(ShellCommand.class);
    String command = null;
    String output = null;
    String error = null;
    int exitStatus = 0;
    static final String thisClass = "ShellCommand";

    protected ShellCommand() {
    }

    public ShellCommand(String command) {
        String thisMethod = "ShellCommand::Command()";
        logger.trace(thisMethod);
        if (command == null) {
            String message = thisMethod + " - command must not be null.";
            throw new IllegalArgumentException(message);
        }
        this.command = command;
    }

    public int exec() throws InterruptedException, IOException {
        Process proc;
        String thisMethod = "ShellCommand::exec()";
        logger.trace(thisMethod);
        Runtime rt = Runtime.getRuntime();
        try {
            logger.debug(this.command);
            proc = rt.exec(this.command);
        }
        catch (IOException e2) {
            this.exitStatus = -1;
            logger.error(e2.getMessage());
            throw e2;
        }
        StreamConsumer errorConsumer = new StreamConsumer(proc.getErrorStream());
        StreamConsumer outputConsumer = new StreamConsumer(proc.getInputStream());
        errorConsumer.start();
        outputConsumer.start();
        try {
            this.exitStatus = proc.waitFor();
        }
        catch (InterruptedException e3) {
            this.exitStatus = -1;
            logger.error(e3.getMessage());
            throw e3;
        }
        this.output = outputConsumer.toString();
        this.error = errorConsumer.toString();
        proc.destroy();
        return this.exitStatus;
    }

    public synchronized String getCommand() {
        return this.command;
    }

    protected synchronized void setCommand(String c2) {
        this.command = c2;
    }

    public synchronized String getError() {
        return this.error;
    }

    public synchronized int getExitStatus() {
        return this.exitStatus;
    }

    public synchronized String getOutput() {
        return this.output;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        long objectCount = 10000000L;
        long startTime = Calendar.getInstance().getTimeInMillis();
        int i = 0;
        while ((long)i < objectCount) {
            ShellCommand sc = new ShellCommand("dummy");
            ++i;
        }
        long elapsedTime = Calendar.getInstance().getTimeInMillis() - startTime;
        double timeToCreateOneObject = (double)elapsedTime / (double)objectCount;
        logger.debug("Created " + objectCount + " objects in " + elapsedTime + " ms");
        logger.debug("timeToCreateOneObject: " + timeToCreateOneObject + " ms");
        String goodOne = "cmd.exe /C dir";
        String badOne = "cmd.exe /C dira";
        ShellCommand goodCmd = new ShellCommand(goodOne);
        ShellCommand badCmd = new ShellCommand(badOne);
        try {
            if (goodCmd.exec() == 0) {
                logger.debug("Command '" + goodOne + "' succeeded.");
                logger.debug(goodCmd.getOutput());
            } else {
                logger.debug("Command '" + goodOne + "' failed.");
                logger.debug(goodCmd.getError());
            }
            if (badCmd.exec() == 0) {
                logger.debug("Command '" + badOne + "' succeeded.");
                logger.debug(badCmd.getOutput());
            } else {
                logger.debug("Command '" + badOne + "' failed.");
                logger.debug(badCmd.getError());
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (InterruptedException e3) {
            e3.printStackTrace();
        }
    }
}

