// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A mapping applied to the authenticating end-entity certificate.
type AttributeMapping struct {

	// Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
	CertificateField CertificateField

	// A list of mapping entries for every supported specifier or sub-field.
	MappingRules []MappingRule

	noSmithyDocumentSerde
}

// A record of a presented X509 credential from a temporary credential request.
type CredentialSummary struct {

	// Indicates whether the credential is enabled.
	Enabled *bool

	// Indicates whether the temporary credential request was successful.
	Failed *bool

	// The fully qualified domain name of the issuing certificate for the presented
	// end-entity certificate.
	Issuer *string

	// The ISO-8601 time stamp of when the certificate was last used in a temporary
	// credential request.
	SeenAt *time.Time

	// The serial number of the certificate.
	SerialNumber *string

	// The PEM-encoded data of the certificate.
	X509CertificateData *string

	noSmithyDocumentSerde
}

// The state of the certificate revocation list (CRL) after a read or write
// operation.
type CrlDetail struct {

	// The ISO-8601 timestamp when the certificate revocation list (CRL) was created.
	CreatedAt *time.Time

	// The ARN of the certificate revocation list (CRL).
	CrlArn *string

	// The state of the certificate revocation list (CRL) after a read or write
	// operation.
	CrlData []byte

	// The unique identifier of the certificate revocation list (CRL).
	CrlId *string

	// Indicates whether the certificate revocation list (CRL) is enabled.
	Enabled *bool

	// The name of the certificate revocation list (CRL).
	Name *string

	// The ARN of the TrustAnchor the certificate revocation list (CRL) will provide
	// revocation for.
	TrustAnchorArn *string

	// The ISO-8601 timestamp when the certificate revocation list (CRL) was last
	// updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// A key-value pair you set that identifies a property of the authenticating
// instance.
type InstanceProperty struct {

	// Indicates whether the temporary credential request was successful.
	Failed *bool

	// A list of instanceProperty objects.
	Properties map[string]string

	// The ISO-8601 time stamp of when the certificate was last used in a temporary
	// credential request.
	SeenAt *time.Time

	noSmithyDocumentSerde
}

// A single mapping entry for each supported specifier or sub-field.
type MappingRule struct {

	// Specifier within a certificate field, such as CN, OU, or UID from the Subject
	// field.
	//
	// This member is required.
	Specifier *string

	noSmithyDocumentSerde
}

//	Customizable notification settings that will be applied to notification
//
// events. IAM Roles Anywhere consumes these settings while notifying across
// multiple channels - CloudWatch metrics, EventBridge, and Health Dashboard.
type NotificationSetting struct {

	// Indicates whether the notification setting is enabled.
	//
	// This member is required.
	Enabled *bool

	// The event to which this notification setting is applied.
	//
	// This member is required.
	Event NotificationEvent

	// The specified channel of notification. IAM Roles Anywhere uses CloudWatch
	// metrics, EventBridge, and Health Dashboard to notify for an event.
	//
	// In the absence of a specific channel, IAM Roles Anywhere applies this setting
	// to 'ALL' channels.
	Channel NotificationChannel

	// The number of days before a notification event. This value is required for a
	// notification setting that is enabled.
	Threshold *int32

	noSmithyDocumentSerde
}

// The state of a notification setting.
//
// A notification setting includes information such as event name, threshold,
// status of the notification setting, and the channel to notify.
type NotificationSettingDetail struct {

	// Indicates whether the notification setting is enabled.
	//
	// This member is required.
	Enabled *bool

	// The event to which this notification setting is applied.
	//
	// This member is required.
	Event NotificationEvent

	// The specified channel of notification. IAM Roles Anywhere uses CloudWatch
	// metrics, EventBridge, and Health Dashboard to notify for an event.
	//
	// In the absence of a specific channel, IAM Roles Anywhere applies this setting
	// to 'ALL' channels.
	Channel NotificationChannel

	// The principal that configured the notification setting. For default settings
	// configured by IAM Roles Anywhere, the value is rolesanywhere.amazonaws.com , and
	// for customized notifications settings, it is the respective account ID.
	ConfiguredBy *string

	// The number of days before a notification event.
	Threshold *int32

	noSmithyDocumentSerde
}

// A notification setting key to reset. A notification setting key includes the
// event and the channel.
type NotificationSettingKey struct {

	// The notification setting event to reset.
	//
	// This member is required.
	Event NotificationEvent

	// The specified channel of notification.
	Channel NotificationChannel

	noSmithyDocumentSerde
}

// The state of the profile after a read or write operation.
type ProfileDetail struct {

	// Used to determine if a custom role session name will be accepted in a temporary
	// credential request.
	AcceptRoleSessionName *bool

	// A mapping applied to the authenticating end-entity certificate.
	AttributeMappings []AttributeMapping

	// The ISO-8601 timestamp when the profile was created.
	CreatedAt *time.Time

	// The Amazon Web Services account that created the profile.
	CreatedBy *string

	//  Used to determine how long sessions vended using this profile are valid for.
	// See the Expiration section of the [CreateSession API documentation] page for more details. In requests, if this
	// value is not provided, the default value will be 3600.
	//
	// [CreateSession API documentation]: https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object
	DurationSeconds *int32

	// Indicates whether the profile is enabled.
	Enabled *bool

	// A list of managed policy ARNs that apply to the vended session credentials.
	ManagedPolicyArns []string

	// The name of the profile.
	Name *string

	// The ARN of the profile.
	ProfileArn *string

	// The unique identifier of the profile.
	ProfileId *string

	// Specifies whether instance properties are required in temporary credential
	// requests with this profile.
	RequireInstanceProperties *bool

	// A list of IAM roles that this profile can assume in a temporary credential
	// request.
	RoleArns []string

	// A session policy that applies to the trust boundary of the vended session
	// credentials.
	SessionPolicy *string

	// The ISO-8601 timestamp when the profile was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The trust anchor type and its related certificate data.
type Source struct {

	// The data field of the trust anchor depending on its type.
	SourceData SourceData

	// The type of the trust anchor.
	SourceType TrustAnchorType

	noSmithyDocumentSerde
}

// The data field of the trust anchor depending on its type.
//
// The following types satisfy this interface:
//
//	SourceDataMemberAcmPcaArn
//	SourceDataMemberX509CertificateData
type SourceData interface {
	isSourceData()
}

//	The root certificate of the Private Certificate Authority specified by this
//
// ARN is used in trust validation for temporary credential requests. Included for
// trust anchors of type AWS_ACM_PCA .
type SourceDataMemberAcmPcaArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*SourceDataMemberAcmPcaArn) isSourceData() {}

// The PEM-encoded data for the certificate anchor. Included for trust anchors of
// type CERTIFICATE_BUNDLE .
type SourceDataMemberX509CertificateData struct {
	Value string

	noSmithyDocumentSerde
}

func (*SourceDataMemberX509CertificateData) isSourceData() {}

// The state of the subject after a read or write operation.
type SubjectDetail struct {

	// The ISO-8601 timestamp when the subject was created.
	CreatedAt *time.Time

	// The temporary session credentials vended at the last authenticating call with
	// this subject.
	Credentials []CredentialSummary

	// The enabled status of the subject.
	Enabled *bool

	// The specified instance properties associated with the request.
	InstanceProperties []InstanceProperty

	// The ISO-8601 timestamp of the last time this subject requested temporary
	// session credentials.
	LastSeenAt *time.Time

	// The ARN of the resource.
	SubjectArn *string

	// The id of the resource
	SubjectId *string

	// The ISO-8601 timestamp when the subject was last updated.
	UpdatedAt *time.Time

	// The x509 principal identifier of the authenticating certificate.
	X509Subject *string

	noSmithyDocumentSerde
}

// A summary representation of subjects.
type SubjectSummary struct {

	// The ISO-8601 time stamp of when the certificate was first used in a temporary
	// credential request.
	CreatedAt *time.Time

	// The enabled status of the subject.
	Enabled *bool

	// The ISO-8601 time stamp of when the certificate was last used in a temporary
	// credential request.
	LastSeenAt *time.Time

	// The ARN of the resource.
	SubjectArn *string

	// The id of the resource.
	SubjectId *string

	// The ISO-8601 timestamp when the subject was last updated.
	UpdatedAt *time.Time

	// The x509 principal identifier of the authenticating certificate.
	X509Subject *string

	noSmithyDocumentSerde
}

// A label that consists of a key and value you define.
type Tag struct {

	// The tag key.
	//
	// This member is required.
	Key *string

	// The tag value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The state of the trust anchor after a read or write operation.
type TrustAnchorDetail struct {

	// The ISO-8601 timestamp when the trust anchor was created.
	CreatedAt *time.Time

	// Indicates whether the trust anchor is enabled.
	Enabled *bool

	// The name of the trust anchor.
	Name *string

	// A list of notification settings to be associated to the trust anchor.
	NotificationSettings []NotificationSettingDetail

	// The trust anchor type and its related certificate data.
	Source *Source

	// The ARN of the trust anchor.
	TrustAnchorArn *string

	// The unique identifier of the trust anchor.
	TrustAnchorId *string

	// The ISO-8601 timestamp when the trust anchor was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isSourceData() {}
