// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/pinpoint"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To get the activity execution metrics for a journey run
// The following example gets activity execution metrics for a single run of a journey.
func ExamplePinpoint_GetJourneyRunExecutionActivityMetrics_shared00() {
	svc := pinpoint.New(session.New())
	input := &pinpoint.GetJourneyRunExecutionActivityMetricsInput{
		ApplicationId:     aws.String("11111111112222222222333333333344"),
		JourneyActivityId: aws.String("AAAAAAAAAA"),
		JourneyId:         aws.String("aaaaaaaaaabbbbbbbbbbccccccccccdd"),
		RunId:             aws.String("99999999998888888888777777777766"),
	}

	result, err := svc.GetJourneyRunExecutionActivityMetrics(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case pinpoint.ErrCodeBadRequestException:
				fmt.Println(pinpoint.ErrCodeBadRequestException, aerr.Error())
			case pinpoint.ErrCodeInternalServerErrorException:
				fmt.Println(pinpoint.ErrCodeInternalServerErrorException, aerr.Error())
			case pinpoint.ErrCodePayloadTooLargeException:
				fmt.Println(pinpoint.ErrCodePayloadTooLargeException, aerr.Error())
			case pinpoint.ErrCodeForbiddenException:
				fmt.Println(pinpoint.ErrCodeForbiddenException, aerr.Error())
			case pinpoint.ErrCodeNotFoundException:
				fmt.Println(pinpoint.ErrCodeNotFoundException, aerr.Error())
			case pinpoint.ErrCodeMethodNotAllowedException:
				fmt.Println(pinpoint.ErrCodeMethodNotAllowedException, aerr.Error())
			case pinpoint.ErrCodeTooManyRequestsException:
				fmt.Println(pinpoint.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get the execution metrics for a journey run
// The following example gets execution metrics for a single run of a journey.
func ExamplePinpoint_GetJourneyRunExecutionMetrics_shared00() {
	svc := pinpoint.New(session.New())
	input := &pinpoint.GetJourneyRunExecutionMetricsInput{
		ApplicationId: aws.String("11111111112222222222333333333344"),
		JourneyId:     aws.String("aaaaaaaaaabbbbbbbbbbccccccccccdd"),
		RunId:         aws.String("99999999998888888888777777777766"),
	}

	result, err := svc.GetJourneyRunExecutionMetrics(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case pinpoint.ErrCodeBadRequestException:
				fmt.Println(pinpoint.ErrCodeBadRequestException, aerr.Error())
			case pinpoint.ErrCodeInternalServerErrorException:
				fmt.Println(pinpoint.ErrCodeInternalServerErrorException, aerr.Error())
			case pinpoint.ErrCodePayloadTooLargeException:
				fmt.Println(pinpoint.ErrCodePayloadTooLargeException, aerr.Error())
			case pinpoint.ErrCodeForbiddenException:
				fmt.Println(pinpoint.ErrCodeForbiddenException, aerr.Error())
			case pinpoint.ErrCodeNotFoundException:
				fmt.Println(pinpoint.ErrCodeNotFoundException, aerr.Error())
			case pinpoint.ErrCodeMethodNotAllowedException:
				fmt.Println(pinpoint.ErrCodeMethodNotAllowedException, aerr.Error())
			case pinpoint.ErrCodeTooManyRequestsException:
				fmt.Println(pinpoint.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get the runs of a journey
// The following example gets the runs of a journey.
func ExamplePinpoint_GetJourneyRuns_shared00() {
	svc := pinpoint.New(session.New())
	input := &pinpoint.GetJourneyRunsInput{
		ApplicationId: aws.String("11111111112222222222333333333344"),
		JourneyId:     aws.String("aaaaaaaaaabbbbbbbbbbccccccccccdd"),
	}

	result, err := svc.GetJourneyRuns(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case pinpoint.ErrCodeBadRequestException:
				fmt.Println(pinpoint.ErrCodeBadRequestException, aerr.Error())
			case pinpoint.ErrCodeInternalServerErrorException:
				fmt.Println(pinpoint.ErrCodeInternalServerErrorException, aerr.Error())
			case pinpoint.ErrCodePayloadTooLargeException:
				fmt.Println(pinpoint.ErrCodePayloadTooLargeException, aerr.Error())
			case pinpoint.ErrCodeForbiddenException:
				fmt.Println(pinpoint.ErrCodeForbiddenException, aerr.Error())
			case pinpoint.ErrCodeNotFoundException:
				fmt.Println(pinpoint.ErrCodeNotFoundException, aerr.Error())
			case pinpoint.ErrCodeMethodNotAllowedException:
				fmt.Println(pinpoint.ErrCodeMethodNotAllowedException, aerr.Error())
			case pinpoint.ErrCodeTooManyRequestsException:
				fmt.Println(pinpoint.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
