//
// Syd: rock-solid application kernel
// src/kernel/sysinfo.rs: sysinfo(2) handler
//
// Copyright (c) 2023, 2024, 2025 Ali Polatel <alip@chesswob.org>
//
// SPDX-License-Identifier: GPL-3.0

// SAFETY: This module has been liberated from unsafe code!
#![forbid(unsafe_code)]

use libseccomp::ScmpNotifResp;
use nix::errno::Errno;

use crate::{confine::is_valid_ptr, req::UNotifyEventRequest, sysinfo::SysInfo};

pub(crate) fn sys_sysinfo(request: UNotifyEventRequest) -> ScmpNotifResp {
    syscall_handler!(request, |request: UNotifyEventRequest| {
        let req = request.scmpreq;

        // SAFETY: Check pointer against mmap_min_addr.
        if !is_valid_ptr(req.data.args[0]) {
            return Err(Errno::EFAULT);
        }

        // Generate a randomized sysinfo(2) structure.
        let info = SysInfo::new(req.data.arch)?;

        request.write_mem(info.as_bytes(), req.data.args[0])?;
        Ok(request.return_syscall(0))
    })
}
