/********************************************************************

    This file is part of ETSwitch
    Copyright (C) 2004, 2005, 2006  Nicklas Larsson - etswitch@gmail.com - All rights reserved.

    etswitch - switch to desktop

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

********************************************************************/

#if HAVE_CONFIG_H
# include <config.h>		/* autotool generated ifdef's */
#endif

#define _GNU_SOURCE

#include <fcntl.h>		/* locking over nfs */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/ioctl.h>		/* for sending/geting data from special device */
#include <sys/file.h>		/* bsd? */


#include <dirent.h>		/* for scandir usage */
#include <libgen.h>		/* dirname / basename */

#include <pwd.h>		/* for getting home/user dir/settings */
#include <sys/types.h>

#include <sys/stat.h>		/* for file info/stat */

#include <malloc.h>
#include <linux/limits.h>

#include <signal.h>		/* signal handler */
#include <sys/time.h>
#include <sys/types.h>		/* kill */

#include <sys/resource.h>	/* resources */

#include "etswitch.h" 		/* etswitch */
#include "read_wid.h" 		/* .h */
#include "etswitch_wid.h" 	/* .h */


#include <errno.h>
extern int errno;

/*
will try and read the wid file and malloc the game struct 
if wid file is missing it will read the internal one
thus having a wid file overrides the internal one
*/
void readwid_conf(){

    char *file, *home;
    FILE *fp;			/* wid file */
    char *line = NULL;
    size_t len = 0;
    ssize_t string_length;
    char *a,*b,*c,*d,*e,*f;

#ifdef DEBUG
    fprintf(stdout, "readwid_conf: start\n");    
#endif

    /* patch me please */
    file = calloc(PATH_MAX + NAME_MAX + 1,1);
    
    home = (char *)getenv("HOME_ETC");
    if(home == NULL)
	home = (char *)getenv("HOME");

    snprintf((char *)file, PATH_MAX+NAME_MAX+1, "%s/.etswitch/etswitch.wid", (char *)home);

    if(wid != NULL){	
	free_array(wid);
    }
    wid = NULL;
    
    /* try and open the wid file */
    if (!(fp = fopen((char *)file, "r"))){
	/* dont create it, just read the internal */
	readwid_internal_conf();
    }else{
	fprintf(stdout, "Overrideing internal list with the content from the file '%s'.\n", (char *)file);
	while ((string_length = getline(&line, (size_t *)&len, (FILE *)fp)) != -1) {
	    a = (char*)malloc(string_length+1);	/* just in case */
	    b = (char*)malloc(string_length+1);	/* just in case */
	    c = (char*)malloc(string_length+1);	/* just in case */
	    d = (char*)malloc(string_length+1);	/* just in case */
	    e = (char*)malloc(string_length+1);	/* just in case */
	    f = (char*)malloc(string_length+1);	/* just in case */

	    /* test malloc calls here */

	    if (sscanf((char *)line, "%[^\t]\t%[^\t]\t%[^\t]\t%[^\t]\t%[^\t]\t%[^\t]", a, b, c, d, e, f) != 6) {
		/* remove last \n if exists, this isnt safe? */
		if(string_length>0){
		    if(line[string_length-1] == '\n')
			line[string_length-1] = '\0';

		    /* if line starts with # or '' totaly ignore, no output */
		    if(!(line[0] == '\0' || line[0] == '#')){
			printf("Ignoreing line: '%s'\n",(char *)line);
		    }
		}
    	    }else{
#ifdef DEBUG
    		printf("OK: %s:%s:%s:%s:%s:%s\n",a,b,c,d,e,f); 
#endif
		wid = ex2(wid);

		wid->WMNAME = (char *)strdup(a);
		wid->iconname = (char *)strdup(b);
		wid->res_name = (char *)strdup(c);
		wid->res_class = (char *)strdup(d);
		wid->known_binary = (char *)strdup(e);
		wid->tweak = atof(f);
	    }

	    free(a);
	    free(b);
	    free(c);
	    free(d);
	    free(e);
	    free(f);
	}
    if (line)
	free(line);
    }/* if (!(fp = fopen((char *)file, "r"))){ */
    free(file);
#ifdef DEBUG
    if(wid != NULL){
        printf("----- LOOPIE ----- \n"); 
        loopie((wid_info_struct *)wid->first_struct);
    }
    fprintf(stdout, "readwid_conf: end\n");    
#endif

}
/*
reads the internal wid data to wid	
*/
void readwid_internal_conf(){
	
    int i = 0;
    char *a,*b,*c,*d,*e,*f;
	
    while(i < conf_str_size){
        int string_length = strlen((char *)conf_str[i]);
/*	buff = (char *)strdup((char *)conf_str[i]); */
	a = (char*)malloc(string_length+1);	/* just in case */
	b = (char*)malloc(string_length+1);	/* just in case */
	c = (char*)malloc(string_length+1);	/* just in case */
	d = (char*)malloc(string_length+1);	/* just in case */
	e = (char*)malloc(string_length+1);	/* just in case */
	f = (char*)malloc(string_length+1);	/* just in case */
        
	if (sscanf((char *)conf_str[i], "%[^\t]\t%[^\t]\t%[^\t]\t%[^\t]\t%[^\t]\t%[^\t]", a, b, c, d, e, f) != 6) {
#ifdef DEBUG
/* in general -> good conf */
	    printf("Scanf() failure on line\n");
	    printf("buff: '%s'\n", (char *)conf_str[i]);
#endif
        }else{
#ifdef DEBUG
    	    printf("OK: %s:%s:%s:%s:%s:%s\n",a,b,c,d,e,f); 
	    printf("malloc new wid\n");
#endif
	    wid = ex2(wid);

	    wid->WMNAME = (char *)strdup(a);
	    wid->iconname = (char *)strdup(b);
	    wid->res_name = (char *)strdup(c);
	    wid->res_class = (char *)strdup(d);
	    wid->known_binary = (char *)strdup(e);
	    wid->tweak = atof(f);
	}

	free(a);
	free(b);
	free(c);
	free(d);
	free(e);
	free(f);
	    
	i++;
    }
}

/* create a new struct, pointing old to new */
wid_info_struct *ex2(wid_info_struct *old){
    wid_info_struct *xy;

    if((xy = malloc(sizeof(wid_info_struct))) == NULL){
	perror("read_wid.c : ex2: malloc().. out of memory\n");
	exit(EXIT_FAILURE);
    }

    if(old != NULL){
	old->next_struct = (char *)xy;
	xy->id = old->id+1;
	xy->first_struct = old->first_struct;
    }else{
	xy->first_struct = (char *)xy;
	xy->id = 0;
    }

    /* default */
    xy->tweak = 0;
    xy->next_struct = NULL;
    return xy;
}

/* just test the sucker */
void loopie(wid_info_struct *old){

    wid_info_struct *p;
    p = old; 

    fprintf(stdout, "in loopie\n");    

    while( 1 ){
	printf("--\nStruct ID:%i, twe: %i\n",p->id, p->tweak);	
	printf("WM:%s\nIC:%s\nNA:%s\nCL:%s\nTW:%i\n",
	p->WMNAME,
	p->iconname,
	p->res_name,
	p->res_class,
	p->tweak);	

	printf("--\n");
	if(p->next_struct == NULL) break;
	p = (wid_info_struct *)p->next_struct;
    }

}
/* free the array's */
void free_array(wid_info_struct *old){

    wid_info_struct *p;
    #ifdef DEBUG
    fprintf(stdout, "read_wid free_array: start\n");    
    #endif
    p = (wid_info_struct *)old->first_struct; 

    if(p != NULL){
	while( 1 ){
	    #ifdef DEBUG
	    printf("Struct ID:%i WM:%s IC:%s NA:%s CL:%s TW:%i\n",p->id,
	    p->WMNAME, p->iconname, p->res_name, p->res_class, p->tweak);	
	    #endif

	    free(p->WMNAME);
	    free(p->iconname);
	    free(p->res_name);
	    free(p->res_class);

	    if(p->next_struct == NULL) break;
    	    free(p);
    	    p = (wid_info_struct *)p->next_struct;
	}
	free(p);
    }else{
	#ifdef DEBUG
	fprintf(stdout, "read_wid free_array: Hmm.. array was allready cleared.\n");
	#endif
    }

    #ifdef DEBUG
    fprintf(stdout, "read_wid free_array: end\n");    
    #endif

}


void writewid_conf(void){

    char *file, *dir, *home;
    struct stat dir_stat;	/* test path */

    FILE *fpp;			/* file exists break; */

    int fp;
    int r;
    int i;
    int string_length;

    dir = calloc(PATH_MAX+1,1);
    file = calloc(PATH_MAX+NAME_MAX+1,1);

    home = (char *)getenv("HOME_ETC");
    if(home == NULL)
	home = (char *)getenv("HOME");


    if((char *)file == NULL || (char *)dir == NULL){
	fprintf(stderr, "malloc failed: %s, at line: %d\n", strerror(errno),__LINE__);
	exit(EXIT_FAILURE);
    }
    /* change to get pw */
    snprintf((char *)dir, PATH_MAX, "%s/.etswitch", (char *)home);
    snprintf((char *)file, PATH_MAX+NAME_MAX, "%s/etswitch.wid", (char *)dir);
    if (stat((char *)dir, &dir_stat)!=-1){
	if (!S_ISDIR (dir_stat.st_mode)){    /* the name is a directory, and it exists  */
	    fprintf(stderr,"'%s' exists but it's not a directory, can't save config.\n", (char *)dir);
	}
    }else{
	fprintf(stdout,"Creating missing directory, '%s'.\n", (char *)dir);
	mkdir((char *)dir, S_IRWXU);
    }
    if ((fpp = fopen((char *)file, "r"))){
	/* file exists */
	fprintf(stderr, "file '%s' allready exists, remove it manually.\n", (char *)file);
	exit(EXIT_FAILURE);
    }
    if (!(fp = open((char *)file, O_CREAT | O_TRUNC | O_WRONLY, S_IRWXU))){
        fprintf(stderr, "fopen read failed: %s, at line: %d\n", strerror(errno),__LINE__);
    }else{
	i = 0;
	while(i < conf_str_size){
    	    string_length = strlen((char *)conf_str[i]);
    	    r = write(fp, (char *)conf_str[i], string_length);
    	    if(r != string_length){
		/* critical error ? */
    		fprintf(stderr, "Hmm.. error '%i' writing to conf, make sure the path '%s' exists and is writeble.\n", r,(char *)file);
	    }
	    i++;
	}
	#ifdef DEBUG
	fprintf(stdout, "read_wid writewid_conf: \n");
	#endif

	close(fp);
    }
    free(file);
    free(dir);
    /* free(home); */
}

