/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples.stream;

import java.util.ArrayList;
import java.util.Arrays;
import twitter4j.FilterQuery;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.TwitterException;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;

public final class PrintFilterStream {
    public static void main(String[] args) throws TwitterException {
        if (args.length < 1) {
            System.out.println("Usage: java twitter4j.examples.PrintFilterStream [follow(comma separated numerical user ids)] [track(comma separated filter terms)]");
            System.exit(-1);
        }
        StatusListener listener = new StatusListener(){

            public void onStatus(Status status) {
                System.out.println("@" + status.getUser().getScreenName() + " - " + status.getText());
            }

            public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
                System.out.println("Got a status deletion notice id:" + statusDeletionNotice.getStatusId());
            }

            public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
                System.out.println("Got track limitation notice:" + numberOfLimitedStatuses);
            }

            public void onScrubGeo(long userId, long upToStatusId) {
                System.out.println("Got scrub_geo event userId:" + userId + " upToStatusId:" + upToStatusId);
            }

            public void onException(Exception ex) {
                ex.printStackTrace();
            }
        };
        TwitterStream twitterStream = new TwitterStreamFactory().getInstance();
        twitterStream.addListener(listener);
        ArrayList<Long> follow = new ArrayList<Long>();
        ArrayList<String> track = new ArrayList<String>();
        String[] arr$ = args;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String arg = arr$[i$];
            if (PrintFilterStream.isNumericalArgument(arg)) {
                String[] arr$2 = arg.split(",");
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    String id = arr$2[i$2];
                    follow.add(new Long(Long.parseLong(id)));
                }
                continue;
            }
            track.addAll(Arrays.asList(arg.split(",")));
        }
        long[] followArray = new long[follow.size()];
        for (int i = 0; i < follow.size(); ++i) {
            followArray[i] = (Long)follow.get(i);
        }
        String[] trackArray = track.toArray(new String[track.size()]);
        twitterStream.filter(new FilterQuery(0, followArray, trackArray));
    }

    private static boolean isNumericalArgument(String argument) {
        String[] args = argument.split(",");
        boolean isNumericalArgument = true;
        String[] arr$ = args;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String arg = arr$[i$];
            try {
                Integer.parseInt(arg);
                continue;
            }
            catch (NumberFormatException nfe) {
                isNumericalArgument = false;
                break;
            }
        }
        return isNumericalArgument;
    }
}

