/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.composite.internal.DefaultIncludedBuild;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildFactory;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.reflect.Instantiator;

public class DefaultIncludedBuildFactory
implements IncludedBuildFactory {
    private final BuildTreeState buildTree;
    private final Instantiator instantiator;

    public DefaultIncludedBuildFactory(BuildTreeState buildTree, Instantiator instantiator) {
        this.buildTree = buildTree;
        this.instantiator = instantiator;
    }

    private static void validateBuildDirectory(File dir) {
        if (!dir.exists()) {
            throw new InvalidUserDataException(String.format("Included build '%s' does not exist.", dir));
        }
        if (!dir.isDirectory()) {
            throw new InvalidUserDataException(String.format("Included build '%s' is not a directory.", dir));
        }
    }

    public IncludedBuildState createBuild(BuildIdentifier buildIdentifier, BuildDefinition buildDefinition, boolean isImplicit, BuildState owner) {
        DefaultIncludedBuildFactory.validateBuildDirectory(buildDefinition.getBuildRootDir());
        return new DefaultIncludedBuild(buildIdentifier, buildDefinition, isImplicit, owner, this.buildTree, this.instantiator);
    }
}

