// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
	domainservice "github.com/go-acme/jdcloud-sdk-go/services/domainservice/models"
)

type DescribeResourceRecordRequest struct {
	core.JDCloudRequest

	/* 实例所属的地域ID  */
	RegionId string `json:"regionId"`

	/* 域名ID，请使用describeDomains接口获取。  */
	DomainId string `json:"domainId"`

	/* 当前页数，起始值为1，默认为1 (Optional) */
	PageNumber *int `json:"pageNumber"`

	/* 分页查询时设置的每页行数, 默认为10 (Optional) */
	PageSize *int `json:"pageSize"`

	/* 关键字，按照”%search%”模式匹配解析记录的主机记录 (Optional) */
	Search *string `json:"search"`
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeResourceRecordRequest(
	regionId string,
	domainId string,
) *DescribeResourceRecordRequest {

	return &DescribeResourceRecordRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/ResourceRecord",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
		RegionId: regionId,
		DomainId: domainId,
	}
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param pageNumber: 当前页数，起始值为1，默认为1 (Optional)
 * param pageSize: 分页查询时设置的每页行数, 默认为10 (Optional)
 * param search: 关键字，按照”%search%”模式匹配解析记录的主机记录 (Optional)
 */
func NewDescribeResourceRecordRequestWithAllParams(
	regionId string,
	domainId string,
	pageNumber *int,
	pageSize *int,
	search *string,
) *DescribeResourceRecordRequest {

	return &DescribeResourceRecordRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/ResourceRecord",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
		RegionId:   regionId,
		DomainId:   domainId,
		PageNumber: pageNumber,
		PageSize:   pageSize,
		Search:     search,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeResourceRecordRequestWithoutParam() *DescribeResourceRecordRequest {

	return &DescribeResourceRecordRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/ResourceRecord",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 实例所属的地域ID(Required) */
func (r *DescribeResourceRecordRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param domainId: 域名ID，请使用describeDomains接口获取。(Required) */
func (r *DescribeResourceRecordRequest) SetDomainId(domainId string) {
	r.DomainId = domainId
}

/* param pageNumber: 当前页数，起始值为1，默认为1(Optional) */
func (r *DescribeResourceRecordRequest) SetPageNumber(pageNumber int) {
	r.PageNumber = &pageNumber
}

/* param pageSize: 分页查询时设置的每页行数, 默认为10(Optional) */
func (r *DescribeResourceRecordRequest) SetPageSize(pageSize int) {
	r.PageSize = &pageSize
}

/* param search: 关键字，按照”%search%”模式匹配解析记录的主机记录(Optional) */
func (r *DescribeResourceRecordRequest) SetSearch(search string) {
	r.Search = &search
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeResourceRecordRequest) GetRegionId() string {
	return r.RegionId
}

type DescribeResourceRecordResponse struct {
	RequestID string                       `json:"requestId"`
	Error     core.ErrorResponse           `json:"error"`
	Result    DescribeResourceRecordResult `json:"result"`
}

type DescribeResourceRecordResult struct {
	DataList     []domainservice.RRInfo `json:"dataList"`
	TotalCount   int                    `json:"totalCount"`
	TotalPage    int                    `json:"totalPage"`
	CurrentCount int                    `json:"currentCount"`
}
