#include "pjl_config.h"                 /* must go first */

#line 3 "lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 135
#define YY_END_OF_BUFFER 136
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_acclist[1096] =
    {   0,
      132,  132,  136,  134,  135,  108,  134,  135,  109,  135,
       54,  134,  135,   98,  134,  135,   55,  134,  135,   56,
      134,  135,   57,  134,  135,   58,  134,  135,   59,  134,
      135,   60,  134,  135,   61,  134,  135,   62,  134,  135,
       63,  134,  135,   64,  134,  135,   65,  134,  135,   16,
      134,  135,   17,  134,  135,   66,  134,  135,   67,  134,
      135,   68,  134,  135,   69,  134,  135,   70,  134,  135,
       71,  134,  135,   14,  134,  135,16397,   14,  134,  135,
    16397,   14,  134,  135,16397,   72,  134,  135,   73,  134,
      135,   74,  134,  135,   14,  134,  135,16397,   14,  134,

      135,16397,   14,  134,  135,16397,   14,  134,  135,16397,
       14,  134,  135,16397,   14,  134,  135,16397,   75,  134,
      135,   76,  134,  135,   77,  134,  135,   78,  134,  135,
      108,  134,  135,   51,   55,  134,  135,   56,  134,  135,
       71,  134,  135,   14,  134,  135,16397,    7,   14,  134,
      135,16397,  134,  135,  128,  134,  135,  134,  135,  134,
      135,  134,  135,  134,  135,  127,  134,  135,16510,  103,
      134,  135,  103,  108,  134,  135,  100,  109,  135,  104,
      134,  135,  103,  134,  135,  103,  134,  135,  103,  134,
      135,  103,  134,  135,  103,  134,  135,  134,  135,  112,

      134,  135,  114,  134,  135,  113,  134,  135,  134,  135,
      111,  134,  135,  111,  134,  135,   55,  122,  134,  135,
      123,  134,  135,   56,  134,  135,   71,  134,  135,  124,
      134,  135,  116,  134,  135,  116,  134,  135,  116,  134,
      135,  125,  134,  135,  116,  134,  135,  108,  134,  135,
       51,   55,  122,  134,  135,   56,  134,  135,   71,  134,
      135,  129,  134,  135,  129,  134,  135,  129,  134,  135,
      129,  134,  135,  131,  134,  135,  129,  134,  135,  130,
      134,  135,  129,  134,  135,  108,  134,  135,  132,  134,
      135,  134,  135,  133,  134,  135,   14,  132,  134,  135,

    16397,   14,  132,  134,  135,16397,   14,  132,  134,  135,
    16397,   14,  132,  134,  135,16397,   14,  132,  134,  135,
    16397,   14,  132,  134,  135,16397,  108,  134,  135,  134,
      135,   14,  132,  134,  135,16397,    7,   14,  132,  134,
      135,16397,  101,  134,  135,  101,  108,  134,  135,  101,
      134,  135,  102,  134,  135,  101,  134,  135,  101,  134,
      135,  101,  134,  135,  101,  134,  135,  105,  134,  135,
       96,  134,  135,   96,  108,  134,  135,   96,  109,  135,
       96,  134,  135,   97,  134,  135,   96,  134,  135,   96,
      134,  135,   96,  134,  135,   96,  134,  135,  108,   25,

       79,   26,   83,   27,   28,   29,   30,   31,   32,   16,
       17,   33,   34,   36,   19,  106,  107,   38,   19,   16,
       16,   16,   16,   17,   17,   17,   17,   24,   81,   82,
       80,   39,   41,   43,   44,   45,   47,   14,16397,   98,
       14,16397,   22,   48,   14,16397,   14,16397,   14,16397,
       14,16397,   14,16397,   14,16397,   49,   50,  108,   51,
        7,   52,   79,   14,16397,    7,   80, 8318,  127,16510,
      103,  103,  108,   79,  103,   83,  103,  103,  106,  103,
      107,   81,  103,   82,  103,   80,  103,  103,   99,  111,
      111,  121,   79,  118,  116,  116,  116,  108,   51,   52,

       79,  118,  129,   79,  129,   83,  129,  106,  129,  107,
      129,   81,  129,   82,  129,   80,  129,  129,  108,  132,
      132,  132,  132,   14,  132,16397,   14,  132,16397,   14,
      132,16397,   14,  132,16397,   14,  132,16397,   14,  132,
    16397,   14,  132,16397,  108,   14,  132,16397,    7,  101,
      101,  108,   79,  101,   83,  101,  101,  106,  101,  107,
       81,  101,   82,  101,   80,  101,  101,   96,   96,  108,
       79,   96,   83,   96,   96,  106,   96,  107,   81,   96,
       82,   96,   80,   96,   96,   35,   37,   19,  107,   16,
       15,   19,   16,   16,   16,   16,   18,   16,   17,   17,

       17,   17,   17,   17,   23,   40,   42,   46,   92,   87,
       88,   90,   94,   89,   91,   93,   95,   14,16397,   12,
       14,16397,   14,16397,   14,16397,   52,    7,   53,   14,
    16397,    6,    6,    6,   88,  103,  107,   92,  103,   87,
      103,   88,  103,   90,  103,   94,  103,   89,  103,   91,
      103,   93,  103,  115,  111,  120,   53,  120,  107,  129,
       92,  129,   87,  129,   88,  129,   90,  129,   94,  129,
       89,  129,   91,  129,   93,  129,  132,  132,  132,  132,
      132,  132,   14,  132,16397,   14,  132,16397,   14,  132,
    16397,   14,  132,16397,   14,  132,16397,    6,  101,  107,

       92,  101,   88,  101,   90,  101,   94,  101,   89,  101,
       91,  101,   93,  101,   96,  107,   92,   96,   87,   96,
       88,   96,   94,   96,   89,   96,   91,   96,   93,   96,
       19,   15,   15,   15,   18,   18,   18,   20,   85,   84,
    16394,16394,16394,   14,16397,   14,16397,   14,16397,   14,
    16397,   14,16397,    6,    6,   85,  103,  103,   84,  103,
      111,  117,  129,  132,  132,  132,  132,  132,16394,  132,
    16394,  132,16394,   14,  132,16397,   14,  132,16397,   14,
      132,16397,   14,  132,16397,   14,  132,16397,    6,  132,
       85,  101,  101,   85,   96,   96,   84,   96,   15,   15,

       15,   15,   15,   15,   18,   18,   18,   19,   18,   18,
       18,   11,   11,16394,   11,16394,16394,    8,   14,16397,
        2,   14,16387,16397,   14,16397,   14,16397,    6,16394,
        6,16394,    6,16394,    6,    6,  103,  111,  129,   11,
       11,  132,  132,16394,   11,  132,16394,  132,16394,  132,
    16394,   14,  132,16397,   14,  132,16387,16397,   14,  132,
    16397,   14,  132,16397,    6,  132,    6,    6,  132,16394,
        6,  132,16394,    6,  132,16394,  101,   96,   86,   21,
    16394,16394,    8,   14,16397,   14,16397,   14,16397,   14,
    16397,    6,   11,    6,16394,    6,   11,    6,16394,    6,

    16394,    6,    8,    6,   86,  103,  111,  119,   86,  129,
      132,16394,  132,16394,   14,  132,16397,   14,  132,16397,
       14,  132,16397,   14,  132,16397,    6,  132,    6,  132,
        6,   11,  132,    6,  132,16394,    6,   11,    6,  132,
    16394,    6,  132,16394,    6,  132,16394,   86,  101,   86,
       96, 8205,16394,16394,   14,16397,   14,16397,   14,16397,
       14,16397,    6,16394,    6,16394,    6,    8,    6, 8205,
      132,16394,  132,16394,   14,  132,16397,   14,  132,16397,
       14,  132,16397,   14,  132,16397,    6,  132,    6,  132,
        6,  132,    6,  132,16394,    6,  132,16394,16394,16394,

        1,   14,16387,16397,    5,    6,16394,    6,16394,  132,
    16394,  132,16394,   14,  132,16387,16397,    6,  132,16394,
        6,  132,16394,   11,16394,    6,16394,    6,16394,  110,
       11,  132,16394,    6,  132,16394,    6,  132,16394, 8202,
        8,16394,    6,16394,  132,16394,    6,  132,16394,    8,
    16394, 8195,    6,16394,  132,16394,    6,  132,16394,    8,
        9,   11,    9,   11,    9,   11,    6,16394,    9,   11,
        9,   11,  132,    9,   11,    6,  132,16394,    8, 8205,
        6,    9,   11,    6,    9,   11,    6,    9,   11,  132,
        6,    9,   11,    4,    4

    } ;

static const flex_int16_t yy_accept[755] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    2,    3,    3,    3,    3,    3,    3,
        3,    4,    6,    9,   11,   14,   17,   20,   23,   26,
       29,   32,   35,   38,   41,   44,   47,   50,   53,   56,
       59,   62,   65,   68,   71,   74,   78,   82,   86,   89,
       92,   95,   99,  103,  107,  111,  115,  119,  122,  125,
      128,  131,  134,  138,  141,  144,  148,  153,  155,  158,
      160,  162,  164,  166,  170,  173,  177,  180,  183,  186,
      189,  192,  195,  198,  200,  203,  206,  209,  211,  214,
      217,  221,  224,  227,  230,  233,  236,  239,  242,  245,

      248,  251,  256,  259,  262,  265,  268,  271,  274,  277,
      280,  283,  286,  289,  292,  294,  297,  302,  307,  312,
      317,  322,  327,  330,  332,  337,  343,  346,  350,  353,
      356,  359,  362,  365,  368,  371,  374,  378,  381,  384,
      387,  390,  393,  396,  399,  400,  401,  402,  403,  404,
      405,  406,  407,  408,  409,  410,  410,  411,  412,  413,
      414,  415,  415,  416,  417,  418,  419,  419,  420,  421,
      421,  421,  421,  422,  423,  423,  423,  424,  424,  424,
      425,  426,  427,  427,  428,  428,  429,  430,  431,  432,
      433,  434,  435,  436,  437,  438,  438,  438,  440,  440,

      441,  443,  443,  443,  444,  445,  447,  447,  449,  451,
      453,  455,  457,  458,  459,  460,  461,  461,  461,  462,
      462,  462,  464,  464,  466,  467,  468,  468,  468,  469,
      471,  472,  474,  476,  478,  480,  482,  484,  486,  488,
      489,  490,  490,  491,  492,  493,  495,  495,  496,  497,
      498,  499,  500,  503,  503,  504,  506,  508,  510,  512,
      514,  516,  518,  519,  520,  520,  520,  521,  522,  523,
      523,  524,  527,  527,  530,  533,  536,  539,  542,  545,
      546,  546,  549,  550,  551,  553,  555,  557,  559,  561,
      563,  565,  567,  568,  569,  571,  573,  575,  577,  579,

      581,  583,  585,  586,  587,  588,  588,  589,  590,  591,
      592,  592,  593,  594,  595,  596,  596,  597,  597,  597,
      598,  599,  600,  601,  602,  603,  603,  604,  604,  605,
      605,  606,  606,  606,  607,  608,  609,  610,  611,  612,
      613,  614,  615,  616,  617,  617,  617,  617,  618,  620,
      621,  623,  625,  627,  628,  628,  629,  629,  630,  632,
      633,  634,  635,  636,  638,  640,  642,  644,  646,  648,
      650,  652,  654,  655,  656,  656,  657,  659,  661,  663,
      665,  667,  669,  671,  673,  675,  677,  678,  679,  680,
      681,  682,  683,  686,  689,  692,  695,  698,  699,  701,

      703,  705,  707,  709,  711,  713,  715,  717,  719,  721,
      723,  725,  727,  729,  731,  731,  732,  732,  733,  734,
      734,  735,  735,  735,  735,  735,  736,  736,  737,  737,
      738,  738,  739,  740,  740,  741,  741,  741,  741,  741,
      742,  743,  744,  744,  746,  746,  748,  750,  752,  752,
      754,  755,  756,  758,  759,  761,  762,  763,  763,  764,
      765,  766,  767,  768,  770,  772,  774,  777,  780,  783,
      786,  789,  791,  793,  794,  796,  797,  799,  800,  801,
      802,  803,  803,  804,  804,  805,  806,  807,  808,  808,
      809,  810,  810,  811,  811,  812,  812,  812,  812,  813,

      814,  815,  816,  817,  818,  818,  819,  821,  821,  821,
      821,  821,  822,  825,  827,  827,  829,  831,  833,  835,
      836,  837,  838,  839,  839,  840,  841,  843,  845,  846,
      848,  850,  852,  855,  855,  859,  862,  865,  867,  868,
      871,  874,  877,  878,  879,  880,  881,  881,  881,  881,
      882,  883,  884,  886,  886,  886,  886,  886,  886,  886,
      888,  890,  890,  892,  894,  896,  898,  900,  902,  904,
      905,  907,  908,  909,  911,  911,  913,  915,  918,  918,
      921,  924,  927,  929,  931,  934,  937,  939,  942,  945,
      948,  950,  952,  953,  953,  954,  955,  957,  957,  957,

      957,  957,  959,  961,  961,  963,  965,  967,  969,  971,
      971,  973,  975,  978,  981,  984,  987,  989,  991,  993,
      996,  999,  999, 1000, 1001, 1001, 1002, 1002, 1002, 1002,
     1002, 1002, 1005, 1005, 1005, 1005, 1006, 1008, 1010, 1010,
     1012, 1014, 1014, 1018, 1018, 1018, 1021, 1024, 1024, 1025,
     1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026,
     1026, 1028, 1030, 1031, 1031, 1032, 1034, 1034, 1037, 1040,
     1041, 1041, 1042, 1043, 1043, 1043, 1043, 1043, 1043, 1043,
     1043, 1045, 1045, 1047, 1050, 1051, 1052, 1052, 1052, 1053,
     1053, 1053, 1053, 1053, 1053, 1055, 1057, 1060, 1061, 1063,

     1065, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 1069, 1071,
     1074, 1076, 1079, 1080, 1080, 1080, 1080, 1081, 1081, 1081,
     1084, 1087, 1091, 1094, 1094, 1094, 1094, 1094, 1094, 1094,
     1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094,
     1095, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096,
     1096, 1096, 1096, 1096
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    7,    8,    9,   10,   11,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
       21,   21,   21,   21,   21,   22,   23,   24,   25,   26,
       27,   28,   29,   30,   31,   32,   33,   33,   34,   35,
       36,   36,   36,   36,   36,   37,   36,   36,   36,   38,
       36,   39,   36,   36,   40,   36,   41,   42,   36,   43,
       44,   45,   46,   47,   48,   49,   50,   51,   52,   53,

       54,   55,   56,   56,   57,   56,   56,   58,   59,   60,
       61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
       56,   71,   72,   73,   74,   75,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[76] =
    {   0,
        1,    2,    3,    1,    4,    1,    1,    1,    1,    5,
        6,    7,    8,    1,    1,    9,   10,    1,   11,   11,
       11,   11,   11,   12,   13,    1,   13,    1,    1,    1,
       14,   14,   14,   14,   14,   15,   15,   15,   15,   15,
       15,   15,   15,    1,   16,    1,    1,   15,    1,   17,
       17,   17,   17,   17,   17,   18,   19,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   20,   18,   18,   18,
       18,    1,    1,    1,   21
    } ;

static const flex_int16_t yy_base[798] =
    {   0,
        0,   74,  137,    0,   76,   83,  212,    0,  287,   81,
       90,  361,  390,  464,  465,  469,  494,  514,  523,  542,
     2686, 3867, 2679, 3867, 2653, 3867, 3867,   96,   68, 3867,
     3867, 2652,   99, 3867,  354,  556,  109,  570,  632,  101,
     3867,  477, 2651,   69,   75,  109,  476,  504,   88, 3867,
     2650,  505,  702, 2609,  305,  311,  560, 3867,  457, 3867,
     3867,  555,  467,  356,  106,  486,  488,  452, 3867,  495,
     2647,  110, 2645,  531,    0, 2671, 3867, 3867,  464,  538,
     2644,  540, 2642,    0, 3867, 3867, 3867, 2653,    0, 2615,
     2655, 3867,  570,  538, 3867,    0,  576, 2655, 3867,  578,

      614, 2653,  581,  572,    0,  595,  612, 2630, 3867,  550,
     3867, 2628,  365,  632,  605, 3867,  657,  689,  772, 2570,
      444,  518,  644,  480,  571,  593,    0, 2634,  608, 3867,
      644, 2607,  639, 2605, 3867,    0, 2631,    0,  620, 3867,
      669, 2604,  650, 2602, 2628, 3867, 3867, 3867, 3867, 3867,
     3867, 3867, 3867, 3867, 3867,  673,    0,    0, 3867, 2616,
     3867, 2611,  825, 3867,    0, 3867,  664,  830,  747,  852,
      645,  761,  841,  852, 2595, 2609,  621, 2574,  708,    0,
      857,  859, 2592,  631, 2572,  601, 3867, 3867,  774, 2594,
     2592, 3867, 3867, 2592, 3867,  915,  665,  695, 2594, 3867,

      797, 2606,  703, 3867, 3867,  795,    0, 2549,  650,  796,
      734,  927, 3867, 3867,  905,  730, 2591, 2580, 2606,  852,
     2547, 3867,  934,  803,  866, 3867,  953,  624, 3867,  855,
        0, 2604,    0,    0,    0,  701,    0,    0,    0,  966,
     3867, 2588,    0, 2549, 3867, 2595,  979,    0, 2597,  948,
      994, 3867, 2593,  999,    0,    0,    0,    0,  947,    0,
        0,    0, 1018,  874, 2576,  880,  890, 1018, 1011,  997,
     1030, 2567, 2573, 2564,  683, 2527,  869,  845,  851, 1043,
      885,  887, 1031,    0, 2591,    0,    0,    0,  910,    0,
        0,    0, 1046,    0, 2590,    0,    0,    0,  944,    0,

        0,    0, 1059, 3867, 3867, 1070, 3867,    0, 1097, 1085,
     1077, 1092,  711, 3867,  864, 2559, 3867, 2539,    0, 1159,
     3867, 1221,  900, 3867,  922, 2557, 3867, 2537, 3867,  973,
     3867,  986, 2562, 3867, 3867, 3867,  789, 2554, 1049, 3867,
     3867, 3867, 3867, 3867, 2513, 1058, 2567, 3867, 1059, 2561,
     1291,  943,  940, 3867, 2549, 2573, 2522, 3867,  958, 2569,
     1064, 1012, 3867, 1063, 1053, 2543,    0,    0,    0,    0,
        0,    0, 3867, 2512, 2537, 2531, 2529, 1119, 1074, 2508,
        0,    0,    0,    0,    0,    0, 1158, 1170, 1129, 1146,
     1185, 1149,  987,  992, 1065, 1078, 1091, 1100, 1129, 1134,

        0,    0,    0,    0,    0,    0, 1172, 1138, 2507,    0,
        0,    0,    0,    0, 1192, 1213, 1166, 1179, 1212, 2501,
     1155, 2481, 1014,    0, 1165, 1217, 1275, 1326, 2499, 1178,
     2478, 3867, 3867, 2499, 3867, 1218, 2498, 2459, 1314, 1397,
     2463, 2455, 2514, 1227, 2499, 1276, 1199, 1202, 2455, 1074,
     1472, 1221,    0, 2480,    0, 2447, 3867, 2476, 2475, 1363,
     1546, 1558, 1548, 1623, 2442, 2440, 1207, 1547, 1206, 1189,
     2434, 1698,    0, 2471,    0, 2470,    0, 1764, 1234, 3867,
     1036, 2466, 3867, 2446, 3867, 1769, 1236, 3867, 1351, 1564,
     1222, 2459, 3867, 2439, 3867, 2485, 2477, 2426, 3867, 1773,

        0, 2462, 2426, 2430, 2480,    0, 1550, 1815, 1785, 2457,
     2450, 3867, 1333, 1245, 2411,  932, 1883, 2416, 2414, 1957,
     1275, 2387, 2336, 2362, 2383, 1775, 1366,    0, 2357,    0,
     2319, 2323, 1251, 2027, 1553, 1254,  824, 2095, 1362, 2170,
     2315, 2313, 2370, 2368, 3867, 3867,    0, 1776, 2303, 2306,
     2297,    0, 1778, 2299, 2298, 1790, 1816, 2347, 1796, 1239,
     1324, 2304, 1327, 2353,    0, 1551, 2295, 2299, 2245, 2320,
        0, 2350, 3867,    0, 1813, 2289, 2184, 1286, 1819, 1491,
     1326, 1535, 2395, 1591,    0,    0, 1586,    0, 2188, 2044,
        0,    0, 3867, 2028, 2032, 2038, 1594, 2026, 2026, 1199,

     2022, 1316, 1552, 2026, 1786, 2014, 2011,    0, 2071, 2070,
     2012, 2019, 1846, 1325, 1121, 1784,    0,    0,    0, 2006,
     2003, 2003, 2060, 1994, 2028, 3867, 1993, 2004, 1998, 1972,
     1945, 1555, 1982, 1590, 2033, 3867, 1929, 1936, 1974, 1981,
     1916, 2031, 1788, 2469, 2035, 1923, 1930,    0, 1830, 1918,
     1912, 1911, 1918, 1911, 1908, 2470, 1539, 1761, 1936, 1592,
     1971, 1906, 3867, 1960, 2039, 1909, 2471, 1967, 1902, 3867,
     2041, 1900, 1902, 2354, 1908, 1897, 1544, 1736, 1980, 2007,
     1902, 2042, 1898, 1900, 1816, 2538, 2570, 1823, 3867, 1829,
     1805, 1818, 2026, 2315, 1802, 2638, 1798, 1747, 3867, 2338,

     1772, 1741, 1716, 1716, 1718, 2713, 2490, 2788, 2472, 1588,
     1677, 2863, 2938, 1564, 1560, 1558, 1789, 2506, 1555, 1562,
     1847,    0, 1850, 1501, 1414, 1325, 2317, 1286, 1259, 1244,
     1175, 2318, 1102, 1042,  998,  907, 3013,  891,  801, 3867,
     2319, 2451,  730,  687, 2456,  646,  546, 2459,  481,  407,
      311,   49, 3867, 3088, 3109, 3130, 3151, 3171, 3190, 3210,
     3231, 3242, 3252, 3272, 3292, 3311, 3331, 3352, 3373, 3385,
     3402, 3407, 3427, 3448, 3469, 3489, 3508, 3528, 3549, 1847,
     3569, 3590, 3603, 3622, 3641, 1861, 3661, 3671, 3691, 3711,
     3730, 3745, 3765, 3785, 3805, 3825, 3845

    } ;

static const flex_int16_t yy_def[798] =
    {   0,
      753,    1,  753,    3,  754,  754,  753,    7,  753,    9,
      755,  755,  753,   13,  756,  756,  754,  754,  757,  757,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  758,  758,  758,  753,  753,
      753,  758,  753,   53,   53,   53,   53,  753,  753,  753,
      753,  753,  753,  753,  753,   53,   53,  753,  753,  753,
      753,  753,  753,  759,  760,  760,  753,  753,  760,  760,
      760,  760,  760,  761,  753,  753,  753,  753,  762,  762,
      753,  753,  753,  753,  753,  763,  763,  763,  753,  763,

      753,  753,  753,  753,  764,  764,  764,  764,  753,  764,
      753,  764,  753,  765,  753,  753,  766,  766,  753,  119,
      119,  119,  753,  753,  119,  119,  767,  767,  767,  753,
      767,  767,  767,  767,  753,  768,  768,  768,  768,  753,
      768,  768,  768,  768,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,   38,   39,  753,  753,
      753,  753,  753,  753,  769,  753,  753,  753,   38,  753,
      753,  753,  753,  753,  753,  770,  753,  753,  753,   39,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  758,  753,  753,

      758,  771,  753,  753,  753,  758,  772,   53,   53,   53,
       53,  758,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,   53,  773,  753,  753,  753,  753,  759,
      760,  760,  760,  760,  760,  774,  760,  760,  760,  760,
      753,  753,  762,  762,  753,  753,  753,  763,  763,  763,
      753,  753,  753,  753,  764,  764,  764,  764,  775,  764,
      764,  764,  764,  753,  753,  753,  753,  776,  777,  753,
      765,  118,  753,  118,  118,  119,  119,  119,  119,  753,
      753,  119,  773,  767,  767,  767,  767,  767,  778,  767,
      767,  767,  767,  768,  768,  768,  768,  768,  779,  768,

      768,  768,  768,  753,  753,  753,  753,  769,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  780,  770,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  781,  782,  753,  758,  783,
      753,  351,  351,  753,  753,  773,  753,  753,  351,  773,
      773,  773,  753,  774,  760,  760,  760,  760,  760,  760,
      760,  760,  753,  762,  753,  753,  753,  775,  764,  764,
      764,  764,  764,  764,  764,  764,  776,  776,  777,  777,
      784,  785,  118,  119,  119,  119,  119,  773,  778,  767,

      767,  767,  767,  767,  767,  767,  779,  768,  768,  768,
      768,  768,  768,  768,  753,  753,  753,  753,  753,  753,
      753,  753,  780,  786,  780,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  781,  753,
      440,  440,  787,  758,  783,  351,  351,  351,  753,  351,
      753,  773,  760,  760,  760,  762,  753,  753,  764,  777,
      784,  784,  785,  753,  464,  464,  118,  119,  119,  119,
      119,  753,  767,  767,  768,  768,  768,  753,  753,  753,
      753,  753,  753,  753,  753,  786,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,

      440,  753,  440,  440,  787,  788,  758,  753,  753,  753,
      753,  753,  351,  351,  753,  351,  753,  517,  517,  773,
      773,  760,  762,  753,  764,  753,  777,  464,  753,  464,
      464,  464,  118,  753,  119,  119,  119,  753,  773,  753,
      540,  540,  767,  768,  753,  753,  789,  753,  753,  440,
      440,  788,  758,  753,  753,  753,  753,  753,  753,  351,
      351,  753,  351,  773,  517,  773,  517,  517,  753,  773,
      760,  762,  753,  764,  753,  464,  464,  118,  753,  119,
      119,  119,  753,  538,  538,  540,  773,  540,  540,  540,
      767,  768,  753,  753,  440,  440,  758,  753,  753,  753,

      753,  351,  351,  753,  351,  517,  517,  569,  773,  790,
      464,  464,  118,  119,  119,  119,  538,  583,  583,  540,
      540,  753,  440,  440,  753,  753,  753,  753,  753,  753,
      753,  351,  791,  753,  753,  753,  517,  517,  792,  464,
      464,  753,  119,  791,  753,  540,  540,  793,  794,  440,
      753,  753,  753,  753,  753,  791,  791,  791,  791,  753,
      517,  517,  753,  792,  794,  464,  791,  540,  540,  753,
      794,  788,  440,  753,  753,  795,  795,  795,  791,  791,
      517,  794,  464,  540,  788,  440,  753,  753,  753,  753,
      753,  753,  791,  791,  517,  464,  540,  788,  753,  753,

      753,  753,  753,  753,  753,  791,  791,  517,  753,  796,
      753,  540,  788,  753,  753,  753,  791,  791,  753,  773,
      773,  538,  773,  753,  753,  753,  791,  753,  753,  753,
      753,  791,  753,  795,  795,  753,  706,  797,  753,  753,
      791,  791,  753,  753,  791,  753,  753,  791,  753,  795,
      737,  797,    0,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753

    } ;

static const flex_int16_t yy_nxt[3943] =
    {   0,
       22,   23,   24,   25,   26,   27,   22,   28,   29,   26,
       30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
       39,   39,   39,   40,   41,   42,   43,   44,   45,   22,
       46,   46,   46,   46,   46,   46,   47,   46,   48,   47,
       46,   46,   46,   49,   22,   50,   51,   52,   22,   53,
       54,   55,   56,   54,   54,   54,   54,   54,   54,   54,
       54,   54,   54,   54,   54,   54,   57,   54,   54,   54,
       54,   58,   59,   60,   61,   62,  150,   76,   77,   63,
       78,   64,  101,   79,   76,   77,  102,   78,  103,  203,
       79,   23,   24,   80,  151,  193,  194,  106,  195,   81,

       80,   82,   65,  196,   83,  753,   81,  107,   82,  104,
      197,   83,  153,  108,  109,  110,  111,  188,  112,  147,
       84,  164,  148,  149,  186,  154,  165,   84,  187,  195,
       66,  204,  199,  226,  223,  166,   67,   22,   23,   24,
       22,   22,   22,   22,   68,   22,   22,   69,   22,   22,
       22,   22,   22,   22,   70,   22,   22,   22,   22,   22,
       71,   22,   72,   22,   22,   73,   22,   74,   74,   74,
       74,   74,   74,   74,   74,   74,   74,   74,   74,   74,
       22,   22,   22,   22,   74,   22,   74,   74,   74,   74,
       74,   74,   74,   74,   74,   74,   74,   74,   74,   74,

       74,   74,   74,   74,   74,   74,   74,   74,   22,   22,
       22,   22,   22,   23,   24,   22,   22,   22,   22,   68,
       22,   22,   85,   86,   22,   22,   87,   22,   88,   70,
       22,   22,   22,   22,   22,   71,   22,   72,   22,   22,
       73,   22,   89,   89,   89,   89,   89,   89,   89,   89,
       89,   89,   89,   89,   89,   22,   22,   22,   22,   89,
       22,   89,   89,   89,   90,   89,   89,   89,   89,   89,
       89,   89,   89,   89,   89,   89,   89,   89,   89,   89,
       89,   89,   89,   22,   22,   22,   22,   22,   23,   24,
       25,   26,   91,   92,   93,   29,   26,   30,   31,   32,

       33,   34,   35,   36,   37,   38,   39,   39,   39,   39,
       40,   41,   42,   43,   44,   94,   95,   96,   96,   96,
       96,   96,   96,   97,   96,   98,   97,   96,   96,   96,
       49,   22,   50,   51,   96,   99,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,  100,   96,   96,   96,   96,   58,   59,
       60,   61,   23,   24,  211,  210,  264,  657,  106,  155,
      156,  208,  157,  158,  158,  158,  158,  208,  107,  222,
      159,  160,  148,  149,  108,  109,  110,  111,  265,  112,
       22,  113,   24,   22,   22,   22,   22,   68,   22,   22,

       22,   22,  114,   22,   22,   22,   22,   70,   22,   22,
       22,   22,   22,  115,  116,   72,   22,   22,   73,   22,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      117,  117,  117,   22,   22,   22,   22,  118,   22,  119,
      120,  121,  122,  120,  120,  120,  120,  120,  120,  120,
      120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
      120,   22,   22,   22,   22,  123,  128,   77,  220,  124,
      128,   77,  129,  753,  130,  147,  129,  197,  130,  149,
      200,  220,  131,  213,  188,  200,  131,  233,  132,  225,
      133,  234,  132,  134,  133,   76,   77,  134,  135,  199,

      189,   79,  190,  191,  278,  197,  197,  164,  202,   84,
      276,   80,  165,   84,  201,   76,   77,   81,  135,   82,
      125,   79,   83,  221,  137,  138,  126,  199,  199,  214,
      139,   80,  228,  752,  140,  206,  221,   81,   84,   82,
      141,  229,   83,  137,  138,  224,  142,  238,  143,  139,
      235,  144,  208,  140,  208,  236,  215,  261,   84,  141,
      216,  195,  217,  239,  200,  142,  247,  143,  161,  200,
      144,  279,  162,  262,  163,  163,  163,  163,  163,  167,
      200,  212,  200,  218,  276,  200,  168,  200,  169,  169,
      169,  170,  170,  246,  283,  195,  148,  149,  201,  250,

      254,  171,  330,  172,  253,  750,  173,  148,  149,  174,
      175,  176,  177,  331,  249,  251,  249,  219,  256,  252,
      171,  217,  257,  172,  258,  228,  208,  173,  269,  259,
      282,  286,  187,  266,  229,  287,  174,  276,  178,  176,
      177,  179,  218,  296,  267,  280,  291,  297,  168,  281,
      180,  180,  180,  180,  180,  265,  288,  301,  270,  276,
      321,  289,  292,  310,  310,  172,  197,  265,  181,  271,
      329,  182,  183,  302,  184,  272,  272,  272,  272,  272,
      273,  298,  309,  309,  309,  172,  299,  321,  199,  181,
      270,  163,  163,  163,  163,  163,  197,  329,  182,  749,

      185,  271,  184,  197,  203,  308,  219,  272,  272,  272,
      272,  272,  273,  274,  345,  351,  208,  207,  199,  275,
      198,  198,  198,  198,  198,  199,  322,  322,  322,  322,
      322,  220,  198,  198,  198,  198,  198,  198,  198,  198,
      198,  198,  198,  198,  198,  308,  204,  747,  393,  198,
      314,  208,  208,  208,  208,  208,  208,  208,  208,  208,
      208,  208,  208,  208,  208,  208,  208,  208,  209,  208,
      208,  208,  208,  270,  311,  332,  311,  314,  753,  312,
      312,  312,  312,  312,  271,  353,  221,  207,  753,  746,
      272,  272,  272,  272,  272,  273,  197,  753,  197,  333,

      208,  202,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  433,  753,  434,  199,  274,
      199,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  277,  276,
      276,  276,  276,  163,  163,  163,  163,  163,  163,  163,
      163,  163,  163,  220,  359,  352,  228,  744,  306,  307,
      349,  307,  208,  306,  307,  229,  307,  225,  168,  208,
      170,  170,  170,  170,  170,  264,  582,  313,  306,  307,
      314,  266,  307,  306,  307,  172,  220,  307,  315,  361,
      276,  266,  316,  323,  317,  325,  324,  265,  313,  326,

      317,  327,  396,  265,  395,  172,  215,  314,  221,  315,
      216,  276,  217,  265,  323,  362,  325,  276,  337,  308,
      318,  317,  317,  324,  338,  339,  340,  328,  197,  327,
      341,  200,  342,  218,  394,  276,  200,  337,  397,  324,
      343,  221,  344,  338,  339,  340,  294,  743,  308,  341,
      199,  342,  200,  276,  308,  308,  337,  200,  327,  343,
      358,  344,  338,  363,  340,  201,  324,  219,  341,  365,
      342,  308,  739,  308,  330,  366,  367,  368,  343,  327,
      344,  369,  337,  370,  563,  331,  249,  332,  338,  339,
      340,  371,  208,  372,  341,  251,  342,  448,  270,  252,

      208,  217,  337,  208,  343,  376,  344,  447,  338,  339,
      340,  333,  389,  753,  341,  450,  342,  274,  208,  266,
      273,  379,  218,  390,  343,  377,  344,  380,  381,  382,
      271,  266,  283,  383,  265,  384,  387,  387,  387,  387,
      387,  265,  753,  385,  280,  386,  345,  467,  281,  400,
      436,  427,  468,  265,  398,  338,  401,  402,  276,  439,
      197,  403,  408,  404,  753,  753,  265,  308,  409,  410,
      340,  405,  483,  406,  411,  427,  412,  437,  452,  453,
      362,  454,  199,  415,  413,  415,  414,  451,  416,  416,
      416,  416,  416,  483,  417,  312,  312,  312,  312,  312,

      433,  753,  459,  310,  310,  219,  167,  308,  753,  441,
      312,  312,  312,  312,  312,  309,  309,  309,  442,  444,
      308,  418,  644,  472,  419,  420,  307,  421,  307,  469,
      389,  276,  443,  173,  208,  470,  174,  175,  308,  177,
      516,  390,  418,  308,  276,  308,  307,  266,  471,  307,
      463,  419,  265,  422,  173,  421,  738,  276,  753,  266,
      473,  390,  474,  174,  475,  178,  476,  177,  424,  265,
      271,  266,  265,  308,  294,  425,  387,  387,  387,  387,
      387,  265,  271,  308,  478,  478,  266,  276,  387,  387,
      387,  387,  387,  265,  485,  426,  427,  460,  428,  429,

      465,  430,  427,  461,  461,  461,  461,  461,  265,  466,
      416,  416,  416,  416,  416,  479,  426,  495,  480,  436,
      427,  485,  753,  443,  736,  428,  427,  431,  197,  430,
      179,  416,  416,  416,  416,  416,  479,  274,  536,  322,
      322,  322,  322,  322,  495,  480,  437,  307,  481,  307,
      199,  514,  482,  487,  483,  276,  488,  181,  493,  208,
      182,  183,  208,  184,  513,  533,  629,  307,  630,  481,
      307,  535,  276,  480,  487,  488,  753,  508,  181,  493,
      484,  274,  483,  488,  509,  507,  521,  182,  489,  185,
      489,  184,  197,  490,  490,  490,  490,  490,  602,  208,

      480,  510,  488,  735,  511,  208,  207,  578,  561,  198,
      198,  198,  198,  198,  199,  439,  274,  581,  734,  512,
      276,  198,  198,  198,  198,  198,  198,  198,  198,  198,
      198,  198,  198,  198,  559,  570,  208,  613,  198,  733,
      208,  208,  208,  208,  208,  208,  208,  208,  208,  208,
      208,  446,  208,  208,  208,  208,  208,  208,  208,  208,
      208,  208,  491,  753,  266,  441,  492,  266,  493,  490,
      490,  490,  490,  490,  442,  753,  208,  603,  753,  615,
      605,  632,  560,  491,  208,  584,  265,  208,  443,  265,
      643,  276,  276,  208,  494,  731,  493,  499,  500,  499,

      499,  499,  499,  499,  499,  499,  499,  499,  499,  499,
      499,  499,  499,  499,  499,  501,  501,  501,  501,  501,
      502,  499,  499,  499,  499,  499,  499,  501,  501,  501,
      501,  501,  501,  501,  501,  501,  501,  501,  501,  501,
      499,  499,  499,  499,  501,  499,  501,  501,  501,  501,
      501,  501,  501,  501,  501,  501,  501,  501,  501,  501,
      501,  501,  501,  501,  501,  501,  501,  501,  499,  499,
      499,  499,  360,  439,  730,  360,  360,  360,  360,  360,
      360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
      360,  360,  360,  360,  360,  360,  360,  360,  360,  360,

      360,  360,  517,  517,  517,  517,  517,  517,  517,  517,
      517,  517,  517,  517,  517,  360,  360,  360,  360,  517,
      360,  517,  517,  518,  517,  517,  517,  517,  517,  517,
      517,  517,  519,  517,  517,  517,  517,  517,  517,  517,
      517,  517,  517,  360,  360,  360,  520,  266,  534,  463,
      614,  197,  753,  633,  579,  509,  559,  276,  460,  266,
      390,  729,  753,  753,  461,  461,  461,  461,  461,  265,
      460,  265,  510,  199,  451,  511,  461,  461,  461,  461,
      461,  265,  490,  490,  490,  490,  490,  753,  616,  266,
      512,  660,  389,  660,  636,  625,  636,  691,  307,  465,

      307,  276,  580,  538,  626,  659,  553,  728,  466,  472,
      753,  265,  208,  276,  726,  208,  725,  199,  307,  276,
      724,  307,  443,  499,  526,  499,  499,  499,  499,  499,
      499,  499,  499,  499,  499,  527,  499,  499,  499,  499,
      499,  528,  528,  528,  528,  528,  529,  499,  499,  499,
      499,  499,  499,  530,  530,  530,  530,  530,  530,  530,
      530,  530,  530,  530,  530,  530,  499,  499,  499,  499,
      530,  499,  530,  530,  530,  530,  530,  530,  530,  530,
      530,  530,  530,  530,  530,  530,  530,  530,  530,  530,
      530,  530,  530,  530,  499,  499,  499,  499,  360,  463,

      392,  360,  360,  360,  360,  360,  360,  360,  360,  360,
      538,  360,  360,  360,  360,  360,  360,  360,  360,  360,
      360,  539,  360,  360,  360,  360,  360,  360,  540,  540,
      540,  540,  540,  540,  540,  540,  540,  540,  540,  540,
      540,  360,  360,  360,  360,  540,  360,  540,  540,  541,
      540,  540,  540,  540,  540,  540,  540,  540,  542,  540,
      540,  540,  540,  540,  540,  540,  540,  540,  540,  360,
      360,  360,  520,  417,  548,  716,  575,  548,  424,  197,
      715,  714,  478,  478,  753,  645,  556,  635,  636,  579,
      636,  556,  692,  557,  674,  346,  199,  559,  273,  199,

      418,  199,  753,  419,  420,  426,  421,  713,  428,  429,
      510,  430,  753,  511,  575,  510,  508,  556,  511,  199,
      579,  418,  549,  509,  549,  549,  426,  679,  512,  597,
      419,  671,  422,  512,  421,  428,  273,  431,  199,  430,
      510,  510,  273,  511,  511,  345,  208,  642,  753,  600,
      276,  753,  601,  199,  276,  659,  626,  423,  512,  512,
      423,  712,  549,  423,  345,  708,  554,  705,  345,  704,
      451,  486,  600,  472,  486,  601,  274,  486,  703,  672,
      702,  698,  555,  564,  500,  499,  564,  564,  564,  564,
      564,  564,  564,  564,  564,  564,  564,  564,  564,  564,

      564,  565,  565,  565,  565,  565,  566,  564,  564,  564,
      564,  564,  564,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  564,  564,  564,  564,
      565,  564,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  564,  564,  564,  564,  505,  753,
      697,  696,  695,  690,  688,  686,  685,  684,  665,  683,
      663,  681,  649,  678,  677,  676,  675,  674,  673,  669,
      668,  666,  665,  656,  663,  662,  661,  569,  569,  569,
      569,  569,  569,  569,  569,  569,  569,  569,  569,  569,

      680,  655,  659,  753,  569,  199,  569,  569,  569,  569,
      569,  569,  569,  569,  569,  569,  569,  569,  569,  569,
      569,  569,  569,  569,  569,  569,  569,  569,  534,  625,
      753,  658,  642,  654,  635,  509,  645,  636,  626,  636,
      682,  626,  671,  682,  680,  693,  659,  653,  659,  753,
      273,  199,  510,  652,  273,  511,  199,  651,  273,  650,
      694,  649,  273,  648,  199,  273,  647,  646,  641,  640,
      512,  610,  753,  659,  638,  637,  345,  345,  554,  634,
      345,  631,  345,  628,  345,  627,  706,  624,  672,  623,
      672,  672,  659,  622,  555,  360,  266,  621,  360,  360,

      360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
      360,  360,  360,  360,  360,  360,  360,  360,  539,  360,
      360,  360,  360,  360,  360,  583,  583,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  583,  583,  360,  360,
      360,  360,  583,  360,  583,  583,  583,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  360,  360,  360,  360,
      564,  526,  499,  564,  564,  564,  564,  564,  564,  564,
      564,  564,  585,  564,  564,  564,  564,  564,  586,  586,
      586,  586,  586,  587,  564,  564,  564,  564,  564,  564,

      588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
      588,  588,  588,  564,  564,  564,  564,  588,  564,  588,
      588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
      588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
      588,  564,  564,  564,  564,  360,  620,  612,  360,  360,
      360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
      360,  360,  360,  608,  608,  608,  608,  608,  360,  360,
      360,  360,  360,  360,  360,  608,  608,  608,  608,  608,
      608,  608,  608,  608,  608,  608,  608,  608,  360,  360,
      360,  360,  608,  360,  608,  608,  608,  608,  608,  608,

      608,  608,  608,  608,  608,  608,  608,  608,  608,  608,
      608,  608,  608,  608,  608,  608,  360,  360,  360,  360,
      609,  593,  593,  609,  609,  609,  609,  609,  609,  609,
      609,  609,  609,  609,  609,  609,  609,  609,  753,  548,
      753,  753,  753,  609,  609,  609,  609,  609,  609,  609,
      611,  610,  607,  606,  753,  687,  604,  512,  599,  598,
      596,  199,  509,  609,  609,  609,  609,  595,  609,  594,
      732,  592,  737,  591,  590,  589,  577,  576,  707,  510,
      392,  659,  511,  659,  659,  659,  574,  549,  573,  572,
      571,  609,  609,  609,  609,  360,  266,  512,  360,  360,

      360,  360,  360,  360,  360,  360,  360,  617,  360,  360,
      360,  360,  360,  618,  618,  618,  618,  618,  539,  360,
      360,  360,  360,  360,  360,  619,  619,  619,  619,  619,
      619,  619,  619,  619,  619,  619,  619,  619,  360,  360,
      360,  360,  619,  360,  619,  619,  619,  619,  619,  619,
      619,  619,  619,  619,  619,  619,  619,  619,  619,  619,
      619,  619,  619,  619,  619,  619,  360,  360,  360,  360,
      667,  656,  667,  575,  753,  568,  567,  562,  558,  753,
      512,  505,  753,  551,  550,  346,  547,  546,  545,  493,
      493,  718,  273,  199,  273,  273,  483,  483,  544,  543,

      537,  532,  531,  525,  524,  719,  523,  718,  522,  748,
      745,  751,  515,  753,  753,  505,  504,  659,  658,  658,
      658,  549,  659,  503,  498,  659,  497,  496,  488,  753,
      488,  480,  480,  477,  435,  659,  659,  659,  699,  700,
      699,  699,  699,  699,  699,  699,  699,  699,  699,  699,
      699,  699,  699,  699,  699,  699,  659,  458,  727,  458,
      457,  701,  699,  699,  699,  699,  699,  699,  456,  455,
      753,  687,  659,  449,  356,  358,  445,  348,  509,  438,
      435,  699,  699,  699,  699,  432,  699,  327,  327,  317,
      317,  295,  285,  276,  274,  510,  392,  274,  511,  269,

      375,  202,  375,  374,  373,  232,  357,  356,  355,  699,
      699,  699,  699,  512,  354,  208,  348,  346,  336,  335,
      334,  554,  324,  324,  314,  319,  314,  305,  304,  145,
      303,  300,  295,  293,  290,  285,  276,  555,  699,  709,
      699,  699,  699,  699,  699,  699,  699,  699,  699,  699,
      710,  699,  699,  699,  699,  699,  263,  260,  245,  202,
      245,  711,  699,  699,  699,  699,  699,  699,  244,  242,
      240,  237,  232,  227,  187,  208,  205,  192,  152,  146,
      145,  699,  699,  699,  699,  753,  699,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,

      753,  753,  753,  753,  753,  753,  753,  753,  753,  699,
      699,  699,  699,  593,  717,  593,  593,  593,  593,  593,
      593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
      593,  753,  753,  753,  753,  753,  593,  593,  593,  593,
      593,  593,  593,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  593,  593,  593,  593,
      753,  593,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  659,
      753,  753,  753,  753,  593,  593,  593,  593,  720,  700,
      699,  720,  720,  720,  720,  720,  720,  720,  720,  720,

      720,  720,  720,  720,  720,  720,  753,  753,  753,  753,
      753,  721,  720,  720,  720,  720,  720,  720,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  720,  720,  720,  720,  753,  720,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  720,
      720,  720,  720,  720,  709,  699,  720,  720,  720,  720,
      720,  720,  720,  720,  720,  722,  720,  720,  720,  720,
      720,  753,  753,  753,  753,  753,  723,  720,  720,  720,
      720,  720,  720,  753,  753,  753,  753,  753,  753,  753,

      753,  753,  753,  753,  753,  753,  720,  720,  720,  720,
      753,  720,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  720,  720,  720,  720,  670,  670,
      670,  670,  670,  670,  670,  670,  670,  670,  670,  670,
      670,  670,  670,  670,  670,  670,  753,  753,  753,  753,
      753,  670,  670,  670,  670,  670,  670,  670,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  670,  670,  670,  670,  753,  670,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,

      753,  753,  753,  753,  753,  753,  753,  753,  753,  670,
      670,  670,  670,  740,  741,  740,  740,  740,  740,  740,
      740,  740,  740,  740,  740,  740,  740,  740,  740,  740,
      740,  753,  753,  753,  753,  753,  740,  740,  740,  740,
      740,  740,  740,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  740,  740,  740,  740,
      753,  740,  753,  753,  753,  753,  753,  753,  753,  742,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  740,  740,  740,  740,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,

       75,   75,   75,   75,   75,   75,   75,   75,   75,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      127,  127,  127,  127,  127,  127,  127,  127,  127,  127,
      127,  127,  127,  127,  127,  127,  127,  127,  127,  127,
      127,  136,  136,  136,  136,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
      136,  136,  198,  753,  753,  753,  753,  753,  753,  753,
      753,  198,  198,  753,  198,  198,  753,  198,  198,  198,
      198,  230,  753,  753,  753,  230,  753,  753,  753,  753,

      230,  753,  753,  230,  230,  753,  230,  230,  230,  230,
      231,  231,  753,  753,  231,  231,  231,  231,  231,  231,
      231,  231,  231,  231,  231,  753,  231,  231,  231,  231,
      231,  241,  241,  241,  241,  241,  241,  241,  241,  241,
      241,  241,  241,  241,  241,  241,  241,  241,  241,  241,
      241,  241,  243,  753,  753,  243,  243,  753,  243,  243,
      243,  243,  248,  753,  753,  248,  248,  753,  248,  248,
      248,  248,  255,  753,  753,  255,  255,  255,  255,  255,
      255,  255,  255,  255,  753,  255,  255,  255,  255,  255,
      255,  255,  255,  268,  753,  753,  753,  753,  753,  268,

      753,  753,  753,  268,  753,  268,  268,  753,  268,  268,
      268,  268,  274,  753,  753,  753,  753,  753,  274,  753,
      753,  274,  274,  753,  274,  274,  753,  274,  274,  274,
      274,  284,  284,  753,  284,  753,  284,  284,  284,  284,
      284,  284,  284,  284,  284,  284,  753,  284,  284,  284,
      284,  284,  294,  294,  294,  294,  294,  294,  753,  294,
      294,  294,  294,  294,  294,  294,  294,  294,  294,  294,
      294,  294,  294,  308,  308,  753,  308,  308,  308,  308,
      308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
      308,  308,  308,  308,  320,  320,  753,  753,  320,  753,

      753,  320,  347,  753,  753,  347,  347,  347,  753,  347,
      347,  347,  347,  347,  347,  347,  347,  753,  347,  347,
      347,  347,  347,  350,  350,  350,  350,  360,  360,  753,
      360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
      360,  360,  360,  360,  360,  360,  360,  360,  364,  364,
      753,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  378,
      378,  753,  378,  378,  378,  378,  378,  378,  378,  378,
      378,  378,  378,  378,  378,  378,  378,  378,  378,  378,
      388,  753,  753,  753,  753,  753,  388,  753,  753,  388,

      388,  753,  388,  388,  753,  388,  388,  388,  388,  391,
      753,  753,  753,  753,  753,  391,  753,  753,  753,  391,
      753,  391,  391,  753,  391,  391,  391,  391,  399,  399,
      753,  399,  399,  399,  399,  399,  399,  399,  399,  399,
      399,  399,  399,  399,  399,  399,  399,  399,  399,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      440,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  440,  440,  753,  440,  440,  440,  440,  440,
      347,  753,  753,  347,  347,  347,  753,  347,  347,  347,

      347,  347,  347,  347,  347,  753,  347,  347,  347,  347,
      347,  350,  753,  753,  753,  753,  753,  753,  753,  350,
      350,  350,  350,  462,  753,  753,  753,  753,  753,  462,
      753,  753,  462,  462,  753,  462,  462,  753,  462,  462,
      462,  462,  464,  753,  753,  753,  753,  753,  464,  753,
      753,  753,  464,  753,  464,  464,  753,  464,  464,  464,
      464,  464,  506,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  506,  506,  753,  506,  506,  506,
      506,  552,  753,  753,  552,  552,  753,  552,  552,  552,
      552,  593,  593,  593,  593,  593,  593,  593,  593,  593,

      593,  753,  593,  593,  753,  753,  593,  753,  753,  753,
      753,  593,  639,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  639,  639,  753,  639,  639,  639,
      639,  657,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  657,  753,  657,  657,  753,  657,  657,  657,  657,
      664,  753,  753,  753,  753,  664,  753,  753,  664,  664,
      753,  664,  664,  664,  664,  670,  670,  670,  670,  670,
      670,  670,  670,  670,  670,  753,  670,  670,  753,  753,
      670,  753,  753,  753,  753,  670,  506,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  506,  753,  506,  506,

      753,  506,  506,  506,  506,  689,  689,  689,  689,  689,
      689,  689,  689,  689,  689,  753,  689,  689,  753,  753,
      689,  753,  753,  753,  689,  689,  391,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  391,  753,  391,  391,
      753,  391,  391,  391,  391,  740,  740,  740,  740,  740,
      740,  740,  740,  740,  740,  753,  740,  740,  753,  753,
      740,  753,  753,  740,  753,  740,   21,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,

      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753
    } ;

static const flex_int16_t yy_chk[3943] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    2,   29,    5,    5,    2,
        5,    2,   10,    5,    6,    6,   10,    6,   10,   49,
        6,   11,   11,    5,   29,   44,   44,   11,   45,    5,

        6,    5,    2,   45,    5,  752,    6,   11,    6,   10,
       46,    6,   33,   11,   11,   11,   11,   72,   11,   28,
        5,   37,   28,   28,   40,   33,   37,    6,   40,   65,
        2,   49,   46,   72,   65,   37,    2,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,

        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,

        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,   12,   12,   56,   55,  113,  751,   12,   35,
       35,   55,   35,   35,   35,   35,   35,   56,   12,   64,
       35,   35,   64,   64,   12,   12,   12,   12,  113,   12,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,

       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   14,   15,   15,   63,   14,
       16,   16,   15,  750,   15,   68,   16,   47,   16,   68,
       47,  124,   15,   59,   42,   47,   16,   79,   15,   67,
       15,   79,   16,   15,   16,   17,   17,   16,   17,   47,

       42,   17,   42,   42,  121,   48,   52,   70,   48,   15,
      121,   17,   70,   16,   47,   18,   18,   17,   18,   17,
       14,   18,   17,   63,   19,   19,   14,   48,   52,   59,
       19,   18,   74,  749,   19,   52,  124,   18,   17,   18,
       19,   74,   18,   20,   20,   66,   19,   82,   19,   20,
       80,   19,   66,   20,   67,   80,   62,  110,   18,   20,
       62,   94,   62,   82,   57,   20,   94,   20,   36,   57,
       20,  122,   36,  110,   36,   36,   36,   36,   36,   38,
       97,   57,  100,   62,  122,   97,   38,  100,   38,   38,
       38,   38,   38,   93,  126,  104,   93,   93,   57,  100,

      104,   38,  186,   38,  103,  747,   38,  103,  103,   38,
       38,   38,   38,  186,   97,  101,  100,   62,  106,  101,
       38,  101,  106,   38,  107,  228,   57,   38,  115,  107,
      125,  129,  115,  114,  228,  129,   38,  125,   38,   38,
       38,   39,  101,  139,  114,  123,  133,  139,   39,  123,
       39,   39,   39,   39,   39,  114,  131,  143,  117,  126,
      177,  131,  133,  171,  171,   39,  197,  123,   39,  117,
      184,   39,   39,  143,   39,  117,  117,  117,  117,  117,
      117,  141,  167,  167,  167,   39,  141,  177,  197,   39,
      118,  156,  156,  156,  156,  156,  198,  184,   39,  746,

       39,  118,   39,   53,  203,  236,  123,  118,  118,  118,
      118,  118,  118,  275,  197,  209,  209,   53,  198,  118,
       53,   53,   53,   53,   53,   53,  179,  179,  179,  179,
      179,  216,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,  236,  203,  744,  275,   53,
      313,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,  119,  172,  189,  172,  313,  169,  172,
      172,  172,  172,  172,  119,  211,  216,  119,  169,  743,
      119,  119,  119,  119,  119,  119,  206,  169,  201,  189,

      211,  201,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  119,  119,  337,  169,  337,  206,  119,
      201,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  163,  163,  163,  163,  163,  168,  168,
      168,  168,  168,  220,  224,  210,  230,  739,  163,  163,
      206,  163,  210,  168,  168,  230,  168,  225,  170,  224,
      170,  170,  170,  170,  170,  264,  537,  173,  163,  163,
      173,  266,  163,  168,  168,  170,  281,  168,  174,  225,
      537,  267,  174,  181,  174,  182,  181,  264,  173,  182,

      315,  182,  279,  266,  278,  170,  215,  173,  220,  174,
      215,  278,  215,  267,  181,  225,  182,  279,  196,  289,
      174,  315,  174,  181,  196,  196,  196,  182,  212,  182,
      196,  212,  196,  215,  277,  277,  212,  223,  282,  323,
      196,  281,  196,  223,  223,  223,  299,  738,  259,  223,
      212,  223,  250,  282,  289,  299,  227,  250,  325,  223,
      223,  223,  227,  227,  227,  212,  323,  215,  227,  240,
      227,  259,  736,  259,  330,  240,  240,  240,  227,  325,
      227,  240,  247,  240,  516,  330,  250,  332,  247,  247,
      247,  240,  516,  240,  247,  251,  247,  353,  270,  251,

      353,  251,  254,  352,  247,  247,  247,  352,  254,  254,
      254,  332,  269,  362,  254,  359,  254,  393,  359,  268,
      270,  263,  251,  269,  254,  254,  254,  263,  263,  263,
      268,  271,  283,  263,  269,  263,  268,  268,  268,  268,
      268,  268,  271,  263,  280,  263,  270,  393,  280,  293,
      339,  423,  394,  271,  283,  293,  293,  293,  394,  346,
      349,  293,  303,  293,  735,  361,  280,  364,  303,  303,
      303,  293,  481,  293,  303,  423,  303,  339,  362,  365,
      283,  365,  349,  306,  303,  306,  303,  361,  306,  306,
      306,  306,  306,  481,  310,  311,  311,  311,  311,  311,

      379,  398,  379,  310,  310,  280,  309,  364,  734,  346,
      312,  312,  312,  312,  312,  309,  309,  309,  346,  349,
      378,  310,  615,  398,  310,  310,  312,  310,  312,  395,
      389,  395,  346,  309,  450,  396,  309,  309,  399,  309,
      450,  389,  310,  378,  396,  378,  312,  390,  397,  312,
      392,  310,  389,  310,  309,  310,  733,  397,  390,  387,
      400,  392,  400,  309,  408,  309,  408,  309,  320,  390,
      387,  388,  392,  399,  407,  320,  387,  387,  387,  387,
      387,  387,  388,  407,  417,  417,  391,  615,  388,  388,
      388,  388,  388,  388,  421,  320,  320,  391,  320,  320,

      392,  320,  425,  391,  391,  391,  391,  391,  391,  392,
      415,  415,  415,  415,  415,  418,  320,  430,  418,  436,
      320,  421,  452,  392,  731,  320,  425,  320,  444,  320,
      322,  416,  416,  416,  416,  416,  418,  467,  470,  322,
      322,  322,  322,  322,  430,  418,  436,  416,  419,  416,
      444,  448,  419,  426,  419,  470,  426,  322,  491,  447,
      322,  322,  448,  322,  447,  467,  600,  416,  600,  419,
      416,  469,  469,  479,  426,  487,  521,  446,  322,  491,
      419,  533,  419,  426,  446,  444,  452,  322,  427,  322,
      427,  322,  351,  427,  427,  427,  427,  427,  560,  560,

      479,  446,  487,  730,  446,  514,  351,  533,  514,  351,
      351,  351,  351,  351,  351,  439,  578,  536,  729,  446,
      536,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  513,  521,  446,  578,  351,  728,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  428,  539,  460,  439,  428,  527,  428,  489,
      489,  489,  489,  489,  439,  460,  602,  561,  527,  581,
      563,  602,  513,  428,  561,  539,  460,  563,  439,  527,
      614,  614,  581,  513,  428,  726,  428,  440,  440,  440,

      440,  440,  440,  440,  440,  440,  440,  440,  440,  440,
      440,  440,  440,  440,  440,  440,  440,  440,  440,  440,
      440,  440,  440,  440,  440,  440,  440,  440,  440,  440,
      440,  440,  440,  440,  440,  440,  440,  440,  440,  440,
      440,  440,  440,  440,  440,  440,  440,  440,  440,  440,
      440,  440,  440,  440,  440,  440,  440,  440,  440,  440,
      440,  440,  440,  440,  440,  440,  440,  440,  440,  440,
      440,  440,  451,  451,  725,  451,  451,  451,  451,  451,
      451,  451,  451,  451,  451,  451,  451,  451,  451,  451,
      451,  451,  451,  451,  451,  451,  451,  451,  451,  451,

      451,  451,  451,  451,  451,  451,  451,  451,  451,  451,
      451,  451,  451,  451,  451,  451,  451,  451,  451,  451,
      451,  451,  451,  451,  451,  451,  451,  451,  451,  451,
      451,  451,  451,  451,  451,  451,  451,  451,  451,  451,
      451,  451,  451,  451,  451,  451,  451,  461,  468,  463,
      580,  507,  566,  603,  535,  468,  632,  580,  461,  462,
      463,  724,  657,  720,  461,  461,  461,  461,  461,  461,
      462,  463,  468,  507,  566,  468,  462,  462,  462,  462,
      462,  462,  490,  490,  490,  490,  490,  587,  582,  710,
      468,  634,  584,  660,  634,  597,  660,  677,  490,  463,

      490,  582,  535,  584,  597,  657,  507,  719,  463,  587,
      677,  710,  603,  468,  716,  632,  715,  597,  490,  535,
      714,  490,  463,  464,  464,  464,  464,  464,  464,  464,
      464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
      464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
      464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
      464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
      464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
      464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
      464,  464,  464,  464,  464,  464,  464,  464,  472,  472,

      711,  472,  472,  472,  472,  472,  472,  472,  472,  472,
      472,  472,  472,  472,  472,  472,  472,  472,  472,  472,
      472,  472,  472,  472,  472,  472,  472,  472,  472,  472,
      472,  472,  472,  472,  472,  472,  472,  472,  472,  472,
      472,  472,  472,  472,  472,  472,  472,  472,  472,  472,
      472,  472,  472,  472,  472,  472,  472,  472,  472,  472,
      472,  472,  472,  472,  472,  472,  472,  472,  472,  472,
      472,  472,  472,  478,  500,  705,  526,  548,  486,  553,
      704,  703,  478,  478,  658,  616,  509,  605,  616,  643,
      605,  556,  678,  509,  702,  701,  500,  559,  526,  548,

      478,  553,  678,  478,  478,  486,  478,  698,  486,  486,
      509,  486,  717,  509,  575,  556,  508,  557,  556,  559,
      579,  478,  500,  508,  526,  548,  486,  658,  509,  553,
      478,  649,  478,  556,  478,  486,  575,  486,  508,  486,
      508,  557,  579,  508,  557,  559,  605,  613,  721,  559,
      616,  723,  559,  649,  643,  717,  613,  780,  508,  557,
      780,  697,  575,  780,  508,  695,  508,  692,  579,  691,
      721,  786,  579,  723,  786,  579,  613,  786,  690,  649,
      688,  685,  508,  517,  517,  517,  517,  517,  517,  517,
      517,  517,  517,  517,  517,  517,  517,  517,  517,  517,

      517,  517,  517,  517,  517,  517,  517,  517,  517,  517,
      517,  517,  517,  517,  517,  517,  517,  517,  517,  517,
      517,  517,  517,  517,  517,  517,  517,  517,  517,  517,
      517,  517,  517,  517,  517,  517,  517,  517,  517,  517,
      517,  517,  517,  517,  517,  517,  517,  517,  517,  517,
      517,  517,  517,  517,  517,  517,  517,  517,  520,  659,
      684,  683,  681,  676,  675,  673,  672,  669,  668,  666,
      664,  662,  661,  655,  654,  653,  652,  651,  650,  647,
      646,  641,  640,  633,  639,  638,  637,  520,  520,  520,
      520,  520,  520,  520,  520,  520,  520,  520,  520,  520,

      659,  631,  659,  679,  520,  633,  520,  520,  520,  520,
      520,  520,  520,  520,  520,  520,  520,  520,  520,  520,
      520,  520,  520,  520,  520,  520,  520,  520,  534,  625,
      680,  633,  642,  630,  635,  534,  645,  635,  625,  645,
      665,  642,  671,  682,  679,  679,  679,  629,  633,  693,
      534,  625,  534,  628,  642,  534,  635,  627,  645,  624,
      680,  623,  665,  622,  671,  682,  621,  620,  612,  611,
      534,  610,  609,  680,  607,  606,  534,  625,  534,  604,
      642,  601,  635,  599,  645,  598,  693,  596,  665,  595,
      671,  682,  693,  594,  534,  538,  538,  590,  538,  538,

      538,  538,  538,  538,  538,  538,  538,  538,  538,  538,
      538,  538,  538,  538,  538,  538,  538,  538,  538,  538,
      538,  538,  538,  538,  538,  538,  538,  538,  538,  538,
      538,  538,  538,  538,  538,  538,  538,  538,  538,  538,
      538,  538,  538,  538,  538,  538,  538,  538,  538,  538,
      538,  538,  538,  538,  538,  538,  538,  538,  538,  538,
      538,  538,  538,  538,  538,  538,  538,  538,  538,  538,
      540,  540,  540,  540,  540,  540,  540,  540,  540,  540,
      540,  540,  540,  540,  540,  540,  540,  540,  540,  540,
      540,  540,  540,  540,  540,  540,  540,  540,  540,  540,

      540,  540,  540,  540,  540,  540,  540,  540,  540,  540,
      540,  540,  540,  540,  540,  540,  540,  540,  540,  540,
      540,  540,  540,  540,  540,  540,  540,  540,  540,  540,
      540,  540,  540,  540,  540,  540,  540,  540,  540,  540,
      540,  540,  540,  540,  540,  569,  589,  577,  569,  569,
      569,  569,  569,  569,  569,  569,  569,  569,  569,  569,
      569,  569,  569,  569,  569,  569,  569,  569,  569,  569,
      569,  569,  569,  569,  569,  569,  569,  569,  569,  569,
      569,  569,  569,  569,  569,  569,  569,  569,  569,  569,
      569,  569,  569,  569,  569,  569,  569,  569,  569,  569,

      569,  569,  569,  569,  569,  569,  569,  569,  569,  569,
      569,  569,  569,  569,  569,  569,  569,  569,  569,  569,
      570,  570,  570,  570,  570,  570,  570,  570,  570,  570,
      570,  570,  570,  570,  570,  570,  570,  570,  694,  700,
      727,  732,  741,  570,  570,  570,  570,  570,  570,  570,
      576,  572,  568,  567,  564,  674,  562,  558,  555,  554,
      551,  700,  674,  570,  570,  570,  570,  550,  570,  549,
      727,  544,  732,  543,  542,  541,  532,  531,  694,  674,
      529,  694,  674,  727,  732,  741,  525,  700,  524,  523,
      522,  570,  570,  570,  570,  583,  583,  674,  583,  583,

      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      644,  656,  667,  709,  742,  519,  518,  515,  511,  745,
      510,  505,  748,  504,  503,  502,  498,  497,  496,  494,
      492,  707,  644,  656,  667,  709,  484,  482,  476,  474,

      471,  466,  465,  459,  458,  707,  456,  718,  454,  745,
      742,  748,  449,  707,  445,  443,  442,  742,  644,  656,
      667,  709,  745,  441,  438,  748,  437,  434,  431,  718,
      429,  422,  420,  409,  380,  644,  656,  667,  686,  686,
      686,  686,  686,  686,  686,  686,  686,  686,  686,  686,
      686,  686,  686,  686,  686,  686,  707,  377,  718,  376,
      375,  686,  686,  686,  686,  686,  686,  686,  374,  366,
      360,  687,  718,  357,  356,  355,  350,  347,  687,  345,
      338,  686,  686,  686,  686,  333,  686,  328,  326,  318,
      316,  295,  285,  276,  274,  687,  273,  272,  687,  265,

      253,  249,  246,  244,  242,  232,  221,  219,  218,  686,
      686,  686,  686,  687,  217,  208,  202,  199,  194,  191,
      190,  687,  185,  183,  178,  176,  175,  162,  160,  145,
      144,  142,  137,  134,  132,  128,  120,  687,  696,  696,
      696,  696,  696,  696,  696,  696,  696,  696,  696,  696,
      696,  696,  696,  696,  696,  696,  112,  108,  102,   98,
       91,  696,  696,  696,  696,  696,  696,  696,   90,   88,
       83,   81,   76,   73,   71,   54,   51,   43,   32,   25,
       23,  696,  696,  696,  696,   21,  696,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,  696,
      696,  696,  696,  706,  706,  706,  706,  706,  706,  706,
      706,  706,  706,  706,  706,  706,  706,  706,  706,  706,
      706,    0,    0,    0,    0,    0,  706,  706,  706,  706,
      706,  706,  706,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  706,  706,  706,  706,
        0,  706,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  706,
        0,    0,    0,    0,  706,  706,  706,  706,  708,  708,
      708,  708,  708,  708,  708,  708,  708,  708,  708,  708,

      708,  708,  708,  708,  708,  708,    0,    0,    0,    0,
        0,  708,  708,  708,  708,  708,  708,  708,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  708,  708,  708,  708,    0,  708,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  708,
      708,  708,  708,  712,  712,  712,  712,  712,  712,  712,
      712,  712,  712,  712,  712,  712,  712,  712,  712,  712,
      712,    0,    0,    0,    0,    0,  712,  712,  712,  712,
      712,  712,  712,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,  712,  712,  712,  712,
        0,  712,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  712,  712,  712,  712,  713,  713,
      713,  713,  713,  713,  713,  713,  713,  713,  713,  713,
      713,  713,  713,  713,  713,  713,    0,    0,    0,    0,
        0,  713,  713,  713,  713,  713,  713,  713,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  713,  713,  713,  713,    0,  713,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,  713,
      713,  713,  713,  737,  737,  737,  737,  737,  737,  737,
      737,  737,  737,  737,  737,  737,  737,  737,  737,  737,
      737,    0,    0,    0,    0,    0,  737,  737,  737,  737,
      737,  737,  737,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  737,  737,  737,  737,
        0,  737,    0,    0,    0,    0,    0,    0,    0,  737,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  737,  737,  737,  737,  754,  754,
      754,  754,  754,  754,  754,  754,  754,  754,  754,  754,

      754,  754,  754,  754,  754,  754,  754,  754,  754,  755,
      755,  755,  755,  755,  755,  755,  755,  755,  755,  755,
      755,  755,  755,  755,  755,  755,  755,  755,  755,  755,
      756,  756,  756,  756,  756,  756,  756,  756,  756,  756,
      756,  756,  756,  756,  756,  756,  756,  756,  756,  756,
      756,  757,  757,  757,  757,  757,  757,  757,  757,  757,
      757,  757,  757,  757,  757,  757,  757,  757,  757,  757,
      757,  757,  758,    0,    0,    0,    0,    0,    0,    0,
        0,  758,  758,    0,  758,  758,    0,  758,  758,  758,
      758,  759,    0,    0,    0,  759,    0,    0,    0,    0,

      759,    0,    0,  759,  759,    0,  759,  759,  759,  759,
      760,  760,    0,    0,  760,  760,  760,  760,  760,  760,
      760,  760,  760,  760,  760,    0,  760,  760,  760,  760,
      760,  761,  761,  761,  761,  761,  761,  761,  761,  761,
      761,  761,  761,  761,  761,  761,  761,  761,  761,  761,
      761,  761,  762,    0,    0,  762,  762,    0,  762,  762,
      762,  762,  763,    0,    0,  763,  763,    0,  763,  763,
      763,  763,  764,    0,    0,  764,  764,  764,  764,  764,
      764,  764,  764,  764,    0,  764,  764,  764,  764,  764,
      764,  764,  764,  765,    0,    0,    0,    0,    0,  765,

        0,    0,    0,  765,    0,  765,  765,    0,  765,  765,
      765,  765,  766,    0,    0,    0,    0,    0,  766,    0,
        0,  766,  766,    0,  766,  766,    0,  766,  766,  766,
      766,  767,  767,    0,  767,    0,  767,  767,  767,  767,
      767,  767,  767,  767,  767,  767,    0,  767,  767,  767,
      767,  767,  768,  768,  768,  768,  768,  768,    0,  768,
      768,  768,  768,  768,  768,  768,  768,  768,  768,  768,
      768,  768,  768,  769,  769,    0,  769,  769,  769,  769,
      769,  769,  769,  769,  769,  769,  769,  769,  769,  769,
      769,  769,  769,  769,  770,  770,    0,    0,  770,    0,

        0,  770,  771,    0,    0,  771,  771,  771,    0,  771,
      771,  771,  771,  771,  771,  771,  771,    0,  771,  771,
      771,  771,  771,  772,  772,  772,  772,  773,  773,    0,
      773,  773,  773,  773,  773,  773,  773,  773,  773,  773,
      773,  773,  773,  773,  773,  773,  773,  773,  774,  774,
        0,  774,  774,  774,  774,  774,  774,  774,  774,  774,
      774,  774,  774,  774,  774,  774,  774,  774,  774,  775,
      775,    0,  775,  775,  775,  775,  775,  775,  775,  775,
      775,  775,  775,  775,  775,  775,  775,  775,  775,  775,
      776,    0,    0,    0,    0,    0,  776,    0,    0,  776,

      776,    0,  776,  776,    0,  776,  776,  776,  776,  777,
        0,    0,    0,    0,    0,  777,    0,    0,    0,  777,
        0,  777,  777,    0,  777,  777,  777,  777,  778,  778,
        0,  778,  778,  778,  778,  778,  778,  778,  778,  778,
      778,  778,  778,  778,  778,  778,  778,  778,  778,  779,
      779,  779,  779,  779,  779,  779,  779,  779,  779,  779,
      779,  779,  779,  779,  779,  779,  779,  779,  779,  779,
      781,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  781,  781,    0,  781,  781,  781,  781,  781,
      782,    0,    0,  782,  782,  782,    0,  782,  782,  782,

      782,  782,  782,  782,  782,    0,  782,  782,  782,  782,
      782,  783,    0,    0,    0,    0,    0,    0,    0,  783,
      783,  783,  783,  784,    0,    0,    0,    0,    0,  784,
        0,    0,  784,  784,    0,  784,  784,    0,  784,  784,
      784,  784,  785,    0,    0,    0,    0,    0,  785,    0,
        0,    0,  785,    0,  785,  785,    0,  785,  785,  785,
      785,  785,  787,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  787,  787,    0,  787,  787,  787,
      787,  788,    0,    0,  788,  788,    0,  788,  788,  788,
      788,  789,  789,  789,  789,  789,  789,  789,  789,  789,

      789,    0,  789,  789,    0,    0,  789,    0,    0,    0,
        0,  789,  790,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  790,  790,    0,  790,  790,  790,
      790,  791,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  791,    0,  791,  791,    0,  791,  791,  791,  791,
      792,    0,    0,    0,    0,  792,    0,    0,  792,  792,
        0,  792,  792,  792,  792,  793,  793,  793,  793,  793,
      793,  793,  793,  793,  793,    0,  793,  793,    0,    0,
      793,    0,    0,    0,    0,  793,  794,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  794,    0,  794,  794,

        0,  794,  794,  794,  794,  795,  795,  795,  795,  795,
      795,  795,  795,  795,  795,    0,  795,  795,    0,    0,
      795,    0,    0,    0,  795,  795,  796,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  796,    0,  796,  796,
        0,  796,  796,  796,  796,  797,  797,  797,  797,  797,
      797,  797,  797,  797,  797,    0,  797,  797,    0,    0,
      797,    0,    0,  797,    0,  797,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,

      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753,  753,  753,  753,  753,  753,  753,  753,  753,
      753,  753
    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[136] =
    {   0,
0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,     };

extern int yy_flex_debug;
int yy_flex_debug = 0;

static yy_state_type *yy_state_buf=0, *yy_state_ptr=0;
static char *yy_full_match;
static int yy_lp;
static int yy_looking_for_trail_begin = 0;
static int yy_full_lp;
static int *yy_full_state;
#define YY_TRAILING_MASK 0x2000
#define YY_TRAILING_HEAD_MASK 0x4000
#define REJECT \
{ \
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */ \
yy_cp = (yy_full_match); /* restore poss. backed-over text */ \
(yy_lp) = (yy_full_lp); /* restore orig. accepting pos. */ \
(yy_state_ptr) = (yy_full_state); /* restore orig. state */ \
yy_current_state = *(yy_state_ptr); /* restore curr. state */ \
++(yy_lp); \
goto find_rule; \
}

#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lexer.l"
/*
**      cdecl -- C gibberish translator
**      src/lexer.l
**
**      Copyright (C) 2017-2024  Paul J. Lucas, et al.
**
**      This program is free software: you can redistribute it and/or modify
**      it under the terms of the GNU General Public License as published by
**      the Free Software Foundation, either version 3 of the License, or
**      (at your option) any later version.
**
**      This program is distributed in the hope that it will be useful,
**      but WITHOUT ANY WARRANTY; without even the implied warranty of
**      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**      GNU General Public License for more details.
**
**      You should have received a copy of the GNU General Public License
**      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/**
 * @file
 * Defines helper macros, data structures, variables, functions, and the
 * tokenizer for C/C++ declarations.
 */
/** @cond DOXYGEN_IGNORE */

#line 37 "lexer.l"
#define LEXER_H_INLINE _GL_EXTERN_INLINE
/** @endcond */

// local
#include "lexer.h"
#include "c_keyword.h"
#include "c_lang.h"
#include "c_typedef.h"
#include "cdecl.h"
#include "cdecl_keyword.h"
#include "gibberish.h"
#include "literals.h"
#include "options.h"
#include "p_keyword.h"
#include "p_macro.h"
#include "print.h"
#include "read_line.h"
#include "red_black.h"
#include "slist.h"
#include "strbuf.h"
#include "util.h"
#include "cdecl_parser.h"               /* must go last */

/// @cond DOXYGEN_IGNORE

// standard
#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <stdbool.h>
#include <stddef.h>                     /* for NULL, size_t */
#include <stdio.h>
#include <stdlib.h>                     /* for strtol(3) */
#include <string.h>
#include <wordexp.h>

// Silence these warnings for Flex-generated code.
#ifdef __clang__
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wimplicit-int-conversion"
# pragma clang diagnostic ignored "-Wshorten-64-to-32"
#endif /* __clang__ */
#ifdef __GNUC__
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wconversion"
# pragma GCC diagnostic ignored "-Wimplicit-fallthrough"
# pragma GCC diagnostic ignored "-Wmisleading-indentation"
# pragma GCC diagnostic ignored "-Wredundant-decls"
# pragma GCC diagnostic ignored "-Wsign-compare"
# pragma GCC diagnostic ignored "-Wsign-conversion"
#endif /* __GNUC__ */

/// @endcond

///////////////////////////////////////////////////////////////////////////////

/**
 * @addtogroup lexer-group
 * @{
 */

/**
 * Switch to lexer \a STATE start-state saving the current start-state.
 *
 * @param STATE The start-state to switch to.
 *
 * @sa #BEGIN_RETURN
 */
#define BEGIN_CALL(STATE) \
  BLOCK( yy_start_stack_push(); BEGIN( STATE ); )

/**
 * Switch to the previous lexer start-state saved by #BEGIN_CALL().
 *
 * @sa #BEGIN_CALL()
 */
#define BEGIN_RETURN              BEGIN( yy_start_stack_pop() )

/**
 * A **cdecl**-specfic version of Flex's `REJECT` that also undoes
 * #YY_USER_ACTION.
 *
 * @note This _must_ be used instead of Flex's `REJECT`.
 */
#define CDECL_REJECT \
  BLOCK( token_column -= STATIC_CAST( c_loc_num_t, yyleng ); REJECT; )

/**
 * C++ raw string delimiter maximum length.
 */
#define RSTR_DELIM_LEN_MAX        16u

/**
 * Overrides Flex's fatal error message to print the message in our format and
 * also exit with the status code we want.
 *
 * @param MSG The error message to print.
 */
#define YY_FATAL_ERROR(MSG)       lexer_fatal( (MSG) )

/**
 * Overrides Flex's input.
 *
 * @param BUF The buffer to use.
 * @param BYTES_READ Set to the number of bytes read.
 * @param BYTES_MAX The maximum number of bytes to read.
 */
#define YY_INPUT(BUF,BYTES_READ,BYTES_MAX) \
  (BYTES_READ) = lexer_get_input( (BUF), STATIC_CAST( yy_size_t, (BYTES_MAX) ) )

/**
 * This code is inserted by Flex at the beginning of each rule to set the
 * current token location information.
 *
 * @note Flex expects this to end with a `;`.
 */
#define YY_USER_ACTION \
  BLOCK( is_constrained_auto = false; lexer_update_loc(); );

///////////////////////////////////////////////////////////////////////////////

/**
 * Data to keep for a file that is `include`d.
 *
 * @remarks
 * @parblock
 * When a file is included, an <code>%include_file_info</code> is
 * pushed onto \ref include_stack such that:
 *
 *  + \ref prev_orig_path is the unresolved path of the _previous_ include (or
 *    configuration) file, if any, that is the value of \ref cdecl_input_path.
 *
 *  + \ref curr_real_path is the resolved path of the _new_ file about to be
 *    included.  We need to remember the resolved path in order to be able to
 *    remove it from \ref include_set upon EOF.
 *
 * @endparblock
 * @note We need \ref prev_lineno because Flex doesn't restore `yylineno` when
 * `yypop_buffer_state()` is called.
 */
struct include_file_info {
  char const *prev_orig_path;           ///< The previous file's original path.
  char const *curr_real_path;           ///< The current file's real path.
  c_loc_num_t orig_opt_lineno;          ///< Original value of \ref opt_lineno.
  c_loc_num_t prev_lineno;              ///< The file's last line number.
};
typedef struct include_file_info include_file_info_t;

/// @cond DOXYGEN_IGNORE
/// Otherwise Doxygen generates two entries.

// extern variables
lexer_find_kind_t lexer_find = LEXER_FIND_ANY;
bool              lexer_is_param_list_decl;
c_keyword_ctx_t   lexer_keyword_ctx;

/// @endcond

// local variables
static bool         digraph_warned;     ///< Printed digraph warning once?
static rb_tree_t    include_set;        ///< Set of resolved include paths.
static slist_t      include_stack;      ///< Stack of include paths.
static strbuf_t     input_sbuf;         ///< Entire current input line.
static size_t       input_sent;         ///< How many bytes returned to Flex.
static bool         is_constrained_auto;///< _Identifier_ followed by `auto`?
static bool         is_eof;             ///< Encountered EOF?
static bool         is_func_like_macro; ///< Defining a function-like macro?
static strbuf_t     str_lit_buf;        ///< String (or character) literal.
static c_loc_t      str_lit_loc;        ///< String literal starting location.
static c_loc_num_t  token_column;       ///< Column position of current token.
static bool         trigraph_warned;    ///< Printed trigraph warning once?

/// C++ raw string literal delimiter.
static char       rstr_delim[ RSTR_DELIM_LEN_MAX + 1/*"*/ + 1/*\0*/ ];

/**
 * Stack of `yylineno` values.
 *
 * @remarks Currently, we need only to remember 1 previous value between
 * lexer_push_string() and lexer_pop_string(), but making this a "stack"
 * future-proofs the code since it can much more easily be extended.
 *
 * @sa yylineno_stack_pop()
 * @sa yylineno_stack_push()
 */
static int          yylineno_stack[1];

/// Top of \ref yylineno_stack.
static int          yylineno_stack_top = -1;

/**
 * Stack of `YY_START` values.
 *
 * @remarks Currently, we need only to remember 1 previous value, but making
 * this a "stack" future-proofs the code since it can much more easily be
 * extended.
 *
 * @sa yy_start_stack_pop()
 * @sa yy_start_stack_push()
 */
static int        yy_start_stack[1];

/// Top of \ref yy_start_stack.
static int        yy_start_stack_top = -1;

// local functions
_Noreturn
static void       lexer_fatal( char const* );

////////// local functions ////////////////////////////////////////////////////

/**
 * Frees all memory associated with \a ifi _including_ \a ifi itself.
 *
 * @param ifi The \ref include_file_info to free.  If NULL, does nothing.
 */
static void ifi_free( include_file_info_t *ifi ) {
  if ( ifi != NULL ) {
    FREE( ifi->prev_orig_path );
    FREE( ifi->curr_real_path );
    free( ifi );
  }
}

/**
 * Frees all memory used by include files.
 *
 * @sa include_init()
 */
static void include_cleanup( void ) {
  slist_cleanup( &include_stack, POINTER_CAST( slist_free_fn_t, &ifi_free ) );
  // Do not pass free() as the second argument since the resolved include path
  // strings are shared with and owned by include_stack.
  rb_tree_cleanup( &include_set, /*free_fn=*/NULL );
}

/**
 * Initializes include files.
 *
 * @sa include_cleanup()
 */
static void include_init( void ) {
  rb_tree_init( &include_set, POINTER_CAST( rb_cmp_fn_t, &strcmp ) );
}

/**
 * Lexer-specific wrapper around cdecl_keyword_find() that finds a **cdecl**
 * keyword, but only if we're currently supposed to or we're always supposed to
 * find a particular keyword.
 *
 * @param literal The literal to find.
 * @return Returns a pointer to the corresponding cdecl_keyword or NULL if not
 * found or we're not currently supposed to find it.
 */
NODISCARD
static inline
cdecl_keyword_t const* lexer_cdecl_keyword_find( char const *literal ) {
  cdecl_keyword_t const *const cdk = cdecl_keyword_find( literal );
  if ( cdk == NULL )
    return NULL;
  if ( (lexer_find & LEXER_FIND_CDECL_KEYWORDS) != 0 || cdk->always_find )
    return cdk;
  return NULL;
}

/**
 * Cleans up lexer data.
 *
 * @sa lexer_init()
 */
static void lexer_cleanup( void ) {
  include_cleanup();
  strbuf_cleanup( &str_lit_buf );
}

/**
 * Gets a line of input for Flex and keeps a copy for use later if printing an
 * error message.
 *
 * @param buf A pointer to the buffer to write into.
 * @param buf_cap The capacity of \a buf.
 * @return Returns the number of bytes read.
 */
NODISCARD
static yy_size_t lexer_get_input( char *buf, yy_size_t buf_cap ) {
  assert( buf != NULL );
  yy_size_t input_avail = input_sbuf.len - input_sent;
  if ( input_avail == 0 ) {
    strbuf_reset( &input_sbuf );
    if ( !strbuf_read_line( &input_sbuf, yyin, /*prompts=*/NULL, &yylineno ) )
      strbuf_reset( &input_sbuf );
    input_avail = STATIC_CAST( yy_size_t, input_sbuf.len );
    input_sent = 0;
  }
  //
  // Given that the default buffer capacity (YY_READ_BUF_SIZE) for Flex is
  // 8192, it's unlikely that this will ever be true and that we'll have to
  // return the input line in chunks; but might as well code for the case.
  //
  if ( unlikely( input_avail > buf_cap ) )
    input_avail = buf_cap;              // LCOV_EXCL_LINE
  memcpy( buf, input_sbuf.str + input_sent, input_avail );
  input_sent += input_avail;
  return input_avail;
}

/**
 * Pops a buffer from Flex's input.
 */
static void lexer_pop_buffer( void ) {
  // The example code in the Flex manual leaks file handles; see:
  // https://stackoverflow.com/a/27512485/99089
  assert( yyin != NULL );
  assert( yyin != stdin );
  fclose( yyin );
  yypop_buffer_state();
  assert( YY_CURRENT_BUFFER != NULL );
}

/**
 * Update the parser's location.
 * @note This is called by Flex via #YY_USER_ACTION.
 */
static void lexer_update_loc( void ) {
  yylloc.first_line   = yylloc.last_line = STATIC_CAST( c_loc_num_t, yylineno );
  yylloc.first_column = token_column;
  yylloc.last_column  = token_column + STATIC_CAST( c_loc_num_t, yyleng ) - 1;
  token_column += STATIC_CAST( c_loc_num_t, yyleng );
}

/**
 * Resets the token column position upon encountering a newline.
 */
static inline void newline( void ) {
  token_column = 0;
}

/**
 * Parses an integer from \ref yytext.
 *
 * @param base The integer base to use.
 * @return Returns the integer value.
 */
NODISCARD
static int parse_int( int base ) {
  char const *s = yytext;
  bool const is_neg = s[0] == '-';

  if ( is_neg )
    ++s;

  if ( base == 2 ) {
    // Prior to C23, strtol(3) doesn't understand a "0b" (binary) prefix, so
    // skip over it.
    assert( s[0] == '0' );              // String should start with "0b" ...
    assert( tolower( s[1] ) == 'b' );   // ... since it was just lex'd as such.
    s += 2;
  }

  char no_digit_seps[ MAX_DEC_INT_DIGITS(uintmax_t) + 1/*\0*/ ];

  if ( strchr( s, '\'' ) != NULL ) {
    // Strip digit separator (') characters since strtol(3) doesn't understand
    // them.
    char *t = no_digit_seps;
    do {
      if ( *s != '\'' )
        *t++ = *s;
    } while ( *s++ != '\0' );
    s = no_digit_seps;
  }

  errno = 0;
  long rv = strtol( s, /*endptr=*/NULL, base );
  if ( is_neg )
    rv = -rv;
  if ( unlikely( errno != 0 || rv < INT_MIN || rv > INT_MAX ) ) {
    // LCOV_EXCL_START
    rv = rv < INT_MIN ? INT_MIN : INT_MAX;
    print_warning( &yylloc, "integer out of range; clamped to %ld\n", rv );
    // LCOV_EXCL_STOP
  }

  return STATIC_CAST( int, rv );
}

/**
 * Pops the current input file, if any.
 *
 * @return Returns `true` only if an include file was popped.
 *
 * @sa push_file()
 * @sa https://westes.github.io/flex/manual/Multiple-Input-Buffers.html
 */
NODISCARD
static bool pop_file( void ) {
  if ( slist_empty( &include_stack ) )
    return false;

  include_file_info_t *const ifi = slist_pop_front( &include_stack );
  assert( ifi != NULL );

  rb_node_t *const found_rb = rb_tree_find( &include_set, ifi->curr_real_path );
  assert( found_rb != NULL );
  // Ignore the curr_real_path returned by rb_tree_delete() since it's shared
  // with and owned by ifi.
  PJL_DISCARD_RV( rb_tree_delete( &include_set, found_rb ) );

  cdecl_input_path = ifi->prev_orig_path;
  opt_lineno = ifi->orig_opt_lineno;
  yylineno = ifi->prev_lineno;
  ifi_free( ifi );
  lexer_pop_buffer();
  return true;
}

/**
 * Pushes the current input file and sets \a path as the new file to read
 * subsequent input from.
 *
 * @param path The path to read subsequent input from until EOF.  Shell
 * metacharacters, e.g., `~`, are expanded.
 * @param path_loc The location of \a path.
 *
 * @sa pop_file()
 * @sa http://westes.github.io/flex/manual/Multiple-Input-Buffers.html
 */
static void push_file( char const *path, c_loc_t const *path_loc ) {
  path = null_if_empty( path );
  if ( path == NULL ) {
    print_error( path_loc, "empty path\n" );
    return;
  }

  wordexp_t we;
  int const rv_we = wordexp( path, &we, /*flags=*/0 );

  char const *real_path = NULL;

  switch ( rv_we ) {
    case 0:                             // success
      if ( we.we_wordc != 1 ) {
        print_error( path_loc, "\"%s\": too many files\n", path );
        goto done;
      }
      break;
    case WRDE_BADCHAR:
      print_error( path_loc,
        "\"%s\": contains unquoted shell characters\n", path
      );
      return;
    // LCOV_EXCL_START
    case WRDE_SYNTAX:
      print_error( path_loc, "\"%s\": path syntax error\n", path );
      return;
    case WRDE_NOSPACE:                  // unlikely
      print_error( path_loc, "out of memory\n" );
      _Exit( EX_OSERR );
    case WRDE_BADVAL:                   // can't happen
    case WRDE_CMDSUB:                   // can't happen
    default:
      UNEXPECTED_INT_VALUE( rv_we );
    // LCOV_EXCL_STOP
  } // switch

  real_path = realpath( we.we_wordv[0], /*real_buf=*/NULL );
  if ( real_path == NULL ) {
    print_error( path_loc, "\"%s\": could not resolve path\n", path );
    goto done;
  }

  if ( rb_tree_find( &include_set, real_path ) != NULL ) {
    print_error( path_loc, "\"%s\": file previously included\n", path );
    goto done;
  }

  if ( !path_is_file( real_path ) ) {
    // LCOV_EXCL_START
    print_error( path_loc, "\"%s\": not a plain file\n", path );
    goto done;
    // LCOV_EXCL_STOP
  }

  FILE *const include_file = fopen( real_path, "r" );
  if ( include_file == NULL ) {
    // LCOV_EXCL_START
    print_error( path_loc, "\"%s\": %s\n", path, STRERROR() );
    goto done;
    // LCOV_EXCL_STOP
  }

  //
  // Now that we know the path resolves, it wasn't previously included, it's a
  // plain file, and we can open it, we can insert it into include_set.
  //
  PJL_DISCARD_RV(
    rb_tree_insert( &include_set, CONST_CAST( void*, real_path ) )
  );

  include_file_info_t *const ifi = MALLOC( include_file_info_t, 1 );
  *ifi = (include_file_info_t){
    .prev_orig_path = cdecl_input_path,
    .curr_real_path = real_path,
    .orig_opt_lineno = opt_lineno,
    .prev_lineno = yylineno
  };
  slist_push_front( &include_stack, ifi );
  real_path = NULL;                     // now owned by ifi above
  opt_lineno = 0;                       // applies only to original file

  yyin = include_file;
  yypush_buffer_state( yy_create_buffer( yyin, YY_BUF_SIZE ) );
  cdecl_input_path = check_strdup( we.we_wordv[0] );
  yylineno = 1;
  newline();

done:
  FREE( real_path );
  wordfree( &we );                      // call only if rv_we == 0
}

/**
 * Sets the current token to \a token for the current digraph sequence.
 * Additionally, if the current language is older than C95, prints a warning
 * that digraphs are not supported until C95 (only once per parse).
 *
 * @param token The token the digraph maps to.
 *
 * @sa set_trigraph()
 */
static void set_digraph( char const *token ) {
  if ( !OPT_LANG_IS( DIGRAPHS ) && false_set( &digraph_warned ) ) {
    print_warning( &yylloc,
      "digraphs not supported%s\n", C_LANG_WHICH( DIGRAPHS )
    );
  }
  set_yytext( token );
}

/**
 * Sets the current token to \a token for the current trigraph sequence.
 * Additionally, if the current language is K&R&nbsp;C or C++17 or later,
 * prints a warning that trigraphs are not supported (only once per parse).
 *
 * @param token The token the trigraph maps to.
 *
 * @sa set_digraph()
 */
static void set_trigraph( char const *token ) {
  if ( !OPT_LANG_IS( TRIGRAPHS ) && false_set( &trigraph_warned ) ) {
    print_warning( &yylloc,
      "trigraphs not supported%s\n", C_LANG_WHICH( TRIGRAPHS )
    );
  }
  set_yytext( token );
}

/**
 * Pops \ref yylineno_stack into `yylineno`.
 *
 * @sa yylineno_stack_push()
 */
static void yylineno_stack_pop( void ) {
  assert( yylineno_stack_top >= 0 );
  yylineno = yylineno_stack[ yylineno_stack_top-- ];
}

/**
 * Pushes the current `yylineno` value onto \ref yylineno_stack.
 *
 * @sa yylineno_stack_pop()
 */
static void yylineno_stack_push( void ) {
  ++yylineno_stack_top;
  assert( yylineno_stack_top < ARRAY_SIZE( yylineno_stack ) );
  yylineno_stack[ yylineno_stack_top ] = yylineno;
}

/**
 * Pops \ref yy_start_stack.
 *
 * @return Returns a previously pushed `YY_START` value.
 *
 * @sa yy_start_stack_push()
 */
static int yy_start_stack_pop( void ) {
  assert( yy_start_stack_top >= 0 );
  return yy_start_stack[ yy_start_stack_top-- ];
}

/**
 * Pushes the current `YY_START` value onto \ref yy_start_stack.
 *
 * @sa yy_start_stack_pop()
 */
static void yy_start_stack_push( void ) {
  ++yy_start_stack_top;
  assert( yy_start_stack_top < ARRAY_SIZE( yy_start_stack ) );
  yy_start_stack[ yy_start_stack_top ] = YY_START;
}

/**
 * Standard lex function to know whether to continue parsing upon reaching EOF.
 *
 * @return Returns 1 if done or 0 to continue parsing (a new file set via
 * `yyin`).
 */
static int yywrap( void ) {
  return /*done=*/1;
}

///////////////////////////////////////////////////////////////////////////////

/** @} */

/// @cond DOXYGEN_IGNORE

#line 2382 "lexer.c"
/*
 * For the "expand" command.
 */

/*
 * For "include" files.
 */

/*
 * For the C preprocessor.
 */

/*
 * For the "set" command, we want to allow (almost) any character sequence for
 * the command's options.
 */

/*
 * For the "show" command, we want to allow globs (scoped names containing
 * `*`).
 */

/*
 * For C character and string literals.
 */

#line 2409 "lexer.c"

#define INITIAL 0
#define X_EXPAND 1
#define X_INCLUDE 2
#define X_PRE_COMMAND 3
#define X_PRE_TOKENS 4
#define X_SET 5
#define S_SHOW 6
#define X_CHAR 7
#define X_STR 8
#define X_RSTR 9

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

        /* Create the reject buffer large enough to save one state per allowed character. */
        if ( ! (yy_state_buf) )
            (yy_state_buf) = (yy_state_type *)yyalloc(YY_STATE_BUF_SIZE  );
            if ( ! (yy_state_buf) )
                YY_FATAL_ERROR( "out of dynamic memory in yylex()" );

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 729 "lexer.l"

#line 731 "lexer.l"
              /*
               * Special case: if "_Atomic" is immediately followed by a '(',
               * it is interpreted as a type specifier, not as a type
               * qualifier.
               */
#line 2652 "lexer.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();

		(yy_state_ptr) = (yy_state_buf);
		*(yy_state_ptr)++ = yy_current_state;

yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 754 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			*(yy_state_ptr)++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 3867 );

yy_find_action:
		yy_current_state = *--(yy_state_ptr);
		(yy_lp) = yy_accept[yy_current_state];
find_rule: /* we branch to this label when backing up */
		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( (yy_lp) && (yy_lp) < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[(yy_lp)];
				if ( yy_act & YY_TRAILING_HEAD_MASK ||
				     (yy_looking_for_trail_begin) )
					{
					if ( yy_act == (yy_looking_for_trail_begin) )
						{
						(yy_looking_for_trail_begin) = 0;
						yy_act &= ~YY_TRAILING_HEAD_MASK;
						break;
						}
					}
				else if ( yy_act & YY_TRAILING_MASK )
					{
					(yy_looking_for_trail_begin) = yy_act & ~YY_TRAILING_MASK;
					(yy_looking_for_trail_begin) |= YY_TRAILING_HEAD_MASK;
					}
				else
					{
					(yy_full_match) = yy_cp;
					(yy_full_state) = (yy_state_ptr);
					(yy_full_lp) = (yy_lp);
					break;
					}
				++(yy_lp);
				goto find_rule;
				}
			--yy_cp;
			yy_current_state = *--(yy_state_ptr);
			(yy_lp) = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 7;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 736 "lexer.l"
{
                return Y__Atomic_SPEC;
              }
	YY_BREAK
/*
               * Special case: if "auto" is optionally followed by "const"
               * and/or "volatile", optionally followed by either '&' or "&&",
               * and followed by '[', it's a C++ structured binding "auto" ---
               * unless we're currently parsing a function-like parameter list
               * (see below).
               *
               * For example, given:
               *
               *      auto const [N]        // structured binding
               *      auto const x[N]       // array of reference to const auto
               *
               * you can't tell whether it's an ordinary "auto" declaration or
               * a structured binding declaration until you see '[' without
               * having seen a name like "x".  Hence, this special case to
               * look-ahead more than one token and return a structured binding
               * "auto".
               *
               * However, for function parameters, a declaration like:
               *
               *      int f(auto const[N])  // unnamed array N of const auto
               *
               * is always an (unnamed) array of const ordinary "auto" and
               * never a structured binding.  When parsing a parameter list,
               * the parser sets lexer_is_param_list_decl so a structured
               * binding "auto" won't be returned.
               */
case 2:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 4;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 767 "lexer.l"
{
                if ( !lexer_is_param_list_decl )
                  return Y_auto_STRUCTURED_BINDING;
                CDECL_REJECT;
              }
	YY_BREAK
/*
               * Special case: if "const[ant]" is immediately followed by one
               * of "eval[uation]", "expr[ession]", or "init[ialization]",
               * return a special English version of the "const" token to
               * disambiguate it (as part of one of those three storage
               * classes) from the normal "const" that's a CV qualifier.
               */
case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 780 "lexer.l"
{
                return Y_constant;
              }
	YY_BREAK
/*
               * Special case: if "declare" is eventually followed by "user-
               * defined", e.g.:
               *
               *      c++decl> declare overridden user-defined \
               *        conversion operator returning int
               *      operator int() override;
               *
               * the keyword context has to be set to C_KW_CTX_MBR_FUNC to be
               * able to match "override" and "final" (that ordinarily are not
               * matched unless within a member function declaration).
               *
               * The context can't always be set to C_KW_CTX_MBR_FUNC after
               * "declare" otherwise "override" and "final" would match when
               * they shouldn't, e.g.:
               *
               *      c++decl> declare final as int
               *      int final;
               *
               * (which is legal).
               */
case 4:
/* rule 4 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 7);
(yy_c_buf_p) = yy_cp = yy_bp + 7;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 805 "lexer.l"
{
                lexer_keyword_ctx = C_KW_CTX_MBR_FUNC;
                return Y_declare;
              }
	YY_BREAK
/*
               * Special case: implement "include" files entirely within the
               * lexer.  See:
               *
               * http://westes.github.io/flex/manual/Multiple-Input-Buffers.html
               */
case 5:
YY_RULE_SETUP
#line 816 "lexer.l"
{
                strbuf_init( &str_lit_buf );
                //
                // Save the start location because we want to use it as the
                // location for the literal, not its end location.
                //
                str_lit_loc = yylloc;
                str_lit_loc.first_column = yylloc.last_column;
                BEGIN( X_INCLUDE );
              }
	YY_BREAK
/*
               * Special case: make `q` a synonym for `quit`, but only when
               * it's the only thing on a line other than whitespace.  In all
               * other cases, `q` should be treated as an ordinary identifier.
               * This is done to allow things like:
               *
               *      cdecl> declare p, q as pointer to int
               *      int *p, *q;
               *
               * This isn't handled by having a `q` entry in CDECL_KEYWORDS
               * because that would make `q` a synonym all the time.
               *
               * Note that we can't simply do:
               *
               *      ^{S}*q{S}*$
               *
               * because `$` only matches a newline and not "end of string."
               *
               * To forbid a string like `q x`, we first have to match its
               * pattern explicitly and always forbid it.
               */
case 6:
YY_RULE_SETUP
#line 848 "lexer.l"
{
                char const *const orig_yytext = yytext;
                // update yytext to be only the offending token past the 'q'
                SKIP_WS( yytext );
                assert( yytext[0] == 'q' );
                ++yytext;
                SKIP_WS( yytext );
                // update yyloc to be at the start of the offending token
                token_column = yytext - orig_yytext;
                lexer_update_loc();
                return Y_LEXER_ERROR;
              }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 860 "lexer.l"
{ set_yytext( L_quit ); return Y_quit; }
	YY_BREAK
/*
               * Special case: similar to {sname} below, handle scoped
               * destructor names in the lexer so destructor names are
               * recognized as such, e.g.:
               *
               *      S::T::T           // not a destructor
               *      S::T::U           // not a destructor
               *      S::T::~T          // a destructor
               *      S::T::~U          // not a destructor (and an error)
               */
case 8:
YY_RULE_SETUP
#line 872 "lexer.l"
{
                c_sname_t sname;
                if ( c_sname_parse_dtor( yytext, &sname ) > 0 ) {
                  yylval.sname = sname;
                  return Y_DESTRUCTOR_SNAME;
                }
                print_error( &yylloc,
                  "matching class name after '~' expected\n"
                );
                return Y_LEXER_ERROR;
              }
	YY_BREAK
/*
               * Special case: similar to {sname} below, handle scoped
               * operators in the lexer to simplify the grammar, e.g.:
               *
               *      S::T::operator    // sname = "S::T"
               */
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 890 "lexer.l"
{
                c_sname_t sname;
                size_t const sname_len = c_sname_parse( yytext, &sname );
                if ( sname_len == 0 )
                  CDECL_REJECT;

                //
                // c_sname_parse() will not include "::operator" in the parsed
                // scoped name, so the returned length will only include the
                // actual scoped name, e.g., "S::T".  We therefore have to tell
                // Flex to put the characters "::operator" back onto the input
                // stream.
                //
                yyless( STATIC_CAST( int, sname_len ) );

                //
                // See if it's a typedef'd type: if so, copy the type's scoped
                // name so we get its scope types (if any).
                //
                c_typedef_t const *const tdef = c_typedef_find_sname( &sname );
                if ( tdef != NULL ) {
                  c_sname_cleanup( &sname );
                  sname = c_sname_dup( &tdef->ast->sname );
                }

                yylval.sname = sname;
                return Y_OPERATOR_SNAME;
              }
	YY_BREAK
/*
               * Special case: handle concept (constrained) "auto" for an
               * {sname}, e.g.:
               *
               *      std::integral auto x
               *
               * in the lexer so:
               *
               * 1. Conflicts don't arrise in the grammar since you can't tell
               *    an {sname} is a concept until you parse the "auto".
               *
               * 2. Concepts don't have to be pre-declared via a pseudo-C++
               *    syntax like:
               *
               *          namespace std { concept integral; }
               *
               *    prior to use.
               */
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 937 "lexer.l"
{
                c_sname_t sname;
                size_t const sname_len = c_sname_parse( yytext, &sname );
                if ( sname_len == 0 )
                  CDECL_REJECT;
                yylval.sname = sname;
                return Y_CONCEPT_SNAME;
              }
	YY_BREAK
/*
               * Special case: handle scoped names in the lexer so:
               *
               * 1. Constructors are recognized as such, specifically, when the
               *    scoped name's last two scopes match, e.g.:
               *
               *          A::B::C       // not a constructor
               *          S::T::T       // a constructor
               *
               *    This is needed because constructors and ordinary
               *    declarations are lexically ambiguous in a LALR(1) parser:
               *
               *          A::B(x);      // declare x as A::B with unneeded ()
               *          S::S()        // define constructor for S
               *
               * 2. Previously declared scope-types are recognized as such,
               *    e.g.:
               *
               *          define S::T as int
               *          explain S::T x
               *
               * The trailing context of a Non-Indentifier (NI) character is
               * necessary to prevent Flex from recognizing partial identifiers
               * upon REJECT.  For example, given these declarations:
               *
               *      namespace X::YY { class T; }
               *      namespace X     { class Y; }
               *      namespace X::YY { class U; }
               *
               * Just as in the first declaration, when "X::YY" is encountered
               * in the third declaration, we would ordinarily REJECT a match
               * because "X::YY" is not a type.  (Hence, "X::YY" would be
               * returned to the parser as three separate tokens "X", "::", and
               * "YY" just as they were in the first declaration.)
               *
               * However, upon REJECT, Flex backs off one character at a time,
               * so it will next try to match "X::Y" and succeed since it's a
               * substring of "X::YY".  The "X::Y" is then looked-up and finds
               * the class X::Y (from the second declaration).  This is of
               * course wrong semantically, but Flex doesn't know anything
               * about semantics, i.e., it doesn't know that the longest set of
               * contiguous alphanumeric characters comprises an identifier and
               * shouldn't be split.
               *
               * Using the trailing context prevents Flex from matching the
               * partial token.
               */
case 11:
/* rule 11 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_cp - 1);
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 993 "lexer.l"
{
                c_sname_t sname;
                size_t const sname_len = c_sname_parse( yytext, &sname );
                if ( sname_len == 0 )
                  CDECL_REJECT;

                if ( sname_len < STATIC_CAST( size_t, yyleng ) )
                  yyless( sname_len );

                //
                // 1. See if it's a constructor name.
                //
                if ( c_sname_is_ctor( &sname ) ) {
                  yylval.sname = sname;
                  return Y_CONSTRUCTOR_SNAME;
                }

                if ( (lexer_find & LEXER_FIND_TYPES) != 0 ) {
                  //
                  // 2. See if it's a typedef'd type.
                  //
                  c_typedef_t const *const tdef =
                    c_typedef_find_sname( &sname );
                  if ( tdef != NULL ) {
                    yylval.tdef = tdef;
                    c_sname_cleanup( &sname );
                    return Y_TYPEDEF_SNAME_TDEF;
                  }
                }

                //
                // 3. Otherwise, reject it.
                //
                c_sname_cleanup( &sname );
                CDECL_REJECT;
              }
	YY_BREAK
/*
               * Special case: match hyphenated tokens.  We need a separate
               * rule because '-' isn't a valid character in an identifier.
               */
case 12:
YY_RULE_SETUP
#line 1034 "lexer.l"
{
                //
                // Hyphenated tokens are legal only in pseudo-English.
                //
                if ( (lexer_find & LEXER_FIND_CDECL_KEYWORDS) == 0 )
                  return Y_ERROR;

                //
                // Now that we've matched a hyphenated token, use the same
                // keyword-matching code.
                //
                goto find_cdecl_keyword;
              }
	YY_BREAK
/***************************************************************************/
/*  IDENTIFIERS                                                            */
/***************************************************************************/
/*
               * Special case: similar to the special case for {sname} auto,
               * handle concept (constrained) auto for an {identifier}, e.g.:
               *
               *      C auto x
               *
               * where "C" is a concept.
               */
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 1060 "lexer.l"
{
                is_constrained_auto = true;
                //
                // Now that we've set the flag, use the same keyword-matching
                // code.
                //
                goto find_cdecl_keyword;
              }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 1069 "lexer.l"
{
                //
                // 1. See if it's a cdecl keyword.
                //
        find_cdecl_keyword:
                NO_OP;
                cdecl_keyword_t const *const cdk =
                  lexer_cdecl_keyword_find( yytext );
                if ( cdk != NULL ) {
                  if ( cdk->lang_syn == NULL ) {
                    if ( cdk->literal == L_expand ) {
                      //
                      // For the "expand" command, we want to allow all tokens,
                      // but also return a few more that ordinarily aren't
                      // returned to the parser.
                      //
                      BEGIN( X_EXPAND );
                    }
                    else if ( cdk->literal == L_set ) {
                      //
                      // For the "set" command, we want to allow (almost) any
                      // character sequence for the command's options, so we
                      // use an exclusive start state.
                      //
                      BEGIN( X_SET );
                    }
                    else if ( cdk->literal == L_show ) {
                      //
                      // For the "show" command, we need to allow globs.
                      //
                      BEGIN( S_SHOW );
                    }
                    return cdk->y_token_id;
                  }
                  char const *const literal = c_lang_literal( cdk->lang_syn );
                  if ( literal != NULL ) {
                    set_yytext( literal );
                    goto find_c_keyword;
                  }
                }

                if ( (lexer_find & LEXER_FIND_TYPES) != 0 ) {
                  //
                  // 2. See if it's a typedef'd type.
                  //
                  c_typedef_t const *const tdef =
                    c_typedef_find_sname( &C_SNAME_LIT( yytext ) );
                  if ( tdef != NULL ) {
                    yylval.tdef = tdef;
                    return Y_TYPEDEF_NAME_TDEF;
                  }
                }

        find_c_keyword:
                if ( (lexer_find & LEXER_FIND_C_KEYWORDS) != 0 ) {
                  //
                  // 3. See if it's a C/C++ keyword.
                  //
                  c_keyword_t const *const ck = c_keyword_find(
                    yytext, opt_lang_id, lexer_keyword_ctx
                  );
                  if ( ck != NULL ) {
                    yylval.tid = ck->tid;
                    return ck->y_token_id;
                  }
                }

                if ( is_constrained_auto ) {
                  //
                  // 4. If it's constrained auto, it's a concept name.
                  //
                  c_sname_init_name( &yylval.sname, check_strdup( yytext ) );
                  return Y_CONCEPT_SNAME;
                }

                //
                // 5. Otherwise, it's just an ordinary name.
                //
                yylval.name = check_strdup( yytext );
                return Y_NAME;
              }
	YY_BREAK
/***************************************************************************/
/*  NUMERIC LITERALS                                                       */
/***************************************************************************/

case 15:
YY_RULE_SETUP
#line 1157 "lexer.l"
{
                yylval.int_val = parse_int( 2 );
                return Y_INT_LIT;
              }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 1161 "lexer.l"
{
                yylval.int_val = parse_int( 8 );
                return Y_INT_LIT;
              }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 1165 "lexer.l"
{
                yylval.int_val = parse_int( 10 );
                return Y_INT_LIT;
              }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 1169 "lexer.l"
{
                yylval.int_val = parse_int( 16 );
                return Y_INT_LIT;
              }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 1174 "lexer.l"
{
                // cdecl doesn't care what the actual float value is, only the
                // characters comprising the token for the macro processor.
                return Y_FLOAT_LIT;
              }
	YY_BREAK
/* <INITIAL,X_PRE_TOKENS> */
/***************************************************************************/
/*  ATTRIBUTES                                                             */
/***************************************************************************/

/*
               * Special case: if '[' is immediately followed by another '[',
               * return a distinct token to decrease the number of shift/reduce
               * conflicts.
               */
case 20:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 1193 "lexer.l"
{ set_digraph( "[" );  return Y_ATTR_BEGIN; }
	YY_BREAK
case 21:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 1194 "lexer.l"
{ set_trigraph( "[" ); return Y_ATTR_BEGIN; }
	YY_BREAK
case 22:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 1195 "lexer.l"
{                      return Y_ATTR_BEGIN; }
	YY_BREAK
/* <INITIAL,X_PRE_TOKENS> */
/***************************************************************************/
/*  OPERATORS & PUNCTUATION                                                */
/***************************************************************************/

/*
               * Special case: if "::" is immediately followed by a '*', return
               * a distinct token to make it possible to distinguish between:
               *
               *    <name>::<name>::<name>
               *    <name>::<name>::*
               *
               * in an LALR(1) parser.
               */
case 23:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 1213 "lexer.l"
{ return Y_COLON_COLON_STAR       ; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 1214 "lexer.l"
{ return Y_COLON_COLON            ; }
	YY_BREAK
/* Multi-character operators. */
case 25:
YY_RULE_SETUP
#line 1217 "lexer.l"
{ return Y_EXCLAM_EQUAL           ; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 1218 "lexer.l"
{ return Y_PERCENT_EQUAL          ; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 1219 "lexer.l"
{ return Y_AMPER_AMPER            ; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 1220 "lexer.l"
{ return Y_AMPER_EQUAL            ; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 1221 "lexer.l"
{ return Y_STAR_EQUAL             ; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 1222 "lexer.l"
{ return Y_PLUS_PLUS              ; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 1223 "lexer.l"
{ return Y_PLUS_EQUAL             ; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 1224 "lexer.l"
{ return Y_MINUS_MINUS            ; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 1225 "lexer.l"
{ return Y_MINUS_EQUAL            ; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 1226 "lexer.l"
{ return Y_MINUS_GREATER          ; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 1227 "lexer.l"
{ return Y_MINUS_GREATER_STAR     ; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 1228 "lexer.l"
{ return Y_DOT_STAR               ; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 1229 "lexer.l"
{ return Y_ELLIPSIS               ; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 1230 "lexer.l"
{ return Y_SLASH_EQUAL            ; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 1231 "lexer.l"
{ return Y_LESS_LESS              ; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 1232 "lexer.l"
{ return Y_LESS_LESS_EQUAL        ; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 1233 "lexer.l"
{ return Y_LESS_EQUAL             ; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 1234 "lexer.l"
{ return Y_LESS_EQUAL_GREATER     ; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 1235 "lexer.l"
{ return Y_EQUAL_EQUAL            ; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 1236 "lexer.l"
{ return Y_GREATER_EQUAL          ; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 1237 "lexer.l"
{ return Y_GREATER_GREATER        ; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 1238 "lexer.l"
{ return Y_GREATER_GREATER_EQUAL  ; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 1239 "lexer.l"
{ return Y_QMARK_COLON            ; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 1240 "lexer.l"
{ return Y_CARET_EQUAL            ; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 1241 "lexer.l"
{ return Y_PIPE_EQUAL             ; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 1242 "lexer.l"
{ return Y_PIPE_PIPE              ; }
	YY_BREAK
/*
               * Special case: if '#' is the first non-whitespace character on
               * a line, assume it's the start of a C preprocessor command.
               *
               * This needs to be here before the regular "#" a few lines below
               * so Flex will match this rule before that rule.
               */
case 51:
YY_RULE_SETUP
#line 1251 "lexer.l"
{
                BEGIN( X_PRE_COMMAND );
                return '#';
              }
	YY_BREAK
/*
               * Same as above, but for the digraph equivalent of '#'.
               */
case 52:
YY_RULE_SETUP
#line 1259 "lexer.l"
{
                set_digraph( "#" );
                BEGIN( X_PRE_COMMAND );
                return '#';
              }
	YY_BREAK
/*
               * Same as above, but for the trigraph equivalent of '#'.
               */
case 53:
YY_RULE_SETUP
#line 1268 "lexer.l"
{
                set_trigraph( "#" );
                BEGIN( X_PRE_COMMAND );
                return '#';
              }
	YY_BREAK
/* Single-character operators and miscellaneous punctuation. */
case 54:
#line 1276 "lexer.l"
case 55:
#line 1277 "lexer.l"
case 56:
#line 1278 "lexer.l"
case 57:
#line 1279 "lexer.l"
case 58:
#line 1280 "lexer.l"
case 59:
#line 1281 "lexer.l"
case 60:
#line 1282 "lexer.l"
case 61:
#line 1283 "lexer.l"
case 62:
#line 1284 "lexer.l"
case 63:
#line 1285 "lexer.l"
case 64:
#line 1286 "lexer.l"
case 65:
#line 1287 "lexer.l"
case 66:
#line 1288 "lexer.l"
case 67:
#line 1289 "lexer.l"
case 68:
#line 1290 "lexer.l"
case 69:
#line 1291 "lexer.l"
case 70:
#line 1292 "lexer.l"
case 71:
#line 1293 "lexer.l"
case 72:
#line 1294 "lexer.l"
case 73:
#line 1295 "lexer.l"
case 74:
#line 1296 "lexer.l"
case 75:
#line 1297 "lexer.l"
case 76:
#line 1298 "lexer.l"
case 77:
#line 1299 "lexer.l"
case 78:
YY_RULE_SETUP
#line 1299 "lexer.l"
{ return yytext[0]                ; }
	YY_BREAK
/* <INITIAL,X_PRE_TOKENS> */
/***************************************************************************/
/*  DIGRAPHS & TRIGRAPHS                                                   */
/***************************************************************************/

/* Digraphs. */
case 79:
YY_RULE_SETUP
#line 1309 "lexer.l"
{ set_digraph( "#" ); return '#'; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 1310 "lexer.l"
{ set_digraph( "[" ); return '['; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 1311 "lexer.l"
{ set_digraph( "]" ); return ']'; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 1312 "lexer.l"
{ set_digraph( "{" ); return '{'; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 1313 "lexer.l"
{ set_digraph( "}" ); return '}'; }
	YY_BREAK
/* Trigraphs. */
case 84:
YY_RULE_SETUP
#line 1316 "lexer.l"
{ set_trigraph( "^=" ); return Y_CARET_EQUAL; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 1317 "lexer.l"
{ set_trigraph( "|=" ); return Y_PIPE_EQUAL ; }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 1318 "lexer.l"
{ set_trigraph( "||" ); return Y_PIPE_PIPE  ; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 1319 "lexer.l"
{ set_trigraph( "^"  ); return '^'          ; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 1320 "lexer.l"
{ set_trigraph( "["  ); return '['          ; }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 1321 "lexer.l"
{ set_trigraph( "\\" ); return '\\'         ; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 1322 "lexer.l"
{ set_trigraph( "]"  ); return ']'          ; }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 1323 "lexer.l"
{ set_trigraph( "{"  ); return '{'          ; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 1324 "lexer.l"
{ set_trigraph( "|"  ); return '|'          ; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 1325 "lexer.l"
{ set_trigraph( "}"  ); return '}'          ; }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 1326 "lexer.l"
{ set_trigraph( "~"  ); return '~'          ; }
	YY_BREAK
/* <*> */
/***************************************************************************/
/*  RAW STRING LITERALS                                                    */
/***************************************************************************/

case 95:
YY_RULE_SETUP
#line 1336 "lexer.l"
{ // e.g.: u8R"abc(...)abc"
                // find:    ^   ^
                char const *q = strchr( yytext, '"' );
                assert( q != NULL );
                char const *const p = strchr( ++q, '(' );
                assert( p != NULL );

                size_t const delim_len = STATIC_CAST( size_t, p - q );
                if ( delim_len > RSTR_DELIM_LEN_MAX ) {
                  print_error( &yylloc,
                    "raw string literal delimiter "
                    "exceeds maximum length of %u\n",
                    RSTR_DELIM_LEN_MAX
                  );
                  return Y_LEXER_ERROR;
                }

                strncpy( rstr_delim, q, delim_len );
                //
                // To make the delimiter-match code simpler, include the
                // closing '"' as part of the delimiter.  (Using strcpy() also
                // has the benefit of ensuring rstr_delim is null-terminated.)
                //
                strcpy( rstr_delim + delim_len, "\"" );

                strbuf_init( &str_lit_buf );
                //
                // Save the start location because we want to use it as the
                // location for the literal, not its end location.
                //
                str_lit_loc = yylloc;

                BEGIN_CALL( X_RSTR );
              }
	YY_BREAK
/* <INITIAL,X_PRE_TOKENS> */

case 96:
/* rule 96 can match eol */
YY_RULE_SETUP
#line 1375 "lexer.l"
{ strbuf_putsn( &str_lit_buf, yytext, yyleng ); }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 1376 "lexer.l"
{
                char const *d;
                for ( d = rstr_delim; *d != '\0'; ++d, ++token_column ) {
                  int const c = input();
                  if ( c == EOF ) {
                    print_error( &yylloc, "unterminated string literal\n" );
                    strbuf_reset( &str_lit_buf );
                    return Y_LEXER_ERROR;
                  }
                  if ( c == *d )
                    continue;
                  //
                  // Found a mismatch with the delimiter, e.g.:
                  //
                  //      )abc"       // delimiter
                  //      )abx"       // what was found
                  //
                  // Hence, it's not the actual delimiter, but part of the
                  // string literal: append the part that matched (")ab").
                  //
                  int const part_len = STATIC_CAST( int, d - rstr_delim );
                  strbuf_printf( &str_lit_buf, ")%.*s", part_len, rstr_delim );
                  //
                  // Unput the character that caused the mismatch since it
                  // could be ')' that could potentially start a real match,
                  // e.g.:
                  //
                  //      R"abc(X)ab)abc"
                  //                ^
                  //
                  // Hence the raw string is "X)ab".
                  //
                  unput( c );
                  break;
                } // for

                if ( *d == '\0' ) {     // found delimiter
                  yylloc.first_line   = str_lit_loc.first_line;
                  yylloc.first_column = str_lit_loc.first_column;
                  yylval.str_val = strbuf_take( &str_lit_buf );
                  BEGIN_RETURN;
                  return Y_STR_LIT;
                }
              }
	YY_BREAK
/* <X_RSTR> */
/***************************************************************************/
/*  STRING LITERALS, CHARACTER LITERALS, & INCLUDE FILES                   */
/***************************************************************************/

case 98:
YY_RULE_SETUP
#line 1429 "lexer.l"
{
                strbuf_init( &str_lit_buf );
                //
                // Save the start location because we want to use it as the
                // location for the literal, not its end location.
                //
                str_lit_loc = yylloc;

                char const quote = yytext[ yyleng - 1 ];
                BEGIN_CALL( (quote == '"' ? X_STR : X_CHAR) );
              }
	YY_BREAK
/* <INITIAL,X_PRE_TOKENS> */
/*
               * Common code between X_CHAR, X_INCLUDE, and X_STR.
               * Multicharacter literals are legal, but implementation-defined.
               */

/* Escaped characters are copied verbatim, not interpreted. */
case 99:
/* rule 99 can match eol */
YY_RULE_SETUP
#line 1450 "lexer.l"
{ strbuf_putsn( &str_lit_buf, yytext, yyleng ); }
	YY_BREAK
case 100:
/* rule 100 can match eol */
YY_RULE_SETUP
#line 1451 "lexer.l"
{
                print_error( &str_lit_loc,
                  "unterminated %s literal\n",
                  YY_START == X_CHAR ? "character" : "string"
                );
                strbuf_reset( &str_lit_buf );
                return Y_LEXER_ERROR;
              }
	YY_BREAK
/* <X_CHAR,X_INCLUDE,X_STR> */

case 101:
YY_RULE_SETUP
#line 1464 "lexer.l"
{ strbuf_putsn( &str_lit_buf, yytext, yyleng ); }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 1465 "lexer.l"
{
                yylloc.first_line   = str_lit_loc.first_line;
                yylloc.first_column = str_lit_loc.first_column;
                yylval.str_val = strbuf_take( &str_lit_buf );
                BEGIN_RETURN;
                return Y_CHAR_LIT;
              }
	YY_BREAK
/* <X_CHAR> */
/*
               * Common code between X_INCLUDE and X_STR:
               *
               * 1. X_INCLUDE is the same as X_STR except we need to do
               *    different things upon the terminating " (which is why
               *    X_INCLUDE exists rather than just using X_STR).
               *
               * 2. X_STR is the same as X_CHAR except " replaces '.
               */
case 103:
YY_RULE_SETUP
#line 1484 "lexer.l"
{
                strbuf_putsn( &str_lit_buf, yytext, yyleng );
              }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 1488 "lexer.l"
{
                push_file( str_lit_buf.str, &str_lit_loc );
                strbuf_reset( &str_lit_buf );
                BEGIN( INITIAL );
              }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 1494 "lexer.l"
{
                yylloc.first_line   = str_lit_loc.first_line;
                yylloc.first_column = str_lit_loc.first_column;
                yylval.str_val = strbuf_take( &str_lit_buf );
                BEGIN_RETURN;
                return Y_STR_LIT;
              }
	YY_BREAK
/***************************************************************************/
/*  COMMENTS                                                               */
/***************************************************************************/

case 106:
YY_RULE_SETUP
#line 1508 "lexer.l"
{                         /* ignore C-style comments */
                for ( int c = input(), prev = '\0'; ; prev = c, c = input() ) {
                  if ( c == EOF ) {
                    print_error( &yylloc, "unterminated comment\n" );
                    return Y_LEXER_ERROR;
                  }
                  ++token_column;
                  if ( c == '/' && prev == '*' )
                    break;
                  if ( c == '\n' )
                    newline();
                } // for

                if ( YY_START == X_PRE_TOKENS ) {
                  //
                  // When lexing tokens for the C preprocessor, comments have
                  // to turn into a space, e.g.:
                  //
                  //      cdecl> #define Q(A,B)  A/**/B
                  //      cdecl> expand Q(x,y)
                  //      Q(x, y) => A B
                  //      | A => x
                  //      | B => y
                  //      Q(x, y) => x y
                  //
                  return Y_PRE_SPACE;
                }
              }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 1537 "lexer.l"
;                         /* ignore C++-style comments */
	YY_BREAK
/* <*> */
/***************************************************************************/
/*  WHITESPACE                                                             */
/***************************************************************************/
case 108:
YY_RULE_SETUP
#line 1545 "lexer.l"
{
                if ( YY_START == X_PRE_TOKENS ) {
                  //
                  // When lexing tokens for the C preprocessor, whitespace is
                  // significant.
                  //
                  return Y_PRE_SPACE;
                }
              }
	YY_BREAK
case 109:
/* rule 109 can match eol */
YY_RULE_SETUP
#line 1555 "lexer.l"
{
                newline();
                BEGIN( INITIAL );
                return Y_END;
              }
	YY_BREAK
/***************************************************************************/
/*  PREPROCESSOR                                                           */
/***************************************************************************/

/*
               * Special case: if "define" is followed by an identifier that is
               * _immediately_ followed by '(' with no intervening whitespace,
               * it's defining a function-like macro, so set a flag we can use
               * it in {identifier} below.
               */
case 110:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 6;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 1572 "lexer.l"
{
                is_func_like_macro = true;
                return Y_PRE_define;
              }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 1577 "lexer.l"
{
                p_keyword_t const *const pk = p_keyword_find( yytext );
                if ( pk != NULL )
                  return pk->y_token_id;
                yylval.name = check_strdup( yytext );
                if ( !is_func_like_macro ) {
                  //
                  // We can switch to X_PRE_TOKENS now; otherwise we switch
                  // after lexing ')' below.
                  //
                  BEGIN( X_PRE_TOKENS );
                }
                return Y_NAME;
              }
	YY_BREAK
case 112:
#line 1593 "lexer.l"
case 113:
YY_RULE_SETUP
#line 1593 "lexer.l"
{ return yytext[0]    ; }
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 1594 "lexer.l"
{
                BEGIN( X_PRE_TOKENS );
                return ')';
              }
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 1599 "lexer.l"
{ return Y_ELLIPSIS   ; }
	YY_BREAK
/* <X_PRE_COMMAND> */

case 116:
YY_RULE_SETUP
#line 1605 "lexer.l"
{
                if ( strcmp( yytext, L_PRE___VA_ARGS__ ) == 0 )
                  return Y_PRE___VA_ARGS__;
                if ( strcmp( yytext, L_PRE___VA_OPT__ ) == 0 )
                  return Y_PRE___VA_OPT__;
                yylval.name = check_strdup( yytext );
                return Y_NAME;
              }
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 1614 "lexer.l"
{ set_digraph( "##" ); return Y_PRE_CONCAT; }
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 1615 "lexer.l"
{ set_digraph( "#"  ); return '#'         ; }
	YY_BREAK
case 119:
YY_RULE_SETUP
#line 1617 "lexer.l"
{ set_trigraph( "##" ); return Y_PRE_CONCAT ; }
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 1618 "lexer.l"
{ set_trigraph( "#"  ); return '#'          ; }
	YY_BREAK
case 121:
YY_RULE_SETUP
#line 1620 "lexer.l"
{ return Y_PRE_CONCAT ; }
	YY_BREAK
case 122:
#line 1623 "lexer.l"
case 123:
#line 1624 "lexer.l"
case 124:
#line 1625 "lexer.l"
case 125:
YY_RULE_SETUP
#line 1625 "lexer.l"
{ return yytext[0]    ; }
	YY_BREAK
/* <X_PRE_TOKENS> */

/*
               * Special case: if an identifier is followed by '(', it's a
               * function-like macro, so defer switching to the X_PRE_TOKENS
               * state until after lexing '(' so we don't have to deal with
               * optional whitespace before the '(' being significant.
               */
case 126:
YY_RULE_SETUP
#line 1636 "lexer.l"
{
                yylval.name = check_strdup( yytext );
                return Y_NAME;
              }
	YY_BREAK
case 127:
YY_RULE_SETUP
#line 1641 "lexer.l"
{                        // object-like macro
                yylval.name = check_strdup( yytext );
                BEGIN( X_PRE_TOKENS );
                return Y_NAME;
              }
	YY_BREAK
case 128:
YY_RULE_SETUP
#line 1647 "lexer.l"
{
                BEGIN( X_PRE_TOKENS );
                return '(';
              }
	YY_BREAK
/* <X_EXPAND> */
/***************************************************************************/
/*  OTHER START STATES                                                     */
/***************************************************************************/

case 129:
YY_RULE_SETUP
#line 1660 "lexer.l"
{
                yylval.name = check_strdup( yytext );
                return Y_SET_OPTION;
              }
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 1665 "lexer.l"
{ return yytext[0]; }
	YY_BREAK
case 131:
YY_RULE_SETUP
#line 1666 "lexer.l"
{
                BEGIN( INITIAL );
                return yytext[0];
              }
	YY_BREAK
/* <X_SET> */

case 132:
YY_RULE_SETUP
#line 1675 "lexer.l"
{
                yylval.name = check_strdup( yytext );
                return Y_GLOB;
              }
	YY_BREAK
case 133:
YY_RULE_SETUP
#line 1680 "lexer.l"
{
                BEGIN( INITIAL );
                return yytext[0];
              }
	YY_BREAK
/* <S_SHOW> */
/***************************************************************************/
/*  NON-MATCH & EOF                                                        */
/***************************************************************************/
case 134:
YY_RULE_SETUP
#line 1691 "lexer.l"
{
                return Y_ERROR;
              }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(X_EXPAND):
case YY_STATE_EOF(X_INCLUDE):
case YY_STATE_EOF(X_PRE_COMMAND):
case YY_STATE_EOF(X_PRE_TOKENS):
case YY_STATE_EOF(X_SET):
case YY_STATE_EOF(S_SHOW):
case YY_STATE_EOF(X_CHAR):
case YY_STATE_EOF(X_STR):
case YY_STATE_EOF(X_RSTR):
#line 1695 "lexer.l"
{
                newline();
                BEGIN( INITIAL );

                if ( pop_file() )
                  return Y_END;

                //
                // The first time we encounter EOF (not for an include file),
                // we want to treat it as if it were a newline by returning
                // Y_END so commands in the parser always end in Y_END.
                //
                // Requesting more characters after encountering EOF will
                // simply continue to return EOF, so the second time we
                // encounter EOF, treat it as EOF by returning no token.
                //
                return (is_eof = !is_eof) ? Y_END : YY_NULL;
              }
	YY_BREAK
case 135:
YY_RULE_SETUP
#line 1714 "lexer.l"
ECHO;
	YY_BREAK
#line 4137 "lexer.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	(yy_state_ptr) = (yy_state_buf);
	*(yy_state_ptr)++ = yy_current_state;

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 754 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		*(yy_state_ptr)++ = yy_current_state;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    
	YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 754 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 753);
	if ( ! yy_is_jam )
		*(yy_state_ptr)++ = yy_current_state;

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');
	if ( YY_CURRENT_BUFFER_LVALUE->yy_at_bol )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

    (yy_state_buf) = 0;
    (yy_state_ptr) = 0;
    (yy_full_match) = 0;
    (yy_lp) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    yyfree ( (yy_state_buf) );
    (yy_state_buf)  = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 1714 "lexer.l"


/// @endcond

// Re-enable warnings.
#ifdef __clang__
# pragma clang diagnostic pop
#endif /* __clang__ */
#ifdef __GNUC__
# pragma GCC diagnostic pop
#endif /* __GNUC__ */

////////// local functions ////////////////////////////////////////////////////

/**
 * @addtogroup lexer-group
 * @{
 */

// LCOV_EXCL_START
/**
 * Called by Flex only when there's a fatal error.
 *
 * @param msg The error message to print.
 */
_Noreturn
static void lexer_fatal( char const *msg ) {
  if ( msg == NULL ) {
    // Never true -- here just to silence the "unused function" warning.
    yy_fatal_error( msg );
  }

  //
  // This is defined down here to avoid having to declare yy_fatal_error
  // ourselves and having to get it right being subject to possible changes in
  // its signature in different Flex versions.
  //
  INTERNAL_ERROR( "lexer_fatal(): %s\n", msg );
}
// LCOV_EXCL_STOP

/** @} */

////////// extern functions ///////////////////////////////////////////////////

void lexer_init( void ) {
  ASSERT_RUN_ONCE();
  ATEXIT( &lexer_cleanup );
  include_init();
}

char const* lexer_input_line( size_t *rv_len ) {
  assert( rv_len != NULL );
  *rv_len = input_sbuf.len;
  return input_sbuf.str;
}

c_loc_t lexer_loc( void ) {
  c_loc_t rv_loc = yylloc;
  if ( yytext[0] == '\n' ) {
    //
    // If the current token is '\n', it means first_line & last_line are
    // already on the next line, but we want the line that the '\n' is on which
    // is the previous line.
    //
    --rv_loc.first_line;
    --rv_loc.last_line;
  }
  return rv_loc;
}

void lexer_pop_string( void ) {
  lexer_pop_buffer();
  yylineno_stack_pop();
  BEGIN( INITIAL );
}

void lexer_push_string( char const *s, size_t s_len, c_loc_num_t line_no ) {
  assert( s != NULL );
  FILE *const f = fmemopen( CONST_CAST( void*, s ), s_len, "r" );
  PERROR_EXIT_IF( f == NULL, EX_IOERR );
  yyin = f;
  yypush_buffer_state( yy_create_buffer( yyin, YY_BUF_SIZE ) );
  yylineno_stack_push();
  yylineno = line_no;
  BEGIN( X_PRE_TOKENS );
}

void lexer_reset( bool hard_reset ) {
  if ( hard_reset ) {
    is_eof = false;
    include_cleanup();
    include_init();
    newline();
    if ( opt_lineno == 0 )
      yylineno = 1;
  }
  BEGIN( INITIAL );
  digraph_warned = trigraph_warned = false;
  strbuf_reset( &input_sbuf );
  input_sent = 0;
  is_constrained_auto = false;
  is_func_like_macro = false;
  lexer_find = LEXER_FIND_ANY;
  lexer_is_param_list_decl = false;
  lexer_keyword_ctx = C_KW_CTX_DEFAULT;
  strbuf_reset( &str_lit_buf );
  yylineno_stack_top = -1;
  yy_start_stack_top = -1;
}

char const* printable_yytext( void ) {
  switch ( yytext[0] ) {
    case '\0':
    case '\n':
      return NULL;
    default:
      return yytext;
  } // switch
}

///////////////////////////////////////////////////////////////////////////////
/* vim:set et sw=2 ts=2: */

