// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: localhost.proto

package localhost

import (
	bytes "bytes"
	context "context"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type OutputMessage_Status int32

const (
	RUNNING OutputMessage_Status = 0
	DONE    OutputMessage_Status = 1
	KILLED  OutputMessage_Status = 2
)

var OutputMessage_Status_name = map[int32]string{
	0: "RUNNING",
	1: "DONE",
	2: "KILLED",
}

var OutputMessage_Status_value = map[string]int32{
	"RUNNING": 0,
	"DONE":    1,
	"KILLED":  2,
}

func (OutputMessage_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a5c3d86c7f529fcc, []int{1, 0}
}

// InputMessage contains stdin data
type InputMessage struct {
	Command []string `protobuf:"bytes,1,rep,name=command,proto3" json:"command,omitempty"`
	Stdin   []byte   `protobuf:"bytes,2,opt,name=stdin,proto3" json:"stdin,omitempty"`
	Dir     string   `protobuf:"bytes,3,opt,name=dir,proto3" json:"dir,omitempty"`
}

func (m *InputMessage) Reset()      { *m = InputMessage{} }
func (*InputMessage) ProtoMessage() {}
func (*InputMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5c3d86c7f529fcc, []int{0}
}
func (m *InputMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InputMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InputMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InputMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputMessage.Merge(m, src)
}
func (m *InputMessage) XXX_Size() int {
	return m.Size()
}
func (m *InputMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_InputMessage.DiscardUnknown(m)
}

var xxx_messageInfo_InputMessage proto.InternalMessageInfo

func (m *InputMessage) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *InputMessage) GetStdin() []byte {
	if m != nil {
		return m.Stdin
	}
	return nil
}

func (m *InputMessage) GetDir() string {
	if m != nil {
		return m.Dir
	}
	return ""
}

// OutputMessage contains stdout and stderr data
type OutputMessage struct {
	Stdout   []byte               `protobuf:"bytes,1,opt,name=stdout,proto3" json:"stdout,omitempty"`
	Stderr   []byte               `protobuf:"bytes,2,opt,name=stderr,proto3" json:"stderr,omitempty"`
	Status   OutputMessage_Status `protobuf:"varint,3,opt,name=status,proto3,enum=moby.localhost.v1.OutputMessage_Status" json:"status,omitempty"`
	ExitCode int32                `protobuf:"varint,4,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
}

func (m *OutputMessage) Reset()      { *m = OutputMessage{} }
func (*OutputMessage) ProtoMessage() {}
func (*OutputMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5c3d86c7f529fcc, []int{1}
}
func (m *OutputMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OutputMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OutputMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OutputMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputMessage.Merge(m, src)
}
func (m *OutputMessage) XXX_Size() int {
	return m.Size()
}
func (m *OutputMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputMessage.DiscardUnknown(m)
}

var xxx_messageInfo_OutputMessage proto.InternalMessageInfo

func (m *OutputMessage) GetStdout() []byte {
	if m != nil {
		return m.Stdout
	}
	return nil
}

func (m *OutputMessage) GetStderr() []byte {
	if m != nil {
		return m.Stderr
	}
	return nil
}

func (m *OutputMessage) GetStatus() OutputMessage_Status {
	if m != nil {
		return m.Status
	}
	return RUNNING
}

func (m *OutputMessage) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

// BytesMessage contains a chunk of byte data
type BytesMessage struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *BytesMessage) Reset()      { *m = BytesMessage{} }
func (*BytesMessage) ProtoMessage() {}
func (*BytesMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5c3d86c7f529fcc, []int{2}
}
func (m *BytesMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BytesMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BytesMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BytesMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BytesMessage.Merge(m, src)
}
func (m *BytesMessage) XXX_Size() int {
	return m.Size()
}
func (m *BytesMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_BytesMessage.DiscardUnknown(m)
}

var xxx_messageInfo_BytesMessage proto.InternalMessageInfo

func (m *BytesMessage) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterEnum("moby.localhost.v1.OutputMessage_Status", OutputMessage_Status_name, OutputMessage_Status_value)
	proto.RegisterType((*InputMessage)(nil), "moby.localhost.v1.InputMessage")
	proto.RegisterType((*OutputMessage)(nil), "moby.localhost.v1.OutputMessage")
	proto.RegisterType((*BytesMessage)(nil), "moby.localhost.v1.BytesMessage")
}

func init() { proto.RegisterFile("localhost.proto", fileDescriptor_a5c3d86c7f529fcc) }

var fileDescriptor_a5c3d86c7f529fcc = []byte{
	// 388 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x92, 0xc1, 0xae, 0xd2, 0x40,
	0x14, 0x86, 0x7b, 0x68, 0x29, 0xf4, 0x88, 0x5a, 0x27, 0xc6, 0x34, 0x98, 0x8c, 0x4d, 0x37, 0x36,
	0x31, 0x69, 0x14, 0x1f, 0x80, 0x04, 0x21, 0x84, 0x00, 0x85, 0xd4, 0xb8, 0x71, 0x63, 0x4a, 0x3b,
	0x51, 0x12, 0x60, 0x48, 0x3b, 0x35, 0xb0, 0xf3, 0x11, 0x7c, 0x0c, 0x1f, 0xc5, 0xb8, 0x62, 0xc9,
	0x52, 0xca, 0xc6, 0x25, 0x0b, 0x1f, 0xc0, 0x50, 0x5a, 0x2f, 0x37, 0x97, 0x84, 0xcd, 0xdd, 0x9d,
	0xff, 0xcf, 0x39, 0x5f, 0xff, 0xbf, 0x19, 0x7c, 0x3c, 0xe3, 0x81, 0x3f, 0xfb, 0xc2, 0x63, 0xe1,
	0x2c, 0x23, 0x2e, 0x38, 0x79, 0x32, 0xe7, 0x93, 0xb5, 0x73, 0xe3, 0x7e, 0x7d, 0x63, 0x8d, 0xb1,
	0xd6, 0x5b, 0x2c, 0x13, 0x31, 0x64, 0x71, 0xec, 0x7f, 0x66, 0xc4, 0xc0, 0x4a, 0xc0, 0xe7, 0x73,
	0x7f, 0x11, 0x1a, 0x60, 0xca, 0xb6, 0xe6, 0x15, 0x92, 0x3c, 0xc5, 0x72, 0x2c, 0xc2, 0xe9, 0xc2,
	0x28, 0x99, 0x60, 0xd7, 0xbc, 0x93, 0x20, 0x3a, 0xca, 0xe1, 0x34, 0x32, 0x64, 0x13, 0x6c, 0xcd,
	0x3b, 0x8e, 0xd6, 0x2f, 0xc0, 0x87, 0xa3, 0x44, 0x9c, 0x31, 0x9f, 0xa1, 0x1a, 0x8b, 0x90, 0x27,
	0xc2, 0x80, 0xec, 0x34, 0x57, 0xb9, 0xcf, 0xa2, 0x28, 0x47, 0xe6, 0x8a, 0x34, 0x8f, 0xbe, 0x2f,
	0x92, 0x38, 0xc3, 0x3e, 0x6a, 0xbc, 0x74, 0xee, 0xe4, 0x76, 0x6e, 0x7d, 0xc1, 0x79, 0x9f, 0xad,
	0x7b, 0xf9, 0x19, 0x79, 0x8e, 0x1a, 0x5b, 0x4d, 0xc5, 0xa7, 0x80, 0x87, 0xcc, 0x50, 0x4c, 0xb0,
	0xcb, 0x5e, 0xf5, 0x68, 0xbc, 0xe3, 0x21, 0xb3, 0x5e, 0xa1, 0x7a, 0x5a, 0x27, 0x0f, 0xb0, 0xe2,
	0x7d, 0x70, 0xdd, 0x9e, 0xdb, 0xd5, 0x25, 0x52, 0x45, 0xa5, 0x3d, 0x72, 0x3b, 0x3a, 0x10, 0x44,
	0xb5, 0xdf, 0x1b, 0x0c, 0x3a, 0x6d, 0xbd, 0x64, 0x59, 0x58, 0x6b, 0xad, 0x05, 0x8b, 0x8b, 0x2a,
	0x04, 0x95, 0xd0, 0x17, 0x7e, 0x5e, 0x24, 0x9b, 0x1b, 0x7f, 0x01, 0xb5, 0x41, 0x91, 0x8d, 0x0c,
	0x51, 0xe9, 0xac, 0x58, 0x40, 0x5e, 0x5c, 0x08, 0x7d, 0xfe, 0xa7, 0xeb, 0xe6, 0xb5, 0x56, 0x36,
	0xbc, 0x06, 0xd2, 0x47, 0xb9, 0xcb, 0xc4, 0x45, 0xda, 0x79, 0xb0, 0xfa, 0xb5, 0x85, 0x02, 0x36,
	0x4e, 0xee, 0x09, 0xd6, 0x6a, 0x6e, 0x76, 0x54, 0xda, 0xee, 0xa8, 0x74, 0xd8, 0x51, 0xf8, 0x96,
	0x52, 0xf8, 0x91, 0x52, 0xf8, 0x99, 0x52, 0xd8, 0xa4, 0x14, 0x7e, 0xa7, 0x14, 0xfe, 0xa4, 0x54,
	0x3a, 0xa4, 0x14, 0xbe, 0xef, 0xa9, 0xb4, 0xd9, 0x53, 0x69, 0xbb, 0xa7, 0xd2, 0x47, 0xed, 0x3f,
	0x74, 0xa2, 0x66, 0x8f, 0xf2, 0xed, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x50, 0xd1, 0x4b, 0xfa,
	0xa7, 0x02, 0x00, 0x00,
}

func (x OutputMessage_Status) String() string {
	s, ok := OutputMessage_Status_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *InputMessage) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*InputMessage)
	if !ok {
		that2, ok := that.(InputMessage)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Command) != len(that1.Command) {
		return false
	}
	for i := range this.Command {
		if this.Command[i] != that1.Command[i] {
			return false
		}
	}
	if !bytes.Equal(this.Stdin, that1.Stdin) {
		return false
	}
	if this.Dir != that1.Dir {
		return false
	}
	return true
}
func (this *OutputMessage) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OutputMessage)
	if !ok {
		that2, ok := that.(OutputMessage)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Stdout, that1.Stdout) {
		return false
	}
	if !bytes.Equal(this.Stderr, that1.Stderr) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.ExitCode != that1.ExitCode {
		return false
	}
	return true
}
func (this *BytesMessage) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*BytesMessage)
	if !ok {
		that2, ok := that.(BytesMessage)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *InputMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&localhost.InputMessage{")
	s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	s = append(s, "Stdin: "+fmt.Sprintf("%#v", this.Stdin)+",\n")
	s = append(s, "Dir: "+fmt.Sprintf("%#v", this.Dir)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OutputMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&localhost.OutputMessage{")
	s = append(s, "Stdout: "+fmt.Sprintf("%#v", this.Stdout)+",\n")
	s = append(s, "Stderr: "+fmt.Sprintf("%#v", this.Stderr)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "ExitCode: "+fmt.Sprintf("%#v", this.ExitCode)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *BytesMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&localhost.BytesMessage{")
	s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringLocalhost(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// LocalhostClient is the client API for Localhost service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LocalhostClient interface {
	Exec(ctx context.Context, opts ...grpc.CallOption) (Localhost_ExecClient, error)
	// Get fetches a file or dir from the localhost and copies it to buildkit
	Get(ctx context.Context, opts ...grpc.CallOption) (Localhost_GetClient, error)
	// Put sends a file or dir from buildkit and tells the localhost to save it locally
	Put(ctx context.Context, opts ...grpc.CallOption) (Localhost_PutClient, error)
}

type localhostClient struct {
	cc *grpc.ClientConn
}

func NewLocalhostClient(cc *grpc.ClientConn) LocalhostClient {
	return &localhostClient{cc}
}

func (c *localhostClient) Exec(ctx context.Context, opts ...grpc.CallOption) (Localhost_ExecClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Localhost_serviceDesc.Streams[0], "/moby.localhost.v1.Localhost/Exec", opts...)
	if err != nil {
		return nil, err
	}
	x := &localhostExecClient{stream}
	return x, nil
}

type Localhost_ExecClient interface {
	Send(*InputMessage) error
	Recv() (*OutputMessage, error)
	grpc.ClientStream
}

type localhostExecClient struct {
	grpc.ClientStream
}

func (x *localhostExecClient) Send(m *InputMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *localhostExecClient) Recv() (*OutputMessage, error) {
	m := new(OutputMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *localhostClient) Get(ctx context.Context, opts ...grpc.CallOption) (Localhost_GetClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Localhost_serviceDesc.Streams[1], "/moby.localhost.v1.Localhost/Get", opts...)
	if err != nil {
		return nil, err
	}
	x := &localhostGetClient{stream}
	return x, nil
}

type Localhost_GetClient interface {
	Send(*BytesMessage) error
	Recv() (*BytesMessage, error)
	grpc.ClientStream
}

type localhostGetClient struct {
	grpc.ClientStream
}

func (x *localhostGetClient) Send(m *BytesMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *localhostGetClient) Recv() (*BytesMessage, error) {
	m := new(BytesMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *localhostClient) Put(ctx context.Context, opts ...grpc.CallOption) (Localhost_PutClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Localhost_serviceDesc.Streams[2], "/moby.localhost.v1.Localhost/Put", opts...)
	if err != nil {
		return nil, err
	}
	x := &localhostPutClient{stream}
	return x, nil
}

type Localhost_PutClient interface {
	Send(*BytesMessage) error
	Recv() (*BytesMessage, error)
	grpc.ClientStream
}

type localhostPutClient struct {
	grpc.ClientStream
}

func (x *localhostPutClient) Send(m *BytesMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *localhostPutClient) Recv() (*BytesMessage, error) {
	m := new(BytesMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// LocalhostServer is the server API for Localhost service.
type LocalhostServer interface {
	Exec(Localhost_ExecServer) error
	// Get fetches a file or dir from the localhost and copies it to buildkit
	Get(Localhost_GetServer) error
	// Put sends a file or dir from buildkit and tells the localhost to save it locally
	Put(Localhost_PutServer) error
}

// UnimplementedLocalhostServer can be embedded to have forward compatible implementations.
type UnimplementedLocalhostServer struct {
}

func (*UnimplementedLocalhostServer) Exec(srv Localhost_ExecServer) error {
	return status.Errorf(codes.Unimplemented, "method Exec not implemented")
}
func (*UnimplementedLocalhostServer) Get(srv Localhost_GetServer) error {
	return status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedLocalhostServer) Put(srv Localhost_PutServer) error {
	return status.Errorf(codes.Unimplemented, "method Put not implemented")
}

func RegisterLocalhostServer(s *grpc.Server, srv LocalhostServer) {
	s.RegisterService(&_Localhost_serviceDesc, srv)
}

func _Localhost_Exec_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(LocalhostServer).Exec(&localhostExecServer{stream})
}

type Localhost_ExecServer interface {
	Send(*OutputMessage) error
	Recv() (*InputMessage, error)
	grpc.ServerStream
}

type localhostExecServer struct {
	grpc.ServerStream
}

func (x *localhostExecServer) Send(m *OutputMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *localhostExecServer) Recv() (*InputMessage, error) {
	m := new(InputMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Localhost_Get_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(LocalhostServer).Get(&localhostGetServer{stream})
}

type Localhost_GetServer interface {
	Send(*BytesMessage) error
	Recv() (*BytesMessage, error)
	grpc.ServerStream
}

type localhostGetServer struct {
	grpc.ServerStream
}

func (x *localhostGetServer) Send(m *BytesMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *localhostGetServer) Recv() (*BytesMessage, error) {
	m := new(BytesMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Localhost_Put_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(LocalhostServer).Put(&localhostPutServer{stream})
}

type Localhost_PutServer interface {
	Send(*BytesMessage) error
	Recv() (*BytesMessage, error)
	grpc.ServerStream
}

type localhostPutServer struct {
	grpc.ServerStream
}

func (x *localhostPutServer) Send(m *BytesMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *localhostPutServer) Recv() (*BytesMessage, error) {
	m := new(BytesMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Localhost_serviceDesc = grpc.ServiceDesc{
	ServiceName: "moby.localhost.v1.Localhost",
	HandlerType: (*LocalhostServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Exec",
			Handler:       _Localhost_Exec_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Get",
			Handler:       _Localhost_Get_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Put",
			Handler:       _Localhost_Put_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "localhost.proto",
}

func (m *InputMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InputMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InputMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Dir) > 0 {
		i -= len(m.Dir)
		copy(dAtA[i:], m.Dir)
		i = encodeVarintLocalhost(dAtA, i, uint64(len(m.Dir)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Stdin) > 0 {
		i -= len(m.Stdin)
		copy(dAtA[i:], m.Stdin)
		i = encodeVarintLocalhost(dAtA, i, uint64(len(m.Stdin)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Command) > 0 {
		for iNdEx := len(m.Command) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Command[iNdEx])
			copy(dAtA[i:], m.Command[iNdEx])
			i = encodeVarintLocalhost(dAtA, i, uint64(len(m.Command[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *OutputMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutputMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OutputMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ExitCode != 0 {
		i = encodeVarintLocalhost(dAtA, i, uint64(m.ExitCode))
		i--
		dAtA[i] = 0x20
	}
	if m.Status != 0 {
		i = encodeVarintLocalhost(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Stderr) > 0 {
		i -= len(m.Stderr)
		copy(dAtA[i:], m.Stderr)
		i = encodeVarintLocalhost(dAtA, i, uint64(len(m.Stderr)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Stdout) > 0 {
		i -= len(m.Stdout)
		copy(dAtA[i:], m.Stdout)
		i = encodeVarintLocalhost(dAtA, i, uint64(len(m.Stdout)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BytesMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BytesMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BytesMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintLocalhost(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintLocalhost(dAtA []byte, offset int, v uint64) int {
	offset -= sovLocalhost(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *InputMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovLocalhost(uint64(l))
		}
	}
	l = len(m.Stdin)
	if l > 0 {
		n += 1 + l + sovLocalhost(uint64(l))
	}
	l = len(m.Dir)
	if l > 0 {
		n += 1 + l + sovLocalhost(uint64(l))
	}
	return n
}

func (m *OutputMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Stdout)
	if l > 0 {
		n += 1 + l + sovLocalhost(uint64(l))
	}
	l = len(m.Stderr)
	if l > 0 {
		n += 1 + l + sovLocalhost(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovLocalhost(uint64(m.Status))
	}
	if m.ExitCode != 0 {
		n += 1 + sovLocalhost(uint64(m.ExitCode))
	}
	return n
}

func (m *BytesMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovLocalhost(uint64(l))
	}
	return n
}

func sovLocalhost(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozLocalhost(x uint64) (n int) {
	return sovLocalhost(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *InputMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InputMessage{`,
		`Command:` + fmt.Sprintf("%v", this.Command) + `,`,
		`Stdin:` + fmt.Sprintf("%v", this.Stdin) + `,`,
		`Dir:` + fmt.Sprintf("%v", this.Dir) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OutputMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OutputMessage{`,
		`Stdout:` + fmt.Sprintf("%v", this.Stdout) + `,`,
		`Stderr:` + fmt.Sprintf("%v", this.Stderr) + `,`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`ExitCode:` + fmt.Sprintf("%v", this.ExitCode) + `,`,
		`}`,
	}, "")
	return s
}
func (this *BytesMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&BytesMessage{`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringLocalhost(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *InputMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLocalhost
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InputMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InputMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLocalhost
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLocalhost
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLocalhost
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = append(m.Command, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stdin", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLocalhost
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLocalhost
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthLocalhost
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Stdin = append(m.Stdin[:0], dAtA[iNdEx:postIndex]...)
			if m.Stdin == nil {
				m.Stdin = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLocalhost
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLocalhost
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLocalhost
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dir = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLocalhost(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLocalhost
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutputMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLocalhost
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutputMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutputMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stdout", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLocalhost
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLocalhost
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthLocalhost
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Stdout = append(m.Stdout[:0], dAtA[iNdEx:postIndex]...)
			if m.Stdout == nil {
				m.Stdout = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stderr", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLocalhost
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLocalhost
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthLocalhost
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Stderr = append(m.Stderr[:0], dAtA[iNdEx:postIndex]...)
			if m.Stderr == nil {
				m.Stderr = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLocalhost
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= OutputMessage_Status(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExitCode", wireType)
			}
			m.ExitCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLocalhost
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExitCode |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLocalhost(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLocalhost
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BytesMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLocalhost
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BytesMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BytesMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLocalhost
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLocalhost
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthLocalhost
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLocalhost(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLocalhost
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipLocalhost(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowLocalhost
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLocalhost
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLocalhost
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthLocalhost
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupLocalhost
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthLocalhost
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthLocalhost        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowLocalhost          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupLocalhost = fmt.Errorf("proto: unexpected end of group")
)
