/*
 * Please edit these settings to match your system.
 *
 * When you're done, type 'make' to compile and link.
 * Then you may install with 'make install'.
 */
#ifndef MMIX_PARAMS_H
#define MMIX_PARAMS_H

#define DRAW_BUFSIZE         5555
#define MIXER_UPDATES       55555
#define WANT_NICE_BOXES         1

/*
 * ESC seqences, you may change some of them ...
 * (these are vt100, xterm, linux, xterm-color compatible)
 *
 *
 * style:  00=none 01=bold 04=underscore 05=blink 07=reverse 08=concealed
 * fg: 30=black 31=red 32=green 33=yellow 34=blue 35=magenta 36=cyan 37=grey
 * bg: 40=black 41=red 42=green 43=yellow 44=blue 45=magenta 46=cyan 47=grey
 */

#define T_NORMAL   "\033[0m"         /* normal mode */
#define T_BOLD     "\033[1m"         /* bold mode */
#define T_HOME     "\033[H"          /* goto 0,0 */
#define T_CLEAR    "\033[2J"         /* clear screen */
#define T_GOTO_XY  "\033[%d;%dH"     /* goto x,y position (%d=int) */
#define T_INIT     "\e[?25l\e(B\e)0" /* for init stuff */
#define T_QUIT     "\e[?25h"         /* for quit stuff */

/* box drawing */
#if !WANT_NICE_BOXES
/* for ugly terms, use this: */
#define AC_TL      ","   /* top left */
#define AC_TR      "."   /* top right */
#define AC_BL      "`"   /* bottom left */
#define AC_BR      "'"   /* bottom right */
#define AC_MT      "^"   /* top 2middle */
#define AC_MB      "v"   /* bottom 2middle */
#define AC_ML      ">"   /* left 2middle */
#define AC_MR      "<"   /* right 2middle */
#define AC_MM      "+"   /* middle + */
#define AC_HL      "-"   /* hline - */
#define AC_VL      "|"   /* vline | */
#else
/* for good terms, use this: */
#define AC_TL      "\016l\017"   /* top left */
#define AC_TR      "\016k\017"   /* top right */
#define AC_BL      "\016m\017"   /* bottom left */
#define AC_BR      "\016j\017"   /* bottom right */
#define AC_MT      "\016v\017"   /* top 2middle */
#define AC_MB      "\016w\017"   /* bottom 2middle */
#define AC_ML      "\016t\017"   /* left 2middle */
#define AC_MR      "\016u\017"   /* right 2middle */
#define AC_MM      "\016n\017"   /* middle + */
#define AC_HL      "\016q\017"   /* hline - */
#define AC_VL      "\016x\017"   /* vline | */
#endif

/* colors */
#define C_VERSION  "\033[0;33m"  /* brown    - version, headlines */
#define C_BOX      "\033[0;34m"  /* blue     - boxdrawing */
#define C_DESCRIPT "\033[1;33m"  /* yellow   - descriptions */
#define C_NORMAL   "\033[0;37m"  /* grey     - normal/default/tracks */
#define C_MUTED    "\033[1;30m"  /* darkgrey - normal/default/tracks */
#define C_STATUS   "\033[0;31m"  /* red      - highlight */

/* volume/balance character */
#define VOL_HL  "-" /* unset ... */
#define VOL_BL  ">" /* left border */
#define VOL_BR  "<" /* right border */
#define VOL_L   "L" /* balance left */
#define VOL_M   "O" /* volume middle */
#define VOL_R   "R" /* balance right */

#endif
