// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/storage/v1/storage.proto

package storage

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for `CreateReadSession`.
type CreateReadSessionRequest struct {
	// Required. The request project that owns the session, in the form of
	// `projects/{project_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Session to be created.
	ReadSession *ReadSession `protobuf:"bytes,2,opt,name=read_session,json=readSession,proto3" json:"read_session,omitempty"`
	// Max initial number of streams. If unset or zero, the server will
	// provide a value of streams so as to produce reasonable throughput. Must be
	// non-negative. The number of streams may be lower than the requested number,
	// depending on the amount parallelism that is reasonable for the table. Error
	// will be returned if the max count is greater than the current system
	// max limit of 1,000.
	//
	// Streams must be read starting from offset 0.
	MaxStreamCount       int32    `protobuf:"varint,3,opt,name=max_stream_count,json=maxStreamCount,proto3" json:"max_stream_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateReadSessionRequest) Reset()         { *m = CreateReadSessionRequest{} }
func (m *CreateReadSessionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateReadSessionRequest) ProtoMessage()    {}
func (*CreateReadSessionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_79bf7871be7b3410, []int{0}
}

func (m *CreateReadSessionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateReadSessionRequest.Unmarshal(m, b)
}
func (m *CreateReadSessionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateReadSessionRequest.Marshal(b, m, deterministic)
}
func (m *CreateReadSessionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateReadSessionRequest.Merge(m, src)
}
func (m *CreateReadSessionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateReadSessionRequest.Size(m)
}
func (m *CreateReadSessionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateReadSessionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateReadSessionRequest proto.InternalMessageInfo

func (m *CreateReadSessionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateReadSessionRequest) GetReadSession() *ReadSession {
	if m != nil {
		return m.ReadSession
	}
	return nil
}

func (m *CreateReadSessionRequest) GetMaxStreamCount() int32 {
	if m != nil {
		return m.MaxStreamCount
	}
	return 0
}

// Request message for `ReadRows`.
type ReadRowsRequest struct {
	// Required. Stream to read rows from.
	ReadStream string `protobuf:"bytes,1,opt,name=read_stream,json=readStream,proto3" json:"read_stream,omitempty"`
	// The offset requested must be less than the last row read from Read.
	// Requesting a larger offset is undefined. If not specified, start reading
	// from offset zero.
	Offset               int64    `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadRowsRequest) Reset()         { *m = ReadRowsRequest{} }
func (m *ReadRowsRequest) String() string { return proto.CompactTextString(m) }
func (*ReadRowsRequest) ProtoMessage()    {}
func (*ReadRowsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_79bf7871be7b3410, []int{1}
}

func (m *ReadRowsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadRowsRequest.Unmarshal(m, b)
}
func (m *ReadRowsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadRowsRequest.Marshal(b, m, deterministic)
}
func (m *ReadRowsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadRowsRequest.Merge(m, src)
}
func (m *ReadRowsRequest) XXX_Size() int {
	return xxx_messageInfo_ReadRowsRequest.Size(m)
}
func (m *ReadRowsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadRowsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReadRowsRequest proto.InternalMessageInfo

func (m *ReadRowsRequest) GetReadStream() string {
	if m != nil {
		return m.ReadStream
	}
	return ""
}

func (m *ReadRowsRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

// Information on if the current connection is being throttled.
type ThrottleState struct {
	// How much this connection is being throttled. Zero means no throttling,
	// 100 means fully throttled.
	ThrottlePercent      int32    `protobuf:"varint,1,opt,name=throttle_percent,json=throttlePercent,proto3" json:"throttle_percent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ThrottleState) Reset()         { *m = ThrottleState{} }
func (m *ThrottleState) String() string { return proto.CompactTextString(m) }
func (*ThrottleState) ProtoMessage()    {}
func (*ThrottleState) Descriptor() ([]byte, []int) {
	return fileDescriptor_79bf7871be7b3410, []int{2}
}

func (m *ThrottleState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThrottleState.Unmarshal(m, b)
}
func (m *ThrottleState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThrottleState.Marshal(b, m, deterministic)
}
func (m *ThrottleState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThrottleState.Merge(m, src)
}
func (m *ThrottleState) XXX_Size() int {
	return xxx_messageInfo_ThrottleState.Size(m)
}
func (m *ThrottleState) XXX_DiscardUnknown() {
	xxx_messageInfo_ThrottleState.DiscardUnknown(m)
}

var xxx_messageInfo_ThrottleState proto.InternalMessageInfo

func (m *ThrottleState) GetThrottlePercent() int32 {
	if m != nil {
		return m.ThrottlePercent
	}
	return 0
}

// Estimated stream statistics for a given Stream.
type StreamStats struct {
	// Represents the progress of the current stream.
	Progress             *StreamStats_Progress `protobuf:"bytes,2,opt,name=progress,proto3" json:"progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *StreamStats) Reset()         { *m = StreamStats{} }
func (m *StreamStats) String() string { return proto.CompactTextString(m) }
func (*StreamStats) ProtoMessage()    {}
func (*StreamStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_79bf7871be7b3410, []int{3}
}

func (m *StreamStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamStats.Unmarshal(m, b)
}
func (m *StreamStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamStats.Marshal(b, m, deterministic)
}
func (m *StreamStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamStats.Merge(m, src)
}
func (m *StreamStats) XXX_Size() int {
	return xxx_messageInfo_StreamStats.Size(m)
}
func (m *StreamStats) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamStats.DiscardUnknown(m)
}

var xxx_messageInfo_StreamStats proto.InternalMessageInfo

func (m *StreamStats) GetProgress() *StreamStats_Progress {
	if m != nil {
		return m.Progress
	}
	return nil
}

type StreamStats_Progress struct {
	// The fraction of rows assigned to the stream that have been processed by
	// the server so far, not including the rows in the current response
	// message.
	//
	// This value, along with `at_response_end`, can be used to interpolate
	// the progress made as the rows in the message are being processed using
	// the following formula: `at_response_start + (at_response_end -
	// at_response_start) * rows_processed_from_response / rows_in_response`.
	//
	// Note that if a filter is provided, the `at_response_end` value of the
	// previous response may not necessarily be equal to the
	// `at_response_start` value of the current response.
	AtResponseStart float64 `protobuf:"fixed64,1,opt,name=at_response_start,json=atResponseStart,proto3" json:"at_response_start,omitempty"`
	// Similar to `at_response_start`, except that this value includes the
	// rows in the current response.
	AtResponseEnd        float64  `protobuf:"fixed64,2,opt,name=at_response_end,json=atResponseEnd,proto3" json:"at_response_end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamStats_Progress) Reset()         { *m = StreamStats_Progress{} }
func (m *StreamStats_Progress) String() string { return proto.CompactTextString(m) }
func (*StreamStats_Progress) ProtoMessage()    {}
func (*StreamStats_Progress) Descriptor() ([]byte, []int) {
	return fileDescriptor_79bf7871be7b3410, []int{3, 0}
}

func (m *StreamStats_Progress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamStats_Progress.Unmarshal(m, b)
}
func (m *StreamStats_Progress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamStats_Progress.Marshal(b, m, deterministic)
}
func (m *StreamStats_Progress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamStats_Progress.Merge(m, src)
}
func (m *StreamStats_Progress) XXX_Size() int {
	return xxx_messageInfo_StreamStats_Progress.Size(m)
}
func (m *StreamStats_Progress) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamStats_Progress.DiscardUnknown(m)
}

var xxx_messageInfo_StreamStats_Progress proto.InternalMessageInfo

func (m *StreamStats_Progress) GetAtResponseStart() float64 {
	if m != nil {
		return m.AtResponseStart
	}
	return 0
}

func (m *StreamStats_Progress) GetAtResponseEnd() float64 {
	if m != nil {
		return m.AtResponseEnd
	}
	return 0
}

// Response from calling `ReadRows` may include row data, progress and
// throttling information.
type ReadRowsResponse struct {
	// Row data is returned in format specified during session creation.
	//
	// Types that are valid to be assigned to Rows:
	//	*ReadRowsResponse_AvroRows
	//	*ReadRowsResponse_ArrowRecordBatch
	Rows isReadRowsResponse_Rows `protobuf_oneof:"rows"`
	// Number of serialized rows in the rows block.
	RowCount int64 `protobuf:"varint,6,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// Statistics for the stream.
	Stats *StreamStats `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
	// Throttling state. If unset, the latest response still describes
	// the current throttling status.
	ThrottleState        *ThrottleState `protobuf:"bytes,5,opt,name=throttle_state,json=throttleState,proto3" json:"throttle_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ReadRowsResponse) Reset()         { *m = ReadRowsResponse{} }
func (m *ReadRowsResponse) String() string { return proto.CompactTextString(m) }
func (*ReadRowsResponse) ProtoMessage()    {}
func (*ReadRowsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_79bf7871be7b3410, []int{4}
}

func (m *ReadRowsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadRowsResponse.Unmarshal(m, b)
}
func (m *ReadRowsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadRowsResponse.Marshal(b, m, deterministic)
}
func (m *ReadRowsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadRowsResponse.Merge(m, src)
}
func (m *ReadRowsResponse) XXX_Size() int {
	return xxx_messageInfo_ReadRowsResponse.Size(m)
}
func (m *ReadRowsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadRowsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReadRowsResponse proto.InternalMessageInfo

type isReadRowsResponse_Rows interface {
	isReadRowsResponse_Rows()
}

type ReadRowsResponse_AvroRows struct {
	AvroRows *AvroRows `protobuf:"bytes,3,opt,name=avro_rows,json=avroRows,proto3,oneof"`
}

type ReadRowsResponse_ArrowRecordBatch struct {
	ArrowRecordBatch *ArrowRecordBatch `protobuf:"bytes,4,opt,name=arrow_record_batch,json=arrowRecordBatch,proto3,oneof"`
}

func (*ReadRowsResponse_AvroRows) isReadRowsResponse_Rows() {}

func (*ReadRowsResponse_ArrowRecordBatch) isReadRowsResponse_Rows() {}

func (m *ReadRowsResponse) GetRows() isReadRowsResponse_Rows {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *ReadRowsResponse) GetAvroRows() *AvroRows {
	if x, ok := m.GetRows().(*ReadRowsResponse_AvroRows); ok {
		return x.AvroRows
	}
	return nil
}

func (m *ReadRowsResponse) GetArrowRecordBatch() *ArrowRecordBatch {
	if x, ok := m.GetRows().(*ReadRowsResponse_ArrowRecordBatch); ok {
		return x.ArrowRecordBatch
	}
	return nil
}

func (m *ReadRowsResponse) GetRowCount() int64 {
	if m != nil {
		return m.RowCount
	}
	return 0
}

func (m *ReadRowsResponse) GetStats() *StreamStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

func (m *ReadRowsResponse) GetThrottleState() *ThrottleState {
	if m != nil {
		return m.ThrottleState
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReadRowsResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReadRowsResponse_AvroRows)(nil),
		(*ReadRowsResponse_ArrowRecordBatch)(nil),
	}
}

// Request message for `SplitReadStream`.
type SplitReadStreamRequest struct {
	// Required. Name of the stream to split.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A value in the range (0.0, 1.0) that specifies the fractional point at
	// which the original stream should be split. The actual split point is
	// evaluated on pre-filtered rows, so if a filter is provided, then there is
	// no guarantee that the division of the rows between the new child streams
	// will be proportional to this fractional value. Additionally, because the
	// server-side unit for assigning data is collections of rows, this fraction
	// will always map to a data storage boundary on the server side.
	Fraction             float64  `protobuf:"fixed64,2,opt,name=fraction,proto3" json:"fraction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SplitReadStreamRequest) Reset()         { *m = SplitReadStreamRequest{} }
func (m *SplitReadStreamRequest) String() string { return proto.CompactTextString(m) }
func (*SplitReadStreamRequest) ProtoMessage()    {}
func (*SplitReadStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_79bf7871be7b3410, []int{5}
}

func (m *SplitReadStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitReadStreamRequest.Unmarshal(m, b)
}
func (m *SplitReadStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitReadStreamRequest.Marshal(b, m, deterministic)
}
func (m *SplitReadStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitReadStreamRequest.Merge(m, src)
}
func (m *SplitReadStreamRequest) XXX_Size() int {
	return xxx_messageInfo_SplitReadStreamRequest.Size(m)
}
func (m *SplitReadStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitReadStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SplitReadStreamRequest proto.InternalMessageInfo

func (m *SplitReadStreamRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SplitReadStreamRequest) GetFraction() float64 {
	if m != nil {
		return m.Fraction
	}
	return 0
}

// Response message for `SplitReadStream`.
type SplitReadStreamResponse struct {
	// Primary stream, which contains the beginning portion of
	// |original_stream|. An empty value indicates that the original stream can no
	// longer be split.
	PrimaryStream *ReadStream `protobuf:"bytes,1,opt,name=primary_stream,json=primaryStream,proto3" json:"primary_stream,omitempty"`
	// Remainder stream, which contains the tail of |original_stream|. An empty
	// value indicates that the original stream can no longer be split.
	RemainderStream      *ReadStream `protobuf:"bytes,2,opt,name=remainder_stream,json=remainderStream,proto3" json:"remainder_stream,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SplitReadStreamResponse) Reset()         { *m = SplitReadStreamResponse{} }
func (m *SplitReadStreamResponse) String() string { return proto.CompactTextString(m) }
func (*SplitReadStreamResponse) ProtoMessage()    {}
func (*SplitReadStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_79bf7871be7b3410, []int{6}
}

func (m *SplitReadStreamResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitReadStreamResponse.Unmarshal(m, b)
}
func (m *SplitReadStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitReadStreamResponse.Marshal(b, m, deterministic)
}
func (m *SplitReadStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitReadStreamResponse.Merge(m, src)
}
func (m *SplitReadStreamResponse) XXX_Size() int {
	return xxx_messageInfo_SplitReadStreamResponse.Size(m)
}
func (m *SplitReadStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitReadStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SplitReadStreamResponse proto.InternalMessageInfo

func (m *SplitReadStreamResponse) GetPrimaryStream() *ReadStream {
	if m != nil {
		return m.PrimaryStream
	}
	return nil
}

func (m *SplitReadStreamResponse) GetRemainderStream() *ReadStream {
	if m != nil {
		return m.RemainderStream
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateReadSessionRequest)(nil), "google.cloud.bigquery.storage.v1.CreateReadSessionRequest")
	proto.RegisterType((*ReadRowsRequest)(nil), "google.cloud.bigquery.storage.v1.ReadRowsRequest")
	proto.RegisterType((*ThrottleState)(nil), "google.cloud.bigquery.storage.v1.ThrottleState")
	proto.RegisterType((*StreamStats)(nil), "google.cloud.bigquery.storage.v1.StreamStats")
	proto.RegisterType((*StreamStats_Progress)(nil), "google.cloud.bigquery.storage.v1.StreamStats.Progress")
	proto.RegisterType((*ReadRowsResponse)(nil), "google.cloud.bigquery.storage.v1.ReadRowsResponse")
	proto.RegisterType((*SplitReadStreamRequest)(nil), "google.cloud.bigquery.storage.v1.SplitReadStreamRequest")
	proto.RegisterType((*SplitReadStreamResponse)(nil), "google.cloud.bigquery.storage.v1.SplitReadStreamResponse")
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/storage/v1/storage.proto", fileDescriptor_79bf7871be7b3410)
}

var fileDescriptor_79bf7871be7b3410 = []byte{
	// 1051 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xef, 0x3a, 0x89, 0xe5, 0x8c, 0x93, 0x38, 0x9d, 0x43, 0x6b, 0xcc, 0xbf, 0x68, 0x55, 0xa1,
	0xd4, 0x71, 0x76, 0xb1, 0x8b, 0x4a, 0x09, 0x14, 0x64, 0x47, 0x55, 0x8b, 0xb8, 0x84, 0x71, 0x1b,
	0xa4, 0x2a, 0x62, 0x35, 0x5e, 0x4f, 0x36, 0x8b, 0x76, 0x77, 0xb6, 0x33, 0x63, 0xbb, 0x95, 0xe5,
	0x0b, 0x9c, 0x38, 0x73, 0xe6, 0x0b, 0x70, 0xe0, 0x3b, 0x70, 0x29, 0x52, 0x2f, 0x48, 0x70, 0xeb,
	0xa9, 0x07, 0x0e, 0xc0, 0x47, 0xe0, 0x84, 0xe6, 0xcf, 0xda, 0x8b, 0x4b, 0xb1, 0x93, 0x93, 0xdf,
	0xbe, 0xfd, 0xbd, 0xdf, 0xbc, 0xdf, 0x9b, 0xf7, 0x9e, 0x17, 0x38, 0x01, 0xa5, 0x41, 0x44, 0x5c,
	0x3f, 0xa2, 0x83, 0xbe, 0xdb, 0x0b, 0x83, 0x47, 0x03, 0xc2, 0x9e, 0xb8, 0x5c, 0x50, 0x86, 0x03,
	0xe2, 0x0e, 0x9b, 0x99, 0xe9, 0xa4, 0x8c, 0x0a, 0x0a, 0x77, 0x34, 0xde, 0x51, 0x78, 0x27, 0xc3,
	0x3b, 0x19, 0x68, 0xd8, 0xac, 0xbd, 0x61, 0x18, 0x71, 0x1a, 0xba, 0x38, 0x49, 0xa8, 0xc0, 0x22,
	0xa4, 0x09, 0xd7, 0xf1, 0xb5, 0xab, 0xb9, 0xb7, 0x7e, 0x14, 0x92, 0x44, 0x98, 0x17, 0x6f, 0xe7,
	0x5e, 0x9c, 0x86, 0x24, 0xea, 0x7b, 0x3d, 0x72, 0x86, 0x87, 0x21, 0x65, 0x06, 0xf0, 0x5a, 0x0e,
	0xc0, 0x08, 0xa7, 0x03, 0xe6, 0x9b, 0xa4, 0x6a, 0x8d, 0x85, 0x22, 0x30, 0x63, 0x74, 0x64, 0xd0,
	0x7b, 0x8b, 0xd1, 0x43, 0x46, 0x0d, 0x78, 0x7f, 0x89, 0xfa, 0x30, 0x82, 0x63, 0x0d, 0xb7, 0xff,
	0xb0, 0x40, 0xf5, 0x90, 0x11, 0x2c, 0x08, 0x22, 0xb8, 0xdf, 0x25, 0x9c, 0x87, 0x34, 0x41, 0xe4,
	0xd1, 0x80, 0x70, 0x01, 0x3f, 0x03, 0xc5, 0x14, 0x33, 0x92, 0x88, 0xaa, 0xb5, 0x63, 0xed, 0xae,
	0x77, 0x6e, 0xbc, 0x68, 0x17, 0xfe, 0x6e, 0xef, 0x83, 0x3d, 0x45, 0x9e, 0x69, 0x8a, 0x71, 0x82,
	0x03, 0xc2, 0xcc, 0xc5, 0xe0, 0x34, 0xe4, 0x8e, 0x4f, 0x63, 0xf7, 0x88, 0xd1, 0xaf, 0x88, 0x2f,
	0x90, 0xa1, 0x80, 0x0f, 0xc0, 0x06, 0x23, 0xb8, 0xef, 0x71, 0x7d, 0x46, 0xb5, 0xb0, 0x63, 0xed,
	0x96, 0x5b, 0xfb, 0xce, 0xa2, 0xfb, 0x71, 0x72, 0x89, 0x75, 0x56, 0x5e, 0xb4, 0x0b, 0xa8, 0xcc,
	0x66, 0x1e, 0xb8, 0x0b, 0xb6, 0x63, 0xfc, 0xd8, 0xd3, 0xa2, 0x3c, 0x9f, 0x0e, 0x12, 0x51, 0x5d,
	0xd9, 0xb1, 0x76, 0xd7, 0xd0, 0x56, 0x8c, 0x1f, 0x77, 0x95, 0xfb, 0x50, 0x7a, 0xed, 0x09, 0xa8,
	0x48, 0x2a, 0x44, 0x47, 0x3c, 0x13, 0x88, 0x40, 0x59, 0xe7, 0xa4, 0x60, 0x46, 0x65, 0x53, 0xa9,
	0xdc, 0x03, 0xd7, 0xb3, 0x64, 0xb2, 0x5c, 0xe6, 0x04, 0xaa, 0xbc, 0x54, 0x20, 0x02, 0x6c, 0x6a,
	0xc3, 0x2b, 0xa0, 0x48, 0x4f, 0x4f, 0x39, 0x11, 0x4a, 0xe1, 0x0a, 0x32, 0x4f, 0xf6, 0x01, 0xd8,
	0xbc, 0x7f, 0xc6, 0xa8, 0x10, 0x11, 0xe9, 0x0a, 0x2c, 0x08, 0xbc, 0x0e, 0xb6, 0x85, 0x71, 0x78,
	0x29, 0x61, 0x7e, 0x56, 0xe7, 0x35, 0x54, 0xc9, 0xfc, 0x47, 0xda, 0x6d, 0xff, 0x64, 0x81, 0xb2,
	0xa6, 0x97, 0xa1, 0x1c, 0x22, 0x50, 0x4a, 0x19, 0x0d, 0x18, 0xe1, 0xdc, 0xd4, 0xf1, 0xe6, 0xe2,
	0x3a, 0xe6, 0x08, 0x9c, 0x23, 0x13, 0x8d, 0xa6, 0x3c, 0xb5, 0x2f, 0x41, 0x29, 0xf3, 0xc2, 0x3a,
	0xb8, 0x8c, 0x85, 0xc7, 0x08, 0x4f, 0x69, 0xc2, 0x89, 0xc7, 0x05, 0x66, 0x3a, 0x37, 0x0b, 0x55,
	0xb0, 0x40, 0xc6, 0xdf, 0x95, 0x6e, 0xf8, 0x0e, 0xa8, 0xe4, 0xb1, 0x24, 0xe9, 0xab, 0x94, 0x2c,
	0xb4, 0x39, 0x43, 0xde, 0x49, 0xfa, 0xf6, 0x37, 0x2b, 0x60, 0x7b, 0x56, 0x7f, 0xed, 0x87, 0x9f,
	0x82, 0x75, 0xd9, 0xbb, 0x1e, 0xa3, 0x23, 0xae, 0xae, 0xad, 0xdc, 0xaa, 0x2f, 0x56, 0xd2, 0x1e,
	0x32, 0x2a, 0x69, 0xee, 0x5d, 0x42, 0x25, 0x6c, 0x6c, 0xd8, 0x03, 0x50, 0x0d, 0x8d, 0xc7, 0x88,
	0x4f, 0x59, 0xdf, 0xeb, 0x61, 0xe1, 0x9f, 0x55, 0x57, 0x15, 0x67, 0x6b, 0x09, 0x4e, 0x19, 0x8b,
	0x54, 0x68, 0x47, 0x46, 0xde, 0xbb, 0x84, 0xb6, 0xf1, 0x9c, 0x0f, 0xbe, 0x0e, 0xd6, 0xe5, 0x09,
	0xba, 0xcb, 0x8a, 0xea, 0x7a, 0x4b, 0x8c, 0x8e, 0x54, 0x7f, 0xc1, 0x43, 0xb0, 0xc6, 0x65, 0x71,
	0x97, 0xef, 0xec, 0xdc, 0x8d, 0x20, 0x1d, 0x0b, 0x8f, 0xc1, 0xd6, 0xb4, 0x29, 0xa4, 0x87, 0x54,
	0xd7, 0x14, 0x9b, 0xbb, 0x98, 0xed, 0x5f, 0xdd, 0x85, 0x36, 0x45, 0xfe, 0xb1, 0x53, 0x04, 0xab,
	0xb2, 0xc6, 0xf6, 0x18, 0x5c, 0xe9, 0xa6, 0x51, 0x28, 0x72, 0xcd, 0x6b, 0x66, 0xe1, 0x0e, 0x58,
	0x4d, 0x70, 0x4c, 0x2e, 0x3e, 0x04, 0x2a, 0x1c, 0xd6, 0x40, 0xe9, 0x94, 0x61, 0x5f, 0x64, 0x23,
	0x6e, 0xa1, 0xe9, 0xb3, 0xfd, 0xb3, 0x05, 0xae, 0xbe, 0x74, 0xba, 0xe9, 0x84, 0x2e, 0xd8, 0x4a,
	0x59, 0x18, 0x63, 0xf6, 0x24, 0x3f, 0x8d, 0xe5, 0x56, 0x63, 0xc9, 0x05, 0xa1, 0xd9, 0x36, 0x0d,
	0x87, 0x99, 0xc5, 0x2f, 0xc0, 0x36, 0x23, 0x31, 0x0e, 0x93, 0x3e, 0x61, 0x19, 0x6d, 0xe1, 0x02,
	0xb4, 0x95, 0x29, 0x8b, 0x76, 0xb4, 0x9e, 0x16, 0xc1, 0x46, 0x27, 0x0c, 0x3e, 0x97, 0x31, 0x12,
	0x07, 0xff, 0xb4, 0xc0, 0xe5, 0x97, 0xf6, 0x28, 0x3c, 0x58, 0x7c, 0xca, 0xab, 0x96, 0x6f, 0xed,
	0x7c, 0x9b, 0xd1, 0x0e, 0x9f, 0xb7, 0xaf, 0xe9, 0x4d, 0xdb, 0xc8, 0xaf, 0xd9, 0xc6, 0xfc, 0x72,
	0xfc, 0xfa, 0xb7, 0xdf, 0xbf, 0x2b, 0x7c, 0x64, 0xbf, 0x2f, 0xff, 0x09, 0xc6, 0x79, 0xa4, 0x23,
	0x70, 0x2f, 0x22, 0xb7, 0x53, 0xbd, 0xb6, 0xb9, 0x5b, 0x77, 0xfb, 0x58, 0x60, 0x4e, 0x94, 0xa9,
	0xde, 0x71, 0xb7, 0x3e, 0x39, 0xb0, 0xea, 0xf0, 0x17, 0x0b, 0x94, 0xb2, 0x49, 0x86, 0xcd, 0xe5,
	0xd2, 0xcc, 0x6d, 0xdd, 0x5a, 0xeb, 0x3c, 0x21, 0xba, 0x3d, 0xec, 0x87, 0xcf, 0xdb, 0x30, 0xb7,
	0xaa, 0x1b, 0x7a, 0xa9, 0x2a, 0x31, 0x9f, 0xc0, 0xdb, 0x39, 0x31, 0xea, 0x75, 0x5e, 0x45, 0x44,
	0x7d, 0xfd, 0x87, 0xee, 0xd6, 0x5d, 0x23, 0x55, 0x99, 0x0a, 0x28, 0x25, 0xbd, 0x6b, 0xc1, 0xa7,
	0x16, 0xa8, 0xcc, 0x35, 0x26, 0xbc, 0xb5, 0xc4, 0xfc, 0xfe, 0xe7, 0x24, 0xd5, 0x3e, 0xb8, 0x40,
	0xa4, 0x91, 0xf9, 0xb1, 0x52, 0x74, 0x0b, 0xde, 0x54, 0x8a, 0xe4, 0x40, 0x9d, 0x4b, 0x4a, 0xed,
	0x47, 0xeb, 0x59, 0xfb, 0xad, 0xff, 0x1f, 0xd9, 0x5f, 0xdb, 0xdf, 0x5a, 0x67, 0x42, 0xa4, 0xfc,
	0xc0, 0x75, 0x47, 0xa3, 0xd1, 0xfc, 0x40, 0xe3, 0x81, 0x38, 0x9b, 0x7e, 0x36, 0x34, 0x96, 0x05,
	0x3a, 0xb2, 0xf8, 0x34, 0x89, 0x16, 0x47, 0xa8, 0x9a, 0xec, 0xa7, 0x11, 0x16, 0xa7, 0x94, 0xc5,
	0x9d, 0xef, 0x0b, 0x7f, 0xb5, 0x1f, 0x80, 0x37, 0xa7, 0x3c, 0x73, 0x21, 0xf7, 0x65, 0xdf, 0xc1,
	0xf7, 0xa6, 0x35, 0x18, 0x1b, 0x6b, 0x32, 0x6b, 0xce, 0xb1, 0xb1, 0x26, 0x59, 0x93, 0x8e, 0xd5,
	0xef, 0x04, 0x5c, 0xf3, 0x69, 0xbc, 0xf0, 0x26, 0x3a, 0x1b, 0x5d, 0x6d, 0x1f, 0xc9, 0xcf, 0xa1,
	0x23, 0xeb, 0xe1, 0x5d, 0x13, 0x11, 0xd0, 0x08, 0x27, 0x81, 0x43, 0x59, 0xe0, 0x06, 0x24, 0x51,
	0x1f, 0x4b, 0xee, 0x2c, 0xb9, 0x57, 0x7f, 0x5e, 0x7d, 0x68, 0xcc, 0x1f, 0x0a, 0x3b, 0x77, 0x35,
	0xd3, 0xa1, 0x3a, 0x3b, 0xdb, 0x16, 0x8e, 0x39, 0xcf, 0x39, 0x6e, 0x3e, 0xcb, 0x20, 0x27, 0x0a,
	0x72, 0x92, 0x41, 0x4e, 0x0c, 0xe4, 0xe4, 0xb8, 0xd9, 0x2b, 0xaa, 0x93, 0x6f, 0xfc, 0x13, 0x00,
	0x00, 0xff, 0xff, 0xa2, 0x7c, 0x09, 0x31, 0xf7, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BigQueryReadClient is the client API for BigQueryRead service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BigQueryReadClient interface {
	// Creates a new read session. A read session divides the contents of a
	// BigQuery table into one or more streams, which can then be used to read
	// data from the table. The read session also specifies properties of the
	// data to be read, such as a list of columns or a push-down filter describing
	// the rows to be returned.
	//
	// A particular row can be read by at most one stream. When the caller has
	// reached the end of each stream in the session, then all the data in the
	// table has been read.
	//
	// Data is assigned to each stream such that roughly the same number of
	// rows can be read from each stream. Because the server-side unit for
	// assigning data is collections of rows, the API does not guarantee that
	// each stream will return the same number or rows. Additionally, the
	// limits are enforced based on the number of pre-filtered rows, so some
	// filters can lead to lopsided assignments.
	//
	// Read sessions automatically expire 24 hours after they are created and do
	// not require manual clean-up by the caller.
	CreateReadSession(ctx context.Context, in *CreateReadSessionRequest, opts ...grpc.CallOption) (*ReadSession, error)
	// Reads rows from the stream in the format prescribed by the ReadSession.
	// Each response contains one or more table rows, up to a maximum of 100 MiB
	// per response; read requests which attempt to read individual rows larger
	// than 100 MiB will fail.
	//
	// Each request also returns a set of stream statistics reflecting the current
	// state of the stream.
	ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigQueryRead_ReadRowsClient, error)
	// Splits a given `ReadStream` into two `ReadStream` objects. These
	// `ReadStream` objects are referred to as the primary and the residual
	// streams of the split. The original `ReadStream` can still be read from in
	// the same manner as before. Both of the returned `ReadStream` objects can
	// also be read from, and the rows returned by both child streams will be
	// the same as the rows read from the original stream.
	//
	// Moreover, the two child streams will be allocated back-to-back in the
	// original `ReadStream`. Concretely, it is guaranteed that for streams
	// original, primary, and residual, that original[0-j] = primary[0-j] and
	// original[j-n] = residual[0-m] once the streams have been read to
	// completion.
	SplitReadStream(ctx context.Context, in *SplitReadStreamRequest, opts ...grpc.CallOption) (*SplitReadStreamResponse, error)
}

type bigQueryReadClient struct {
	cc grpc.ClientConnInterface
}

func NewBigQueryReadClient(cc grpc.ClientConnInterface) BigQueryReadClient {
	return &bigQueryReadClient{cc}
}

func (c *bigQueryReadClient) CreateReadSession(ctx context.Context, in *CreateReadSessionRequest, opts ...grpc.CallOption) (*ReadSession, error) {
	out := new(ReadSession)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1.BigQueryRead/CreateReadSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryReadClient) ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigQueryRead_ReadRowsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BigQueryRead_serviceDesc.Streams[0], "/google.cloud.bigquery.storage.v1.BigQueryRead/ReadRows", opts...)
	if err != nil {
		return nil, err
	}
	x := &bigQueryReadReadRowsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BigQueryRead_ReadRowsClient interface {
	Recv() (*ReadRowsResponse, error)
	grpc.ClientStream
}

type bigQueryReadReadRowsClient struct {
	grpc.ClientStream
}

func (x *bigQueryReadReadRowsClient) Recv() (*ReadRowsResponse, error) {
	m := new(ReadRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigQueryReadClient) SplitReadStream(ctx context.Context, in *SplitReadStreamRequest, opts ...grpc.CallOption) (*SplitReadStreamResponse, error) {
	out := new(SplitReadStreamResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1.BigQueryRead/SplitReadStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigQueryReadServer is the server API for BigQueryRead service.
type BigQueryReadServer interface {
	// Creates a new read session. A read session divides the contents of a
	// BigQuery table into one or more streams, which can then be used to read
	// data from the table. The read session also specifies properties of the
	// data to be read, such as a list of columns or a push-down filter describing
	// the rows to be returned.
	//
	// A particular row can be read by at most one stream. When the caller has
	// reached the end of each stream in the session, then all the data in the
	// table has been read.
	//
	// Data is assigned to each stream such that roughly the same number of
	// rows can be read from each stream. Because the server-side unit for
	// assigning data is collections of rows, the API does not guarantee that
	// each stream will return the same number or rows. Additionally, the
	// limits are enforced based on the number of pre-filtered rows, so some
	// filters can lead to lopsided assignments.
	//
	// Read sessions automatically expire 24 hours after they are created and do
	// not require manual clean-up by the caller.
	CreateReadSession(context.Context, *CreateReadSessionRequest) (*ReadSession, error)
	// Reads rows from the stream in the format prescribed by the ReadSession.
	// Each response contains one or more table rows, up to a maximum of 100 MiB
	// per response; read requests which attempt to read individual rows larger
	// than 100 MiB will fail.
	//
	// Each request also returns a set of stream statistics reflecting the current
	// state of the stream.
	ReadRows(*ReadRowsRequest, BigQueryRead_ReadRowsServer) error
	// Splits a given `ReadStream` into two `ReadStream` objects. These
	// `ReadStream` objects are referred to as the primary and the residual
	// streams of the split. The original `ReadStream` can still be read from in
	// the same manner as before. Both of the returned `ReadStream` objects can
	// also be read from, and the rows returned by both child streams will be
	// the same as the rows read from the original stream.
	//
	// Moreover, the two child streams will be allocated back-to-back in the
	// original `ReadStream`. Concretely, it is guaranteed that for streams
	// original, primary, and residual, that original[0-j] = primary[0-j] and
	// original[j-n] = residual[0-m] once the streams have been read to
	// completion.
	SplitReadStream(context.Context, *SplitReadStreamRequest) (*SplitReadStreamResponse, error)
}

// UnimplementedBigQueryReadServer can be embedded to have forward compatible implementations.
type UnimplementedBigQueryReadServer struct {
}

func (*UnimplementedBigQueryReadServer) CreateReadSession(ctx context.Context, req *CreateReadSessionRequest) (*ReadSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReadSession not implemented")
}
func (*UnimplementedBigQueryReadServer) ReadRows(req *ReadRowsRequest, srv BigQueryRead_ReadRowsServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadRows not implemented")
}
func (*UnimplementedBigQueryReadServer) SplitReadStream(ctx context.Context, req *SplitReadStreamRequest) (*SplitReadStreamResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SplitReadStream not implemented")
}

func RegisterBigQueryReadServer(s *grpc.Server, srv BigQueryReadServer) {
	s.RegisterService(&_BigQueryRead_serviceDesc, srv)
}

func _BigQueryRead_CreateReadSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReadSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryReadServer).CreateReadSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1.BigQueryRead/CreateReadSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryReadServer).CreateReadSession(ctx, req.(*CreateReadSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryRead_ReadRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRowsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigQueryReadServer).ReadRows(m, &bigQueryReadReadRowsServer{stream})
}

type BigQueryRead_ReadRowsServer interface {
	Send(*ReadRowsResponse) error
	grpc.ServerStream
}

type bigQueryReadReadRowsServer struct {
	grpc.ServerStream
}

func (x *bigQueryReadReadRowsServer) Send(m *ReadRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BigQueryRead_SplitReadStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SplitReadStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryReadServer).SplitReadStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1.BigQueryRead/SplitReadStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryReadServer).SplitReadStream(ctx, req.(*SplitReadStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigQueryRead_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.storage.v1.BigQueryRead",
	HandlerType: (*BigQueryReadServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateReadSession",
			Handler:    _BigQueryRead_CreateReadSession_Handler,
		},
		{
			MethodName: "SplitReadStream",
			Handler:    _BigQueryRead_SplitReadStream_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadRows",
			Handler:       _BigQueryRead_ReadRows_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/bigquery/storage/v1/storage.proto",
}
