/***************************************************************************
 *   Copyright (C) 2007 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "zeroinput.h"
#include <math.h>

ZeroInput::ZeroInput(
	unsigned long timeLimitMS,
	unsigned int sampleRate,
	unsigned int channels,
	unsigned int bitsPerSample ):
	Input( timeLimitMS )
{
	m_totalTimeMS = MaxLimit;
	m_sampleRate = sampleRate;
	m_channels = channels;
	m_bitsPerSample = bitsPerSample;
}

ZeroInput::~ZeroInput()
{
	if ( isOpened() )
		_close();
}

bool ZeroInput::_open()
{
	return true;
}

bool ZeroInput::_close()
{
	return true;
}

bool ZeroInput::setSampleRate( unsigned long sampleRate )
{
	if ( isOpened() )
		return false;

	m_sampleRate = sampleRate;
	m_bytesLimit = getBlockAlign()*(unsigned long long)(m_timeLimitMS*(m_sampleRate/1000.0));
	return true;
}

bool ZeroInput::setChannels( unsigned int channels )
{
	if ( isOpened() )
		return false;

	m_channels = channels;
	m_bytesLimit = getBlockAlign()*(unsigned long long)(m_timeLimitMS*(m_sampleRate/1000.0));
	return true;
}

bool ZeroInput::setBitsPerSample( unsigned int bitsPerSample )
{
	if ( isOpened() )
		return false;

	m_bitsPerSample = bitsPerSample;
	m_bytesLimit = getBlockAlign()*(unsigned long long)(m_timeLimitMS*(m_sampleRate/1000.0));
	return true;
}

bool ZeroInput::_getPCMChunk( unsigned char* data, unsigned long limit, unsigned long &read )
{
	read = limit;

	if ( read )
	{
		memset( data, 0, read );
		m_currentTimeMS = (unsigned long)((m_bytesRead+read)/(getBlockAlign()*(m_sampleRate/1000.0)));
	}

	return true; // the length limit is enforced by Input
}
