#ifndef _ZEROINPUT_H_
#define _ZEROINPUT_H_

/***************************************************************************
 *   Copyright (C) 2007 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "input.h"

class ZeroInput : public Input
{
	public:
		ZeroInput(
			unsigned long totalTimeMS,
			unsigned int sampleRate=44100,
			unsigned int channels=2,
			unsigned int bitsPerSample=16
		);

		virtual ~ZeroInput();

		bool setTotalTime( unsigned long totalTimeMS );
		bool setSampleRate( unsigned long sampleRate );
		bool setChannels( unsigned int channels );
		bool setBitsPerSample( unsigned int bitsPerSample );

	protected:

		virtual bool _open();
		virtual bool _close();

		virtual bool _getPCMChunk( unsigned char* data, unsigned long limit, unsigned long &read );

		void setCurrentTime();
};

#endif

