// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/model_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_MODEL_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_MODEL_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/model_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ModelServiceConnectionIdempotencyPolicy {
 public:
  virtual ~ModelServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<ModelServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency UploadModel(
      google::cloud::aiplatform::v1::UploadModelRequest const& request);

  virtual google::cloud::Idempotency GetModel(
      google::cloud::aiplatform::v1::GetModelRequest const& request);

  virtual google::cloud::Idempotency ListModels(
      google::cloud::aiplatform::v1::ListModelsRequest request);

  virtual google::cloud::Idempotency ListModelVersions(
      google::cloud::aiplatform::v1::ListModelVersionsRequest request);

  virtual google::cloud::Idempotency UpdateModel(
      google::cloud::aiplatform::v1::UpdateModelRequest const& request);

  virtual google::cloud::Idempotency UpdateExplanationDataset(
      google::cloud::aiplatform::v1::UpdateExplanationDatasetRequest const&
          request);

  virtual google::cloud::Idempotency DeleteModel(
      google::cloud::aiplatform::v1::DeleteModelRequest const& request);

  virtual google::cloud::Idempotency DeleteModelVersion(
      google::cloud::aiplatform::v1::DeleteModelVersionRequest const& request);

  virtual google::cloud::Idempotency MergeVersionAliases(
      google::cloud::aiplatform::v1::MergeVersionAliasesRequest const& request);

  virtual google::cloud::Idempotency ExportModel(
      google::cloud::aiplatform::v1::ExportModelRequest const& request);

  virtual google::cloud::Idempotency CopyModel(
      google::cloud::aiplatform::v1::CopyModelRequest const& request);

  virtual google::cloud::Idempotency ImportModelEvaluation(
      google::cloud::aiplatform::v1::ImportModelEvaluationRequest const&
          request);

  virtual google::cloud::Idempotency BatchImportModelEvaluationSlices(
      google::cloud::aiplatform::v1::
          BatchImportModelEvaluationSlicesRequest const& request);

  virtual google::cloud::Idempotency BatchImportEvaluatedAnnotations(
      google::cloud::aiplatform::v1::
          BatchImportEvaluatedAnnotationsRequest const& request);

  virtual google::cloud::Idempotency GetModelEvaluation(
      google::cloud::aiplatform::v1::GetModelEvaluationRequest const& request);

  virtual google::cloud::Idempotency ListModelEvaluations(
      google::cloud::aiplatform::v1::ListModelEvaluationsRequest request);

  virtual google::cloud::Idempotency GetModelEvaluationSlice(
      google::cloud::aiplatform::v1::GetModelEvaluationSliceRequest const&
          request);

  virtual google::cloud::Idempotency ListModelEvaluationSlices(
      google::cloud::aiplatform::v1::ListModelEvaluationSlicesRequest request);
};

std::unique_ptr<ModelServiceConnectionIdempotencyPolicy>
MakeDefaultModelServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_MODEL_CONNECTION_IDEMPOTENCY_POLICY_H
